<?php

namespace App\Http\Controllers\Api\User;

use App\Blog;
use App\Contact;
use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Api\User\AuthController;
use App\Http\Resources\Api\SessionResource;
use App\Http\Resources\MessageResource;
use App\Languages;
use App\MainFocus;
use App\Sessions;
use App\Coupons;
use App\Specialties;
use App\Therapist;
use App\TherapistsMainFocus;
use App\Visitor;
use App\User;
use Lang;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Collection;
use Illuminate\Pagination\LengthAwarePaginator;
use Stevebauman\Location\Facades\Location;
use App\PaymentLogs;
use App\Payments;
use App\TherapistsInvoices;
use App\TherapistsSpecialties;
use Illuminate\Support\Str;
use App\TherapistsRequests;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Tymon\JWTAuth\Exceptions\JWTException;
use Auth;
use JWTAuth;
use Illuminate\Support\Facades\Response;

use Illuminate\Support\Facades\Http;
use App\Rules\FilterStringRule;
use App\Http\Requests\UpdateVisitorProfile;
use  App\Http\Requests\createEvalutionRequest;

use  App\Reviews;
use  App\ReviewsQuestionAnswer;
use  App\SessionsSchedules;

use App\TreatmentPlan;
use App\TreatmentPlansDiagnosis;
use App\TreatmentPlansTreatments;
use App\Message;

class AppController extends ApiController
{



    public function languages()
    {
        try {
            return $this->returnJsonResponse('success', Languages::active()->get());
        }
        catch (JWTException $e) {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }

    public function specialties()
    {
        try {
            return $this->returnJsonResponse('success', Specialties::active()->get());
        }
        catch (JWTException $e) {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }

    public function blog()
    {
        try {
            return $this->returnJsonResponse('success', $this->blogDataHandel(Blog::active()->paginate(10)));
        }
        catch (JWTException $e) {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }

    public function post($id)
    {
        try {
            if ($post = Blog::active()->find($id))
                return $this->returnJsonResponse('success', $this->singlePostDataHandel($post));
            else
            return $this->returnJsonResponse('no data founded', [], false, 210);
        }
        catch (JWTException $e) {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }


    public function therapists(Request $request)
    {
        try {
            $limit=($request->limit)?$request->limit:10;
            // search by name (en & ar) or title
            $therapists = Therapist::with(['sessions','specialties'])->active();
            if (isset($request->search) && !empty($request->search))
            {
                $therapists = $therapists->when(request('search') , function ($query) {
                    return $query->where('name_e', 'like', '%'.request('search').'%')->where('active', 1)->
                    orWhere('name_a', 'like', '%'.request('search').'%')->where('active', 1)->
                    orWhere('title','LIKE', "%".request('search')."%")->where('active', 1);
                });
            }
            //filtering data
            $therapists=$therapists->when(request('speciality'), function ($query) {
                return $query->whereHas('specialties', function ($q) {
                    $speciality=explode(',',request('speciality'));
                    $q->whereIn('speciality_id',$speciality );
                });
            })->when(request('language'), function ($query) {
                $language=explode(',',request('language'));
                return $query->whereIn('language_id', $language);
            })->when(request('duration') || request('types'), function ($query) {
                return $query->whereHas('sessions', function ($q) {
                    $q->when(request('duration'), function($query){
                        if (request('duration') == 'week') {
                            $from = Carbon::now()->format('Y-m-d');
                            $to = Carbon::now()->addWeek()->subDay()->format('Y-m-d');
                            return $query->whereBetween(DB::raw("DATE(session_date)"), [$from, $to]);
                        }
                        elseif (request('duration') == 'today') {
                            $from = Carbon::now()->format('Y-m-d H:i:m');
                            $to = Carbon::now()->endOfDay()->format('Y-m-d H:i:m');
                            return $query->whereBetween('start_time', [$from, $to]);
                        }
                    })->when(request('types'), function($query){
                        if(request('types') == '30')
                        {
                            return $query->whereIn('type', [3,30])->where('session_status','available')->whereRaw("start_time>=NOW()");
                        }
                        elseif(request('types') == '60')
                        {
                            return $query->whereIn('type', [6,60])->where('session_status','available')->whereRaw("start_time>=NOW()");
                        }

                    });
                    return $q;
                });
            })
                ->when(request('gender'), function ($query) {
                    $gender=explode(',',request('gender'));
                    if(request('gender') == 'all')
                    {
                        return $query->whereIn('gender', ['male','female']);
                    }
                    else
                    {
                        return $query->whereIn('gender', $gender);
                    }
                })->when(request('rating'), function ($query) {

                    $from = request('rating') - 0.5; // 5 => 4.5
                    $to = request('rating') + 0.5;  // 5 => 5.5
                    return $query->where('rating', '>=', $from)->where('rating', '<', $to);

                })->when(request('rang'), function ($query) {
                    if (intval(request('rang'))){
                        $between = [
                            '150' => [0, 150],
                            '200' => [150, 200],
                            '300' => [200, 300],
                            '500' => [300, 500],
                        ];

                        if(request('types') == '30')
                        {
                            return $query->whereBetween('price30', $between[request('rang')]);
                        }
                        elseif(request('types') == '60')
                        {
                            return $query->whereBetween('price60', $between[request('rang')]);
                        }
                        if(!request('types'))
                        {
                            return $query->whereBetween('price30', $between[request('rang')]);
                        }

                    }
                    else{
                        return $query->where('price30','>',500);
                    }
                })->when(request('rang_usd'), function ($query) {
                    if (intval(request('rang_usd'))){
                        $between = [
                            '1' => [0, 50],
                            '2' => [50, 100],
                            '3' => [100, 200],
                            '4' => [200, 500],
                        ];
                        if(request('types') == '30')
                        {
                        return $query->whereBetween('thirty_price_dollar', $between[request('rang_usd')]);
                        }
                        elseif(request('types') == '60')
                        {
                            return $query->whereBetween('sixty_price_dollar', $between[request('rang_usd')]);
                        }
                        if(!request('types'))
                        {
                            return $query->whereBetween('thirty_price_dollar', $between[request('rang_usd')]);
                        }

                    }
                    else{
                        return $query->where('price30','>',500);
                    }
                })->when($request->sort, function ($query){
                    if (request('sort') == 'p_low') {
                        $sortfield = 'price30';
                        $sortoption = 'asc';
                    }
                    else if (request('sort') == 'p_hight') {
                        $sortfield = 'price30';
                        $sortoption = 'desc';
                    }
                    else if (request('sort') == 'r') {
                        $sortfield = 'rating';
                        $sortoption = 'desc';
                    }
                    else {
                        $sortfield = 'title';
                        $sortoption = 'asc';
                    }
                    return $query->orderBy($sortfield, $sortoption);
                });


            if($request->homePage == 'home')
            {
                $therapists_slider = Therapist::whereHas('sessions', function($query){
                    $from = Carbon::now()->format('Y-m-d H:i:m');
                    $to = Carbon::now()->endOfDay()->format('Y-m-d H:i:m');
                    return $query->where('session_status', 'available')->whereBetween('start_time', [$from, $to]);
                })->where('active','=',1)->inRandomOrder();

//                dd(getEloquentSqlWithBindings($therapists),getEloquentSqlWithBindings($therapists_slider));
                $therapists_slider=$therapists_slider->get();

                foreach($therapists_slider as $s)
                {
                    $s->setAttribute('full_image', asset('avatars/therapists/'.$s->picture));
                }



                $therapists=$therapists->paginate(10);


                $data = [
                        'therapists' => $this->therapistsDataHandel($therapists),
                        'therapists_slider' => $therapists_slider,
                    ];

                return $this->returnJsonResponse('success', $data, true,200);
            }
            else
            {
                $therapists_slider = '';
                $therapists=$therapists->whereHas('sessions', function($q)
                {
                    $q->where('session_status','available')->whereRaw("start_time>=NOW()");

                })->paginate(10);

                return $this->returnJsonResponse('success', $this->therapistsDataHandel($therapists));
            }


        }
        catch (JWTException $e)
        {
            return response()->json($e);
        }
    }



    public function getRequestsOfTherapists(Request $request)
    {
        $therapistss = Therapist::where('user_id', '=', $request->user_id)->first();
        $therapistsrequests = TherapistsRequests::with(['therapist','therapistto','languagefrom','languageto','countaryfrom','countaryto'])
            ->where('therapists_id', $therapistss->id)
            ->whereNotIn('column_name',
                [
                    'title',
                    'title_ar',
                    'title_en',
                    'zip_certificates_file_name',
                    'resume_file_name',
                    'picture_file_name',
                    'licence_file_name'
                ])
            ->orderBy('therapists_requests.id', 'desc')->paginate(7);

        foreach($therapistsrequests as $array)
        {
            if($array->column_name == 'speciality_id')
            {
                $from = preg_replace("/[^a-zA-Z 0-9]+/", ",", $array->from );
                $from = explode(',',$from);
                $all = [];
                foreach($from as $f)
                {
                    $specialties = Specialties::find($f);
                    if($f != null)
                    {
                        array_push($all, $specialties);
                    }
                }
                $array->setAttribute("specialties_from",$all);


                $to = preg_replace("/[^a-zA-Z 0-9]+/", ",", $array->to );
                $to = explode(',',$to);
                $allto = [];
                foreach($to as $t)
                {
                    $specialties = Specialties::find($t);
                    if($t != null)
                    {
                        array_push($allto, $specialties);
                    }
                }
                $array->setAttribute("specialties_to",$allto);


            }

        }


        // $userData = User::findOrFail($request->user_id);
        // $userData->therapist = Therapist::where([['user_id', $request->user_id]])->first();
        // $data = $userData->therapist;


        // $column_names=[];

        // foreach($therapistsrequests as $key=>$row)
        // {
        //     if($row->column_name == "speciality_id")
        //     {
        //        array_push($column_names, Lang::get('home.specialties'));
        //     }
        //     else
        //     {
        //         array_push($column_names,Lang::get('home.'.$row->column_name));
        //     }

        // }



        $data = [
            'therapistsrequests' => $therapistsrequests,
            // 'userData' => $userData,
            // 'therapistss' => $therapistss,
            // 'data' => $data,
            // 'column_names' => $column_names
        ];
         return $this->returnJsonResponse('All therapist requests', $data, true, 200);

    }


    //canceltherapists
    public function canceltherapists($id,Request $r)
    {

        $request = TherapistsRequests::where('id', $id)->first();


        if($r->column_name == 'zip_certificates')
        {
            $new = TherapistsRequests::where('therapists_id', $r->therapist_id)->where('column_name', 'zip_certificates_file_name')->whereStatus('pending')->first();

            $data['status'] = "customer_canceled";
            TherapistsRequests::where('id', $id)->update($data);
            TherapistsRequests::where('id', $new->id)->update($data);
            return $this->returnJsonResponse(trans('home.requestcancel'),[], true, 200);
        }
        elseif($r->column_name == 'licence')
        {
            $new = TherapistsRequests::where('therapists_id', $r->therapist_id)->where('column_name', 'licence_file_name')->whereStatus('pending')->first();

            $data['status'] = "customer_canceled";
            TherapistsRequests::where('id', $id)->update($data);
            TherapistsRequests::where('id', $new->id)->update($data);
            return $this->returnJsonResponse(trans('home.requestcancel'),[], true, 200);
        }
        elseif($r->column_name == 'picture')
        {
            $new = TherapistsRequests::where('therapists_id', $r->therapist_id)->where('column_name', 'picture_file_name')->whereStatus('pending')->first();

            $data['status'] = "customer_canceled";
            TherapistsRequests::where('id', $id)->update($data);
            TherapistsRequests::where('id', $new->id)->update($data);
            return $this->returnJsonResponse(trans('home.requestcancel'),[], true, 200);
        }
        elseif($r->column_name == 'resume')
        {
            $new = TherapistsRequests::where('therapists_id', $r->therapist_id)->where('column_name', 'resume_file_name')->whereStatus('pending')->first();

            $data['status'] = "customer_canceled";
            TherapistsRequests::where('id', $id)->update($data);
            TherapistsRequests::where('id', $new->id)->update($data);
            return $this->returnJsonResponse(trans('home.requestcancel'),[], true, 200);
        }

        else
        {
            if ($request->status == "pending") {
            $data['status'] = "customer_canceled";
            TherapistsRequests::where('id', $id)->update($data);

            return $this->returnJsonResponse(trans('home.requestcancel'),[], true, 200);
            } else {
               return $this->returnJsonResponse(trans('home.notavaliable'),[], true, 210);
            }
        }




    }







    public function therapist($id)
    {
        try {
            if ($therapist = Therapist::find($id))
            {
                $profile = Therapist::find($id)
                    ->join('countries', 'therapists.country_id', '=', 'countries.id')
                    ->select('therapists.*') //'countries.title as country'
                    ->where( [['therapists.active','1'],['therapists.id',$therapist->id]])->firstOrFail();

                return $this->returnJsonResponse('success', [
                    $profile !== null ? $this->singleTherapistDataHandel($therapist) : null,
                ]);
            }
            else
                return $this->returnJsonResponse('no data founded', [], false, 210);
        }
        catch (JWTException $e) {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }







    public function getTherapistSessions($id, Request $request)
    {
        $todayDate=Carbon::now()->format('Y-m-d');



        if($request->kind == 'patient')
        {
            $therapist = Therapist::find($id);
            $nextSessions=Sessions::where('therapist_id',$id)
            ->whereIn('session_status', ['available', 'reserved'])
            ->whereRaw("(NOW()BETWEEN start_time AND DATE_ADD(start_time,INTERVAL `type` MINUTE) OR start_time>NOW())")
            ->orderBy('start_time','asc')->get()->toArray();
            foreach ($nextSessions as $x=>$nextSession){
                $nextSessions[$x]['start_time']=date('Y-m-d H:i:s',strtotime($nextSession['start_time']));
                $nextSessions[$x]['session_date']=date('Y-m-d',strtotime($nextSession['session_date']));
            }
            $nextSessions=collect($nextSessions)->groupBy(function($session) {
                    return date('Y-m-d',strtotime($session['start_time']));
                })->mapToGroups(function($sessions, $date) {
                    return ['data' => ['date' => $date, 'sessions'=> $sessions]];
                });

            if($nextSessions->count() > 0)
            {

                $data = [
                    'nextSessions'=> $nextSessions,
                    'therapist'=> $therapist,
                ];
                return $this->returnJsonResponse('Upcoming Sessions', $data, true, 200);
            }
            else
            {
                return $this->returnJsonResponse('No Sessions avilable', [], true, 210);
            }



        }
        else
        {
            //setTimeZone(auth('api')->user()->timezone);
            $nextSessions=Sessions::where('therapist_id',$id)
            //->whereIn('session_status', ['available', 'reserved'])
            ->where("session_date", '>=', $todayDate)->orderBy('start_time','asc')->get()->toArray();
            foreach ($nextSessions as $x=>$nextSession){
                //dd($nextSession);
                $nextSessions[$x]['start_time']=date('Y-m-d H:i:s',strtotime($nextSession['start_time']));
                $nextSessions[$x]['session_date']=date('Y-m-d',strtotime($nextSession['session_date']));
            }
            $nextSessions=collect($nextSessions)->groupBy(function($session) {
                    return date('Y-m-d',strtotime($session['start_time']));
                })->mapToGroups(function($sessions, $date) {
                    return ['data' => ['date' => $date, 'sessions'=> $sessions]];
                });

            if($nextSessions->count() > 0)
            {
                return $this->returnJsonResponse('Upcoming Sessions', $nextSessions, true, 200);
            }
            else
            {
                return $this->returnJsonResponse('No Sessions avilable', [], true, 210);
            }


        }



    }



    //today
    public function getTherapistSessionsAvailable($id, Request $request)
    {
        $todayDate=Carbon::now()->format('Y-m-d');

        // $todaySessions=Sessions::select('*',DB::raw("CASE WHEN TIMESTAMPDIFF(SECOND,NOW(),start_time)>0 THEN TIMESTAMPDIFF(SECOND,NOW(),start_time) ELSE 0 END AS time_ago"))->where('therapist_id',$id)->whereNotNull('visitor_id')
        // // ->whereNotIn('session_status',['cancelled','visitor_cancelled'])
        // ->whereRaw("DATE(start_time)='$todayDate'")->paginate(10);

        $todaySessions = Sessions::select('sessions.*','users.name AS user_name')->leftJoin('visitors','visitors.id','=','sessions.visitor_id')->leftJoin('users','users.id','=','visitors.user_id')->where('therapist_id', $id)->where('session_status','available')->orderBy('start_time', 'desc')->get()->toArray();
        //->paginate(10);


        foreach ($todaySessions as $x=>$todaySession){
            $todaySessions[$x]['start_time']=date('Y-m-d H:i:s',strtotime($todaySession['start_time']));
            $todaySessions[$x]['session_date']=date('Y-m-d',strtotime($todaySession['session_date']));
        }

        $todaySessions = $this->custom_paginate($todaySessions);

        if(count($todaySessions) > 0)
        {
            return $this->returnJsonResponse('Available Sessions', $todaySessions, true, 200);
        }
        else
        {
            return $this->returnJsonResponse('No Sessions avilable', [], true, 210);
        }
    }

    public function getTherapistSessionsUpcoming($id, Request $request)
    {
        $todayDate=Carbon::now()->format('Y-m-d');

        $nextSessions=
        Sessions::select('*',DB::raw("CASE WHEN TIMESTAMPDIFF(SECOND,NOW(),start_time)>0 THEN TIMESTAMPDIFF(SECOND,NOW(),start_time) ELSE 0 END AS time_ago"))->where('therapist_id',$id)

        ->whereNotNull('visitor_id')
        // ->whereNotIn('session_status',['cancelled','visitor_cancelled'])
        ->whereIn('session_status', ['reserved','cancelled','visitor_cancelled','closed'])
       // ->where("start_time", '>=', Carbon::now()->subMinute(30))
        ->whereRaw("(NOW()BETWEEN start_time AND DATE_ADD(start_time,INTERVAL `type` MINUTE) OR start_time>NOW())")->orderBy('start_time')
        ->get()->toArray();

        foreach ($nextSessions as $x=>$nextSession){
            $nextSessions[$x]['start_time']=date('Y-m-d H:i:s',strtotime($nextSession['start_time']));
            $nextSessions[$x]['session_date']=date('Y-m-d',strtotime($nextSession['session_date']));
            $nextSessions[$x]['session_link']=$nextSessions[$x]['session_link'] . '/therapist';

            $visitor = Visitor::find($nextSession['visitor_id']);
            if ($visitor) {
               $user = User::find($visitor->user_id);
               if($user)
               {
                $nextSessions[$x]['user_name']=$user->name;
               }
            }



        }


        $nextSessions = $this->custom_paginate($nextSessions);
        if(count($nextSessions) > 0)
        {
            return $this->returnJsonResponse('Upcoming Sessions', $nextSessions, true, 200);
        }
        else
        {
            return $this->returnJsonResponse('No Sessions avilable', [], true, 210);
        }
    }




    public function getTherapistHistorySessions($id)
    {

        $todayDate=Carbon::now()->format('Y-m-d');
        $previousSessions=Sessions::select('sessions.*','users.name AS user_name')
        ->leftJoin('visitors','visitors.id','=','sessions.visitor_id')
        ->leftJoin('users','users.id','=','visitors.user_id')
        ->where('therapist_id', $id)
        ->where('session_status','!=','available')
        ->whereRaw("(NOW() > DATE_ADD(start_time,INTERVAL `sessions`.`type` MINUTE) )")
        ->orderBy('start_time', 'desc')
        ->get()->toArray();

        foreach ($previousSessions as $x=>$previousSession){
            $previousSessions[$x]['start_time']=date('Y-m-d H:i:s',strtotime($previousSession['start_time']));
            $previousSessions[$x]['session_date']=date('Y-m-d',strtotime($previousSession['session_date']));
        }

        $previousSessions = $this->custom_paginate($previousSessions);

        if(count($previousSessions) > 0)
        {
            return $this->returnJsonResponse('Previous Sessions', $previousSessions, true, 200);
        }
        else
        {
            return $this->returnJsonResponse('No Sessions avilable', [], true, 210);
        }
    }

    public function getVisitorSessions(Request $request)
    {


        $visitor=Visitor::where( [['user_id',auth('api')->id()]] )->first();

        $todayDate=Carbon::now()->format('Y-m-d');
        $nextSessions=Sessions::with('therapist')->select('*',DB::raw("CASE WHEN TIMESTAMPDIFF(SECOND,NOW(),start_time)>0 THEN TIMESTAMPDIFF(SECOND,NOW(),start_time) ELSE 0 END AS time_ago"))->where('visitor_id',$visitor->id)
           // ->whereNotIn('session_status',['cancelled','visitor_cancelled'])
            ->whereRaw("DATE(session_date)>'$todayDate'")->orderBy('start_time', 'asc')->get()->toArray();

        foreach ($nextSessions as $x=>$nextSession){
            $nextSessions[$x]['start_time']=date('Y-m-d H:i:s',strtotime($nextSession['start_time']));
            $nextSessions[$x]['session_date']=date('Y-m-d',strtotime($nextSession['session_date']));
            $nextSessions[$x]['session_link']=$nextSessions[$x]['session_link'] . '/patient';
        }


        $nextSessions = $this->custom_paginate($nextSessions);
        if(count($nextSessions) > 0)
        {
            return $this->returnJsonResponse('Upcoming Sessions', $nextSessions, true, 200);
        }
        else
        {
            return $this->returnJsonResponse('No Sessions avilable', [], true, 210);
        }

    }

    public function getVisitorHistorySessions(Request $request)
    {


        $visitor=Visitor::where( [['user_id',auth('api')->id()]] )->first();

        $todayDate=Carbon::now()->format('Y-m-d');
        $previousSessions=Sessions::with('therapist')->select('*',DB::raw("CASE WHEN TIMESTAMPDIFF(SECOND,NOW(),start_time)>0 THEN TIMESTAMPDIFF(SECOND,NOW(),start_time) ELSE 0 END AS time_ago"))->where('visitor_id',$visitor->id)
        // ->whereNotIn('session_status',['cancelled','visitor_cancelled'])

        //->where("start_time", '<', Carbon::now()->format('Y-m-d H:i:m'))

        ->whereRaw("(NOW() > DATE_ADD(start_time,INTERVAL `type` MINUTE) )")

        ->orderBy('start_time', 'desc')->get()->toArray();

        foreach ($previousSessions as $x=>$previousSession){
            $previousSessions[$x]['start_time']=date('Y-m-d H:i:s',strtotime($previousSession['start_time']));
            $previousSessions[$x]['session_date']=date('Y-m-d',strtotime($previousSession['session_date']));
        }


        $previousSessions = $this->custom_paginate($previousSessions);
        if(count($previousSessions) > 0)
        {
            return $this->returnJsonResponse('Previous Sessions', $previousSessions, true, 200);
        }
        else
        {
            return $this->returnJsonResponse('No Sessions avilable', [], true, 210);
        }
    }


    public function getTodaySessionsOfVisitor(Request $request)
    {

        $visitor=Visitor::where( [['user_id',auth('api')->id()]] )->first();

        $todayDate=Carbon::now()->format('Y-m-d');
        $endtodayDate = Carbon::now()->endOfDay()->format('Y-m-d H:i:m');
        $todaySessions=Sessions::with('therapist')->select('*',DB::raw("CASE WHEN TIMESTAMPDIFF(SECOND,NOW(),start_time)>0 THEN TIMESTAMPDIFF(SECOND,NOW(),start_time) ELSE 0 END AS time_ago"))->where('visitor_id',$visitor->id)
        //->whereNotIn('session_status',['cancelled','visitor_cancelled'])
       // ->whereRaw("DATE(session_date)='$todayDate'")
       // ->whereBetween('start_time', [Carbon::now()->startOfDay()->format('Y-m-d H:i:m'), Carbon::now()->endOfDay()->format('Y-m-d H:i:m')])
      //  ->whereRaw("(NOW()BETWEEN start_time AND DATE_ADD(start_time,INTERVAL `type` MINUTE))")


       ->whereRaw("(NOW()BETWEEN start_time AND DATE_ADD(start_time,INTERVAL `type` MINUTE) OR (start_time<'$endtodayDate' AND start_time>=NOW()) )")



         // ->where('start_time', '>=' ,\Carbon\Carbon::parse(\Carbon\Carbon::now()->format('Y-m-d H:i:m'))->addMinute(10))
         // ->where('start_time', '<' ,Carbon::now()->endOfDay()->format('Y-m-d H:i:m'))
        ->orderBy('start_time', 'desc')->get()->toArray();

        foreach ($todaySessions as $x=>$todaySession){
            $todaySessions[$x]['start_time']=date('Y-m-d H:i:s',strtotime($todaySession['start_time']));
            $todaySessions[$x]['session_date']=date('Y-m-d',strtotime($todaySession['session_date']));

            $todaySessions[$x]['session_link']=$todaySessions[$x]['session_link'] . '/patient';
        }


        $todaySessions = $this->custom_paginate($todaySessions);
        if(count($todaySessions) > 0)
        {
            return $this->returnJsonResponse('Today Sessions', $todaySessions, true, 200);
        }
        else
        {
            return $this->returnJsonResponse('No Sessions avilable', [], true, 210);
        }
    }




    public function reserveSessionWithPayment(Therapist $therapist, Sessions $sessions, Request $request)
    {
        try{

            if ($sessions->therapist_id !== $therapist->id)
                return $this->returnJsonResponse('this session is not belongs so this therapist', [],
                    FALSE, 209);
            if ($sessions->visitor_id)
                return $this->returnJsonResponse('This session has been already reserved', [],
                    FALSE, 209);
            if ($this->reserveSessionWithPaymentValidator($request->all()))
                return $this->reserveSessionWithPaymentValidator($request->all());

            $visitor = Visitor::where('user_id',auth('api')->id())->first();
            $user = User::whereId(auth('api')->id())->first();
            $sessions->visitor_id = $visitor->id;
            $sessions->status = 2;
            $sessions->session_status = 'reserved';
            $sessions->payment_method = $request->type;
            if ($sessions->update())
            {
               // $location = Location::get($request->ip());
               //   $amount=($location->countryName='Egypt')?(in_array($sessions->type,['30','3','10'])?$therapist->price30:$therapist->price60):(in_array($sessions->type,['30','3','10'])?$therapist->thirty_price_dollar:$therapist->sixty_price_dollar);
               //   $currency=($location->countryName='Egypt')?'EGP':'USD';

                if($request->egypt == true)
                {

                    $amount=(in_array($sessions->type,['30','3','10'])?$therapist->price30:$therapist->price60);

                    $currency = 'EGP';
                }
                else
                {
                     $amount=(in_array($sessions->type,['30','3','10'])?$therapist->thirty_price_dollar:$therapist->sixty_price_dollar);
                    $currency = 'USD';
                }



                 $invoice = new TherapistsInvoices();
                 $invoice->therapist_id = $therapist->id;
                 $invoice->visitor_id = $visitor->id;
                 $invoice->session_id = $sessions->id;
                 $invoice->visitor_name = $user->name;
                 $invoice->session_date =  date('Y-m-d H:i:s',strtotime($sessions->start_time));
                 $invoice->therapist_price = (in_array($sessions->type, ['30', '3','10'])) ? $therapist->price30 : $therapist->price60;
                 $invoice->therapist_price_dolar = (in_array($sessions->type, ['30', '3','10'])) ? $therapist->thirty_price_dollar : $therapist->sixty_price_dollar;
                 $invoice->session_type = $sessions->type;
                 $invoice->total_amount = $amount;
                 $invoice->currency = $currency;


                   $dolarRate=getAppSetting('dolar_rating');
                    if(!$dolarRate){
                        $dolarRate=1;
                    }

                $invoice->website_percentage=getAppSetting('website_percentage');
               $invoice->minimum_price_30=getAppSetting('minimum_price_30');
               $invoice->minimum_price_60=getAppSetting('minimum_price_60');
               $invoice->minimum_price_30_dolar=getAppSetting('minimum_price_30_dolar');
               $invoice->minimum_price_60_dolar=getAppSetting('minimum_price_60_dolar');
               $minimum_price=0;

               if ($currency == 'USD')
               {
                   if(in_array($sessions->type,[30,3,10])){
                    $minimum_price=$invoice->minimum_price_30_dolar;
                   }
                   else{
                        $minimum_price=$invoice->minimum_price_60_dolar;
                   }
               }
               elseif($currency == 'EGP')
               {

                   if(in_array($sessions->type,[30,3,10])){
                    $minimum_price=$invoice->minimum_price_30;
                   }
                   else{
                        $minimum_price=$invoice->minimum_price_60;
                   }

               }


               $invoice->therapist_amount=calculateTherapistAmount($invoice->total_amount,$invoice->website_percentage,$minimum_price);



                 $invoice->discount_amount = 0;
                 $invoice->discount_percentage = 0;
                 $invoice->coupon_id = 0;
                 $invoice->coupon_code = '';
                 $invoice->total_after_discount = $invoice->total_amount - $invoice->discount_amount;
                 $invoice->dolar_rating = $dolarRate;
                 $invoice->save();



                return $this->returnJsonResponse('your session reserved successfully', $sessions);
            }else
            {
                return $this->returnJsonResponse('sorry, we couldn\'t complete reservation right now', [], 211);
            }

        }
        catch (JWTException $e) {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }

    public function contactUs(Request $request)
    {
        try {
            if ($this->contactUsValidator($request->all()))
                return $this->contactUsValidator($request->all());
            $contact = new Contact();
            $contact->first_name = $request->first_name;
            $contact->last_name = $request->last_name;
            $contact->email = $request->email;
            $contact->subject = $request->subject;
            $contact->contact_type = $request->contact_type;
            if ($contact->save())
                return $this->returnJsonResponse('your message sent successfully');
            else
                return $this->returnJsonResponse('there is something wrong.', [], 211);
        }
        catch (JWTException $e) {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }

    /**
     * @param $data
     *
     * @return JsonResponse
     */
    public function contactUsValidator($data)
    {
        $validator = Validator::make($data, [
            'first_name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255',
            'last_name' => 'required|string|max:255',
            'subject' => 'required|string|max:600',
            'contact_type' => 'required|integer|not_in:0',

        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
    }

    /**
     * @param $data
     *
     * @return JsonResponse
     */
    public function reserveSessionWithPaymentValidator($data)
    {
        $validator = Validator::make($data, [
            'payment_method' => 'required|',
        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
    }

    public function getTherapistSessionsValidator($data)
    {
        $validator = Validator::make($data, [
            'duration' => 'required|string',
        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
    }

    public function therapistsDataHandel($therapists)
    {
            foreach ($therapists as $therapist)
            {
                $this->singleTherapistDataHandel($therapist);
            }
        return $therapists;
    }

    public function singleTherapistDataHandel($therapist)
    {
        $therapist->picture =  $therapist->picture !== null ? asset('avatars/therapists/' . $therapist->picture): null;
        $therapist->resume =  $therapist->resume !== null ? asset('resumes/' . $therapist->resume): null;
        $therapist->certifications = [
            'en' => explode('.', strip_tags($therapist->certifications_en)),
            'ar' => explode('.', strip_tags($therapist->certifications_ar)),
        ];
        $therapist->experiences = [
            'en' => explode('.', strip_tags($therapist->experience_en)),
            'ar' => explode('.', strip_tags($therapist->experience_ar)),
        ];
        $therapist->summery = [
            'en' => explode('.', strip_tags($therapist->summery_en)),
            'ar' => explode('.', strip_tags($therapist->summery_ar)),
        ];
        $therapist->descriptions = [
            'en' => explode('.', strip_tags($therapist->description_en)),
            'ar' => explode('.', strip_tags($therapist->description_ar)),
        ];
        $therapist->lang = $therapist->languages;
        $therapist->total_reviews = $therapist->reviews->take(5);
        unset($therapist->certifications_en);
        unset($therapist->certifications_ar);
        unset($therapist->experience_en);
        unset($therapist->experience_ar);
        unset($therapist->languages);
        unset($therapist->description_en);
        unset($therapist->description_ar);
        unset($therapist->summery_ar);
        unset($therapist->summery_en);
        unset($therapist->language_id);
        unset($therapist->user_id);
        unset($therapist->reviews);
        return $therapist;
    }

    public function blogDataHandel($posts)
    {
        foreach ($posts as $post)
        {
            $post->picture =  $post->picture !== null ? asset($post->picture): null;
            $post->username = $post->user->name;
            $post->auther_picture = asset('avatars/therapists/'.$post->user->therapist->picture);
            unset($post->user);

        }
        return $posts;
    }
    public function singlePostDataHandel($post)
    {
        $user = $post->user;
        $post->username = $user->name;
        $post->auther_picture = asset('avatars/therapists/'.$user->therapist->picture);
        $post->picture =  $post->picture !== null ? asset($post->picture): null;
        unset($post->user);
        return $post;
    }




    //1-reviews
    public function reviews($id)
    {
        try {
                $review = \DB::table('reviews')->join('visitors', 'reviews.visitor_id', '=', 'visitors.id')->join('users', 'users.id', '=', 'visitors.user_id')->select('reviews.*', 'users.*', 'visitors.image')->where('reviews.therapist_id', $id)->paginate(10);

                if($review->count() > 0)
                    return $this->returnJsonResponse('Get All Reviews of Therapist', $review, true, 210);
                else
                    return $this->returnJsonResponse('no data founded', [], true, 210);
        }
        catch (JWTException $e) {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }


    //2-therapists_invoices
    public function invoices($id, Request $request)
    {
        try {
            $date = date('Y-m-d');

            if ($request->from_date && $request->to_date) {
               $invoices = TherapistsInvoices::whereHas('sessionInvoice', function($q) use ($request){
                    $q->where('start_time', '<=', date('Y-m-d H:i:s'))->where('therapist_start_date', '!=', null)->whereBetween('start_time', [$request->from_date, \Carbon\Carbon::parse($request->to_date)->addDays(1)]);
                })->where('therapist_id', $id)->orderBy('session_date', 'desc')->get()->toArray();

                    foreach ($invoices as $x=>$invoice){
                        $session = Sessions::find($invoice['session_id']);
                        $invoices[$x]['session_date']=date('Y-m-d H:i:s',strtotime($session->start_time));
                    }
                    $invoices = $this->custom_paginate($invoices);

              $totalSessionThisMonthEGP = TherapistsInvoices::whereHas('sessionInvoice', function($q) use ($request){
                    $q->where('start_time', '<=', date('Y-m-d H:i:s'))->where('therapist_start_date', '!=', null)->whereBetween('start_time', [$request->from_date, \Carbon\Carbon::parse($request->to_date)->addDays(1)]);
                })
                ->where('therapist_id', '=', $id)
                ->where('currency','EGP')->sum('therapist_amount');
              $totalSessionThisMonthDollar = TherapistsInvoices::whereHas('sessionInvoice', function($q) use ($request){
                    $q->where('start_time', '<=', date('Y-m-d H:i:s'))->where('therapist_start_date', '!=', null)->whereBetween('start_time', [$request->from_date, \Carbon\Carbon::parse($request->to_date)->addDays(1)]);
                })
                ->where('therapist_id', '=', $id)
                ->where('currency','USD')->sum('therapist_amount');

            }
            else
            {
                $invoices = TherapistsInvoices::whereHas('sessionInvoice', function($q){
                    $q->where('start_time', '<=', date('Y-m-d H:i:s'))->where('therapist_start_date', '!=', null)->whereMonth('start_time', date('m'));
                })->where('therapist_id', $id)->orderBy('session_date', 'desc')->get()->toArray();

                    foreach ($invoices as $x=>$invoice){
                        $session = Sessions::find($invoice['session_id']);
                        $invoices[$x]['session_date']=date('Y-m-d H:i:s',strtotime($session->start_time));


                    }
                    $invoices = $this->custom_paginate($invoices);


                $totalSessionThisMonthEGP = TherapistsInvoices::whereHas('sessionInvoice', function($q){
                    $q->where('start_time', '<=', date('Y-m-d H:i:s'))->where('therapist_start_date', '!=', null)->whereMonth('start_time', date('m'));
                })->where('therapist_id', '=', $id)
                    ->where('currency','EGP')->sum('therapist_amount');
                $totalSessionThisMonthDollar = TherapistsInvoices::whereHas('sessionInvoice', function($q){
                    $q->where('start_time', '<=', date('Y-m-d H:i:s'))->where('therapist_start_date', '!=', null)->whereMonth('start_time', date('m'));
                })->where('therapist_id', '=', $id)
                    ->where('currency','USD')->sum('therapist_amount');
            }





                 if(count($invoices) > 0)

                    return response()->json([
                        'status' => true,
                        'message' => 'All Invoices',
                        'data' => $invoices,
                        'totalSessionThisMonthEGP' => $totalSessionThisMonthEGP,
                        'totalSessionThisMonthDollar' => $totalSessionThisMonthDollar,
                    ]);
                else
                    return $this->returnJsonResponse('no data founded', [], true, 210);
        }
        catch (JWTException $e) {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }


    //therapist profile
    public function basic_info($id)
    {


        $userData = User::findOrFail($id);

        $t = Therapist::where('user_id', $id)->first();

        $sessionsCount = Sessions::where('therapist_id', $t->id)->whereIn('session_status',['reserved','closed'])->count() +25;


        $userData->therapist = Therapist::where([['user_id', $id]])->first();
        if($userData->type=='therapists'&&!$userData->therapist){
            $userData->therapist=Therapist::create(['user_id'=>$id,'name_a'=>$userData->name,'name_e'=>$userData->name,'title'=>$userData->name]);
        }
        $specialties = Specialties::where('active',1)->orderBy('sort', 'ASC')->get();

        $therapist_specialties = TherapistsSpecialties::where('therapist_id', $userData->therapist->id)->pluck('speciality_id');
        $therapistss = Therapist::where('user_id', '=', $id)->first();
        $therapistsrequests = TherapistsRequests::where('therapists_id', $therapistss->id)->get();

        //Rating average of therapist
        $avg_rating = \DB::table('reviews')->where('therapist_id', $therapistss->id)->avg('rating');
        $fullPathPicture = asset('avatars/therapists/'.$therapistss->picture);
        $fullPathLicence = asset('licences/'.$therapistss->licence);

        $userData->therapist->setAttribute('picture', $fullPathPicture);
        $userData->therapist->setAttribute('licence', $fullPathLicence);
        $userData->therapist->main_focus=explode(',',$userData->therapist->main_focus);
        if($userData)
        return response()->json([
            'message' => 'info of Therapist',
            'success' => true,
            'data'    => $userData,
            'sessionsCount' => $sessionsCount,
            'specialties' => $specialties,
            'therapist_specialties' => $therapist_specialties,
            'therapistsrequests' => $therapistsrequests,
            'avg_rating' => $avg_rating == null ? '0' : $avg_rating,
            'main_focus_ar' => MainFocus::pluck('title_ar')->toArray(),
            'main_focus_en' => MainFocus::pluck('title_en')->toArray(),
        ]);
        else
            return $this->returnJsonResponse('no data founded', [], true, 210);



    }




    //edit therapist profile
    public function save_basic_info(Request $request,$id)
    {
        //   dd($request);
        $attributes = $request->input();

        $therapist =  Therapist::where([['active', '1'], ['user_id', $id]])->firstOrFail();
        $user =  User::where('id', $id)->firstOrFail();


        $validator = Validator::make($attributes, [
            'title_ar' => 'required|max:255',
                'title_en' => 'required|max:255',
                'summery_en' => 'required|max:1000',
                'summery_ar' => 'required|max:1000',
                'email' => 'required|unique:users,email,' . $id . ',id',
                'language_id'=>'required',
                'thirty_price_dollar' => ['integer', 'numeric', 'not_in:0', 'min:1'],
                'sixty_price_dollar' => ['integer', 'numeric', 'not_in:0', 'min:1', 'gt:thirty_price_dollar'],

        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }


        if ($request->ajax() && $request->hasFile('resume')) {
            if (file_exists(public_path() . '/resumes/' . $therapist->resume))
                @unlink(public_path() . '/resumes/' . $therapist->resume);

            $file = $request->file('resume');
            $destinationPath = public_path('resumes/');
            $fileName = $file->getClientOriginalName();
            $file->move($destinationPath, $fileName);
            $resumeInfo = $fileName;
        } else {
            $resumeInfo = $therapist->resume;
        }

        if ($request->ajax() && $request->hasFile('picture')) {
            if (file_exists(public_path() . '/avatars/therapists/' . $therapist->picture))
                @unlink(public_path() . '/avatars/therapists/' . $therapist->picture);

            $image_name = time() . '.' . $request->file('picture')->getClientOriginalExtension();
            $destinationPath = public_path('avatars/therapists');
            $request->file('picture')->move($destinationPath, $image_name);
            $therapist->picture = $image_name;
        }

        if ($request->ajax() && $request->hasFile('zip_certificates')) {
            if (file_exists(public_path() . '/certificates/' . $therapist->zip_certificates))
                @unlink(public_path() . '/certificates/' . $therapist->zip_certificates);

            $file = $request->file('zip_certificates');
            $destinationPath = public_path("/certificates/");
            $certificateName = $file->getClientOriginalName();
            $file->move($destinationPath, $certificateName);
            $therapist->zip_certificates = $certificateName;
        } else {
            $therapist->zip_certificates = $therapist->zip_certificates;
        }

        if ($request->hasFile('licence')) {
            if (file_exists(public_path() . '/licences/' . $therapist->licence))
                @unlink(public_path() . '/licences/' . $therapist->licence);

            $file = $request->file('licence');
            $destinationPath = public_path('licences/');
            $fileName = time() . uniqid() . $file->getClientOriginalName();
            $file->move($destinationPath, $fileName);
            $therapist->licence = $fileName;
        } else {
            $therapist->licence =  $therapist->licence;
        }

        $data = [
            'name_a' => $attributes['title_ar'],
            'name_e' => $attributes['title_en'],
            'description_en' => $attributes['description_en'],
            'summery_en' => $attributes['summery_en'],
            'description_ar' => $attributes['description_ar'],
            'summery_ar' => $attributes['summery_ar'],
            'country_id' => $attributes['country_id'],
            'resume' => $resumeInfo,
            'main_specialty_ar' => $attributes['main_specialty_ar'],
            'main_specialty_en' => $attributes['main_specialty_en'],
            'price30' => $attributes['price30'],
            'price60' => $attributes['price60'],
            'thirty_price_dollar' => $attributes['thirty_price_dollar'],
            'sixty_price_dollar' => $attributes['sixty_price_dollar'],
            'experience_ar' => $attributes['experience_ar'],
            'experience_en' => $attributes['experience_en'],
            'certifications_ar' => $attributes['certifacations_ar'],
            'certifications_en' => $attributes['certifacations_en'],
            'license_no' =>  $attributes['license_no'],
            'license_org' => $attributes['license_org'],
            'language_id' => $attributes['language_id'],
        ];

        $data_trans = [
            'summery' => ['ar' => $attributes['summery_ar'], 'en' => $attributes['summery_en']],
            'description' => ['ar' => $attributes['description_ar'], 'en' => $attributes['description_en']],
        ];

        if (!empty($request->specialties)) {
            foreach ($request->specialties as $key => $value) {
                $therapist_spec = TherapistsSpecialties::create([
                    'therapist_id' => $therapist->id,
                    'speciality_id' => $value,
                ]);
            }
        }

        $therapist->update($data);
        $therapist->save();
        if ($therapist) {
            $user->email = $attributes['email'];
            $user->save();
            save_front_trans($data_trans, $therapist->id, 'therapists');

            return $this->returnJsonResponse(trans('home.The data has been successfully updated'), [], true, 210);

        } else {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [], FALSE, 213);

        }
    }






    //Payment
    public function getRedirectPage($id,Request $request){
        if(!$request->mobile){
            return response()->json(['success'=>false,'message'=>trans('home.Mobile is required')]);
        }
        $session = Sessions::withTrashed()->findOrFail($id);
        if($session->visitor_id||!in_array($session->session_status,['available','reserved'])||$session->deleted_at){
            return response()->json(['success'=>false,'message'=>'failed','redirect_url'=>route('therapists_preview',$session->therapist_id)]);
        }

        $location = Location::get($request->ip());
        $userData=$request->user_id;
        $userFind = User::findOrFail($userData);
        $visitor=Visitor::where('user_id',$userData)->first();
        $therapist=Therapist::find($session->therapist_id);
        if($session&&$therapist&&$visitor){
            $visitor->mobile=$request->mobile;
            $visitor->save();
            $dolarRate=getAppSetting('dolar_rating');
            if(!$dolarRate){
                $dolarRate=1;
            }
            $coupon_id=0;
            $coupon_code='';
            $coupon_discount=0;
            $discount_amount=0;
            $amount=($location->countryName=='Egypt')?(in_array($session->type,['30','3'])?$therapist->price30:$therapist->price60):($session->type=='30'?$therapist->thirty_price_dollar:$therapist->sixty_price_dollar);
            $currency=($location->countryName=='Egypt')?'EGP':'USD';
            if($request->coupon){
                $coupon=Coupons::where('code',$request->coupon)->first();
                if($coupon){
                    if($coupon->used_for_session!='all'&&$coupon->used_for_session!=$session->type){
                        return response()->json(['success'=>false,'message'=>trans('home.This coupon not for this type of sessions')]);
                    }
                    if($coupon->currency!='all'&&$coupon->currency!=$currency){
                        return response()->json(['success'=>false,'message'=>trans('home.This coupon not for currency').trans('home.'.$currency)]);
                    }
                    if($coupon->used_limit<=$coupon->used){
                        return response()->json(['success'=>false,'message'=>trans('home.This coupon used for limited users')]);
                    }
                    if($coupon->expired_date<=date('Y-m-d')){
                        return response()->json(['success'=>false,'message'=>trans('home.This coupon expired')]);
                    }
                    $coupon_id=$coupon->id;
                    $coupon_code=$coupon->code;
                    $coupon_discount=$coupon->percentage;
                    $discount_amount=($amount*$coupon_discount)/100;
                    $amount=$amount-$discount_amount;

                }
            }

            $postData=$requestParams=[
                'sessionId'=>$request->session_id,
                'mobileNumber'=>$request->mobile,
                'email'=>$userFind->email,
                'amount'=>($location->countryName=='Egypt')?round($amount/$dolarRate):$amount,
                //'amount'=>1,
                'currencyIso'=>$currency,
                'firstName'=>($visitor->gender=='male')?'Mr.':'Ms.',
                'lastName'=>$userFind->name,
                'onAccept'=>$request->onAccept ? $request->onAccept : route('book_success',$id),//'http://newhayah.com/session/'.$id.'/book_success',//
                'onFail'=>$request->onFail ? $request->onFail : route('book_fail',$id),//'http://newhayah.com/session/'.$id.'/fail_payment',//
            ];

            //dd($postData);
            $hashSecret=generateVapulusHash(config('app.WHEREBY_HASH_SECRET'),$postData);

            $requestParams['appId']=config('app.WHEREBY_APP_ID');
            $requestParams['password']=config('app.WHEREBY_PASSWORD');
            $requestParams['hashSecret']=$hashSecret;
            //dd(json_encode($requestParams),$hashSecret,json_encode($requestParams));
            try{
                $response=Http::post('https://api.vapulus.com:1338/app/session/pay', $requestParams);
                $res=(object)$response->json();
                $paymentLog=new PaymentLogs();
                $paymentLog->coupon_id=$coupon_id;
                $paymentLog->coupon_discount=$coupon_discount;
                $paymentLog->session_id=$session->id;
                $paymentLog->payment_session_id=$request->session_id;
                $paymentLog->statues=$res->statusCode;
                $paymentLog->datasend=json_encode($requestParams);
                $paymentLog->response=json_encode($res);
                $paymentLog->save();
                if($res->statusCode==200){
                    $data=(object)$res->data;

                    $payment=new Payments();
                    $payment->coupon_id=$coupon_id;
                    $payment->coupon_code=$coupon_code;
                    $payment->coupon_discount=$coupon_discount;
                    $payment->discount_amount=$discount_amount;
                    $payment->user_id=$userFind->id;
                    $payment->therapist_id=$session->therapist->user->id;
                    $payment->session_id=$session->id;
                    $payment->payment_session_id=$request->session_id;
                    $payment->transaction_id=$data->transactionId;
                    $payment->status=$data->status;
                    $payment->action=(isset($data->action))?$data->action:null;
                    $payment->html_body_content=(isset($data->htmlBodyContent))?$data->htmlBodyContent:null;
                    $payment->price=($session->type==30)?$therapist->price30:$therapist->price60;
                    $payment->price_dolar=($session->type==30)?$therapist->thirty_price_dollar:$therapist->sixty_price_dollar;
                    $payment->amount=(($location->countryName=='Egypt')?($amount/$dolarRate):$amount);
                    $payment->currancy=$currency;
                    $payment->dolar_rating=$dolarRate;
                    $payment->add_date=date('Y-m-d H:i:s');
                    $payment->save();

                    if($data->status!='approved'){
                        if($request->onAccept)
                        {
                            return response()->json(['success'=>true,'message'=>trans('home.Will redirect to OTP'),'res'=>$res]);
                        }
                        else
                        {
                            return response()->json(['success'=>true,'message'=>trans('home.Will redirect to OTP'),'redirect_url'=> route('book_otp_html',encrypt($payment->id))]);
                        }

                    }
                    $attributes = [
                        'visitor_id' => $visitor->id,
                        'status' => '2',
                        'session_status' => 'reserved',
                        'reserved_date' => date('Y-m-d H:i:s'),
                        'payment_method'=>'vapulus',
                        'payment_id'=>$payment->id,
                    ];
                    Sessions::where('id',$id)->update($attributes);

                    ///send email to therpist and patient
                    $allsessions=Sessions::where('id',$id)->with('visitor')->with('therapist')->first();
                    //dd($allsessions);
                    if(!empty($allsessions)){
                        $therapistUser=$allsessions->therapist->user;
                        $visitorUser=$allsessions->visitor->user;
                        $patientemail=$visitorUser->email;
                        $therapistemail=$therapistUser->email;
                        $patientname=$visitorUser->name;
                        $therapistname=$therapistUser->name;
                        $html = view('email.session_payed',compact('visitorUser','therapistUser','allsessions'))->render();
                        $sendp=sendGridEmailToUser($html,$patientemail, $patientname, 'Session Payed');
                        setTimeZone($therapistUser->timezone?$therapistUser->timezone:'Africa/Cairo');
                        $allsessions=Sessions::find($allsessions->id);
                        $html = view('email.session_payed_therapist',compact('visitorUser','therapistUser','allsessions'))->render();
                        $sendt=sendGridEmailToUser($html,$therapistemail, $therapistname, 'Session Payed');

                        $invoice=new TherapistsInvoices();
                        $invoice->therapist_id=$therapist->id;
                        $invoice->visitor_id=$visitor->id;
                        $invoice->session_id=$id;
                        $invoice->session_id=$session->id;
                        $invoice->visitor_name=$visitorUser->name;
                        $invoice->session_date=$session->start_time;
                        $invoice->therapist_price=(in_array($session->type,['30','3']))?$therapist->price30:$therapist->price60;
                        $invoice->therapist_price_dolar=(in_array($session->type,['30','3']))?$therapist->thirty_price_dollar:$therapist->sixty_price_dollar;
                        $invoice->session_type=$session->type;
                        $invoice->total_amount=$amount;
                        $invoice->currency=$currency;
                        $invoice->discount_amount=0;
                        $invoice->discount_percentage=0;
                        $invoice->coupon_id=0;
                        $invoice->coupon_code='';
                        $invoice->total_after_discount=$invoice->total_amount- $invoice->discount_amount;
                        $invoice->dolar_rating=$dolarRate;
                        $invoice->save();
                        Sessions::where('id',$session->id)->update(['invoice_id'=>$invoice->id]);
                    }

                    ////////
                    return response()->json(['success'=>true,'message'=>'success','$sendp'=>$sendp,'$sendt'=>$sendt,'redirect_url'=>route('pay-session-rating',['id'=>$id])]);
                }
                $res->redirect_url=route('book_message',encrypt($paymentLog->id));
                return response()->json($res);
            }catch (\Exception $e){
                return response()->json(['success'=>false,'message'=>$e->getMessage()]);
            }

        }
        return abort(404);
    }





    //start_session_video
    public function start_session_video($visitor_id,$session_id)
    {

        $todayDate=Carbon::now()->format('Y-m-d');
        $whereby_roomUrl=Sessions::where('visitor_id',$visitor_id)->where('id',$session_id)->whereNotIn('session_status',['cancelled','visitor_cancelled'])->whereRaw("DATE(start_time)>='$todayDate'")->first();

        if($whereby_roomUrl->whereby_roomUrl != null)
        {
            return $this->returnJsonResponse('Whereby URL', $whereby_roomUrl->whereby_roomUrl, true, 200);
        }
        else
        {
            return $this->returnJsonResponse('No URL avilable', [], true, 210);
        }

    }



    //All countries
    public function countries()
    {
        $countries = \DB::table('countries')->get();
        return $this->returnJsonResponse('All Countries', $countries, true, 210);
    }






    public function scheduleCalenderSession(Request $request){
        $therapist = Therapist::where([['user_id', $request->therapist_id]])->firstOrFail();
        $user = User::find($request->therapist_id);

        $validator = Validator::make($request->all(), [
            'type' => ['required'],
            //            'start_time' => ['required', 'date', 'after:today', new SessionStartTime],
            'start_date' => ['required', 'date'],
            'end_date' => ['required', 'date'],
            'timeSlotTime' => ['required'],
            'days' => ['required'],
            //'color' => ['required', 'string'],
            //'text_color' => ['required', 'string'],
        ]);
        if ($validator->fails()) {
            return Response::json(array(
                'success' => false,
                'errors' => $validator->getMessageBag()->toArray()
            ), 400); // 400 being the HTTP code for an invalid request.
        }

        $begin = new \DateTime($request->start_date);
        $end = new \DateTime($request->end_date);
        $end->add(new \DateInterval('P1D'));
        $interval = \DateInterval::createFromDateString('1 day');
        $period = new \DatePeriod($begin, $interval, $end);

        $x=0;
        $z = 0;
        $array=[];
        $arrayTimes=[];
        foreach ($period as $dt) {
            $start_time=date('Y-m-d H:i:s',strtotime($dt->format("Y-m-d").' '.$request->timeSlotTime));


            //dd(date('w', strtotime($start_time)),$request->days);
            if(in_array(date('w', strtotime($start_time)),$request->days)){
                $arrayTimes[]= $start_time;
                $timezone=($user->timezone)??'Africa/Cairo' ;
                setTimeZone($timezone);
                $sessionCount=Sessions::where('therapist_id',$therapist->id)->where(function($q)use($start_time,$request){
                    //$date=getConvertToMySqlDate($request->start_time);
                    $date=$start_time;
                    $q->whereBetween('start_time',[date('Y-m-d H:i:s',strtotime($date)),date('Y-m-d H:i:s',strtotime($date.' +'.$request->type.' minutes '))])
                        ->orWhere(function($q)use($request,$date){
                            $q->where('start_time','>=',date('Y-m-d H:i:s',strtotime($date)))
                                ->where('start_time','<=',date('Y-m-d H:i:s',strtotime($date.' +'.$request->type.' minutes ')));
                        })->orWhere(function($q)use ($request,$date){
                            $start_time=date('Y-m-d H:i:s',strtotime($date));
                            $end_time=date('Y-m-d H:i:s',strtotime($date.' +'.$request->type.' minutes '));
                            $q->whereRaw("'$start_time' BETWEEN start_time AND DATE_ADD(start_time,INTERVAL $request->type MINUTE)")
                                ->orWhereRaw("'$end_time' BETWEEN start_time AND DATE_ADD(start_time,INTERVAL $request->type MINUTE)");
                        });

                    //->orWhereRaw("'$curentDate' BETWEEN start_time AND DATE_ADD(start_time, INTERVAL type MINUTE)")
                    ;
                })->whereNotIn('session_status',['cancelled','visitor_cancelled']);
                //return $sessionCount->count();
                $sessionCount=$sessionCount->count();
                if($sessionCount==0){
                    $array[]=[
                        'start_time' => $start_time,
                        'type' => $request->type,
                        'session_date' => date('Y-m-d', strtotime($start_time)),
                        'status' => 1,
                        'therapist_id' => $therapist->id
                    ];


                    if(isset($user))
                    {
                        $timezone=($user->timezone)?$user->timezone:'Africa/Cairo' ;
                    }
                    else
                    {
                        $timezone='Africa/Cairo' ;
                    }
                    setTimeZone($timezone);

                    if($therapist->active == 1)
                    {
                        if( date('Y-m-d H:i:s',strtotime($start_time)) <= date('Y-m-d H:i:s',strtotime('+'.$request->type.' minutes'))){

                        }
                        else
                        {
                            $session=Sessions::create([
                                'start_time' => $start_time,
                                'type' => $request->type,
                                'session_date' => date('Y-m-d', strtotime($start_time)),
                                'status' => 1,
                                'therapist_id' => $therapist->id,
                                'topic'=>'real',
                            ]);
                            $this->createMeeting($session);
                            $x++;
                            $z++;
                            if($x==2){
                                $x=0;
                                sleep(1);
                            }
                        }

                    }
                    else
                    {
                        return response()->json(['success'=>false,'message' => ' عفوا  هذا الأكونت غير مفعل ' , 'error'=>['notActive' =>'notActive']]);
                    }


                }
            }

        }
        if(!count($array)){
            return response()->json(['success'=>false,'message' => ' هذه الجلسات مضافه من قبل ']);
        }
        elseif($z > 0)
        {
            return response()->json(['success'=>true,'message' => 'تم اضافة الجلسة بنجاح','$array'=>$array,'$arrayTimes'=>$arrayTimes]);
        }
        else
        {
            return response()->json(['success'=>false,'message' => ' هذه الجلسات مضافه من قبل ']);
        }




        // $start_times = [];
        // $start_times_with_types = [];
        // foreach ($period as $dt) {
        //     array_push($start_times, date('Y-m-d H:i:s',strtotime($dt->format("Y-m-d").' '.$request->timeSlotTime)));
        // }
        // foreach($start_times as $start)
        // {
        //     array_push($start_times_with_types, Carbon::parse($start)->addMinute($request->type)->format('Y-m-d H:i:s'));
        // }


    }









    public function calenderOperations(Request $request)
    {
        $request->merge([
            'start_time' => date('Y-m-d H:i:s',strtotime($request->start_time)),
        ]);
        $therapist = Therapist::where([['user_id', $request->therapist_id]])->firstOrFail();
        $user = User::find($request->therapist_id);
        $validator = Validator::make($request->all(), [
            'therapist_id' => ['required'],
            'type' => ['required'],
            'start_time' => ['required', 'date'],
        ], [
            'type.required' => 'من فضلك اختر نوع الجلسة',
            'start_time.required' => 'من فضلك ادخل الوقت والتاريخ',
            'start_time.date' => 'يجب ادخال تاريخ',
            'start_time.after' => 'غير مسموح باضافة مواعيد في الايام السابقة',
        ]);


        if ($validator->fails()) {
            return Response::json(array(
                'success' => false,
                'errors' => $validator->getMessageBag()->toArray()
            ), 400); // 400 being the HTTP code for an invalid request.
        }
        $timezone=($user->timezone)??'Africa/Cairo' ;
         setTimeZone($timezone);
        $sessionCount=Sessions::where('therapist_id',$therapist->id)->where(function($q)use($request){
            $date=$request->start_time;
            $q->whereBetween('start_time',[date('Y-m-d H:i:s',strtotime($date)),date('Y-m-d H:i:s',strtotime($date.' +'.$request->type.' minutes '))])
                ->orWhere(function($q)use($request,$date){
                $q->where('start_time','>=',date('Y-m-d H:i:s',strtotime($date)))
                    ->where('start_time','<=',date('Y-m-d H:i:s',strtotime($date.' +'.$request->type.' minutes ')));
            })->orWhere(function($q)use ($request,$date){
                $start_time=date('Y-m-d H:i:s',strtotime($date));
                $end_time=date('Y-m-d H:i:s',strtotime($date.' +'.$request->type.' minutes '));
                $q->whereRaw("'$start_time' BETWEEN start_time AND DATE_ADD(start_time,INTERVAL type MINUTE)")
                    ->orWhereRaw("'$end_time' BETWEEN start_time AND DATE_ADD(start_time,INTERVAL type MINUTE)");
            });

        })->whereNotIn('session_status',['cancelled','visitor_cancelled']);


        if($request->event_id){
            $sessionCount=$sessionCount->where('id','!=',$request->event_id);
        }
        $sessionCount=$sessionCount->count();
        if ( $sessionCount> 0){
            return response()->json(['success'=>false,'between'=>'0','message' => trans('home.This session date is already added or have session between this date')]);
        }
        if( date('Y-m-d H:i:s',strtotime($request->start_time)) <= date('Y-m-d H:i:s',strtotime('+'.$request->type.' minutes'))){
            return response()->json(['success'=>false,'previuos'=>'0','message' => 'يجب ان يكون وقت الجلسه بعد اكثر من '.$request->type.' دقيقه من الآن']);
        }
        else
        {
            if($therapist->active == 1)
            {
             $session = Sessions::create(array_merge($request->only('type'/*, 'start_time'*/), ['start_time'=>date('Y-m-d H:i:s', strtotime($request->start_time)),'session_date' => date('Y-m-d', strtotime($request->start_time)), 'status' => 1, 'therapist_id' => $therapist->id,'topic' =>'real']));
                $this->createMeeting($session);
                return response()->json(['success'=>true,'message' => 'تم اضافة الجلسة بنجاح', 'start_time_before' => $request->start_time, 'start_time_after' => date('Y-m-d H:i:s',strtotime($request->start_time))]);
            }
            else
            {
                return response()->json(['success'=>false,'message' => ' عفوا  هذا الأكونت غير مفعل ' , 'error'=>['notActive' =>'notActive']]);
            }
        }




        switch ($request->fun_type) {
            case 'add':
                $session = Sessions::create(array_merge($request->only('type'), ['start_time'=>date('Y-m-d H:i:s', strtotime($request->start_time)),'session_date' => date('Y-m-d', strtotime($request->start_time)), 'status' => 1, 'therapist_id' => $therapist->id]));
              $this->createMeeting($session);
                return response()->json(['success'=>true,'message' => 'تم اضافة الجلسة بنجاح']);
                break;
            case 'update':
                if(Sessions::where([ ['id',$request->event_id],['visitor_id','!=',null]])->count() > 0)
                    return response()->json(['success'=>false,'message' => 'غير مسموح بتعديل معاد الجلسة']);

                Sessions::where('id', $request->event_id)->update($request->only('type', 'start_time'));
                return response()->json(['success'=>true,'message' => 'تم تحديث الجلسة بنجاح']);
                break;
            default:
        }

    }





    //update_basic_info
    public function update_basic_info(Request $request)
    {
        $therapist =  Therapist::where([['user_id', $request->therapist_id]])->firstOrFail();
        $user =  User::where('id', $request->therapist_id)->firstOrFail();


        $validator = Validator::make($request->all(), [
            'therapist_id'=> 'required',
            'name_a'      => 'required',
            'name_e'      => 'required',
            'email'       => 'required|unique:users,email,' . $request->therapist_id . ',id',
            'main_focus'  => 'required',
            'mobile'      => 'required',
            'gender'      => 'required',
            'country_id'  => 'required',
            'language_id' => 'required',
        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
        else
        {



            $data = array(
                'therapist_id' => $request->therapist_id,
                'name_a' => $request->name_a,
                'name_e' => $request->name_e,
                'main_focus' => $request->main_focus,
                'email' => $request->email,
                'mobile' => $request->mobile,
                'gender' => $request->gender,
                'country_id' => $request->country_id,
                'language_id' => $request->language_id,
            );


            if($therapist->active == 0)
            {
                $therapist->update($data);
                $therapist->save();
                if ($therapist) {
                    $user->email = $request->email;
                    $user->save();

                    return $this->returnJsonResponse(trans('home.The data has been successfully updated'),[], true, 210);

                } else {
                    return $this->returnJsonResponse('there is something wrong. please, try again later', [], FALSE, 213);

                }
            }

            else
            {
                $therapist2 = Therapist::where('user_id', '=', $request->therapist_id)->first();

                if ($request->title_ar != $therapist2->title) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->title;
                    $dataOfReq['to'] = $request->title_ar;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'title';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }
                if ($request->title_en != $therapist2->title) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->title;
                    $dataOfReq['to'] = $request->title_en;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'title';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }

                if ($request->name_a != $therapist2->name_a) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->name_a;
                    $dataOfReq['to'] = $request->name_a;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'name_a';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }

                if ($request->name_e != $therapist2->name_e) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->name_e;
                    $dataOfReq['to'] = $request->name_e;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'name_e';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }

                if ($request->main_focus != $therapist2->main_focus) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->main_focus;
                    $dataOfReq['to'] = $request->main_focus;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'main_focus';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }

                $user2 =  User::where('id', $request->therapist_id)->first();
                if ($request->email != $user2->email) {

                    $dataOfReq=[];
                    $dataOfReq['from'] = $user2->email;
                    $dataOfReq['to'] = $request->email;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'email';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }

                if ($request->mobile != $therapist2->mobile) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->mobile;
                    $dataOfReq['to'] = $request->mobile;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'mobile';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }

                if ($request->gender != $therapist2->gender) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->gender;
                    $dataOfReq['to'] = $request->gender;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'gender';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }

                if ($request->language_id != $therapist2->language_id) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->language_id;
                    $dataOfReq['to'] = $request->language_id;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'language_id';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }

                if ($request->country_id != $therapist2->country_id) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->country_id;
                    $dataOfReq['to'] = $request->country_id;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'country_id';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }



                 return response()->json(['success' => false, 'error' =>['validate' => true]]);

            }





        }
    }




    //update_basic_info_part_2
    public function update_basic_info_part_two(Request $request)
    {
        $therapist =  Therapist::where([['user_id', $request->therapist_id]])->firstOrFail();
        $user =  User::where('id', $request->therapist_id)->firstOrFail();




        $validator = Validator::make($request->all(), [
            'therapist_id'=> 'required',
            'main_specialty_ar'      => 'required',
            'main_specialty_en'      => 'required',
            'price30'  => 'required',
            'price60'      => 'required',
            'summery_ar'      => 'required',
            'summery_en'      => 'required',
            'description_en'      => 'required',
            'description_ar'      => 'required',
            'certifications_ar'      => 'required',
            'certifications_en'      => 'required',
            'experience_en'      => 'required',
            'experience_en'      => 'required',
            'thirty_price_dollar' => 'integer|numeric|not_in:0|min:1',
            'sixty_price_dollar' => 'integer|numeric|not_in:0|min:1|gt:thirty_price_dollar',
        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
        else
        {
            $data = array(
                'therapist_id' => $request->therapist_id,
                'main_specialty_ar'      => $request->main_specialty_ar,
                'main_specialty_en'      => $request->main_specialty_en,
                'price30'  => $request->price30,
                'price60'      => $request->price60,
                'summery_ar'      => $request->summery_ar,
                'summery_en'      => $request->summery_en,
                'description_en'      => $request->description_en,
                'description_ar'      => $request->description_ar,
                'certifications_ar'      => $request->certifications_ar,
                'certifications_en'      => $request->certifications_en,
                'experience_ar'      => $request->experience_ar,
                'experience_en'      => $request->experience_en,
                'thirty_price_dollar' => $request->thirty_price_dollar,
                'sixty_price_dollar' => $request->sixty_price_dollar,
            );





            if($therapist->active == 0)
            {
                if (!empty($request->therapist_specialties)) {
                    TherapistsSpecialties::where('therapist_id', $therapist->id)->delete();
                    foreach ($request->therapist_specialties as  $value) {
                        $therapist_spec = TherapistsSpecialties::create([
                            'therapist_id' => $therapist->id,
                            'speciality_id' => $value,
                        ]);
                    }
                }

                $therapist->update($data);
                $therapist->save();
                if ($therapist) {
                    if($request->email){
                        $user->email = $request->email;
                    }
                    $user->save();
                    return $this->returnJsonResponse(trans('home.The data has been successfully updated'),[], true, 210);

                } else {
                    return $this->returnJsonResponse('there is something wrong. please, try again later', [], FALSE, 213);

                }
            }
            else
            {

                $therapist2 = Therapist::where('user_id', '=', $request->therapist_id)->first();
                if ($request->main_specialty_ar != $therapist2->main_specialty_ar) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->main_specialty_ar;
                    $dataOfReq['to'] = $request->main_specialty_ar;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'main_specialty_ar';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }
                if ($request->main_specialty_en != $therapist2->main_specialty_en) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->main_specialty_en;
                    $dataOfReq['to'] = $request->main_specialty_en;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'main_specialty_en';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }

                if ($request->price30 != $therapist2->price30) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->price30;
                    $dataOfReq['to'] = $request->price30;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'price30';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }
                if ($request->price60 != $therapist2->price60) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->price60;
                    $dataOfReq['to'] = $request->price60;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'price60';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }
                if ($request->summery_ar != $therapist2->summery_ar) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->summery_ar;
                    $dataOfReq['to'] = $request->summery_ar;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'summery_ar';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }
                if ($request->summery_en != $therapist2->summery_en) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->summery_en;
                    $dataOfReq['to'] = $request->summery_en;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'summery_en';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }
                if ($request->description_ar != $therapist2->description_ar) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->description_ar;
                    $dataOfReq['to'] = $request->description_ar;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'description_ar';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }
                if ($request->description_en != $therapist2->description_en) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->description_en;
                    $dataOfReq['to'] = $request->description_en;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'description_en';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }

                if ($request->certifications_ar != $therapist2->certifications_ar) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->certifications_ar;
                    $dataOfReq['to'] = $request->certifications_ar;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'certifications_ar';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }
                if ($request->certifications_en != $therapist2->certifications_en) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->certifications_en;
                    $dataOfReq['to'] = $request->certifications_en;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'certifications_en';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }

                if ($request->experience_ar != $therapist2->experience_ar) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->experience_ar;
                    $dataOfReq['to'] = $request->experience_ar;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'experience_ar';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }
                if ($request->experience_en != $therapist2->experience_en) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->experience_en;
                    $dataOfReq['to'] = $request->experience_en;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'experience_en';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }

                if ($request->thirty_price_dollar != $therapist2->thirty_price_dollar) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->thirty_price_dollar;
                    $dataOfReq['to'] = $request->thirty_price_dollar;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'thirty_price_dollar';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }
                if ($request->sixty_price_dollar != $therapist2->sixty_price_dollar) {
                    $dataOfReq=[];
                    $dataOfReq['from'] = $therapist2->sixty_price_dollar;
                    $dataOfReq['to'] = $request->sixty_price_dollar;
                    $dataOfReq['therapists_id'] = $therapist->id;
                    $dataOfReq['column_name'] = 'sixty_price_dollar';
                    if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($dataOfReq);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOfReq);
                    }
                }


                if($request->therapist_specialties)
                {
                    $therapistsspecialties = TherapistsSpecialties::where('therapist_id', '=',   $therapist->id)->pluck('speciality_id')->toArray();
                    foreach ($request->therapist_specialties as $specialty){
                        if(!in_array($specialty,$therapistsspecialties)||(in_array($specialty,$therapistsspecialties)&&count($request->therapist_specialties)!=count($therapistsspecialties))){
                            $dataOf=[];
                            $dataOf['from'] = (is_array($therapistsspecialties))?json_encode($therapistsspecialties):json_encode([$therapistsspecialties]);
                            $dataOf['to'] = json_encode($request->therapist_specialties);
                            $dataOf['therapists_id'] = $therapist->id;
                            $dataOf['column_name'] = 'speciality_id';
                            if(!TherapistsRequests::where('column_name',$dataOf['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                                $inserted = TherapistsRequests::create($dataOf);
                            }else{
                                $inserted =TherapistsRequests::where('column_name',$dataOf['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($dataOf);
                            }
                            break;
                        }
                    }
                }





                return response()->json(['success' => false, 'error' =>['validate' => true]]);


            }





        }
    }



    //update_basic_info_certificates
    public function update_basic_info_certificates(Request $request)
    {
        $therapist =  Therapist::where([['id', $request->therapist_id]])->first();


        $validator = Validator::make($request->all(), [
            'therapist_id' => 'required',
          //  'zip_certificates' => 'mimes:zip,pdf,doc,docx|max:5000',
        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
        else
        {
            if($therapist->active == 0)
            {
                if ($file = $request->zip_certificates) {

                    if ($request->file_ext == 'application/vnd.openxmlformats-officedocument.wordprocessingml.document')
                    {
                        $file = str_replace('data:application/vnd.openxmlformats-officedocument.wordprocessingml.document;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'docx';
                        \File::put(public_path('qualification/' . $fileName), base64_decode($file));
                        $data = ['zip_certificates' => $fileName, 'zip_certificates_file_name' => $request->file_name];
                        $therapist->update($data);
                        return $this->returnJsonResponse(trans('home.The data has been successfully updated'), [], true, 210);
                    }
                    elseif ($request->file_ext == 'application/pdf')
                    {
                        $file = str_replace('data:application/pdf;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'pdf';
                        \File::put(public_path('qualification/' . $fileName), base64_decode($file));
                        $data = ['zip_certificates' => $fileName, 'zip_certificates_file_name' => $request->file_name];
                        $therapist->update($data);
                        return $this->returnJsonResponse(trans('home.The data has been successfully updated'), [], true, 210);
                    }
                    else
                    {
                        return $this->returnJsonResponse('The file must be pdf or docx', [], true, 210);
                    }
                }
            }
            else
            {
                if ($file = $request->zip_certificates) {

                    if ($request->file_ext == 'application/vnd.openxmlformats-officedocument.wordprocessingml.document')
                    {
                        $file = str_replace('data:application/vnd.openxmlformats-officedocument.wordprocessingml.document;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'docx';
                        \File::put(public_path('qualification/' . $fileName), base64_decode($file));
                    }
                    elseif ($request->file_ext == 'application/pdf')
                    {
                        $file = str_replace('data:application/pdf;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'pdf';
                        \File::put(public_path('qualification/' . $fileName), base64_decode($file));
                    }

                    $therapist2 = Therapist::where('id', '=', $request->therapist_id)->first();

                    if($therapist2->zip_certificates == '' && $therapist2->zip_certificates_file_name == '')
                    {
                        $this->dataOfRequest('', $fileName,$therapist->id,'zip_certificates');
                        $this->dataOfRequest('', $request->file_name,$therapist->id,'zip_certificates_file_name');
                    }
                    else
                    {
                        $this->dataOfRequest($therapist2->zip_certificates, $fileName,$therapist->id,'zip_certificates');
                        $this->dataOfRequest($therapist2->zip_certificates_file_name, $request->file_name,$therapist->id,'zip_certificates_file_name');
                    }




                    return response()->json(['success' => false, 'error' =>['validate' => true]]);


                }

            }




        }
    }





    //update_basic_info_resume
    public function update_basic_info_resume(Request $request)
    {
        $therapist =  Therapist::where([['id', $request->therapist_id]])->first();


        $validator = Validator::make($request->all(), [
            'therapist_id'=> 'required',
          //  'resume' => 'mimes:pdf,doc,docx',
        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
        else
        {
            if($therapist->active == 0)
            {
                if ($file = $request->resume) {

                    if ($request->file_ext == 'application/vnd.openxmlformats-officedocument.wordprocessingml.document')
                    {
                        $file = str_replace('data:application/vnd.openxmlformats-officedocument.wordprocessingml.document;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'docx';
                        \File::put(public_path('resumes/' . $fileName), base64_decode($file));
                        $data = ['resume' => $fileName, 'resume_file_name' => $request->file_name];
                        $therapist->update($data);
                        return $this->returnJsonResponse(trans('home.The data has been successfully updated'), [], true, 210);
                    }
                    elseif ($request->file_ext == 'application/pdf')
                    {
                        $file = str_replace('data:application/pdf;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'pdf';
                        \File::put(public_path('resumes/' . $fileName), base64_decode($file));
                        $data = ['resume' => $fileName, 'resume_file_name' => $request->file_name];
                        $therapist->update($data);
                        return $this->returnJsonResponse(trans('home.The data has been successfully updated'), [], true, 210);
                    }
                    else
                    {
                        return $this->returnJsonResponse('The file must be pdf or docx', [], true, 210);
                    }
                }
            }
            else
            {
                if ($file = $request->resume) {

                    if ($request->file_ext == 'application/vnd.openxmlformats-officedocument.wordprocessingml.document')
                    {
                        $file = str_replace('data:application/vnd.openxmlformats-officedocument.wordprocessingml.document;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'docx';
                        \File::put(public_path('resumes/' . $fileName), base64_decode($file));
                    }
                    elseif ($request->file_ext == 'application/pdf')
                    {
                        $file = str_replace('data:application/pdf;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'pdf';
                        \File::put(public_path('resumes/' . $fileName), base64_decode($file));
                    }

                    $therapist2 = Therapist::where('id', '=', $request->therapist_id)->first();

                    if($therapist2->resume == '' && $therapist2->resume_file_name == '')
                    {
                        $this->dataOfRequest('', $fileName,$therapist->id,'resume');
                        $this->dataOfRequest('', $request->file_name,$therapist->id,'resume_file_name');
                    }
                    else
                    {
                        $this->dataOfRequest($therapist2->resume, $fileName,$therapist->id,'resume');
                        $this->dataOfRequest($therapist2->zip_certificates_file_name, $request->file_name,$therapist->id,'resume_file_name');
                    }




                    return response()->json(['success' => false, 'error' =>['validate' => true]]);


                }
            }


        }
    }


    //update_basic_info_licence
    public function update_basic_info_licence(Request $request)
    {
        $therapist =  Therapist::where([['id', $request->therapist_id]])->first();


        $validator = Validator::make($request->all(), [
            'therapist_id'=> 'required',
           // 'licence' => 'mimes:jpg,jpeg,png',
        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
        else
        {
            if($therapist->active == 0)
            {
                if ($file = $request->licence) {

                    if ($request->file_ext == 'image/png')
                    {
                        $file = str_replace('data:image/png;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'png';
                        \File::put(public_path('licences/' . $fileName), base64_decode($file));
                        $data = ['licence' => $fileName, 'licence_file_name' => $request->file_name];
                        $therapist->update($data);
                        return $this->returnJsonResponse(trans('home.The data has been successfully updated'), [], true, 210);
                    }
                    elseif ($request->file_ext == 'image/jpg')
                    {
                        $file = str_replace('data:image/jpg;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'jpg';
                        \File::put(public_path('licences/' . $fileName), base64_decode($file));
                        $data = ['licence' => $fileName, 'licence_file_name' => $request->file_name];
                        $therapist->update($data);
                        return $this->returnJsonResponse(trans('home.The data has been successfully updated'), [], true, 210);
                    }
                    elseif ($request->file_ext == 'image/jpeg')
                    {
                        $file = str_replace('data:image/jpeg;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'jpeg';
                        \File::put(public_path('licences/' . $fileName), base64_decode($file));
                        $data = ['licence' => $fileName, 'licence_file_name' => $request->file_name];
                        $therapist->update($data);
                        return $this->returnJsonResponse(trans('home.The data has been successfully updated'), [], true, 210);
                    }
                    elseif ($request->file_ext == 'image/gif')
                    {
                        $file = str_replace('data:image/gif;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'gif';
                        \File::put(public_path('licences/' . $fileName), base64_decode($file));
                        $data = ['licence' => $fileName, 'licence_file_name' => $request->file_name];
                        $therapist->update($data);
                        return $this->returnJsonResponse(trans('home.The data has been successfully updated'), [], true, 210);
                    }
                    else
                    {
                        return $this->returnJsonResponse('The image must be png,jpg or jpeg', [], true, 210);
                    }
                }
            }
            else
            {
                if ($file = $request->licence) {


                    if ($request->file_ext == 'image/png')
                    {
                        $file = str_replace('data:image/png;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'png';
                        \File::put(public_path('licences/' . $fileName), base64_decode($file));
                    }
                    elseif ($request->file_ext == 'image/jpg')
                    {
                        $file = str_replace('data:image/jpg;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'jpg';
                        \File::put(public_path('licences/' . $fileName), base64_decode($file));
                    }
                    elseif ($request->file_ext == 'image/jpeg')
                    {
                        $file = str_replace('data:image/jpeg;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'jpeg';
                        \File::put(public_path('licences/' . $fileName), base64_decode($file));
                    }
                    elseif ($request->file_ext == 'image/gif')
                    {
                        $file = str_replace('data:image/gif;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'gif';
                        \File::put(public_path('licences/' . $fileName), base64_decode($file));
                    }


                    $therapist2 = Therapist::where('id', '=', $request->therapist_id)->first();

                    if($therapist2->licence == '' && $therapist2->licence_file_name == '')
                    {
                        $this->dataOfRequest('', $fileName,$therapist->id,'licence');
                        $this->dataOfRequest('', $request->file_name,$therapist->id,'licence_file_name');
                    }
                    else
                    {
                        $this->dataOfRequest($therapist2->licence, $fileName,$therapist->id,'licence');
                        $this->dataOfRequest($therapist2->zip_certificates_file_name, $request->file_name,$therapist->id,'licence_file_name');
                    }




                    return response()->json(['success' => false, 'error' =>['validate' => true]]);


                }
            }


        }
    }


    //update_basic_info_picture
    public function update_basic_info_picture(Request $request)
    {
        $therapist =  Therapist::where([['id', $request->therapist_id]])->first();


        $validator = Validator::make($request->all(), [
            'therapist_id'=> 'required',
         //   'picture' => 'mimes:jpg,jpeg,png',
        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
        else
        {


            if($therapist->active == 0)
            {
                if ($file = $request->picture) {

                    if ($request->file_ext == 'image/png')
                    {
                        $file = str_replace('data:image/png;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'png';
                        \File::put(public_path('avatars/therapists/' . $fileName), base64_decode($file));
                        $data = ['picture' => $fileName, 'picture_file_name' => $request->file_name];
                        $therapist->update($data);
                        return $this->returnJsonResponse(trans('home.The data has been successfully updated'), [], true, 210);
                    }
                    elseif ($request->file_ext == 'image/jpg')
                    {
                        $file = str_replace('data:image/jpg;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'jpg';
                        \File::put(public_path('avatars/therapists/' . $fileName), base64_decode($file));
                        $data = ['picture' => $fileName, 'picture_file_name' => $request->file_name];
                        $therapist->update($data);
                        return $this->returnJsonResponse(trans('home.The data has been successfully updated'), [], true, 210);
                    }
                    elseif ($request->file_ext == 'image/jpeg')
                    {
                        $file = str_replace('data:image/jpeg;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'jpeg';
                        \File::put(public_path('avatars/therapists/' . $fileName), base64_decode($file));
                        $data = ['picture' => $fileName, 'picture_file_name' => $request->file_name];
                        $therapist->update($data);
                        return $this->returnJsonResponse(trans('home.The data has been successfully updated'), [], true, 210);
                    }
                    elseif ($request->file_ext == 'image/gif')
                    {
                        $file = str_replace('data:image/gif;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'gif';
                        \File::put(public_path('avatars/therapists/' . $fileName), base64_decode($file));
                        $data = ['picture' => $fileName, 'picture_file_name' => $request->file_name];
                        $therapist->update($data);
                        return $this->returnJsonResponse(trans('home.The data has been successfully updated'), [], true, 210);
                    }
                    else
                    {
                        return $this->returnJsonResponse('The image must be png,jpg or jpeg', [], true, 210);
                    }
                }
            }
            else
            {
                if ($file = $request->picture) {


                    if ($request->file_ext == 'image/png')
                    {
                        $file = str_replace('data:image/png;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'png';
                        \File::put(public_path('avatars/therapists/' . $fileName), base64_decode($file));
                    }
                    elseif ($request->file_ext == 'image/jpg')
                    {
                        $file = str_replace('data:image/jpg;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'jpg';
                        \File::put(public_path('avatars/therapists/' . $fileName), base64_decode($file));
                    }
                    elseif ($request->file_ext == 'image/jpeg')
                    {
                        $file = str_replace('data:image/jpeg;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'jpeg';
                        \File::put(public_path('avatars/therapists/' . $fileName), base64_decode($file));
                    }
                    elseif ($request->file_ext == 'image/gif')
                    {
                        $file = str_replace('data:image/gif;base64,', '', $file);
                        $file = str_replace(' ', '+', $file);
                        $fileName = Str::random(10).'.'.'gif';
                        \File::put(public_path('avatars/therapists/' . $fileName), base64_decode($file));
                    }


                    $therapist2 = Therapist::where('id', '=', $request->therapist_id)->first();

                    if($therapist2->picture == '' && $therapist2->picture_file_name == '')
                    {
                        $this->dataOfRequest('', $fileName,$therapist->id,'picture');
                        $this->dataOfRequest('', $request->file_name,$therapist->id,'picture_file_name');
                    }
                    else
                    {
                        $this->dataOfRequest($therapist2->picture, $fileName,$therapist->id,'picture');
                        $this->dataOfRequest($therapist2->zip_certificates_file_name, $request->file_name,$therapist->id,'picture_file_name');
                    }




                    return response()->json(['success' => false, 'error' =>['validate' => true]]);


                }
            }

        }
    }





    public function dataOfRequest($from, $to, $therapist_id, $column_name)
    {
        $dataOfReq=[];
        $dataOfReq['from'] = $from;
        $dataOfReq['to'] =  $to;
        $dataOfReq['therapists_id'] = $therapist_id;
        $dataOfReq['column_name'] = $column_name;
        if(!TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist_id)->where('status','pending')->count()){
            $inserted = TherapistsRequests::create($dataOfReq);
        }else{
            $inserted =TherapistsRequests::where('column_name',$dataOfReq['column_name'])->where('therapists_id',$therapist_id)->where('status','pending')->update($dataOfReq);
        }
    }




    function file64Uploader($file, $folder_name)
    {
        $folder='/' . $folder_name . '/';
        if (!file_exists(public_path() . $folder)) {
            \File::makeDirectory(public_path() . $folder, $mode=0777, TRUE, TRUE);
        }
        $image = $file;
        $extension = explode('/', explode(':',substr($image, 0,strpos($image, ';')))[1])[1];   // .jpg .png .pdf

        $image=explode(';base64,',$image)[1];
        $filename = $folder_name . '_' . rand(0000, 9999) . '_' . time() .'.'. $extension;
        file_put_contents(public_path($folder. $filename), base64_decode($image));
        return ['img'=>$filename, 'img_dir'=>$folder];
    }



    ///Visitor Cancel Session
    //Request Params: ['token','user_id', 'session_id', 'cancel_reason']
    //URL: /api/v1/user/cancelSessionForVisitor
    //Method:post
    public function cancelSessionForVisitor(Request $request){
        $userData = User::findOrFail($request->user_id);
        $visitor = Visitor::where([['user_id', $request->user_id]])->first();
        $userData->visitor = $visitor;
        if ($visitor) {
            if($request->session_id){
                $date=date('Y-m-d H:i:s');
                $date8hours=date('Y-m-d H:i:s',strtotime('- 8 hours'));
                if(Sessions::where('id',$request->session_id)->where('visitor_id',$visitor->id)->where('session_status','reserved')->whereBetween('start_time',[$date,$date8hours])->count()){
                    return response()->json(['success'=>false,'message'=>trans('home.The session may not be canceled 8 hours before the scheduled time')]);
                }
                $session=Sessions::where('visitor_id',$visitor->id)->find($request->session_id);
                if($session){
                    if($session->start_time<=$date){
                        return response()->json(['success'=>false,'message'=>trans('home.The session date is gone')]);
                    }
                    $session->visitor_id=NULL;
                    $session->status=1;
                    $session->session_status='available';
                    $session->cancelled_reason=$request->cancel_reason;
                    $session->cancelled_date=date('Y-m-d H:i:s');
                    $session->save();
                    TherapistsInvoices::where('session_id',$request->session_id)->where('visitor_id',$visitor->id)->delete();
                    sendCanceledEmail([$session], $userData->name,'therapist');
                    return response()->json(['success'=>true, 'message'=>'The session is cancelled successfully']);
                }

            }
        }
        return response()->json(['success'=>false, 'message'=>'The visitor is not found']);
    }




    //Therapist Cancel Session
    //Request Params: ['token','session_id', 'user_id', 'cancel_reason', 'cancel_reason']
    //URL: /api/v1/cancelSessionsForTherapist
    //Method:post
    public function cancelSessionsForTherapist(Request $request){
        $userData = User::findOrFail($request->user_id);
        $therapist = Therapist::where([['user_id', $request->user_id]])->first();
        $userData->therapist = $therapist;
        if ($therapist && $therapist->active == 1) {
            if($request->id){
                if(Sessions::where('id',$request->id)->where('therapist_id',$therapist->id)->where('session_status','reserved')->whereBetween('start_time',[date('Y-m-d H:i:s'),date('Y-m-d H:i:s',strtotime('- 8 hours'))])->count()){
                    return response()->json(['success'=>false,'message'=>trans('home.The session may not be canceled 8 hours before the scheduled time')]);
                }
                $session=Sessions::where('therapist_id',$therapist->id)->find($request->session_id);//->delete();
                if($session){
                    $session->status=3;
                    $session->session_status='cancelled';
                    $session->cancelled_date=date('Y-m-d H:i:s');
                    $session->cancelled_reason=$request->cancel_reason;
                    $session->save();
                    TherapistsInvoices::where('session_id',$request->session_id)->where('therapist_id',$therapist->id)->delete();
                    if($session->visitor){
                        sendCanceledEmail([$session], $userData->name,'visitor');
                    }
                    return response()->json(['success'=>true, 'message'=>'The session is cancelled successfully']);
                }

            }
        }
        return response()->json(['success'=>false, 'message'=>'The therapist is not found']);
    }




    public function getSecrets($id,Request $request){
        if(!$request->mobile){
            return response()->json(['success'=>false,'message'=>trans('home.Mobile is required')]);
        }
        $session = Sessions::withTrashed()->findOrFail($id);
        if($session->visitor_id||!in_array($session->session_status,['available','reserved'])||$session->deleted_at){
            return response()->json(['success'=>false,'message'=>'failed','redirect_url'=>route('therapists_preview',$session->therapist_id)]);
        }

        $location = Location::get($request->ip());
        $userData=$request->user_id;
        $userFind = User::findOrFail($userData);
        $visitor=Visitor::where('user_id',$userData)->first();
        $therapist=Therapist::find($session->therapist_id);
        if($session&&$therapist&&$visitor){
            $visitor->mobile=$request->mobile;
            $visitor->save();
            $dolarRate=getAppSetting('dolar_rating');
            if(!$dolarRate){
                $dolarRate=1;
            }
            $coupon_id=0;
            $coupon_code='';
            $coupon_discount=0;
            $discount_amount=0;
            $amount=($location->countryName=='Egypt')?(in_array($session->type,['30','3'])?$therapist->price30:$therapist->price60):($session->type=='30'?$therapist->thirty_price_dollar:$therapist->sixty_price_dollar);
            $currency=($location->countryName=='Egypt')?'EGP':'USD';
            if($request->coupon){
                $coupon=Coupons::where('code',$request->coupon)->first();
                if($coupon){
                    if($coupon->used_for_session!='all'&&$coupon->used_for_session!=$session->type){
                        return response()->json(['success'=>false,'message'=>trans('home.This coupon not for this type of sessions')]);
                    }
                    if($coupon->currency!='all'&&$coupon->currency!=$currency){
                        return response()->json(['success'=>false,'message'=>trans('home.This coupon not for currency').trans('home.'.$currency)]);
                    }
                    if($coupon->used_limit<=$coupon->used){
                        return response()->json(['success'=>false,'message'=>trans('home.This coupon used for limited users')]);
                    }
                    if($coupon->expired_date<=date('Y-m-d')){
                        return response()->json(['success'=>false,'message'=>trans('home.This coupon expired')]);
                    }
                    $coupon_id=$coupon->id;
                    $coupon_code=$coupon->code;
                    $coupon_discount=$coupon->percentage;
                    $discount_amount=($amount*$coupon_discount)/100;
                    $amount=$amount-$discount_amount;

                }
            }

            $postData=$requestParams=[
                'sessionId'=>$request->session_id,
                'mobileNumber'=>$request->mobile,
                'email'=>$userFind->email,
                'amount'=>($location->countryName=='Egypt')?round($amount/$dolarRate):$amount,
                //'amount'=>1,
                'currencyIso'=>$currency,
                'firstName'=>($visitor->gender=='male')?'Mr.':'Ms.',
                'lastName'=>$userFind->name,
                'onAccept'=>route('book_success',$id),//'http://newhayah.com/session/'.$id.'/book_success',//
                'onFail'=>route('book_fail',$id),//'http://newhayah.com/session/'.$id.'/fail_payment',//
            ];

            //dd($postData);
            $hashSecret=generateVapulusHash(config('app.WHEREBY_HASH_SECRET'),$postData);

            $requestParams['appId']=config('app.WHEREBY_APP_ID');
            $requestParams['password']=config('app.WHEREBY_PASSWORD');
            $requestParams['hashSecret']=$hashSecret;

            return response()->json(['success'=>true, 'params'=>$requestParams, 'hashSecret'=>$hashSecret ]);
        }
        return response()->json(['success'=>false]);
    }






    // /aboutus
    public function staticPages(Request $request)
    {
        $static_pages = DB::table('static_pages')->get();

        $array =[];

        if ($request->links == 'social')
        {
            $data = [
                'facebook' => 'https://www.facebook.com/newhayahuk',
                'instagram' => 'https://www.instagram.com/newhayahuk/',
                'twitter' => 'https://twitter.com/newhayahuk',
                'youtube' => 'https://www.youtube.com/channel/UCi2PFQag9zjE3X7OWtfdTrw',
                'snapchat' => 'https://www.snapchat.com/add/newhayahuk',
                'linkedin' => 'https://www.linkedin.com/company/newhayahuk',
            ];
            array_push($array, $data);
        }
        else
        {
            foreach($static_pages as $s)
            {
                $key = str_replace(' ','',$s->title_en);
                $key = str_replace('&','',$key);
                $key = str_replace('\'','',$key);
                array_push($array, [$key=>$s]);
            }
        }

        return response()->json(['success'=>true, 'data'=>$array]);
    }



    //deleteSessionsForTherapist
    public function deleteSessionsForTherapist(Request $request)
    {
        $todayDate=Carbon::now()->format('Y-m-d');
        $therapist = Therapist::where('user_id', $request->user_id)->first();
        $deleteSession=Sessions::whereNull('visitor_id')->where('session_status', '!=','reserved')->whereId($request->id)->where('therapist_id',$therapist->id)->whereRaw("DATE(start_time)>='$todayDate'")->first();
        if($deleteSession)
        {
            $deleteSession->delete();
            return response()->json(['success' => true, 'message' => ' تم حذف الجلسه بنجاح ']);
        }
        else
        {
            return response()->json(
                ['success' => false,
                'message' => ' الجلسه محجوزه ',
                'error' => ['booked' => 'this session is booked already']]);
        }
    }





    //client file
    public function client_file(Request $request)
    {
        $session = Sessions::whereId($request->session_id)->first();
        $visitor = Visitor::findOrFail($request->visitor_id);
        $user = User::findOrFail($visitor->user_id);

        $todayDate=Carbon::now()->format('Y-m-d');
        $previousSessions=Sessions::where('visitor_id', $request->visitor_id)
        ->where('therapist_id',$request->therapist_id)
        ->where('start_time','>=', date('Y-m-d H:i:s',strtotime($session->start_time))  )->get()->toArray();

        foreach ($previousSessions as $x=>$previousSession){
            $previousSessions[$x]['start_time']=date('Y-m-d H:i:s',strtotime($previousSession['start_time']));
            $previousSessions[$x]['session_date']=date('Y-m-d',strtotime($previousSession['session_date']));
        }




        return response()->json(['success' => true ,
            'user' => $user,
            'visitor' => $visitor,
            'sessions' => $previousSessions
        ]);
    }




    //session rate
    public function insertRate(Request $request,$id)
    {
        $validator = Validator::make($request->all(), [
            'answer1' => 'required',
            'answer2' => 'required',
            'answer3' => 'required',
            'answer4' => 'required',
           // 'comment' => 'required',
            'rating' => 'required',

        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }

        $sessionData = Sessions::findOrFail($id);
        $reviewData = Reviews::create(array_merge($request->only('comment','rating','answer1','answer2','answer3','answer4'),['therapist_id'=>$sessionData->therapist_id,'visitor_id'=>$sessionData->visitor_id,'session_id'=>$id]));
        // foreach ($request->question as $key=>$value)
        // {
        //     ReviewsQuestionAnswer::create([
        //         'question'=>$value,
        //         'answer'=>$request->answer[$key],
        //         'review_id'=>$reviewData->id
        //     ]);
        // }

        return response()->json(['success' => true ,
            'message' => trans('home.Your rating was added successfully'),
        ]);


    }







    public static function createMeeting($session){
        $timezone='UTC' ;
        setTimeZone($timezone);
        $session=Sessions::find($session->id);
        $requestParams=[
            'isLocked'=>false,
            'roomNamePrefix'=>'Meeting-'.$session->id,
            'startDate'=>date($session->start_time,strtotime('-5 minutes')),
            'endDate'=>date($session->start_time,strtotime('+ '.$session->type.' minutes')),
            'fields'=>[
                'hostRoomUrl'
            ]
        ];
        $headerParams=['authorization:Bearer '.config('app.WHEREBY_API_KEY')];
        $response=self::curlRequest('https://api.whereby.dev/v1/meetings','POST',$requestParams,$headerParams,true);
        if(!isset($response->error)){
            $session->whereby_startDate=date('Y-m-d H:i:s',strtotime($response->startDate));
            $session->whereby_endDate=date('Y-m-d H:i:s',strtotime($response->endDate));;
            $session->whereby_roomUrl=$response->roomUrl;
            $session->whereby_meetingId=$response->meetingId;
            $session->whereby_hostRoomUrl=$response->hostRoomUrl;
            $session->meeting_provider='whereby';
            $session->save();

        }
        return $session;
    }





    public static function curlRequest($url,$method='GET',$requestParams=[],$headerParams=[],$creatMeeting=false){
        if($creatMeeting){
            $curl = curl_init();
            $headerParams[]= "accept: */*";
            $headerParams[]= "accept-language: en-US,en;q=0.8";
            $headerParams[]= "content-type: application/json";
            $arr=array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30000,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $method,
                CURLOPT_HTTPHEADER => $headerParams,
            );
            if($method=='POST'){
                $arr[CURLOPT_POSTFIELDS]=json_encode($requestParams);
            }
            curl_setopt_array($curl, $arr);
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);

            if ($err) {
                echo "cURL Error #:" . $err;
            } else {
                return json_decode($response);
            }
        }else{
            $content = '';
            if($method=='POST') {
                foreach ($requestParams as $key => $val) {
                    if ($content) {
                        $content .= '&' . $key . '=' . $val;
                    } else {
                        $content .= $key . '=' . $val;
                    }
                }
            }
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $method,
                CURLOPT_POSTFIELDS => $content,
                CURLOPT_HTTPHEADER => $headerParams,
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) {
                echo "cURL Error #:" . $err;
            } else {
                return json_decode($response);
            }
        }

    }





    //getAvailableSessionsForScheduling
    public function getAvailableSessionsForScheduling(Request $request)
    {
        $session = Sessions::find($request->session_id);
        if($session)
        {
            $sessions = Sessions::where('therapist_id', $session->therapist_id)->where('id', '!=', $session->id)->where('start_time', '>', Carbon::now()->format('Y-m-d H:i:m'))->where('session_status', 'available')->where('type', $session->type)->get()->toArray();
            foreach ($sessions as $x=>$nextSession){
                $sessions[$x]['start_time']=date('Y-m-d H:i:s',strtotime($nextSession['start_time']));
                $sessions[$x]['session_date']=date('Y-m-d',strtotime($nextSession['session_date']));
            }
            $sessions=collect($sessions)->groupBy(function($session) {
                    return date('Y-m-d',strtotime($session['start_time']));
                })->mapToGroups(function($sessions, $date) {
                    return ['data' => ['date' => $date, 'sessions'=> $sessions]];
                });

            $therapist = Therapist::find($session->therapist_id);

            $data = [
                    'sessions'=> $sessions,
                    'therapist'=> $therapist,
                ];
                return $this->returnJsonResponse('Available Sessions', $data, true, 200);

        }
        else
        {
            return response()->json(['success'=>false,'message'=>'Session not found']);
        }

    }




    //
    public function schedulingSession(Request $request){


        if($request->session_id&&$request->scheduling_session_id){
            $currentSession=Sessions::where('session_status','reserved')->find($request->session_id);
            if($currentSession&&date('Y-m-d H:i:s',strtotime($currentSession->start_time))>date('Y-m-d H:i:s')){
                $visitor=Visitor::where( [['user_id',auth('api')->user()->id]] )->first();
                $selectedSession=Sessions::where('session_status','available')->where('therapist_id',$currentSession->therapist_id)->find($request->scheduling_session_id);
                if($selectedSession){
                    SessionsSchedules::create([
                        'session_id'=>$currentSession->id,
                        'session_schedule_id'=>$selectedSession->id,
                        'user_id'=>auth('api')->user()->id,
                        'visitor_id'=>$visitor->id,
                    ]);
                    $selectedSession->visitor_id=$visitor->id;
                    $selectedSession->status=2;
                    $selectedSession->session_status='reserved';
                    $selectedSession->reserved_date=date('Y-m-d H:i:s');
                    $selectedSession->payment_method=$currentSession->payment_method;
                    $selectedSession->payment_id=$currentSession->payment_id;
                    $selectedSession->save();
                    Payments::where('id',$currentSession->payment_id)->update(['session_id'=>$selectedSession->id]);

                    TherapistsInvoices::where('id',$currentSession->invoice_id)->update(['session_id'=>$selectedSession->id,'session_date'=>date('Y-m-d H:i:s',strtotime($selectedSession->start_time))]);
                    $currentSession->session_status='available';
                    $currentSession->visitor_id=NULL;
                    $currentSession->status=1;
                    $currentSession->reserved_date=NULL;
                    $currentSession->payment_method=NULL;
                    $currentSession->payment_id=0;
                    $currentSession->save();
                    $therapistUser=$currentSession->therapist->user;
                     $html=view('email.session_scheduling_therapist',compact('selectedSession','currentSession','therapistUser'));
                     sendGridEmailToUser($html,$therapistUser->email,$therapistUser->name,'Scheduling Session');
                    return response()->json(['success'=>true,'message'=>trans('home.Scheduling Done')]);
                }
                return response()->json(['success'=>false,'message'=>trans('home.This session is not available')]);
            }
            return response()->json(['success'=>false,'message'=>trans('home.Your session you try to scheduling must be with date grete than now')]);
        }
    }









    //Social LOGIN
    public function callback($social,Request $request){

       $user=User::where('email',$request->email)->first();
       if(!$user){
           $user=new User();
           $user->type='visitors';
           $user->active=1;
           $user->name=$request->name;
           $user->email=$request->email;
           $user->login_with=$social;
           $user->password=$request->password;
           $user->save();
           $newVisitor=new Visitor();
           $newVisitor->user_id=$user->id;
           $newVisitor->gender='male';
           $newVisitor->save();
       }
       if($user->type=='visitors'&&$user->active==0){
           $user->active=1;
           $user->save();
           Visitor::where('user_id',$user->id)->update(['active'=>1]);
       }
        if (!$token = JWTAuth::fromUser($user)) {
                return $this->returnJsonResponse('Unauthorized',
                [], FALSE, 209);
        }

        if(request('platform') && request('platform_token'))
        {
            if(!\DB::table('firebase_tokens')->where('user_id', $user->id)->where('platform_token', request('platform_token'))->exists())
            {
                $data =[
                    'user_id' => $user->id,
                    'platform' => request('platform'),
                    'platform_token' => request('platform_token'),
                ];
                \DB::table('firebase_tokens')->insert($data);
            }
        }

        if(request()->header('lang') == 'en' )
            {
                \DB::table('users')->whereId($user->id)->update(['lang'=>'en']);
            }
            else
            {
                \DB::table('users')->whereId($user->id)->update(['lang'=>'ar']);
            }

        auth('api')->login($user);
        return $this->createNewToken($token);
   }


    protected function createNewToken(string $token, $isActivated = null)
    {
        if(auth('api')->user()->type=='visitors'){
            return $this->returnJsonResponse('success',
                array_merge( (array)User::visitorProfile(auth('api')->id()),[
                    'access_token'          => $token,
                    'token_type'            => 'bearer',
                    'expires_in'            =>  auth('api')->factory()->getTTL() * 60*60*7
                ])

            );
        }
        else
        {
            return $this->returnJsonResponse('You are not a patient',
                [], FALSE, 209);
        }
    }






    //update timezone for user
    public function changeTimeZone(Request $request){
        if($request->timezone&&$request->user_id){

            $user = User::find($request->user_id);

            $user->timezone=$request->timezone;
            $user->save();

            return $this->returnJsonResponse('Timezone changed successfully',
                [], true, 200);
        }
        return $this->returnJsonResponse('timezone and user_id are required',
                [], FALSE, 209);
    }




    //therapists clients
    public function therapistClients(Request $request)
    {
        $userData = User::findOrFail($request->user_id);
        $therapistInfo = Therapist::where('user_id', $request->user_id)->first();


        $sessionsData = Sessions::with('therapist')->where([['therapist_id', '=', $therapistInfo->id], ['visitor_id', '!=', null]])->get();

        foreach ($sessionsData as $x=>$sessionsDat){
            $sessionsData[$x]->start_time=date('Y-m-d H:i:s',strtotime($sessionsDat->start_time));
            $sessionsData[$x]->session_date=date('Y-m-d',strtotime($sessionsDat->session_date));
        }



        $ClientInfo = Therapist::getClientData($sessionsData);


        $data = [];

        if($request->search)
        {
            foreach($ClientInfo as $key=>$value)
            {
                $visitor = Visitor::find($value);
                if(isset($visitor))
                {
                    $user = User::where('name', 'LIKE', '%'.$request->search.'%')->whereId($visitor->user_id)->first();
                }

                if($user)
                {
                    $s = Sessions::latest()->where('visitor_id',$value)->first()->start_time;


                    $array = [
                        'username' => $user->name ,
                        'created_at' => $user->created_at,
                        'session_date' =>  date('Y-m-d H:i:s',strtotime($s)),
                        'sessions_count' => Sessions::where(['therapist_id'=>$therapistInfo->id,'visitor_id'=>$value])->count() ,
                    ];
                    array_push($data, $array);
                }

            }
        }
        else
        {
            foreach($ClientInfo as $key=>$value)
            {
                $visitor = Visitor::find($value);
                if(isset($visitor))
                {
                    $user = User::find($visitor->user_id);
                }

                $s = Sessions::latest()->where('visitor_id',$value)->first()->start_time;

                $array = [
                    'username' => $user->name ,
                    'created_at' =>  date('Y-m-d H:i:s',strtotime($user->created_at)),
                    'session_date' => date('Y-m-d H:i:s',strtotime($s)),
                    'sessions_count' => Sessions::where(['therapist_id'=>$therapistInfo->id,'visitor_id'=>$value])->count() ,
                ];
                array_push($data, $array);
            }
        }
        $sort_data = collect($data)->sortBy('session_date')->reverse()->toArray();
        $data = $this->custom_paginate($sort_data);

        return $this->returnJsonResponse('Therapist Clients',
                $data, true, 200);
    }

    function custom_paginate($data)
    {
        $currentPage = LengthAwarePaginator::resolveCurrentPage();
        $collection = new Collection($data);
        $per_page = 15;
        $currentPageResults = $collection->slice(($currentPage - 1) * $per_page, $per_page)->values();
        $data['results'] = new LengthAwarePaginator($currentPageResults, count($collection), $per_page);
        return $data['results']->setPath(request()->url());
    }




    //therapists clients files
    public function clients_files(Request $request)
    {
        $userData = User::findOrFail($request->user_id);
        $therapist = Therapist::where('user_id', $request->user_id)->firstOrFail();
        $therapistSessions = Sessions::where(['therapist_id' => $therapist->id,['visitor_id','!=',null]])->whereNotIn('session_status',['cancelled','visitor_cancelled'])->orderBy('start_time','asc')->get()->unique('visitor_id');



        $data = [];

        if($request->search)
        {
            foreach($therapistSessions  as $therapist_session)
            {

                $visitor = Visitor::find($therapist_session->visitor_id);
                if(isset($visitor))
                {
                    $user = User::where('name', 'LIKE', '%'.$request->search.'%')->whereId($visitor->user_id)->first();
                }
                if($user)
                {
                    $array = [
                        'sessionId' =>$therapist_session->id,
                        'visitor' => $visitor,
                        'username' => $user->name ,
                        'first_session' => date('Y-m-d h:i A',strtotime($therapist_session->start_time)),
                        'first_session_type' => $therapist_session->type,
                        'last_session' => date('Y-m-d h:i A',strtotime(\App\Sessions::latest()->whereNotIn('session_status',['cancelled','visitor_cancelled'])->where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->first()->start_time)) ,
                        'last_session_type' => \App\Sessions::latest()->where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->first()->type ,
                        'reportPDF'=>url('/clientViewPlanForMobile/'.$user->id.'/'.$therapist_session->id),
                    ];
                    array_push($data, $array);
                }

            }
        }
        else
        {
            foreach($therapistSessions  as $therapist_session)
            {
                $treatmentPlan = false;
                if( \App\TreatmentPlan::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->count() > 0 )
                {
                   $treatmentPlan = true;
                   $treatmentPlanChat = TreatmentPlan::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->first()->allow_chat;
                }
                else
                {
                    $treatmentPlan = false;
                    $treatmentPlanChat = 0;
                }



                $visitor = Visitor::find($therapist_session->visitor_id);
                if(isset($visitor))
                {
                    $user = User::find($visitor->user_id);
                }
                $array = [
                        'treatmentPlan' =>$treatmentPlan,
                        'treatmentPlanChat' =>$treatmentPlanChat,
                        'sessionId' =>$therapist_session->id,
                        'visitor' => $visitor,
                        'username' => $user->name ,
                        'first_session' => date('Y-m-d h:i A',strtotime($therapist_session->start_time)),
                        'first_session_type' => $therapist_session->type,
                        'last_session' => date('Y-m-d h:i A',strtotime(\App\Sessions::latest()->whereNotIn('session_status',['cancelled','visitor_cancelled'])->where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->first()->start_time)) ,
                        'last_session_type' => \App\Sessions::latest()->where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->first()->type ,
                        'reportPDF'=>url('/clientViewPlanForMobile/'.$user->id.'/'.$therapist_session->id),
                    ];
                    array_push($data, $array);
            }
        }

        $sort_data = collect($data)->sortBy('last_session')->reverse()->toArray();
        $data = $this->custom_paginate($sort_data);


        return $this->returnJsonResponse('Therapist Clients Files',
                $data, true, 200);

    }



    //location ip
    public function locationIP($ip)
    {
        $location = Location::get($ip);
        return response()->json(['data' => $location, 'ip' => $ip]);
    }



    public function checkStatusOfSession($id)
    {
       $session = Sessions::find($id);
       return response()->json(['data' => $session->session_status]);
    }



    public function allTimeZone($user_id){
        $user = User::find($user_id);
        if($user)
        {
            $timezone = $user->timezone;
        }
        else
        {
            $timezone = '';
        }
        $array=[];
        foreach(DateTimeZone::listIdentifiers(DateTimeZone::ALL) as $key=>$timeZone)
        {
            array_push($array, $timeZone);
        }
        return response()->json(['success'=>true, 'data' => $array, 'myTimeZone' => $timezone]);
    }




    //save_attend
    public function save_attend (Request $request)
    {
        $sessionInfo = Sessions::findOrFail($request->session_id);
        $sessionInfo->attend = $request->attend;
        if($sessionInfo->save())
        {
            return response()->json(['success' => true, 'message' => 'AttendSaved']);
        }
        else
        {
             return response()->json(['success' => false, 'message' => 'notSaved']);
        }

    }


    //create_plan
    public function create_plan(Sessions $therapist_session, Request $request)
    {
        $clientSessions = Sessions::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id,['start_time','>=',date('Y-m-d H:i:s',strtotime($therapist_session->start_time))]])->get();


         $treatmentPlan = false;
        if( \App\TreatmentPlan::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->count() > 0 )
        {
           $treatmentPlan = \App\TreatmentPlan::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->first();


           $TreatmentPlansDiagnosis =  TreatmentPlansDiagnosis::where('treatment_plan_id',$treatmentPlan->id)->pluck('diagnosis_id')->toArray();
           $TreatmentPlansTreatments =  TreatmentPlansTreatments::where('treatment_plan_id',$treatmentPlan->id)->pluck('treatments_id')->toArray();


        }
        else
        {
            $treatmentPlan = false;
            $TreatmentPlansDiagnosis = false;
            $TreatmentPlansTreatments =false;
        }

        $lastSession = Sessions::latest()->where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->first();

        $last_Session = date('Y-m-d H:i:s',strtotime($lastSession->start_time));

        $therapistData = Therapist::where([['active', '1'], ['user_id', $request->user_id]])->firstOrFail();

        $visitor = Visitor::findOrFail($therapist_session->visitor_id);
        $user = User::findOrFail(\App\Visitor::findOrFail($therapist_session->visitor_id)->user_id);


        $doctor = User::find($therapistData->user_id);







        //static data
        $problem = [
            [
                'value' => 1,
                'name_ar' => 'المشكلات الزواجية والأسرية',
                'name_en' => 'Marital and Family Problems',
            ],
            [
                'value' => 2,
                'name_ar' => 'التأهيل الزواجى',
                'name_en' => 'Marital Rehabilitation',
            ],
            [
                'value' => 3,
                'name_ar' => 'العلاج الجنسي',
                'name_en' => 'Sexual Therapy',
            ],
            [
                'value' => 4,
                'name_ar' => 'التأهيل لما بعد الطلاق ',
                'name_en' => 'Post Divorce Rehabilitation',
            ],
            [
                'value' => 5,
                'name_ar' => 'التعافي من الطلاق',
                'name_en' => 'Recovery from Divorce',
            ],
            [
                'value' => 6,
                'name_ar' => 'الاضطرابات النفسية للأطفال',
                'name_en' => 'Children Mental Disorders',
            ],
            [
                'value' => 7,
                'name_ar' => 'مشكلات الأطفال',
                'name_en' => 'Children Problems',
            ],
            [
                'value' => 8,
                'name_ar' => ' الاضطرابات النفسية  للمراهقين',
                'name_en' => 'Adolescent Mental Disorders',
            ],
            [
                'value' => 9,
                'name_ar' => 'مشكلات المراهقين',
                'name_en' => 'Adolescent-Problems',
            ],
        ];


        $diagnosis = [];

        //diagonistics
        foreach(\App\Diagnosis::where('active',1)->get() as $d)
        {
            $data = [
                'value' =>$d->id,
                'title_ar' =>$d->title_ar,
                'title_en' =>$d->title_en,
            ];
            array_push($diagnosis, $data);

        }

        $current_status = [
            [
                'value' => 1,
                'name_ar' => ' متابع ',
                'name_en' => 'In Progress',
            ],
            [
                'value' => 2,
                'name_ar' => ' مقفل ',
                'name_en' => 'Closed',
            ],

        ];


        $transfer = [
            [
                'value' => 1,
                'name_ar' => ' لا يوجد تحويل ',
                'name_en' => 'No Transfer',
            ],
            [
                'value' => 2,
                'name_ar' => ' أخصائب نفسي أكلينكي ',
                'name_en' => 'Clinical Psychologist',
            ],
            [
                'value' => 3,
                'name_ar' => ' طبيب نفسي ',
                'name_en' => 'Psychiatrist',
            ],
        ];


        $treatments = [];

        foreach(\App\Treatments::where('active',1)->get() as $t)
        {
            $data = [
                'value' =>$t->id,
                'title_ar' =>$t->title_ar,
                'title_en' =>$t->title_en,
            ];
            array_push($treatments, $data);

        }


        $evaluation = [
            [
                'value' => 1,
                'name_ar' => ' التقييم النفسي المبدئي ',
                'name_en' => 'BASIC ID',
            ],
            [
                'value' => 2,
                'name_ar' => ' مقياس هولاند للميول المهنية ',
                'name_en' => 'Holland Test for Career Tendencies',
            ],
            [
                'value' => 3,
                'name_ar' => ' مقياس بيك للاكتئاب  ',
                'name_en' => 'Beck Depression Inventory',
            ],
            [
                'value' => 4,
                'name_ar' => ' أختبار أيزنك للشخصية ',
                'name_en' => 'EPQ',
            ],
            [
                'value' => 5,
                'name_ar' => ' مقياس ييل- براون الوسواسي القهري ',
                'name_en' => 'Yale Brown Y BOCS',
            ],
            [
                'value' => 6,
                'name_ar' => ' مقياس الاستعداد الأسري ',
                'name_en' => 'Family Readiness Scale',
            ],
            [
                'value' => 7,
                'name_ar' => ' مقياس تايلور للقلق الصريح ',
                'name_en' => 'Taylor manifest anxiety scale',
            ],
            [
                'value' => 8,
                'name_ar' => ' مقياس أزمة الهوية المراهقين ',
                'name_en' => 'Adolescent Identity Crisis Scale',
            ],
            [
                'value' => 9,
                'name_ar' => ' مقياس العنف المنزلي ',
                'name_en' => 'Domestic Violence Scale',
            ],
            [
                'value' => 10,
                'name_ar' => ' مقياس أساليب المعاملة الوالدية ',
                'name_en' => 'Parenting Style Scale',
            ],
            [
                'value' => 11,
                'name_ar' => ' مقياس التوجه الجنسي ',
                'name_en' => 'Sexual Orientation Scale',
            ],
            [
                'value' => 12,
                'name_ar' => ' اخري ',
                'name_en' => 'Other',
            ],


        ];


       $arraySession=[

            'id' => $therapist_session->id,
            'start_timee' => date('Y-m-d H:i:s',strtotime($therapist_session->start_time)),
            'type' => $therapist_session->type,
            'attend' => $therapist_session->attend,

       ];


        foreach ($clientSessions as $nextSession){
            $nextSession->setAttribute('start_timee',date('Y-m-d H:i:s',strtotime($nextSession->start_time)));
            $nextSession->setAttribute('session_datee',date('Y-m-d',strtotime($nextSession->session_date)));
        }
        $last_Session=date('Y-m-d H:i:s',strtotime($last_Session));
        $data = [
            'visitor' => $visitor,
            'user' => $user,
            'data' => $therapistData,
            'therapist_session' => $arraySession,
            'clientSessions'=>$clientSessions,
            'last_Session'=>$last_Session,
            'problem'=>$problem,
            'diagnosis'=>$diagnosis,
            'current_status'=>$current_status,
            'transfer'=>$transfer,
            'treatments'=>$treatments,
            'evaluation'=>$evaluation,
            'treatmentPlan'=>$treatmentPlan,
            'TreatmentPlansDiagnosis' => $TreatmentPlansDiagnosis ,
            'TreatmentPlansTreatments' => $TreatmentPlansTreatments ,
        ];
        return $this->returnJsonResponse('Create Plan Page',
                $data, true, 200);
    }



    //Store Plan
    public function store_plan(Sessions $therapist_session, Request $request)
    {
        $planData = TreatmentPlan::create(array_merge(
            $request->only(
                'age',
                'gender',
                'problem',
                'problem_description',
                'therap_evaluation',
                'long_term',
                'short_term',
                'transfer',
                'current_status',
                'last_visit',
                'homework',
                'client_name_pdf' ,
                'age_pdf' ,
                'gender_pdf' ,
                'problem_pdf' ,
                'therap_evaluation_pdf' ,
                'diagnostic_pdf' ,
                'therapeutic_intervention_pdf' ,
                'problem_description_pdf' ,
                'homework_pdf' ,
                'table_pdf' ,
                'long_term_pdf' ,
                'short_term_pdf' ,
                'transfer_pdf' ,
                'current_status_pdf' ,
                'last_visit_pdf' ,
                'therapist_name_pdf'
            ),
            ['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id, 'session_id' => $therapist_session->id]));
        if($request->diagnostic){
            foreach ($request->diagnostic as $diag){
                TreatmentPlansDiagnosis::create(['treatment_plan_id'=>$planData->id,'diagnosis_id'=>$diag]);
            }
        }
        if($request->therapeutic_intervention) {
            foreach ($request->therapeutic_intervention as $treat) {
                TreatmentPlansTreatments::create(['treatment_plan_id' => $planData->id, 'treatments_id' => $treat]);
            }
        }


        $therapistData = Therapist::find($therapist_session->therapist_id);

        $visitor = Visitor::findOrFail($therapist_session->visitor_id);

        $doctor = User::find($therapistData->user_id);
        //Send Notify
        $tokens = \DB::table('firebase_tokens')->where('user_id', $visitor->user_id)->pluck('platform_token');

        $userLang = User::find($visitor->user_id);
        if($userLang->lang == 'ar')
        {
            $body = 'المعالج   '.$doctor->name.' قام بإنشاء خطه علاجيه لك  ';
            $this->sendWebNotification(' رسالة جديده ... ', $body, $therapist_session->id, $tokens, 'create_plan');
        }
        else
        {
            $body = 'Doctor '.$therapistData->name_e.' create a new medical plan for you';
            $this->sendWebNotification('New Message...', $body, $therapist_session->id, $tokens, 'create_plan');
        }

        //saveNotifyIntoDatabase
        $saveBody = '<h3>Doctor <span>'.$doctor->name.'</span> create a new medical plan for you</h3>';
        $saveBody_ar = '<h3>المعالج  <span>'.$doctor->name.'</span> قام بإنشاء خطه علاجيه لك</h3>';
        $this->saveNotifyIntoDatabase($saveBody,$therapistData->id, $visitor->id, $saveBody_ar, $doctor->name, $therapist_session->id, 'create_plan');



        return response()->json(['success' => true, 'message'=>'DataSaved']);
    }




    // //Update Plan
    public function update_plan(Request $request, $id)
    {
        $updatedPlan = TreatmentPlan::findOrFail($id);


        $array=array_merge($request->only('age','gender','problem','problem_description',
            'therap_evaluation','long_term','short_term','transfer','current_status','last_visit','homework'
        ),
            ['therapist_id'=>$updatedPlan->therapist_id,'visitor_id'=>$updatedPlan->visitor_id,'agreement_client'=>"0"
                ,
                'client_name_pdf'=>$request->client_name_pdf ,
                'age_pdf'=>$request->age_pdf ,
                'gender_pdf'=>$request->gender_pdf ,
                'problem_pdf'=>$request->problem_pdf ,
                'therap_evaluation_pdf'=>$request->therap_evaluation_pdf ,
                'diagnostic_pdf'=>$request->diagnostic_pdf ,
                'therapeutic_intervention_pdf'=>$request->therapeutic_intervention_pdf ,
                'problem_description_pdf'=>$request->problem_description_pdf ,
                'homework_pdf'=>$request->homework_pdf ,
                'table_pdf'=>$request->table_pdf ,
                'long_term_pdf'=>$request->long_term_pdf ,
                'short_term_pdf'=>$request->short_term_pdf ,
                'transfer_pdf'=>$request->transfer_pdf ,
                'current_status_pdf'=>$request->current_status_pdf ,
                'last_visit_pdf'=>$request->last_visit_pdf ,
                'therapist_name_pdf'=>$request->therapist_name_pdf
            ]);
        foreach ($array as $key=>$value){
            $updatedPlan->$key=$value;
        }
        $updatedPlan->save();

        $diagIds=[];

        if($request->diagnostic){
        foreach ($request->diagnostic as $diag){
            $treatmentPlanDiagnosis=TreatmentPlansDiagnosis::where('treatment_plan_id')->where('diagnosis_id',$diag)->first();
            if(!$treatmentPlanDiagnosis){
                $treatmentPlanDiagnosis=new TreatmentPlansDiagnosis();
                $treatmentPlanDiagnosis->treatment_plan_id=$updatedPlan->id;
                $treatmentPlanDiagnosis->diagnosis_id=$diag;
                $treatmentPlanDiagnosis->save();
            }
            $diagIds[]=$treatmentPlanDiagnosis->id;
        }
        TreatmentPlansDiagnosis::whereNotIn('id',$diagIds)->where('treatment_plan_id',$updatedPlan->id)->delete();
        }



        $treatIds=[];
        if($request->therapeutic_intervention)
        {


        foreach ($request->therapeutic_intervention as $treat){
            $treatmentPlanTreat=TreatmentPlansTreatments::where('treatment_plan_id')->where('treatments_id',$treat)->first();
            if(!$treatmentPlanTreat){
                $treatmentPlanTreat=new TreatmentPlansTreatments();
                $treatmentPlanTreat->treatment_plan_id=$updatedPlan->id;
                $treatmentPlanTreat->treatments_id=$treat;
                $treatmentPlanTreat->save();
            }
            $treatIds[]=$treatmentPlanTreat->id;
        }
        TreatmentPlansTreatments::whereNotIn('id',$treatIds)->where('treatment_plan_id',$updatedPlan->id)->delete();

        }


        return response()->json(['success' => true, 'message'=>'DataUpdated']);
    }





    //getPlans
    public function getPlans()
    {
        $clientData = Visitor::where('user_id', auth('api')->user()->id)->firstOrFail();
        $clientSessions =Sessions::where('visitor_id',$clientData->id)->orderBy('start_time','asc')->get()->unique('therapist_id');


        $data = [];
        foreach($clientSessions  as $client_session)
        {
            $therapist = Therapist::findOrFail($client_session->therapist_id);

            $therapist->setAttribute('full_image', asset('avatars/therapists/'.$therapist->picture));

            $first_session = date('Y-m-d h:i A',strtotime($client_session->start_time));
            $first_session_type = $client_session->type;
            $last_session = date('Y-m-d h:i A',strtotime(Sessions::latest()->where(['therapist_id'=>$client_session->therapist_id,'visitor_id'=>$client_session->visitor_id])->first()->start_time));
            $last_session_type = Sessions::latest()->where(['therapist_id'=>$client_session->therapist_id,'visitor_id'=>$client_session->visitor_id])->first()->type;

            $treatmentPlan = false;
             if( \App\TreatmentPlan::where(['therapist_id'=>$client_session->therapist_id,'visitor_id'=>$client_session->visitor_id])->count() > 0 )
            {
                $treatmentPlan = true;
            }


            $array = [
                'treatmentPlan' =>$treatmentPlan,
                'sessionId' =>$client_session->id,
                'therapist' => $therapist ,
                'first_session' => $first_session,
                'first_session_type' => $first_session_type,
                'last_session' => $last_session ,
                'last_session_type' => $last_session_type,
            ];
            array_push($data, $array);

        }

        $data = $this->custom_paginate($data);


        return $this->returnJsonResponse('Medical Plans',
                $data, true, 200);

    }


    public function clientViewPlan(Sessions $therapist_session)
    {
        $problem = [
            [
                'value' => 1,
                'name_ar' => 'المشكلات الزواجية والأسرية',
                'name_en' => 'Marital and Family Problems',
            ],
            [
                'value' => 2,
                'name_ar' => 'التأهيل الزواجى',
                'name_en' => 'Marital Rehabilitation',
            ],
            [
                'value' => 3,
                'name_ar' => 'العلاج الجنسي',
                'name_en' => 'Sexual Therapy',
            ],
            [
                'value' => 4,
                'name_ar' => 'التأهيل لما بعد الطلاق ',
                'name_en' => 'Post Divorce Rehabilitation',
            ],
            [
                'value' => 5,
                'name_ar' => 'التعافي من الطلاق',
                'name_en' => 'Recovery from Divorce',
            ],
            [
                'value' => 6,
                'name_ar' => 'الاضطرابات النفسية للأطفال',
                'name_en' => 'Children Mental Disorders',
            ],
            [
                'value' => 7,
                'name_ar' => 'مشكلات الأطفال',
                'name_en' => 'Children Problems',
            ],
            [
                'value' => 8,
                'name_ar' => ' الاضطرابات النفسية  للمراهقين',
                'name_en' => 'Adolescent Mental Disorders',
            ],
            [
                'value' => 9,
                'name_ar' => 'مشكلات المراهقين',
                'name_en' => 'Adolescent-Problems',
            ],
        ];


        $diagnosis = [];

        //diagonistics
        foreach(\App\Diagnosis::where('active',1)->get() as $d)
        {
            $data = [
                'value' =>$d->id,
                'title_ar' =>$d->title_ar,
                'title_en' =>$d->title_en,
            ];
            array_push($diagnosis, $data);

        }

        $current_status = [
            [
                'value' => 1,
                'name_ar' => ' متابع ',
                'name_en' => 'In Progress',
            ],
            [
                'value' => 2,
                'name_ar' => ' مقفل ',
                'name_en' => 'Closed',
            ]

        ];


        $transfer = [
            [
                'value' => 1,
                'name_ar' => ' لا يوجد تحويل ',
                'name_en' => 'No Transfer',
            ],
            [
                'value' => 2,
                'name_ar' => ' أخصائب نفسي أكلينكي ',
                'name_en' => 'Clinical Psychologist',
            ],
            [
                'value' => 3,
                'name_ar' => ' طبيب نفسي ',
                'name_en' => 'Psychiatrist',
            ],
        ];


        $treatments = [];

        foreach(\App\Treatments::where('active',1)->get() as $t)
        {
            $data = [
                'value' =>$t->id,
                'title_ar' =>$t->title_ar,
                'title_en' =>$t->title_en,
            ];
            array_push($treatments, $data);

        }


        $evaluation = [
            [
                'value' => 1,
                'name_ar' => ' التقييم النفسي المبدئي ',
                'name_en' => 'BASIC ID',
            ],
            [
                'value' => 2,
                'name_ar' => ' مقياس هولاند للميول المهنية ',
                'name_en' => 'Holland Test for Career Tendencies',
            ],
            [
                'value' => 3,
                'name_ar' => ' مقياس بيك للاكتئاب  ',
                'name_en' => 'Beck Depression Inventory',
            ],
            [
                'value' => 4,
                'name_ar' => ' أختبار أيزنك للشخصية ',
                'name_en' => 'EPQ',
            ],
            [
                'value' => 5,
                'name_ar' => ' مقياس ييل- براون الوسواسي القهري ',
                'name_en' => 'Yale Brown Y BOCS',
            ],
            [
                'value' => 6,
                'name_ar' => ' مقياس الاستعداد الأسري ',
                'name_en' => 'Family Readiness Scale',
            ],
            [
                'value' => 7,
                'name_ar' => ' مقياس تايلور للقلق الصريح ',
                'name_en' => 'Taylor manifest anxiety scale',
            ],
            [
                'value' => 8,
                'name_ar' => ' مقياس أزمة الهوية المراهقين ',
                'name_en' => 'Adolescent Identity Crisis Scale',
            ],
            [
                'value' => 9,
                'name_ar' => ' مقياس العنف المنزلي ',
                'name_en' => 'Domestic Violence Scale',
            ],
            [
                'value' => 10,
                'name_ar' => ' مقياس أساليب المعاملة الوالدية ',
                'name_en' => 'Parenting Style Scale',
            ],
            [
                'value' => 11,
                'name_ar' => ' مقياس التوجه الجنسي ',
                'name_en' => 'Sexual Orientation Scale',
            ],
            [
                'value' => 12,
                'name_ar' => ' اخري ',
                'name_en' => 'Other',
            ],


        ];





        $clientSessions = Sessions::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id,['start_time','>=',date('Y-m-d H:i:s',strtotime($therapist_session->start_time))]])->get();

         $treatmentPlan = false;
        if( \App\TreatmentPlan::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->count() > 0 )
        {
           $treatmentPlan = \App\TreatmentPlan::with(['diagnosis','treatments'])->where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->first();

           if($treatmentPlan->problem)
           {
            $problemObject = '';
            foreach ($problem as $key) {
               if($treatmentPlan->problem == $key['value'])
               {
                $problemObject = $key;
               }
            }
           $treatmentPlan->setAttribute('problem', $problemObject);
           }


           if($treatmentPlan->current_status)
           {
             $currentStatusObject = '';
            foreach ($current_status as $key) {
               if($treatmentPlan->current_status == $key['value'])
               {
                $currentStatusObject = $key;
               }
            }
           $treatmentPlan->setAttribute('current_status', $currentStatusObject);
           }


           if($treatmentPlan->transfer)
           {
             $transferObject = '';
            foreach ($transfer as $key) {
               if($treatmentPlan->transfer == $key['value'])
               {
                $transferObject = $key;
               }
            }
           $treatmentPlan->setAttribute('transfer', $transferObject);
           }


           if($treatmentPlan->therap_evaluation)
           {
             $therapeutic_interventionObject = '';
            foreach ($evaluation as $key) {
               if($treatmentPlan->therap_evaluation == $key['value'])
               {
                $therapeutic_interventionObject = $key;
               }
            }
           $treatmentPlan->setAttribute('therap_evaluation', $therapeutic_interventionObject);
           }




           $TreatmentPlansDiagnosis =  TreatmentPlansDiagnosis::where('treatment_plan_id',$treatmentPlan->id)->pluck('diagnosis_id')->toArray();
           $TreatmentPlansTreatments =  TreatmentPlansTreatments::where('treatment_plan_id',$treatmentPlan->id)->pluck('treatments_id')->toArray();


        }
        else
        {
            $treatmentPlan = false;
            $TreatmentPlansDiagnosis = false;
            $TreatmentPlansTreatments =false;
        }

        $lastSession = Sessions::latest()->where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->first();

        $last_Session = date('Y-m-d H:i:s',strtotime($lastSession->start_time));



        $visitor = Visitor::findOrFail($therapist_session->visitor_id);
        $user = User::findOrFail(\App\Visitor::findOrFail($therapist_session->visitor_id)->user_id);


        //static data



         $reportPDF = url('/clientViewPlanForMobile/'.$user->id.'/'.$therapist_session->id);



        $data = [
            'visitor' => $visitor,
            'reportPDF' =>$reportPDF,
            'user' => $user,
            'therapist_session' => $therapist_session,
            'clientSessions'=>$clientSessions,
            'last_Session'=>$last_Session,
            'problem'=>$problem,
            'diagnosis'=>$diagnosis,
            'current_status'=>$current_status,
            'transfer'=>$transfer,
            'treatments'=>$treatments,
            'evaluation'=>$evaluation,
            'treatmentPlan'=>$treatmentPlan,
            'TreatmentPlansDiagnosis' => $TreatmentPlansDiagnosis ,
            'TreatmentPlansTreatments' => $TreatmentPlansTreatments ,
        ];
        return $this->returnJsonResponse('Medical Plan Page',
                $data, true, 200);
    }





    // Allow And Disallow Chat
    public function allowChat(Request $request,$id){
        $treatInfo = TreatmentPlan::where('session_id',$id)->first();
        if($request->chat == 1)
        {
            $treatInfo->allow_chat_date=date('Y-m-d H:i:s');
            $treatInfo->allow_chat=1;
            $treatInfo->save();
            return response()->json(['success' => true, 'message'=>'allow chat successfully']);
        }
        elseif($request->chat == 0)
        {
            $treatInfo->disallow_chat_date=date('Y-m-d H:i:s');
            $treatInfo->allow_chat=0;
            $treatInfo->save();
            return response()->json(['success' => true, 'message'=>'disallow chat successfully']);
        }
        else
        {
            return response()->json(['success' => false, 'message'=>'NoChat']);
        }
    }
    //End


    public function getClientMessagePage (Sessions $client_session)
    {
        $treatmentPlan=TreatmentPlan::where('session_id',$client_session->id)->first();
        $allMessages=Message::with(['visitors', 'therapists'])->where('session_id',$client_session->id)->orderBy('id','ASC')->get();
        return $this->returnJsonResponse('Inbox',MessageResource::collection($allMessages), true, 200);
    }
    //client send message
    public function sendMessage (Request $request,Sessions $client_session)
    {
        $treatmentPlan = TreatmentPlan::where('session_id',$client_session->id)->first();
        if($treatmentPlan->allow_chat==0){
            return response()->json(['success' => false, 'message'=>($request->type=='patient')?trans('home.You can\'t add comment disallowed from therapist'):trans('home.You can\'t add comment allow it first')]);
        }
       $msg =  Message::create(['therapist_id'=>$treatmentPlan->therapist_id,'visitor_id'=>$treatmentPlan->visitor_id,'treatment_id'=>$treatmentPlan->id,'session_id'=>$client_session->id,'message'=>$request->message,'type'=>$request->type]);
        $treatmentPlan->messages_count += 1;


        if($request->type == 'patient')
        {
            $therapist = Therapist::find($treatmentPlan->therapist_id);
            $visitor = Visitor::find($treatmentPlan->visitor_id);
            $patient = User::find($visitor->user_id);
            $tokens = \DB::table('firebase_tokens')->where('user_id', $therapist->user_id)->pluck('platform_token');

            $userLang = User::find($therapist->user_id);
            if($userLang->lang == 'ar')
            {
                $body = 'العميل   '.$patient->name.'  أرسل لك رسالة  ';
                $this->sendWebNotification('رسالة جديده ...', $body, $client_session->id,$tokens, 'message');
            }
            else
            {
                $body = 'Patient '.$patient->name.' sent you a message';
                $this->sendWebNotification('New Message...', $body, $client_session->id,$tokens, 'message');
            }


            $saveBody = '<h3>Patient <span>'.$patient->name.'</span> sent you a message</h3>';
            $saveBody_ar = '<h3>العميل  <span>'.$patient->name.'</span> أرسل لك رسالة</h3>';
            $this->saveNotifyIntoDatabase($saveBody, $visitor->id, $therapist->id, $saveBody_ar, $patient->name, $client_session->id, 'message');
        }
        else
        {
            $visitor = Visitor::find($treatmentPlan->visitor_id);
            $therapist = Therapist::find($treatmentPlan->therapist_id);
            $doctor = User::find($therapist->user_id);
            $tokens = \DB::table('firebase_tokens')->where('user_id', $visitor->user_id)->pluck('platform_token');


            $userLang = User::find($visitor->user_id);
            if($userLang->lang == 'ar')
            {
                $body = 'المعالج   '.$doctor->name.'  أرسل لك رسالة ';
                $this->sendWebNotification('رسالة جديده...', $body, $client_session->id, $tokens, 'message');
            }
            else
            {
                $body = 'Doctor '.$therapist->name_e.' sent you a message';
                $this->sendWebNotification('New Message...', $body, $client_session->id, $tokens, 'message');
            }




            //saveNotifyIntoDatabase
            $saveBody = '<h3>Doctor <span>'.$doctor->name.'</span> sent you a message</h3>';
            $saveBody_ar = '<h3>المعالج  <span>'.$doctor->name.'</span> أرسل لك رسالة</h3>';
            $this->saveNotifyIntoDatabase($saveBody,$therapist->id, $visitor->id, $saveBody_ar, $doctor->name, $client_session->id, 'message');
        }
        $treatmentPlan->save();

        $lastMessage=Message::with(['visitors', 'therapists'])->where('id',$msg->id)->first();
        return response()->json(['success' => true, 'message'=>'Message Sent', 'data' =>new MessageResource($lastMessage)]);
    }
    public function answerMessage(Request $request,Sessions $client_session,$message_id){
        $treatmentPlan = TreatmentPlan::where('session_id',$client_session->id)->first();
        if($treatmentPlan->allow_chat==0){
            return response()->json(['success' => false, 'message'=>($request->type=='patient')?trans('home.You can\'t add comment disallowed from therapist'):trans('home.You can\'t add comment allow it first')]);
        }
        if(!$request->message){
            return response()->json(['success'=>false,'message'=>trans('home.Message required')]);
        }
        if(!$request->type||!in_array($request->type,['therapist', 'patient'])){
            return response()->json(['success'=>false,'message'=>trans('home.Type not valid')]);
        }
        $message=Message::where('therapist_id',$treatmentPlan->therapist_id)->where('visitor_id',$treatmentPlan->visitor_id)->where('treatment_id',$treatmentPlan->id)->where('session_id',$client_session->id)->find($message_id);
        if(!$message){
            return response()->json(['success' => false, 'message'=>trans('home.No Message')]);
        }
        if($message->answer){
            return response()->json(['success'=>false,'message'=>trans('home.This message answered before')]);
        }
        if($message->type==$request->type){
            return response()->json(['success' => false, 'message'=>trans('home.You can\'t add answer for your self')]);
        }
        $message->answer=$request->message;

        if($request->type == 'patient')
        {
            $therapist = Therapist::find($treatmentPlan->therapist_id);
            $visitor = Visitor::find($treatmentPlan->visitor_id);
            $patient = User::find($visitor->user_id);
            $tokens = \DB::table('firebase_tokens')->where('user_id', $therapist->user_id)->pluck('platform_token');

            $userLang = User::find($therapist->user_id);
            if($userLang->lang == 'ar')
            {
                $body = 'العميل   '.$patient->name.' رد علي رسالتك  ';
                $this->sendWebNotification('رسالة جديده...', $body, $client_session->id,$tokens, 'message');
            }
            else
            {
                $body = 'Patient '.$patient->name.' Has Answered For Your Message';
                $this->sendWebNotification('New Message...', $body, $client_session->id,$tokens, 'message');
            }




            //saveNotifyIntoDatabase
            $saveBody = '<h3>Patient <span>'.$patient->name.'</span> Has Answered For Your Message</h3>';
            $saveBody_ar = '<h3>العميل   <span>'.$patient->name.'</span> رد علي رسالتك</h3>';
            $this->saveNotifyIntoDatabase($saveBody, $visitor->id,$therapist->id,$saveBody_ar, $patient->name, $client_session->id, 'message');
        }
        else
        {
            $visitor = Visitor::find($treatmentPlan->visitor_id);
            $therapist = Therapist::find($treatmentPlan->therapist_id);
            $doctor = User::find($therapist->user_id);
            $tokens = \DB::table('firebase_tokens')->where('user_id', $visitor->user_id)->pluck('platform_token');

            $userLang = User::find($visitor->user_id);
            if($userLang->lang == 'ar')
            {
                $body = 'المعالج   '.$doctor->name.' رد علي رسالتك  ';
                $this->sendWebNotification('رسالة جديده...', $body, $client_session->id, $tokens, 'message');
            }
            else
            {
                $body = 'Doctor '.$therapist->name_e.' Has Answered For Your Message';
                $this->sendWebNotification('New Message...', $body, $client_session->id, $tokens, 'message');
            }


            //saveNotifyIntoDatabase
            $saveBody = '<h3>Doctor <span>'.$doctor->name.'</span> Has Answered For Your Message</h3>';
            $saveBody_ar = '<h3>المعالج  <span>'.$doctor->name.'</span> رد علي رسالتك</h3>';
            $this->saveNotifyIntoDatabase($saveBody, $therapist->id, $visitor->id,$saveBody_ar, $doctor->name, $client_session->id, 'message');
        }
        $message->save();

        $lastMessage=Message::with(['visitors', 'therapists'])->where('id',$message->id)->first();

        return response()->json(['success'=>true,'message'=>trans('home.Your answer added successfully'), 'data' =>new MessageResource($lastMessage)]);
    }





    public function saveNotifyIntoDatabase($body,$sender_id,$reciever_id, $body_ar,$sender_name,$session_id, $type)
    {
        $data = [
            'body' =>$body,
            'body_ar' =>$body_ar,
            'sender_id' =>$sender_id,
            'reciever_id' =>$reciever_id,
            'sender_name' =>$sender_name,
            'session_id' =>$session_id,
            'type' =>$type,
            'created_at' =>date('Y-m-d H:i:s'),
            'updated_at' =>date('Y-m-d H:i:s'),
        ];
        \DB::table('notifications')->insert($data);
    }





    public function sendWebNotification($title,$msg_body, $session_id,$tokens=[], $type)
    {
        $data = '{"notification":{"title":"' . $title . '", "body": "' . $msg_body . '"' . ', "click_action": "FCM_PLUGIN_ACTIVITY"' . '}';
            $data .= ',"data":{"title":"' . $title . '", "body": "' . $msg_body . '","session_id":"' . $session_id . '", "type":"' . $type . '",}';
            $data .= ',"registration_ids":' . $tokens;
            $data .= '}';
            $curl = curl_init();

            $firebase_key = 'key=AAAAVE8vuIo:APA91bFhV7w4-wnqg-MKQttUTLT9Cy-aEZ8gJMPU-fCI1JaBSuvFXXK0yN-FzJuanb1PnHI-4lqpTi9iYVNrHTLdaPCCbG3oTudaJ0jIDBMO2L8FiPDlndbop0fJY2jItJmQYKTcs3it';

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://fcm.googleapis.com/fcm/send',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS =>$data,
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Authorization: ' . $firebase_key
                ),
            ));
            $response = curl_exec($curl);
            curl_close($curl);
    }




    // /getAllNotifications
    public function getAllNotifications(Request $request)
    {

        $notifications = \DB::table('notifications')->where('reciever_id', $request->id)->orderBy('created_at', 'desc')->paginate(10);
        return response()->json(['success'=>true,'data' => $notifications]);
    }




    //setUserLang
    public function setUserLang(Request $request)
    {
        $data = ['lang' => $request->lang];
        $update = \DB::table('users')->whereId(auth('api')->user()->id)->update($data);
        return response()->json(['success'=>true, 'message'=>'updated successfully']);
    }

    //getUserLang
    public function getUserLang()
    {
        $user = User::find(auth('api')->user()->id);
        return response()->json(['success'=>true, 'lang'=>$user->lang]);
    }


}
