<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Api\ApiController;
use App\PasswordReset;
use App\Therapist;
use App\User;
use App\Visitor;
use Carbon\Carbon;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Throwable;
use Tymon\JWTAuth\Exceptions\JWTException;

class AuthController extends ApiController
{

    /**
     * @param Request $request
     *
     * @return JsonResponse
     */
    public function register(Request $request)
    {
        try {
            if ($this->registerValidator($request->all())) {
                return $this->registerValidator($request->all());
            }
            $user = new User();
            $user->name = $request->name;
            $user->email = $request->email;
            $user->password = Hash::make($request->password);
            $user->type = 'visitors';
            $user->active = 1;
            $user->verifyToken = Str::random(40);

            if ($user->save())
            {
                $visitor = new Visitor();
                $visitor->user_id = $user->id;
                $visitor->birthyear = $request->birthyear;
                $visitor->mobile = $request->mobile;
                $visitor->gender = $request->gender;
                $visitor->save();
                return $this->createCredential($request->only('email', 'password'));
            }
            else
                return $this->returnJsonResponse('there is something wrong.', [],
                    FALSE, 211);
        }
        catch (JWTException $e)
        {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }
    public function therapistRegister(Request $request){
        try {
            if ($this->registerTherapistValidator($request->all())) {
                return $this->registerTherapistValidator($request->all());
            }
            if ($request->hasFile('cv')) {
                $file = $request->file('cv');
                $destinationPath = public_path('resumes/');
                $fileName = time() . uniqid() . $file->getClientOriginalName();
                $file->move($destinationPath, $fileName);
                $cv = $fileName;
            } else {
                $cv = '';
            }

            if ($request->hasFile('qualification')) {
                $file = $request->file('qualification');
                $destinationPath = public_path('qualification/');
                $fileName = time() . uniqid() . $file->getClientOriginalName();
                $file->move($destinationPath, $fileName);
                File::copy($destinationPath.$fileName,public_path('certificates/'.$fileName));
                $qualification = $fileName;
            } else {
                $qualification = '';
            }
            $user = User::create([
                'name' => $request->name,
                'email' => $request->email,
                'password' => Hash::make($request->password),
                'type' => 'therapists',
                // 'phone' => $request->phone,
                'verifyToken' => Str::random(40),
                'agreement' => $request->agreement,
                'cv' => $cv,
                'qualification' => $qualification,

            ]);

            $data['user_id'] = $user->id;
            $data['title'] = $user->name;
            $data['name_a'] = $user->name;
            $data['name_e'] = $user->name;
            $data['country_id'] = $request->country_id;

            $data['mobile'] = $request->phone;
            $data['resume'] = $cv;
            $data['zip_certificates'] = $qualification;
            $data['gender'] = $request->gender;

            $therapist=Therapist::create($data);

            $user = User::findOrFail($user->id);
            $html = view('email.sendView', compact('user'))->render();
            sendGridEmailToUser($html, $user->email, $user->name, 'Verified Email');
            $html = view('email.register_step2_hr_email', compact('therapist','user'))->render();
            sendGridEmailToUser($html, 'hr@newhayah.com', 'New Hayah', 'Notification New Doctor Data');
            // sendGridEmailToUser($html, 'omar.bakry@almoasher.net', 'Omar Bakry', 'Notification New Doctor Data');
            // sendGridEmailToUser($html, 'mostafa.elnemer@almoasher.net', 'Mostafa Elnemer', 'Notification New Doctor Data');
            // sendGridEmailToUser($html, 'ahmedibrahim199028@gmail.com', 'Ahmed Tester', 'Notification New Doctor Data');

            if(request('platform') && request('platform_token'))
            {
                if(!\DB::table('firebase_tokens')->where('user_id', $user->id)->where('platform_token', request('platform_token'))->exists())
                {
                    $data =[
                        'user_id' => $user->id,
                        'platform' => request('platform'),
                        'platform_token' => request('platform_token'),
                    ];
                    \DB::table('firebase_tokens')->insert($data);
                }
            }

            if(request()->header('lang') == 'en' )
            {
                \DB::table('users')->whereId($user->id)->update(['lang'=>'en']);
            }
            else
            {
                \DB::table('users')->whereId($user->id)->update(['lang'=>'ar']);
            }
            

            return $this->returnJsonResponse('You success register please check your email', []);
//            return $this->returnJsonResponse('there is something wrong.', [],FALSE, 211);

        }
        catch (JWTException $e)
        {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }

    /**
     * @param Request $request
     *
     * @return JsonResponse
     */
    public function login(Request $request)
    {
        try {
            if ($this->loginValidator($request->all())) {
                return $this->loginValidator($request->all());
            }



            return $this->createCredential($request->only('email', 'password'));

        }
        catch (JWTException $e)
        {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }




    //therapist_login
    public function therapist_login(Request $request)
    {
        try {
            if ($this->loginValidator($request->all())) {
                return $this->loginValidator($request->all());
            }
            return $this->createTherapistCredential($request->only('email', 'password'));

        }
        catch (JWTException $e)
        {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }


    /**
     * @param Request $request
     *
     * @return JsonResponse
     * @throws Throwable
     */
    public function forgetPassword(Request $request)
    {
        try {
            if ($this->forgetPasswordValidator($request->all())) {
                return $this->forgetPasswordValidator($request->all());
            }
            $app_type=($request->app_type)?$request->app_type:'visitors';
            $user = User::where('email', $request->email)->where('type',$app_type)->first();
            if(!$user){
                return $this->returnJsonResponse(__('main.User not found'));
            }
            do {
                $password_reset_code = $this->generateRandomString(6,'all','no');
                $code_exist = PasswordReset::where('token', $password_reset_code)->first();
            } while ($code_exist);
            $password_reset = new PasswordReset();
            $password_reset->email = $request->email;
            $password_reset->token = $password_reset_code;
            $password_reset->created_at = Carbon::now();
            if($password_reset->save()) {
                PasswordReset::where('email',$request->email)->where('id','!=',$password_reset->id)->delete();
                $html = view('api_email.forget_password',compact('user','password_reset'))->render();
                $email_sent = sendGridEmailToUser($html, $request->email, $user->name,'اعادة تعيين كلمة المرور');
                if($email_sent)
                    return $this->returnJsonResponse(__('main.password_reset_code_sent'));

                return $this->returnJsonResponse(__('main.error_occurred_try_again'), [], false, 211);
            }
            return $this->returnJsonResponse(__('main.error_occurred_try_again'), [], false, 211);

        }
        catch (JWTException $e)
        {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }

    /**
     * @param Request $request
     *
     * @return JsonResponse
     * @throws Throwable
     */
    public function resetPassword(Request $request)
    {
        try {
            if ($this->resetPasswordValidator($request->all())) {
                return $this->resetPasswordValidator($request->all());
            }
            $password_reset= PasswordReset::where('token',$request->token)
                //->where('email',$request->email)
                ->first();
            $user = User::where('email', $password_reset->email)->first();

            $user->password = Hash::make($request->password);
            $password_reset->token = Hash::make($request->password);
            if ($user->update())
            {
                PasswordReset::where('email', $user->email)->update([
                   'token' => Hash::make($request->password)
                ]);
                return $this->returnJsonResponse(__('main.password_changed'));
            }
            return $this->returnJsonResponse(__('main.error_occurred_try_again'), [], false, 211);

        }
        catch (JWTException $e)
        {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }

    /**
     * @param Request $request
     *
     * @return JsonResponse
     * @throws Throwable
     */
    public function changePassword(Request $request)
    {
        try {
            if ($this->changePasswordValidator($request->all())) {
                return $this->changePasswordValidator($request->all());
            }
            if (Hash::check($request->old_password, $this->guard()->user()->password))
            {
                $user = User::find($this->guard()->id());
                $user->password = Hash::make($request->new_password);
                if ($user->update())
                {
                     Auth::logoutOtherDevices($request->new_password);
                    return $this->returnJsonResponse(__('main.password_changed'));
                }
                return $this->returnJsonResponse('sorry, there is something wrong!', [], false, 211);
            }
            return $this->returnJsonResponse('wrong password!', [], false, 211);

        }
        catch (JWTException $e)
        {
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],
                FALSE, 213);
        }
    }

    /**
     * @param Request $request
     *
     * @return JsonResponse
     */
    public function updateProfile(Request $request)
    {
        try {

            if ($this->updateProfileValidator($request->all())) {
                return $this->updateProfileValidator($request->all());
            }

            $user = User::find($this->guard()->id());
            if($user->type=='visitors'){
                $visitor = Visitor::where('user_id', $this->guard()->id())->first();
                if ($request->has('birthyear'))
                    $visitor->birthyear = $request->birthyear;
                if ($request->has('mobile'))
                    $visitor->mobile = $request->mobile;
                if ($request->has('gender'))
                    $visitor->gender = $request->gender;
            }else{
                $visitor = Therapist::where('user_id', $this->guard()->id())->first();
                if ($request->has('birth'))
                    $visitor->birth = date('Y-m-d',strtotime($request->birth));
                if ($request->has('mobile'))
                    $visitor->mobile = $request->mobile;
                if ($request->has('gender'))
                    $visitor->gender = $request->gender;
            }

            if ($request->has('name'))
                $user->name = $request->name;
            if ($request->has('email'))
                $user->email = $request->email;

            if ($user->update()&&$visitor->update()) {

                return $this->returnJsonResponse('Profile data updated successfully', ($user->type=='visitors')?User::visitorProfile($this->guard()->id()):User::therapistProfile($this->guard()->id()) );
            }
            else
                return $this->returnJsonResponse('there is something wrong.', [],
                    FALSE, 211);

            }
        catch (\Exception $e) {
            return $this->returnJsonResponse($e->getMessage(), [],FALSE, 213);
            return $this->returnJsonResponse('there is something wrong. please, try again later', [],FALSE, 213);
        }
    }

    /**
     * Log the user out (Invalidate the token).
     *
     * @return JsonResponse
     */
    public function logout()
    {

        try {

            if(request('platform') && request('platform_token'))
            {
                if(\DB::table('firebase_tokens')->where('user_id', $this->guard()->user()->id)->where('platform_token', request('platform_token'))->exists())
                {
                    \DB::table('firebase_tokens')->where('user_id', $this->guard()->user()->id)->where('platform_token', request('platform_token'))->delete();
                }
            }


            $this->guard()->logout();
            return $this->returnJsonResponse('Successfully logged out', [], true, 200);
        }
        catch (JWTException $e)
        {
            return $this->returnJsonResponse('there is something wrong. please, try again later',
                [], FALSE, 213);
        }
    }

    /**
     * Refresh a token.
     *
     * @return JsonResponse
     */
    public function refresh()
    {
        try {
            return $this->createNewToken($this->guard()->refresh());
        }
        catch (JWTException $e)
        {
            return $this->returnJsonResponse('there is something wrong. please, try again later',
                [], FALSE, 213);
        }
    }

    /**
     * @param $credentials
     *
     * @return JsonResponse
     */
    protected function createCredential($credentials)
    {
        if (!$token = $this->guard()->attempt($credentials)) {
            return $this->returnJsonResponse('Unauthorized',
                [], FALSE, 209);
        }
        // if ($this->guard()->user()->active == 0) {
        //     $this->logout();
        //     return $this->returnJsonResponse('Sorry, This account is not activated yet',
        //         [],FALSE, 209);
        // }
        if ($this->guard()->user()->type == 'therapists') {
            $this->logout();
            return $this->returnJsonResponse('NotAllowed',
                [],FALSE, 209);
        }
        else {

            if(request('platform') && request('platform_token'))
            {
                if(!\DB::table('firebase_tokens')->where('user_id', $this->guard()->user()->id)->where('platform_token', request('platform_token'))->exists())
                {
                    $data =[
                        'user_id' => $this->guard()->user()->id,
                        'platform' => request('platform'),
                        'platform_token' => request('platform_token'),
                    ];
                    \DB::table('firebase_tokens')->insert($data);
                }
            }

            if(request()->header('lang') == 'en' )
            {
                \DB::table('users')->whereId($this->guard()->user()->id)->update(['lang'=>'en']);
            }
            else
            {
                \DB::table('users')->whereId($this->guard()->user()->id)->update(['lang'=>'ar']);
            }

            return $this->createNewToken($token);
        }
    }




    //create therapist credential
    protected function createTherapistCredential($credentials)
    {
        if (!$token = $this->guard()->attempt($credentials)) {
            return $this->returnJsonResponse('Unauthorized',
                [], FALSE, 209);
        }

        //To check if therapist fill his/her information or not 
        // if ($this->guard()->user()->therapist->main_specialty_ar == '' || $this->guard()->user()->therapist->main_specialty_ar == null) {
        //     //$this->logout();
        //    // return $this->returnJsonResponse('notCompleted',[],FALSE, 209);
        //     $isActivated = false;
        //     return $this->createNewToken($token, $isActivated);

        // }
        // if ($this->guard()->user()->therapist->active == 0) {
        //     // $this->logout();
        //     // return $this->returnJsonResponse('Sorry, This account is not activated yet ',
        //     //     [],FALSE, 209);
        //     $isActivated = true;
        //     return $this->createNewToken($token, $isActivated);
        // }
        if ($this->guard()->user()->type == 'visitors') {
            $this->logout();
            return $this->returnJsonResponse('NotAllowed',
                [],FALSE, 209);
        }
        else {
            $isActivated = true;

            if(request('platform') && request('platform_token'))
            {
                if(!\DB::table('firebase_tokens')->where('user_id', $this->guard()->user()->id)->where('platform_token', request('platform_token'))->exists())
                {
                    $data =[
                        'user_id' => $this->guard()->user()->id,
                        'platform' => request('platform'),
                        'platform_token' => request('platform_token'),
                    ];
                    \DB::table('firebase_tokens')->insert($data);
                }
            }

            if(request()->header('lang') == 'en' )
            {
                \DB::table('users')->whereId($this->guard()->user()->id)->update(['lang'=>'en']);
            }
            else
            {
                \DB::table('users')->whereId($this->guard()->user()->id)->update(['lang'=>'ar']);
            }

            return $this->createNewToken($token,$isActivated);
        }
    }




    /**
     * Get the token array structure.
     *
     * @param string $token
     *
     * @return JsonResponse
     */
    protected function createNewToken(string $token, $isActivated = null)
    {
        if($this->guard()->user()->type=='visitors'){
            return $this->returnJsonResponse('success',
                array_merge( (array)User::visitorProfile($this->guard()->id()),[
                    'access_token'          => $token,
                    'token_type'            => 'bearer',
                    'expires_in'            =>  $this->guard()->factory()->getTTL() * 60*60*7
                ])

            );
        }
        return $this->returnJsonResponse('success',
            array_merge( (array)User::therapistProfile($this->guard()->id()),[
                'access_token'          => $token,
                'token_type'            => 'bearer',
                'isActivated'           => $isActivated,
                'expires_in'            =>  $this->guard()->factory()->getTTL() * 60*60*7
            ])

        );
    }



    public function userID($id)
    {
        return $this->returnJsonResponse('success',
            array_merge( (array)User::therapistProfile($id),[
                'token_type'            => 'bearer',
                'expires_in'            =>  $this->guard()->factory()->getTTL() * 60*60*7
            ])

        );
    }




    /**
     * Get the guard to be used during authentication.
     *
     * @return Guard
     */
    public function guard()
    {
        return auth('api');
    }

    /**
     * @param $data
     *
     * @return JsonResponse
     */
    public function loginValidator($data)
    {
        $validator = Validator::make($data, [
            'email'=>'required|email|',
            'password'=>'required|string|min:3',
        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
    }

    /**
     * @param $data
     *
     * @return JsonResponse
     */
    public function registerValidator($data)
    {
        $validator = Validator::make($data, [
            'email'=>'required|email|unique:users,email|',
            'password' => 'required|string|min:5|max:32',
            'mobile'=>'required|string|min:11|unique:visitors,mobile',
            'name'=>'required|string|min:3|max:55',
            'birthyear'=> 'required|integer',
            'gender'=> 'required|string',

        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
    }
    public function registerTherapistValidator($data)
    {
        $validator = Validator::make($data, [
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'phone' => 'required|string|max:255|unique:therapists,mobile',
            'password' => 'required|string|min:8|max:32|confirmed',
            'agreement' => 'required|in:1',

        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
    }


    /**
     * @param $data
     *
     * @return JsonResponse
     */
    public function forgetPasswordValidator($data)
    {
        $validator = Validator::make($data, [
            'email'=>'required|email|exists:users|',
        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
    }

    /**
     * @param $data
     *
     * @return JsonResponse
     */
    public function resetPasswordValidator($data)
    {
        $validator = Validator::make($data, [
            'token'=>'required|string|exists:password_resets,token|',
            'password' =>'required|string|min:8'
        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
    }

    /**
     * @param $data
     *
     * @return JsonResponse
     */
    public function changePasswordValidator($data)
    {
        $validator = Validator::make($data, [
            'old_password' =>'required|string|min:3',
            'new_password' =>'required|string|min:3'
        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
    }

    /**
     * @param $data
     *
     * @return JsonResponse
     */
    public function updateProfileValidator($data)
    {
        $table=(auth()->user()->type=='visitors')?'visitors':'therapists';
        $id=(auth()->user()->type=='visitors')?auth()->user()->visitor->id:auth()->user()->therapist->id;
        $validator = Validator::make($data, [
            'email'=>'email|unique:users,email,'.auth()->user()->id.',id,deleted_at,NULL',
            'mobile'=>'string|min:11|unique:'.$table.',mobile,'.$id,
            'name'=>'string|min:3|max:55',
            'birthyear'=> 'integer',
            'gender'=> 'string',
        ]);
        if ($validator->fails()) {
            return $this->returnJsonResponse($validator->errors(),
                [], FALSE, 212);
        }
    }
    public function checkDeleted(Request $request){
        $user = User::withTrashed()->find($request->id);
        $isDeleted=false;
        if(!$user){
            $isDeleted=true;
        }
        if(!$isDeleted){
            $isDeleted=($user->deleted_at==NULL)?false:true;
        }
        return $this->returnJsonResponse('Success',$isDeleted);
    }
}
