<?php

namespace App\Http\Controllers;

use App\Blog;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $blog = Blog::latest()->take(6)->get();
        $blogFeatured=Blog::latest()->where('featured',1)->take(2)->get();
        $blogViews=Blog::orderBy('views','DESC')->take(6)->get();
        $paginate=false;
        return view('blog',compact('blog','blogFeatured','blogViews','paginate'));
    }

    public function getLast(){
        $blog = Blog::latest()->get();
        $paginate=true;
        return view('blog',compact('blog','paginate'));
    }

    public function getMore(Request $request){
        if($request->ajax()){
            $blog = Blog::latest()->take(6)->skip($request->skip)->get();
            $html= view('include.blog_items',compact('blog'))->render();
            return response()->json(['success'=>true,'html'=>$html]);
        }
    }

    public function view($id)
    {
        $blog=Blog::findorFail($id);
        if($blog){
            $blog->views += 1;
            $blog->save();
            return view('single_blog',compact('blog'));
        }
        return abort(404);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function show(Blog $blog)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function edit(Blog $blog)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Blog $blog)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function destroy(Blog $blog)
    {
        //
    }
}
