<?php

namespace App\Http\Controllers;

use App\Sessions;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CronJobsTestController extends Controller
{
    //
    public function getSessionBefore3MinutesAgo(){
        file_put_contents('getSessionBefore3MinutesAgo.log', 'START REQUEST IN : '.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);
        $sessions=Sessions::whereNull('send_before3_hours_date')->where('session_status','reserved')->whereRaw('session_date BETWEEN DATE_SUB(NOW(), INTERVAL 3 MINUTE) AND NOW()')->get();
        foreach ($sessions as $session){
            $session->send_before3_hours_date=date('Y-m-d H:i:s');
            $session->save();
            $therapist=true;
            $htmlTherapist = view('email.session_will_start',compact('session','therapist'))->render();
            $therapist=false;
            $htmlVisitor = view('email.session_will_start',compact('session','therapist'))->render();
            $sendp=sendGridEmailToUser($htmlVisitor,$session->visitor->user->email, $session->visitor->user->name, 'Session Will Start After 1 Hours');
            $sendt=sendGridEmailToUser($htmlTherapist,$session->therapist->user->email, $session->therapist->user->name, 'Session Will Start After 1 Hours');
            $sendt=sendGridEmailToUser($htmlTherapist,'most22491@gmail.com', 'Mostafa Elnemer', 'Session Will Start After 1 Hours');
        }
        file_put_contents('getSessionBefore3MinutesAgo.log', 'END REQUEST IN : '.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);
    }
    public function getSessionBefore3HoursAgo(){
        DB::update('SET time_zone = ?', ['+2:00']);
        file_put_contents('getSessionBefore3HoursAgo.log', 'START REQUEST IN : '.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);
//        $sessions=Sessions::select('sessions.*',DB::raw("DATE_ADD(NOW(), INTERVAL 1 HOUR)"),DB::raw("NOW()"))
//            //whereNull('send_before3_hours_date')
//            ->where('session_status','reserved')
//            //->whereRaw('start_time BETWEEN DATE_SUB(NOW(), INTERVAL 6 HOUR) AND NOW()')
//            ->whereRaw('start_time >NOW()')
//            ->get();
        $sessions=Sessions::select('sessions.*')
        //whereNull('send_before3_hours_date')
            ->where('session_status','reserved')
            ->whereRaw('start_time BETWEEN DATE_SUB(NOW(), INTERVAL 5 MINUTE) AND DATE_ADD(NOW(), INTERVAL 1 HOUR)')
            ->get();
        dd($sessions);
        foreach ($sessions as $session){
            $session->send_before3_hours_date=date('Y-m-d H:i:s');
            $session->save();
            $therapist=true;
            $htmlTherapist = view('email.session_will_start',compact('session','therapist'))->render();
            $therapist=false;
            $htmlVisitor = view('email.session_will_start',compact('session','therapist'))->render();
            $sendp=sendGridEmailToUser($htmlVisitor,$session->visitor->user->email, $session->visitor->user->name, 'Session Will Start After 1 Hours');
            $sendt=sendGridEmailToUser($htmlTherapist,$session->therapist->user->email, $session->therapist->user->name, 'Session Will Start After 1 Hours');
        }
        file_put_contents('getSessionBefore3HoursAgo.log', 'END REQUEST IN : '.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);
    }
    public function getSessionBefore3MinutesAgo_old(){
//        $session=Sessions::find(6066);
//        $therapist=true;
//        $htmlTherapist = view('email.session_will_start',compact('session','therapist'))->render();
//        $therapist=false;
//        $htmlVisitor = view('email.session_will_start',compact('session','therapist'))->render();
//        $sendp=sendGridEmailToUser($htmlVisitor,$session->visitor->user->email, $session->visitor->user->name, 'Session Will Start After 3 Hours');
//        $sendt=sendGridEmailToUser($htmlTherapist,$session->therapist->user->email, $session->therapist->user->name, 'Session Will Start After 3 Hours');
//        dd($sendp,$sendt);
        file_put_contents('getSessionBefore3MinutesAgo.log', 'START REQUEST IN : '.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);
        $therapists=Sessions::whereBetween('session_date',[date('Y-m-d',strtotime('-1 day')),date('Y-m-d',strtotime('+1 day'))])
            ->where('session_status','reserved')
            ->join('therapists','therapists.id','=','sessions.therapist_id')
            ->join('users','users.id','=','therapists.user_id')
            ->pluck('users.timezone','therapists.id')->toArray();
        foreach ($therapists as $therapist_id=>$timezone){
            //setTimeZone($timezone);
            $timezone=($timezone)?$timezone:'Africa/Cairo';
            setTimeZone($timezone);
            $start_date=date('Y-m-d H:i:s',strtotime('-3 minutes'));
            $end_date=date('Y-m-d H:i:s');

            $sessions=Sessions::where('therapist_id',$therapist_id)->whereNull('send_before3_hours_date')->whereBetween('start_time',[$start_date,$end_date]);

            dd(getEloquentSqlWithBindings($sessions),$sessions->get(),Sessions::find(6167));
            $sessions=$sessions->get();//dd($sessions);
            if(count($sessions)){
                dd($sessions);
            }

            foreach ($sessions as $session){
                $session->send_before3_hours_date=date('Y-m-d H:i:s');
                $session->send_before3_hours_time_zone=$timezone;
                $session->save();
                $therapist=true;
                $htmlTherapist = view('email.session_will_start',compact('session','therapist'))->render();
                $therapist=false;
                $htmlVisitor = view('email.session_will_start',compact('session','therapist'))->render();
                $sendp=sendGridEmailToUser($htmlVisitor,$session->visitor->user->email, $session->visitor->user->name, 'Session Will Start After 3 Minutes');
                $sendt=sendGridEmailToUser($htmlTherapist,$session->therapist->user->email, $session->therapist->user->name, 'Session Will Start After 3 Minutes');

            }
        }
        file_put_contents('getSessionBefore3MinutesAgo.log', 'END REQUEST IN : '.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);
    }
    public function getSessionBefore3HoursAgo_old(){
//        $session=Sessions::find(6066);
//        $therapist=true;
//        $htmlTherapist = view('email.session_will_start',compact('session','therapist'))->render();
//        $therapist=false;
//        $htmlVisitor = view('email.session_will_start',compact('session','therapist'))->render();
//        $sendp=sendGridEmailToUser($htmlVisitor,$session->visitor->user->email, $session->visitor->user->name, 'Session Will Start After 3 Hours');
//        $sendt=sendGridEmailToUser($htmlTherapist,$session->therapist->user->email, $session->therapist->user->name, 'Session Will Start After 3 Hours');
//        dd($sendp,$sendt);
        file_put_contents('getSessionBefore3HoursAgo.log', 'START REQUEST IN : '.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);
        $therapists=Sessions::whereBetween('session_date',[date('Y-m-d',strtotime('-1 day')),date('Y-m-d',strtotime('+1 day'))])
            ->where('session_status','reserved')
            ->join('therapists','therapists.id','=','sessions.therapist_id')
            ->join('users','users.id','=','therapists.user_id')
            ->pluck('users.timezone','therapists.id')->toArray();
        foreach ($therapists as $therapist_id=>$timezone){
            //setTimeZone($timezone);
            $timezone=($timezone)?$timezone:'Africa/Cairo';
            setTimeZone($timezone);
            $start_date=date('Y-m-d H:i:s',strtotime('-3 hours'));
            $end_date=date('Y-m-d H:i:s');

            $sessions=Sessions::where('therapist_id',$therapist_id)->whereNull('send_before3_hours_date')->whereBetween('start_time',[$start_date,$end_date]);

            //dd(getEloquentSqlWithBindings($sessions),$sessions->get());
            $sessions=$sessions->get();//dd($sessions);
            foreach ($sessions as $session){
                $session->send_before3_hours_date=date('Y-m-d H:i:s');
                $session->send_before3_hours_time_zone=$timezone;
                $session->save();
                $therapist=true;
                $htmlTherapist = view('email.session_will_start',compact('session','therapist'))->render();
                $therapist=false;
                $htmlVisitor = view('email.session_will_start',compact('session','therapist'))->render();
                $sendp=sendGridEmailToUser($htmlVisitor,$session->visitor->user->email, $session->visitor->user->name, 'Session Will Start After 3 Hours');
                $sendt=sendGridEmailToUser($htmlTherapist,$session->therapist->user->email, $session->therapist->user->name, 'Session Will Start After 3 Hours');

            }
        }
        file_put_contents('getSessionBefore3HoursAgo.log', 'END REQUEST IN : '.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);
    }
}
