<?php

namespace App\Http\Controllers;

use App\QuestionChoicePoint;
use App\RecommendationType;
use App\Scale;
use App\ScaleEmail;
use App\Service;
use App\User;
use Illuminate\Http\Request;
use App\Sliders;
use App\Therapist;
use App\Partners;
use App\Properties;
use App\Blog;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\InsertRecommendation;
use App\Recommendation;
use App\Specialties;
use App\Languages;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use App\Contact;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Stevebauman\Location\Facades\Location;
use Illuminate\Support\Facades\View;

class HomePageController extends Controller
{
    public function __construct(Request $request)
    {
        $ipaddress = '';
            if (isset($_SERVER['HTTP_CLIENT_IP'])) {
                $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
            } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED'];
            } else if (isset($_SERVER['REMOTE_ADDR'])) {
                $ipaddress = $_SERVER['REMOTE_ADDR'];
            } else {
                $ipaddress = 'UNKNOWN';
            }

        $location = Location::get($ipaddress);;
        View::share('location', $location);
        if (Auth::check()) {
            if (auth()->user()->type == 'therapists') {
                return redirect()->intended('therapists/sessions');
            }
        }
    }

    public function index () {
        return view('index');
    }

    public function home () {

        $slider_items = Sliders::where('active','1')->get();
        $services = Service::get();
        $partners = Partners::get();
        $properties = Properties::orderBy('sort', 'asc')->get();
        $therapists = Therapist::where('active','=',1)->limit(4)->get();
        $evaluation_slider = \App\Rating::get();

        $therapists_slider = Therapist::whereHas('sessions', function($query){
            $from = Carbon::now()->format('Y-m-d H:i:m');
            $to = Carbon::now()->endOfDay()->format('Y-m-d H:i:m');
            return $query->where('session_status', 'available')->whereBetween('start_time', [$from, $to]);
        })->where('active','=',1)->inRandomOrder()->get();

        $blog = Blog::latest()->limit(4)->get();
        return view('home',['slider_items'=>$slider_items,'services'=> $services,'therapists'=>$therapists,'partners'=>$partners,'properties'=>$properties,'blog'=>$blog, 'therapists_slider'=>$therapists_slider, 'evaluation_slider' =>$evaluation_slider]);
    }

    public function getRecommendation()
    {
        return view('recommendation');
    }

    public function insertRecommendation(InsertRecommendation $request)
    {
        Recommendation::create($request->only('ans1','ans2','ans3','ans4','ans5','ans6','ans7','ans8','ans9','ans10','email'));
        Session::flash('message', 'تم الارسال بنجاح');
        return redirect()->route('therapistslistInOrder');
    }

    public function getProperty (Request $request)
    {
//        dd($request->all());
        if($request->lang == "ar")
            $propertyData=Properties::findOrFail($request->id)->description_ar;
        else
            $propertyData=Properties::findOrFail($request->id)->description_en;

        return response()->json($propertyData);
    }

    public function getContact(Request $request)
    {
        return view('contact-us');
    }

    public function insertContact (Request $request)
    {
        $request->validate(
            [
                'first_name' => 'required|string|max:255',
                'email' => 'required|string|email|max:255',
                'last_name' => 'required|string|max:255',
                'subject' => 'required|string|max:600',
                'contact_type' => 'required|integer|not_in:0',
            ],
            [
                'first_name.required'    => trans('home.input-required'),
                'last_name.required'   => trans('home.input-required'),
                'contact_type.required'=>trans('home.input-required'),
                'subject.required'=>trans('home.input-required'),
                'contact_type.not_in'=>trans('home.input-required'),

                'first_name.max'=>'لا يزيد الاسم الاول عن 255 حرف',
                'last_name.max'=>'لا يزيد الاسم الاول عن 255 حرف',
                'subject.max'=>'لا يزيد الاسم الاول عن 600 حرف',
                'email.unique'=>'هذ البريد مسجل لدينا يرجي اختيار اخر',
                'email.email'=>'يدب ان يكون شكل الحقل علي هئية بريد الكتورني'
            ]
        );
        $contactData = Contact::create($request->only('first_name','last_name','email','subject','contact_type'));
        Session::flash('message','تم ارسال الرسالة بنجاح');
        return back();
    }

    //counselingMarried
    public function counselingMarried (Request $request)
    {
        return view('Counseling-married');
    }

    //familyProblems
    public function familyProblems (Request $request)
    {
        return view('family-problems');
    }

    //childrenProblems
    public function childrenProblems (Request $request)
    {
        return view('children-problems');
    }

    //psychologicalProblems
    public function psychologicalProblems (Request $request)
    {
        return view('adolescent-psychological-problems');
    }

    //developingPersonal
    public function developingPersonal (Request $request)
    {
        return view('develop-skills');
    }

    //saveCounselingMarried
    public function saveCounselingMarried (Request $request)
    { 
        $recommendationType = RecommendationType::create($request->only('email','service_type','speciality_id', 'gender'));
        foreach ($request->question as $key=>$value)
        {
            Recommendation::create([
               'question'=>$value,
                'answer'=>$request->answer[$key],
                'service_type_id'=>$recommendationType->id
            ]);
        }

        $therapists = Therapist::whereHas('specialties', function($q){
            $q->where('speciality_id', request('speciality_id'));
        })->where('gender', request('gender'))->where('active', 1)->inRandomOrder()->limit(4)->get();
        return view("therapists.randomTherapists", compact("therapists"));

    }

    //savechildrenProblems
    public function savechildrenProblems (Request $request)
    {
        $recommendationType = RecommendationType::create($request->only('email','service_type','speciality_id', 'gender'));
        foreach ($request->question as $key=>$value)
        {
            Recommendation::create([
                'question'=>$value,
                'answer'=>$request->answer[$key],
                'service_type_id'=>$recommendationType->id
            ]);
        }
        $therapists = Therapist::whereHas('specialties', function($q){
            $q->where('speciality_id', request('speciality_id'));
        })->where('gender', request('gender'))->where('active', 1)->inRandomOrder()->limit(4)->get();
        return view("therapists.randomTherapists", compact("therapists"));
    }

    //saveDevelopSkills
    public function saveDevelopSkills (Request $request)
    {
        $recommendationType = RecommendationType::create($request->only('email','service_type','speciality_id', 'gender'));
        foreach ($request->question as $key=>$value)
        {
            Recommendation::create([
                'question'=>$value,
                'answer'=>$request->answer[$key],
                'service_type_id'=>$recommendationType->id
            ]);
        }
        // $html = view('email.testEmail')->render();
        // sendGridEmailToUser($html,$request->email,'test','test email');
        // Session::flash('message', 'تم الارسال بنجاح');
        // return redirect()->route('therapistslistInOrder');
        $therapists = Therapist::whereHas('specialties', function($q){
            $q->where('speciality_id', request('speciality_id'));
        })->where('gender', request('gender'))->where('active', 1)->inRandomOrder()->limit(4)->get();
        return view("therapists.randomTherapists", compact("therapists"));
    }

    //saveAdolescentPsychologicalProblems
    public function saveAdolescentPsychologicalProblems(Request $request)
    {
        $recommendationType = RecommendationType::create($request->only('email','service_type','speciality_id', 'gender'));
        foreach ($request->question as $key=>$value)
        {
            Recommendation::create([
                'question'=>$value,
                'answer'=>$request->answer[$key],
                'service_type_id'=>$recommendationType->id
            ]);
        }
        $therapists = Therapist::whereHas('specialties', function($q){
            $q->where('speciality_id', request('speciality_id'));
        })->where('gender', request('gender'))->where('active', 1)->inRandomOrder()->limit(4)->get();
        return view("therapists.randomTherapists", compact("therapists"));
    }

    //save familyProblems
    public function savefamilyProblems(Request $request)
    {
        $recommendationType = RecommendationType::create($request->only('email','service_type','speciality_id', 'gender'));
        foreach ($request->question as $key=>$value)
        {
            Recommendation::create([
                'question'=>$value,
                'answer'=>$request->answer[$key],
                'service_type_id'=>$recommendationType->id
            ]);
        }
        $therapists = Therapist::whereHas('specialties', function($q){
            $q->whereIn('speciality_id', [25,27]);
        })->where('gender', request('gender'))->where('active', 1)->inRandomOrder()->limit(4)->get();
        return view("therapists.randomTherapists", compact("therapists"));
    }

    //getPsychologicalTest
    public function getPsychologicalTest(Request $request)
    {
        $TypeQuestions = Scale::all();
        $therapistList = Therapist::where('active',1)->limit(3)->get();
        return view('psychological-test',compact('TypeQuestions','therapistList'));
    }

    //getPsychologicalQuestions
    public function getPsychologicalQuestions ($id)
    {
        $PsyQuestions = Scale::with('scalesQuestions')->findOrFail($id);
        $PsyCount = $PsyQuestions->scalesQuestions->count();
        return view('psychological-questions',compact('PsyQuestions','PsyCount'));
    }
    //PsychologicalQuestions
    public function PsychologicalQuestions (Request $request)
    {
        $scaleEmail = Scale::InsertQuestionAnswerPoints($request);

        $this->sendEmailresult($request,$scaleEmail->scale_name,$scaleEmail->message);
      return redirect()->to(route('psychological-questions-result',['id'=>encrypt($scaleEmail->id)]));
       return view('psychological-questions-result',compact('PsyQuestions','scaleResult'));
    }
    public function getPsychologicalQuestionsResult(Request $request,$id){
       // dd($request);
        $scaleEmail=ScaleEmail::findOrFail(decrypt($id));
        $PsyQuestions = Scale::with('scalesQuestions')->findOrFail($scaleEmail->scale_id);
        return view('psychological-questions-result',compact('PsyQuestions','scaleEmail'));

    }





 //sendEmailresult
    public function sendEmailresult (Request $request,$type,$result)
    {
        $request->validate([
            'email' => 'required|email|exists:users',
        ]);
        $token = Str::random(60);

        $email = $request->email;
        $name = $request->name;
        $type = $type;
        $result = $result;
        $html = view('Psychologicalresult',compact('token','email','result','type'))->render();
        sendGridEmailToUser($html,$email,$name,'Psychological test results');
        Session::flash('status','تم الارسال بنجاح');
        return back();
    }

    //sendEmailToVerfication
    public function sendEmailToReset (Request $request)
    {
        $request->validate([
            'email' => 'required|email|exists:users',
        ]);
        $token = Str::random(60);
        DB::table('password_resets')->insert(
            ['email' => $request->email, 'token' => $token, 'created_at' => Carbon::now()]
        );
        $email = $request->email;
        $html = view('email.sendResetPassword',compact('token','email'))->render();
        sendGridEmailToUser($html,$email,'visitor','Reset Password');
        Session::flash('status','تم الارسال بنجاح');
        return back();
    }
    //showResetForm
    public function showResetForm(Request $request,$token = null)
    {
        return view('auth.passwords.reset')->with(
            ['token' => $token, 'email' => $request->email]
        );
    }
    //update password
    public function updateUserPassword(Request $request)
    {
        $request->validate([
            'email' => 'required|email|exists:users',
            'password' => 'required|string|min:6|confirmed',
            'password_confirmation' => 'required',

        ]);
        $updatePassword = DB::table('password_resets')
            ->where(['email' => $request->email, 'token' => $request->token])
            ->first();

        if(!$updatePassword)
            return back()->withInput()->with('error', 'Invalid token!');

        $user = User::where('email', $request->email)
            ->update(['password' => Hash::make($request->password)]);

        DB::table('password_resets')->where(['email'=> $request->email])->delete();
        Session::flash('status','تم التحديث بنجاح');
        return redirect('/login');
    }
    public function changeTimeZone(Request $request){
        if($request->timeZone&&Auth::check()){
            Auth::user()->timezone=$request->timeZone;
            Auth::user()->save();
            return redirect()->back();
        }
        return abort(404);
    }
}
