<?php

namespace App\Http\Controllers;

use App\Complain;
use App\Coupons;
use App\CouponsUsed;
use App\Message;
use App\PaymentLogs;
use App\Payments;
use App\ReviewQuestionAnswer;
use App\Reviews;
use App\ReviewsQuestionAnswer;
use App\SessionsQuestionAnswer;
use App\Therapist;
use App\TherapistsInvoices;
use App\TreatmentPlan;
use App\Visitor;
use App\User;
use App\Sessions;
use App\WebsiteRating;
use Carbon\Carbon;
use Cartalyst\Stripe\Exception\CardErrorException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Session;
use App\Http\Requests\UpdateVisitorProfile;
use  App\Http\Requests\createEvalutionRequest;
use App\Rules\FilterStringRule;
use Stevebauman\Location\Facades\Location;
use Stripe;


class PaymentController extends Controller
{
    //test
//    protected $_appId='a3332a09-f9a2-4472-9852-bbb43213b5b3';
//    protected $_hashSecret='3e80481b31393436356532622d663962';
//    protected $_password='newhayaH1';
    //production
//    protected $_appId='442856a6-6ba1-4c22-a3b4-339b58d1a72e';
//    protected $_hashSecret='93ba08c263616661353736642d666233';
//    protected $_password='newhayaH1';
    public function choosePaymentSession($id){
        $session = Sessions::whereNull('visitor_id')->where('session_status',['available','reserved'])->find($id);
        if(!$session){
            return redirect()->back();
        }
        if($session->start_time<=date('Y-m-d H:i:s',strtotime('+10 minutes'))){
            Session::flash('error','هذه الجلسه غير متاحه يجب ان تحجز جلسه قبل البدء 10 دقائق');
            return redirect()->back();
        }
        return view('payment.chose_payment_method',compact('session'));
    }
    public function vodafonePaymentSession($id, Request $request){
        $session = Sessions::whereNull('visitor_id')->where('session_status',['available','reserved'])->find($id);
        $therapist = Therapist::find($session->therapist_id);
        $ipaddress = '';
            if (isset($_SERVER['HTTP_CLIENT_IP'])) {
                $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
            } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED'];
            } else if (isset($_SERVER['REMOTE_ADDR'])) {
                $ipaddress = $_SERVER['REMOTE_ADDR'];
            } else {
                $ipaddress = 'UNKNOWN';
            }

        $location = Location::get($ipaddress);
        if(!$session){
            return redirect()->back();
        }
        if($session->start_time<=date('Y-m-d H:i:s',strtotime('+'.config('app.NEWHAYAH_SESSION_PAYMENT_BEFORE_MINUTES').' minutes'))){
            Session::flash('error','هذه الجلسه غير متاحه يجب ان تحجز جلسه قبل البدء بنصف ساعة');
            return redirect()->back();
        }
        return view('payment.vodafone_payment_method',compact('session', 'therapist', 'location'));
    }
    public function paymentSession($id,Request $request){
        $session = Sessions::whereNull('visitor_id')->where('session_status',['available','reserved'])->find($id);
        if(!$session){
            return redirect()->back();
        }
        if($session->start_time<=date('Y-m-d H:i:s',strtotime('+'.config('app.NEWHAYAH_SESSION_PAYMENT_BEFORE_MINUTES').' minutes'))){
            Session::flash('error','هذه الجلسه غير متاحه يجب ان تحجز جلسه قبل البدء بنصف ساعة');
            return redirect()->back();
        }
        $ipaddress = '';
            if (isset($_SERVER['HTTP_CLIENT_IP'])) {
                $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
            } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED'];
            } else if (isset($_SERVER['REMOTE_ADDR'])) {
                $ipaddress = $_SERVER['REMOTE_ADDR'];
            } else {
                $ipaddress = 'UNKNOWN';
            }

        $location = Location::get($ipaddress);
        /*$attributes = [
            'visitor_id' => auth()->user()->visitor->id,
            'status' => '2',
            'session_status' => 'reserved',
            'reserved_date' => date('Y-m-d H:i:s'),
            'payment_method'=>'',
            'payment_id'=>0,
        ];
        Sessions::where('id',$id)->update($attributes);*/
        $userData=Auth::user();
        $therapist=Therapist::find($session->therapist_id);
        if($session&&$therapist){
            return view('payment.session_payment',compact('userData','session','therapist','location'));
        }
        return abort(404);
    }
    public function getRedirectPage($id,Request $request){
        if(!$request->mobile){
            return response()->json(['success'=>false,'message'=>trans('home.Mobile is required')]);
        }
        $session = Sessions::withTrashed()->findOrFail($id);
        if($session->visitor_id||!in_array($session->session_status,['available','reserved'])||$session->deleted_at){
            return response()->json(['success'=>false,'message'=>'failed','redirect_url'=>route('therapists_preview',$session->therapist_id)]);
        }

        $ipaddress = '';
            if (isset($_SERVER['HTTP_CLIENT_IP'])) {
                $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
            } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED'];
            } else if (isset($_SERVER['REMOTE_ADDR'])) {
                $ipaddress = $_SERVER['REMOTE_ADDR'];
            } else {
                $ipaddress = 'UNKNOWN';
            }

        $location = Location::get($ipaddress);
        $userData=Auth::user();
        $visitor=Visitor::where('user_id',$userData->id)->first();
        $therapist=Therapist::find($session->therapist_id);
        if($session&&$therapist&&$visitor){
            $visitor->mobile=$request->mobile;
            $visitor->save();
            $dolarRate=getAppSetting('dolar_rating');
            if(!$dolarRate){
                $dolarRate=1;
            }
            $coupon_id=0;
            $coupon_code='';
            $coupon_discount=0;
            $discount_amount=0;
            $amount=($location->countryName=='Egypt')?(in_array($session->type,['30','3','10'])?$therapist->price30:$therapist->price60):(in_array($session->type,['30','3','10'])?$therapist->thirty_price_dollar:$therapist->sixty_price_dollar);
            $currency=($location->countryName=='Egypt')?'EGP':'USD';
            if($request->coupon){
                $coupon=Coupons::where('code',$request->coupon)->first();
                if($coupon){



                    if($coupon->therapists != '' && !in_array($therapist->id,explode(',',$coupon->therapists)))
                    {
                        return response()->json(['success'=>false,'class' => 'alert-danger','message'=>trans('home.notforthis')]);
                    }

                    if($coupon->used_for_session!='all'&&$coupon->used_for_session!=$session->type){
                        return response()->json(['success'=>false,'message'=>trans('home.This coupon not for this type of sessions')]);
                    }
                    if($coupon->currency!='all'&&$coupon->currency!=$currency){
                        return response()->json(['success'=>false,'message'=>trans('home.This coupon not for currency').trans('home.'.$currency)]);
                    }
                    if($coupon->used_limit!=0 && $coupon->used_limit<=$coupon->used){
                        return response()->json(['success'=>false,'message'=>trans('home.This coupon used for limited users')]);
                    }
                    if($coupon->expired_date<date('Y-m-d')){
                        return response()->json(['success'=>false,'message'=>trans('home.This coupon expired')]);
                    }
                    $coupon_id=$coupon->id;
                    $coupon_code=$coupon->code;
                    $coupon_discount=$coupon->percentage;
                    $discount_amount=($amount*$coupon_discount)/100;
                    $amount=$amount-$discount_amount;

                    if(CouponsUsed::where('user_id', auth()->user()->id)->where('coupon_id', $coupon->id)->count() <= $coupon->per_user)
                    {
                        CouponsUsed::create([
                           'session_id'=>$session->id,
                           'user_id'=>auth()->user()->id,
                           'coupon_id'=>$coupon->id,
                           'payment_id'=>0,
                       ]);
                        $coupon->used++;
                        $coupon->save();
                    }
                    else
                    {
                        return response()->json(['success'=>false,'message'=>trans('home.This coupon used before')]);
                    }



                }
            }
            if(env('SELECTED_PAYMENT')=='stripe'){
                $stripe =\Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));
                try{
                    $token = \Stripe\Token::create([
                        'card' => [
                            'number' => $request->cardNumber,
                            'exp_month' => $request->cardMonth,
                            'exp_year' => $request->cardYear,
                            'cvc' => $request->cardCVC,
                        ],
                    ]);
                }catch (CardErrorException $e){
                    return response()->json(['success'=>false,'message'=>$e->getMessage()]);
                }

                if (!isset($token['id'])) {
                    return response()->json(['success'=>false,'message'=>'Error Please Try again']);
                }

                $parameter=[
                    'card' => $token['id'],
                    'currency' => $currency,
                    'amount' => $amount * 100,
                    'description' => 'Payment session #'.$session->id.'('.$therapist->name.')',
                ];
                $charge = \Stripe\Charge::create($parameter);

                $paymentLog = $this->addPaymentLog($request, $coupon_id, $coupon_discount, $session, (object)$charge, $parameter);
                $payment = $this->addPayment($request, $coupon_id, $coupon_code, $coupon_discount, $discount_amount, $userData, $session, (object)$charge, $therapist, $location, $amount, $dolarRate, $currency);
                if($charge['status'] == 'succeeded') {
                    if($request->coupon){
                            $coupon=Coupons::where('code',$request->coupon)->first();
                        list($sendp, $sendt) = $this->approvedPayment($id, $coupon,$discount_amount,$visitor, $payment, $therapist, $session, $amount, $currency, $dolarRate);
                    }
                    else
                    {
                         list($sendp, $sendt) = $this->approvedPayment($id, '',$discount_amount,$visitor, $payment, $therapist, $session, $amount, $currency, $dolarRate);
                    }

                    ////////
                    return response()->json(['success'=>true,'message'=>'success','$sendp'=>$sendp,'$sendt'=>$sendt,'redirect_url'=>route('pay-session-rating',['id'=>$id])]);
                }
                return response()->json(['success'=>true,'message'=>'success','redirect_url'=>route('book_message',encrypt($paymentLog->id))]);
            }else{
                $postData=$requestParams=[
                    'sessionId'=>$request->session_id,
                    'mobileNumber'=>$request->mobile,
                    'email'=>$userData->email,
                    'amount'=>($location->countryName=='Egypt')?round($amount/$dolarRate):$amount,
                    //'amount'=>1,
                    'currencyIso'=>$currency,
                    'firstName'=>($visitor->gender=='male')?'Mr.':'Ms.',
                    'lastName'=>$userData->name,
                    'onAccept'=>route('book_success',$id),//'http://newhayah.com/session/'.$id.'/book_success',//
                    'onFail'=>route('book_fail',$id),//'http://newhayah.com/session/'.$id.'/fail_payment',//
                ];

                //dd($postData);
                $hashSecret=generateVapulusHash(config('app.WHEREBY_HASH_SECRET'),$postData);

                $requestParams['appId']=config('app.WHEREBY_APP_ID');
                $requestParams['password']=config('app.WHEREBY_PASSWORD');
                $requestParams['hashSecret']=$hashSecret;
                //dd(json_encode($requestParams),$hashSecret,json_encode($requestParams));
                try{
                    $response=Http::post('https://api.vapulus.com:1338/app/session/pay', $requestParams);
                    $res=(object)$response->json();
                    $paymentLog = $this->addPaymentLog($request, $coupon_id, $coupon_discount, $session, $res, $requestParams);
                    if($res->statusCode==200){
                        $data=(object)$res->data;
                    if($data->status!='approved'){
                        return response()->json(['success'=>false,'message'=>trans('home.Filed Payment'),'payment_failed'=>true]);
                    }
                        $payment = $this->addPayment($request, $coupon_id, $coupon_code, $coupon_discount, $discount_amount, $userData, $session, $data, $therapist, $location, $amount, $dolarRate, $currency);
                        if($data->status!='approved'){
                            return response()->json(['success'=>true,'message'=>trans('home.Will redirect to OTP'),'redirect_url'=>route('book_otp_html',encrypt($payment->id))]);
                        }

                        if($request->coupon){
                            $coupon=Coupons::where('code',$request->coupon)->first();
                            list($sendp, $sendt) = $this->approvedPayment($id, $coupon,$discount_amount,$visitor, $payment, $therapist, $session, $amount, $currency, $dolarRate);
                        }
                        list($sendp, $sendt) = $this->approvedPayment($id, '',$discount_amount,$visitor, $payment, $therapist, $session, $amount, $currency, $dolarRate);
                        ////////
                        return response()->json(['success'=>true,'message'=>'success','$sendp'=>$sendp,'$sendt'=>$sendt,'redirect_url'=>route('pay-session-rating',['id'=>$id])]);
                    }
                    $res->redirect_url=route('book_message',encrypt($paymentLog->id));
                    return response()->json($res);
                }catch (\Exception $e){
                    return response()->json(['success'=>false,'message'=>$e->getMessage()]);
                }
            }


        }
        return abort(404);
    }
    public function paymentMessage($id){
        try {
            $id=decrypt($id);
            $paymentLog=PaymentLogs::findOrFail($id);
            $response=json_decode($paymentLog->response);
            return view('payment.payment_message',compact('paymentLog','response'));
        }catch (\Exception $e){

        }
        return abort(404);
    }
    public static function sendSessionPay($requestParams=[]){
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_PORT => "1338",
            CURLOPT_URL => "https://api.vapulus.com:1338/app/session/pay",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($requestParams),
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/json",
                "postman-token: 41dc66dc-e4a7-2a26-8139-8671ba8fc485"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }

    }
    public function successPayment($id,Request $request){
        $ipaddress = '';
            if (isset($_SERVER['HTTP_CLIENT_IP'])) {
                $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
            } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED'];
            } else if (isset($_SERVER['REMOTE_ADDR'])) {
                $ipaddress = $_SERVER['REMOTE_ADDR'];
            } else {
                $ipaddress = 'UNKNOWN';
            }

        $location = Location::get($ipaddress);
        if($request->transactionId){
            $payment=Payments::where('transaction_id',$request->transactionId)->where('status','!=',$request->status)->first();
            if($payment){

                $session=Sessions::find($id);

                $coupon=Coupons::find($payment->coupon_id);
                if(isset($coupon)){
                    CouponsUsed::create([
                        'session_id'=>$session->id,
                        'user_id'=>auth()->user()->id,
                        'coupon_id'=>$coupon->id,
                        'payment_id'=>$payment->id,
                    ]);
                }
                $payment->status=$request->status;
                $statues_date=$request->status.'_date';
                $payment->$statues_date=date('Y-m-d H:i:s');
                $payment->save();
                $userData=Auth::user();
                $visitor=Visitor::where('user_id',$userData->id)->first();
                $therapist=Therapist::find($session->therapist_id);
                $attributes = [
                    'visitor_id' => $visitor->id,
                    'status' => '2',
                    'session_status' => 'reserved',
                    'patient_cancel' => 'no',
                    'reserved_date' => date('Y-m-d H:i:s'),
                    'payment_method'=>'vapulus',
                    'payment_id'=>$payment->id,
                ];
                Sessions::where('id',$id)->update($attributes);

                ///send email to therpist and patient
                $allsessions=Sessions::where('id',$id)->with('visitor')->with('therapist')->first();
                //dd($allsessions);
                if(!empty($allsessions)){
                    $therapistUser=$allsessions->therapist->user;
                    $visitorUser=$allsessions->visitor->user;
                    $patientemail=$visitorUser->email;
                    $therapistemail=$therapistUser->email;
                    $patientname=$visitorUser->name;
                    $therapistname=$therapistUser->name;
                    $html = view('email.session_payed',compact('visitorUser','therapistUser','allsessions'))->render();
                    $sendp=sendGridEmailToUser($html,$patientemail, $patientname, 'Session Payed');
                    setTimeZone($therapistUser->timezone?$therapistUser->timezone:'Africa/Cairo');
                    $allsessions=Sessions::find($allsessions->id);
                    $html = view('email.session_payed_therapist',compact('visitorUser','therapistUser','allsessions'))->render();
                    $sendt=sendGridEmailToUser($html,$therapistemail, $therapistname, 'Session Payed');


                    /* $invoice=new TherapistsInvoices();
                     $invoice->therapist_id=$therapist->id;
                     $invoice->visitor_id=$visitor->id;
                     $invoice->session_id=$id;
                     $invoice->session_id=$session->id;
                     $invoice->visitor_name=$visitorUser->name;
                     $invoice->session_date=$session->start_time;
                     $invoice->therapist_price=(in_array($session->type,['30','3']))?$therapist->price30:$therapist->price60;
                     $invoice->therapist_price_dolar=(in_array($session->type,['30','3']))?$therapist->thirty_price_dollar:$therapist->sixty_price_dollar;
                     $invoice->session_type=$session->type;
                     $invoice->total_amount=($location->countryName=='Egypt')?$payment->price:$payment->price_dolar;
                     $invoice->currency=$payment->currancy;
                     $invoice->discount_amount=0;
                     $invoice->discount_percentage=0;
                     $invoice->coupon_id=0;
                     $invoice->coupon_code='';
                     $invoice->total_after_discount=$invoice->total_amount- $invoice->discount_amount;
                     $invoice->dolar_rating=$payment->dolar_rating;

                     $invoice->website_percentage=getAppSetting('website_percentage');
                     $invoice->minimum_price_30=getAppSetting('minimum_price_30');
                     $invoice->minimum_price_60=getAppSetting('minimum_price_60');
                     $invoice->minimum_price_30_dolar=getAppSetting('minimum_price_30_dolar');
                     $invoice->minimum_price_60_dolar=getAppSetting('minimum_price_60_dolar');
                     $minimum_price=0;
                     if(in_array($session->type,[30,3])){
                         if($invoice->currency=='EGP'){
                             $minimum_price=$invoice->minimum_price_30;
                         }else{
                             $minimum_price=$invoice->minimum_price_30_dolar;
                         }
                     }
                     if(in_array($session->type,[60,6])){
                         if($invoice->currency=='EGP'){
                             $minimum_price=$invoice->minimum_price_60;
                         }else{
                             $minimum_price=$invoice->minimum_price_60_dolar;
                         }
                     }
                     $invoice->therapist_amount=calculateTherapistAmount($invoice->total_amount,$invoice->website_percentage,$minimum_price);
                     $invoice->save();*/
                    //Sessions::where('id',$session->id)->update(['invoice_id'=>$invoice->id]);
                    $hasOtherSession=Sessions::where('id','!=',$id)->where('therapist_id',$therapist->id)->where('visitor_id',$visitor->id)->count();
                    return view('payment.success_payment',compact('id','hasOtherSession'));
                }

            }
        }
        return abort(404);
    }
    public function failPayment(Request $request){
        $payment=Payments::where('transaction_id',$request->transactionId)->where('status','!=',$request->status)->first();
        if($payment){
            $payment->status=$request->status;
            $statues_date=$request->status.'_date';
            $payment->$statues_date=date('Y-m-d H:i:s');
            $payment->save();
            return view('payment.fail_payment');
        }
        return abort(404);
    }
    public function showPaymentHtml_old($id){
        $payment=Payments::find($id);
        if($payment){
            echo $payment->html_body_content;
        }else{
            return abort(404);
        }
    }
    public function showPaymentHtml($encode_id){
        try{
            $id=decrypt($encode_id);
            $payment=Payments::find($id);
            if($payment){
                echo $payment->html_body_content;
                return '';
            }
        }catch (\Exception $exception){

        }
        return abort(404);
    }

    /**
     * @param Request $request
     * @param int $coupon_id
     * @param int $coupon_discount
     * @param $session
     * @param object $res
     * @param array $requestParams
     * @return PaymentLogs
     */
    public function addPaymentLog(Request $request, int $coupon_id, int $coupon_discount, $session, object $res, array $requestParams): PaymentLogs
    {
        if(env('SELECTED_PAYMENT')=='stripe'){
            $status=($res->status=='succeeded')?200:203;
        }else{
            $status=$res->statusCode;
        }
        $paymentLog = new PaymentLogs();
        $paymentLog->coupon_id = $coupon_id;
        $paymentLog->coupon_discount = $coupon_discount;
        $paymentLog->session_id = $session->id;
        $paymentLog->payment_session_id = $request->session_id;
        $paymentLog->statues =$status;
        $paymentLog->datasend = json_encode($requestParams);
        $paymentLog->response = json_encode($res);
        $paymentLog->payment_method = env('SELECTED_PAYMENT')=='stripe'?env('SELECTED_PAYMENT'):'vapulus';
        $paymentLog->save();
        return $paymentLog;
    }

    /**
     * @param Request $request
     * @param int $coupon_id
     * @param string $coupon_code
     * @param int $coupon_discount
     * @param $discount_amount
     * @param \Illuminate\Contracts\Auth\Authenticatable|null $userData
     * @param $session
     * @param object $data
     * @param $therapist
     * @param $location
     * @param $amount
     * @param int|null $dolarRate
     * @param string $currency
     * @return Payments
     */
    public function addPayment(Request $request, int $coupon_id, string $coupon_code, int $coupon_discount, $discount_amount, ?\Illuminate\Contracts\Auth\Authenticatable $userData, $session, object $data, $therapist, $location, $amount, ?int $dolarRate, string $currency): Payments
    {
        $payment = new Payments();
        $payment->coupon_id = $coupon_id;
        $payment->coupon_code = $coupon_code;
        $payment->coupon_discount = $coupon_discount;
        $payment->discount_amount = $discount_amount;
        $payment->user_id = $userData->id;
        $payment->therapist_id = $session->therapist->user->id;
        $payment->session_id = $session->id;
        $payment->payment_session_id = $request->session_id;
        $payment->payment_method = env('SELECTED_PAYMENT')=='stripe'?env('SELECTED_PAYMENT'):'vapulus';
        if(env('SELECTED_PAYMENT')=='stripe') {
            $payment->transaction_id = $data->id;
            $payment->status = ($data->status=='succeeded')?200:203;
            $payment->action = (isset($data->action)) ? $data->action : null;
            $payment->html_body_content = (isset($data->htmlBodyContent)) ? $data->htmlBodyContent : null;
        }else{
            $payment->transaction_id = $data->transactionId;
            $payment->status = $data->status;
            $payment->action = (isset($data->action)) ? $data->action : null;
            $payment->html_body_content = (isset($data->htmlBodyContent)) ? $data->htmlBodyContent : null;
        }
        $payment->price = (in_array($session->type, ['30', '3','10'])) ? ($therapist->price30 - $discount_amount) : ($therapist->price60 - $discount_amount);
        $payment->price_dolar = (in_array($session->type, ['30', '3','10'])) ? ($therapist->thirty_price_dollar - $discount_amount) : ($therapist->sixty_price_dollar - $discount_amount);
        $payment->amount = (($location->countryName == 'Egypt') ? ($amount / $dolarRate) : $amount);
        $payment->currancy = $currency;
        $payment->dolar_rating = $dolarRate;
        $payment->add_date = date('Y-m-d H:i:s');
        $payment->save();
        return $payment;
    }

    /**
     * @param $id
     * @param $visitor
     * @param Payments $payment
     * @param $therapist
     * @param $session
     * @param $amount
     * @param string $currency
     * @param int|null $dolarRate
     * @return array
     * @throws \Throwable
     */
    public function approvedPayment($id, $coupon, $discount_amount,$visitor, Payments $payment, $therapist, $session, $amount, string $currency, ?int $dolarRate): array
    {
        $attributes = [
            'visitor_id' => $visitor->id,
            'status' => '2',
            'session_status' => 'reserved',
            'patient_cancel' => 'no',
            'reserved_date' => date('Y-m-d H:i:s'),
            'payment_method' => env('SELECTED_PAYMENT')=='stripe'?env('SELECTED_PAYMENT'):'vapulus',
            'payment_id' => $payment->id,
        ];
        Sessions::where('id', $id)->update($attributes);
        ///send email to therpist and patient
        $allsessions = Sessions::where('id', $id)->with('visitor')->with('therapist')->first();
        if (!empty($allsessions)) {
            $therapistUser = $allsessions->therapist->user;
            $visitorUser = $allsessions->visitor->user;
            $patientemail = $visitorUser->email;
            $therapistemail = $therapistUser->email;
            $patientname = $visitorUser->name;
            $therapistname = $therapistUser->name;
            $html = view('email.session_payed', compact('visitorUser', 'therapistUser', 'allsessions'))->render();
            $sendp = sendGridEmailToUser($html, $patientemail, $patientname, 'Session Payed');
            setTimeZone($therapistUser->timezone ? $therapistUser->timezone : 'Africa/Cairo');
            $allsessions = Sessions::find($allsessions->id);
            $html = view('email.session_payed_therapist', compact('visitorUser', 'therapistUser', 'allsessions'))->render();
            $sendt = sendGridEmailToUser($html, $therapistemail, $therapistname, 'Session Payed');

            $invoice = new TherapistsInvoices();
            $invoice->therapist_id = $therapist->id;
            $invoice->visitor_id = $visitor->id;
            $invoice->session_id = $id;
            $invoice->session_id = $session->id;
            $invoice->visitor_name = $visitorUser->name;
            $invoice->session_date = $session->start_time;
            $invoice->therapist_price = (in_array($session->type, ['30', '3','10'])) ? $therapist->price30 : $therapist->price60;
            $invoice->therapist_price_dolar = (in_array($session->type, ['30', '3','10'])) ? $therapist->thirty_price_dollar : $therapist->sixty_price_dollar;
            $invoice->session_type = $session->type;
            $invoice->total_amount = $amount;
            $invoice->currency = $currency;


            // $minimum_price=0;
            //    if(in_array($session->type,[30,3,10])){
            //        if($invoice->currency=='EGP'){
            //            $minimum_price=$invoice->minimum_price_30;
            //        }else{
            //            $minimum_price=$invoice->minimum_price_30_dolar;
            //        }
            //    }
            //    if(in_array($session->type,[60,6,15])){
            //        if($invoice->currency=='EGP'){
            //            $minimum_price=$invoice->minimum_price_60;
            //        }else{
            //            $minimum_price=$invoice->minimum_price_60_dolar;
            //        }
            //    }
            // $invoice->therapist_amount=calculateTherapistAmount($invoice->total_amount,$invoice->website_percentage,$minimum_price);


               $invoice->website_percentage=getAppSetting('website_percentage');
               $invoice->minimum_price_30=getAppSetting('minimum_price_30');
               $invoice->minimum_price_60=getAppSetting('minimum_price_60');
               $invoice->minimum_price_30_dolar=getAppSetting('minimum_price_30_dolar');
               $invoice->minimum_price_60_dolar=getAppSetting('minimum_price_60_dolar');
               $minimum_price=0;


               if ($currency == 'USD')
               {
                   if(in_array($session->type,[30,3,10])){
                    $minimum_price=$invoice->minimum_price_30_dolar;
                   }
                   else{
                        $minimum_price=$invoice->minimum_price_60_dolar;
                   }
               }
               elseif($currency == 'EGP')
               {

                   if(in_array($session->type,[30,3,10])){
                    $minimum_price=$invoice->minimum_price_30;
                   }
                   else{
                        $minimum_price=$invoice->minimum_price_60;
                   }

               }


             //OLD BEFORE DISCOUNT//  $invoice->therapist_amount=calculateTherapistAmount($invoice->total_amount,$invoice->website_percentage,$minimum_price);

               if($discount_amount > 0)
               {
                $therDiscount = ($discount_amount/2);

                $invoice->therapist_amount=calculateTherapistAmount($invoice->total_amount,$invoice->website_percentage,$minimum_price) + $therDiscount;
               }
               else
               {
                $invoice->therapist_amount=calculateTherapistAmount($invoice->total_amount,$invoice->website_percentage,$minimum_price);
               }


               if($coupon)
               {
                    $coupon_id=$coupon->id;
                    $coupon_code=$coupon->code;
                    $coupon_discount=$coupon->percentage;
               }
               else{
                    $coupon_id=0;
                    $coupon_code='';
                    $coupon_discount=0;
               }





            $invoice->discount_amount = $discount_amount;
            $invoice->discount_percentage = $coupon_discount;
            $invoice->coupon_id = $coupon_id;
            $invoice->coupon_code = $coupon_code;
            $invoice->total_after_discount = $invoice->total_amount;
            $invoice->dolar_rating = $dolarRate;
            $invoice->save();
            Sessions::where('id', $session->id)->update(['invoice_id' => $invoice->id]);

        }
        return array($sendp, $sendt);
    }









    //keyup coupon
    public function applyCoupon(Request $request)
    {
        $session = Sessions::withTrashed()->findOrFail($request->id);
        $ipaddress = '';
            if (isset($_SERVER['HTTP_CLIENT_IP'])) {
                $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
            } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED'];
            } else if (isset($_SERVER['REMOTE_ADDR'])) {
                $ipaddress = $_SERVER['REMOTE_ADDR'];
            } else {
                $ipaddress = 'UNKNOWN';
            }

        $location = Location::get($ipaddress);
        $userData=Auth::user();
        $visitor=Visitor::where('user_id',$userData->id)->first();
        $therapist=Therapist::find($session->therapist_id);
        if($session&&$therapist&&$visitor){

            $coupon_id=0;
            $coupon_code='';
            $coupon_discount=0;
            $discount_amount=0;
            $amount=($location->countryName=='Egypt')?(in_array($session->type,['30','3','10'])?$therapist->price30:$therapist->price60):(in_array($session->type,['30','3','10'])?$therapist->thirty_price_dollar:$therapist->sixty_price_dollar);
            $currency=($location->countryName=='Egypt')?'EGP':'USD';
            if($request->coupon){
                $coupon=Coupons::where('code',$request->coupon)->first();
                if($coupon){



                    if($coupon->therapists != '' && !in_array($therapist->id,explode(',',$coupon->therapists)))
                    {
                        return response()->json(['success'=>false,'amount' => $amount,'class' => 'alert-danger','message'=>trans('home.notforthis')]);
                    }

                    if(CouponsUsed::where('user_id', auth()->user()->id)->where('coupon_id', $coupon->id)->count() >= $coupon->per_user)
                    {
                        $count = CouponsUsed::where('user_id', auth()->user()->id)->where('coupon_id', $coupon->id)->count();
                         return response()->json(['success'=>false, 'class' => 'alert-danger' ,'message'=>trans('home.This coupon used before'), 'amount' => $amount, 'usedcount' => $count]);
                    }

                    if($coupon->used_for_session!='all'&&$coupon->used_for_session!=$session->type){
                        return response()->json(['success'=>false, 'class' => 'alert-danger' ,'message'=>trans('home.This coupon not for this type of sessions'), 'amount' => $amount]);
                    }
                    if($coupon->currency!='all'&&$coupon->currency!=$currency){
                        return response()->json(['success'=>false, 'class' => 'alert-danger' ,'message'=>trans('home.This coupon not for currency').trans('home.'.$currency), 'amount' => $amount]);
                    }
                    if($coupon->used_limit!=0 && $coupon->used_limit<=$coupon->used){
                        return response()->json(['success'=>false, 'class' => 'alert-danger' ,'message'=>trans('home.This coupon used for limited users'), 'amount' => $amount]);
                    }
                    if($coupon->expired_date<date('Y-m-d')){
                        return response()->json(['success'=>false, 'class' => 'alert-danger' ,'message'=>trans('home.This coupon expired'), 'amount' => $amount]);
                    }
                    $coupon_id=$coupon->id;
                    $coupon_code=$coupon->code;
                    $coupon_discount=$coupon->percentage;
                    $discount_amount=($amount*$coupon_discount)/100;
                    $amount=$amount-$discount_amount;





                    return response()->json(['success'=>true, 'class' => 'alert-success' ,'message'=>trans('home.This coupon valid').'( '.$coupon_discount.'%)', 'amount' => $amount]);

                }
                return response()->json(['success'=>false, 'class' => 'alert-danger' ,'message'=>trans('home.This coupon not valid'), 'amount' => $amount]);
            }
            return response()->json(['success'=>false, 'class' => 'alert-danger' ,'message'=>trans('home.This coupon not valid'), 'amount' => $amount]);
        }

        else
        {
            return response()->json(['success'=>false, 'class' => 'alert-danger' ,'message'=>trans('home.This coupon not valid'), 'amount' => $amount]);
        }

    }






















}
