<?php

namespace App\Http\Controllers;

use App\ConfidentialityNoticeAgrements;
use App\Message;
use App\Rules\SessionStartTime;
use App\Sessions;
use App\Therapist;
use App\TreatmentPlan;
use App\TreatmentPlansDiagnosis;
use App\TreatmentPlansTreatments;
use App\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
use App\Http\Requests\InsertSessionRequest;
use Yajra\DataTables\Facades\DataTables;
use function Sodium\add;
use Validator;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\UpdatePlanRequest;
use App\Visitor;

class SessionsController extends ZoomController
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $therapistData = Therapist::where('user_id', auth()->user()->id)->first();
        $allSessions = Sessions::getSessionsJson($therapistData);
        return response()->json($allSessions, 200);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function getAddSessionPage(Request $request)
    {
        $AllSessions = Sessions::select('sessions.id','sessions.therapist_id','sessions.visitor_id','users.name AS visitor_name','sessions.type','sessions.start_time')
            ->leftJoin('visitors','visitors.id','=','sessions.visitor_id')
            ->leftJoin('users','users.id','=','visitors.user_id')
            ->leftJoin('therapists','therapists.id','=','sessions.therapist_id')->where('therapist_id',Therapist::where('user_id',auth()->user()->id)->first()->id);
        if ($request->ajax()) {
            if($request->from_date&&$request->to_date){
                $AllSessions->whereBetween('start_time',[$request->from_date,$request->to_date]);
            }
            if($request->statues){
                switch ($request->statues){
                    case 'not_reserved':
                        $AllSessions=$AllSessions->whereNull('visitor_id');
                        break;
                    case 'reserved':
                        $AllSessions=$AllSessions->whereNotNull('visitor_id');
                        break;
                }
            }
            return DataTables::of($AllSessions)
                ->addIndexColumn()
                ->addColumn('date', function($sessionInfo){
                    return'<strong style="color:#00bacf" class="mx-3"> '.$sessionInfo->start_time.' </strong>  <br/>
                                <strong style="color:#ea6153">
                                    '.$sessionInfo->type.'
                                   '.trans('home.minutes').'
                                </strong>';
                })
                ->addColumn('statues', function($sessionInfo){
                    return($sessionInfo->visitor_id == null)?'<span style="margin-left: 40px;margin-top: 15px;padding: 0px 20px;border-radius: 10px;display: inline-block;color: white;" class="label label-green">'.trans('home.Not reserved').'</span>':'<span style="margin-left: 40px;margin-top: 15px;padding: 0px 20px;border-radius: 10px;display: inline-block;color: white;" class="label label-red">'.trans('home.Reserved').'</span>';
                })
                ->addColumn('checkbox', function($sessionInfo){
                    return($sessionInfo->visitor_id == null)?'<div class="checkbox-nice checkbox-inline"><input data-id="'.$sessionInfo->id.'" class="sessionCheckbox" type="checkbox" class="sub_chk"></div>':'';
                })
                ->rawColumns(['date','statues','checkbox'])
                ->make(true);
        }
        return view('therapists.add-session',compact('AllSessions'));
    }

    public function scheduleCalenderSession(Request $request){
        $therapist = Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail();
        $validator = Validator::make($request->all(), [
            'type' => ['required'],
            //            'start_time' => ['required', 'date', 'after:today', new SessionStartTime],
            'start_date' => ['required', 'date'],
            'end_date' => ['required', 'date'],
            'timeSlotTime' => ['required'],
            'days' => ['required'],
            //'color' => ['required', 'string'],
            //'text_color' => ['required', 'string'],
        ]);
        if ($validator->fails()) {
            return Response::json(array(
                'success' => false,
                'errors' => $validator->getMessageBag()->toArray()
            ), 400); // 400 being the HTTP code for an invalid request.
        }
        $begin = new \DateTime($request->start_date);
        $end = new \DateTime($request->end_date);
        $end->add(new \DateInterval('P1D'));
        $interval = \DateInterval::createFromDateString('1 day');
        $period = new \DatePeriod($begin, $interval, $end);
        $x=0;
        $array=[];
        $arrayTimes=[];
        foreach ($period as $dt) {
            $start_time=date('Y-m-d H:i:s',strtotime($dt->format("Y-m-d").' '.$request->timeSlotTime));
            //dd(date('w', strtotime($start_time)),$request->days);
            if(in_array(date('w', strtotime($start_time)),$request->days)){
                $arrayTimes[]= $start_time;
                // $sessionCount=Sessions::where('therapist_id',$therapist->id)->whereBetween('start_time',[$start_time,date('Y-m-d H:i:s',strtotime($start_time.' +'.$request->type.' minutes'))] )->count();
                $sessionCount=Sessions::where('therapist_id',$therapist->id)->where(function($q)use($start_time,$request){
                    //$date=getConvertToMySqlDate($request->start_time);
                    $date=$start_time;
                    $q->whereBetween('start_time',[date('Y-m-d H:i:s',strtotime($date)),date('Y-m-d H:i:s',strtotime($date.' +'.$request->type.' minutes '))])
                        ->orWhere(function($q)use($request,$date){
                            $q->where('start_time','>=',date('Y-m-d H:i:s',strtotime($date)))
                                ->where('start_time','<=',date('Y-m-d H:i:s',strtotime($date.' +'.$request->type.' minutes ')));
                        })->orWhere(function($q)use ($request,$date){
                            $start_time=date('Y-m-d H:i:s',strtotime($date));
                            $end_time=date('Y-m-d H:i:s',strtotime($date.' +'.$request->type.' minutes '));
                            $q->whereRaw("'$start_time' BETWEEN start_time AND DATE_ADD(start_time,INTERVAL $request->type MINUTE)")
                                ->orWhereRaw("'$end_time' BETWEEN start_time AND DATE_ADD(start_time,INTERVAL $request->type MINUTE)");
                        });

                    //->orWhereRaw("'$curentDate' BETWEEN start_time AND DATE_ADD(start_time, INTERVAL type MINUTE)")
                    ;
                })->whereNotIn('session_status',['cancelled','visitor_cancelled']);
                //return $sessionCount->count();
                $sessionCount=$sessionCount->count();
                if($sessionCount==0){
                    $array[]=[
                        'start_time' => $start_time,
                        'type' => $request->type,
                        'session_date' => date('Y-m-d', strtotime($start_time)),
                        'status' => 1,
                        'therapist_id' => $therapist->id
                    ];
                    $timezone=(Auth::user()->timezone)?Auth::user()->timezone:'Africa/Cairo' ;
                    setTimeZone($timezone);
                    $session=Sessions::create([
                        'start_time' => $start_time,
                        'type' => $request->type,
                        'session_date' => date('Y-m-d', strtotime($start_time)),
                        'status' => 1,
                        'therapist_id' => $therapist->id,
                        'topic'=>'real',
                    ]);
                    $this->createMeeting($session);
                    $x++;
                    if($x==2){
                        $x=0;
                        sleep(1);
                    }

                }
                else
                {
                    return response()->json(['success'=>false,'message' => ' هذه الجلسات مضافه من قبل ']);
                }
            }

        }
        return response()->json(['success'=>true,'message' => 'تم اضافة الجلسة بنجاح','$array'=>$array,'$arrayTimes'=>$arrayTimes]);
    }
    public function calenderOperations(Request $request)
    {
        $request->merge([
            'start_time' => date('Y-m-d H:i:s',strtotime($request->start_time)),
        ]);
        $therapist = Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail();
        $validator = Validator::make($request->all(), [
            'type' => ['required'],
            //            'start_time' => ['required', 'date', 'after:today', new SessionStartTime],
            'start_time' => ['required', 'date'],
            //'color' => ['required', 'string'],
            //'text_color' => ['required', 'string'],
        ], [
            'type.required' => 'من فضلك اختر نوع الجلسة',
            'start_time.required' => 'من فضلك ادخل الوقت والتاريخ',
            'start_time.date' => 'يجب ادخال تاريخ',
            //'start_time.after' => 'غير مسموح باضافة مواعيد في الايام السابقة',
           // 'color.required' => 'يجب ادخال لون الخلفية',
           // 'text_color.required' => 'يجب ادخال لون النص',
        ]);


        if ($validator->fails()) {
            return Response::json(array(
                'success' => false,
                'errors' => $validator->getMessageBag()->toArray()
            ), 400); // 400 being the HTTP code for an invalid request.
        }
        $sessionCount=Sessions::where('therapist_id',$therapist->id)->where(function($q)use($request){
            //$date=getConvertToMySqlDate($request->start_time);
            $date=$request->start_time;
            $q->whereBetween('start_time',[date('Y-m-d H:i:s',strtotime($date)),date('Y-m-d H:i:s',strtotime($date.' +'.$request->type.' minutes '))])
                ->orWhere(function($q)use($request,$date){
                $q->where('start_time','>=',date('Y-m-d H:i:s',strtotime($date)))
                    ->where('start_time','<=',date('Y-m-d H:i:s',strtotime($date.' +'.$request->type.' minutes ')));
            })->orWhere(function($q)use ($request,$date){
                $start_time=date('Y-m-d H:i:s',strtotime($date));
                $end_time=date('Y-m-d H:i:s',strtotime($date.' +'.$request->type.' minutes '));
                $q->whereRaw("'$start_time' BETWEEN start_time AND DATE_ADD(start_time,INTERVAL type MINUTE)")
                    ->orWhereRaw("'$end_time' BETWEEN start_time AND DATE_ADD(start_time,INTERVAL type MINUTE)");
            });

            //->orWhereRaw("'$curentDate' BETWEEN start_time AND DATE_ADD(start_time, INTERVAL type MINUTE)")
            ;
        })->whereNotIn('session_status',['cancelled','visitor_cancelled']);
        //dd($sessionCount->get());
        //dd(getEloquentSqlWithBindings($sessionCount),$sessionCount->count());

        if($request->event_id){
            $sessionCount=$sessionCount->where('id','!=',$request->event_id);
        }
        $sessionCount=$sessionCount->count();
        //dd($sessionCount);
        if ( $sessionCount> 0){
            return response()->json(['success'=>false,'message' => trans('home.This session date is already added or have session between this date')]);
        }
        if($request->start_time<=date('Y-m-d H:i:s',strtotime('+'.$request->type.' minutes'))){
            return response()->json(['success'=>false,'message' => 'يجب ان يكون وقت الجلسه بعد اكثر من '.$request->type.' دقيقه من الآن']);
        }
        //dd(date('Y-m-d H:i:s', strtotime($request->start_time)));
    $session = Sessions::create(array_merge($request->only('type','topic'/*, 'start_time'*/), ['start_time'=>date('Y-m-d H:i:s', strtotime($request->start_time)),'session_date' => date('Y-m-d', strtotime($request->start_time)), 'status' => 1, 'therapist_id' => $therapist->id, 'topic'=>'real']));
    $this->createMeeting($session);
    return response()->json(['success'=>true,'message' => 'تم اضافة الجلسة بنجاح' , 'meeting' => $this->createMeeting($session)]);

        switch ($request->fun_type) {
            case 'add':
//                if($request->start_time<=date('Y-m-d H:i:s',strtotime('+'.$request->type.' minutes'))){
//                    return response()->json(['success'=>false,'message' => 'يجب ان يكون وقت الجلسه بعد اكثر من '.$request->type.' دقيقه من الآن']);
//                }
                $session = Sessions::create(array_merge($request->only('type','topic'/*, 'color', 'text_color'*/), ['start_time'=>date('Y-m-d H:i:s', strtotime($request->start_time)),'session_date' => date('Y-m-d', strtotime($request->start_time)), 'status' => 1, 'therapist_id' => $therapist->id, 'topic'=>'real']));
                $this->createMeeting($session);
                return response()->json(['success'=>true,'message' => 'تم اضافة الجلسة بنجاح'  , 'meeting' => $this->createMeeting($session)]);
                break;
            case 'update':
                if(Sessions::where([ ['id',$request->event_id],['visitor_id','!=',null]])->count() > 0)
                    return response()->json(['success'=>false,'message' => 'غير مسموح بتعديل معاد الجلسة']);

                Sessions::where('id', $request->event_id)->update($request->only('type', 'start_time'/*, 'color', 'text_color'*/));
                return response()->json(['success'=>true,'message' => 'تم تحديث الجلسة بنجاح']);
                break;
            default:
        }

    }

    //therapist client files
    public function clients_files(Request $request)
    {
        $userData = User::findOrFail(auth()->user()->id);
        $therapist = Therapist::where('user_id', auth()->user()->id)->firstOrFail();
        $avg_rating = \DB::table('reviews')->where('therapist_id', $therapist->id)->avg('rating');
//        if($therapist->agreement_privacy_charter==0){
//            return redirect()->to(route('therapist_privacy_charter'));
//        }
        if($therapist->active==1) {
            $therapistSessions = Sessions::where(['therapist_id' => $therapist->id,['visitor_id','!=',null]])
            // ->whereNotIn('session_status',['cancelled','visitor_cancelled'])
            ->orderBy('start_time','asc')->get()->unique('visitor_id');
            if(is_null($therapistSessions))
            {
                Session::flash('status',trans('home.not-plan'));
                return redirect()->route('clients-files');
            }
            else{
                return view('therapists.client-files', [
                    'data' => Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail(),
                    'therapistSessions' => $therapistSessions,
                    'avg_rating' => $avg_rating,
                ]);
            }
        }
        return view('therapists.data-revision',compact('userData'));
    }

    //get create client file
    public function create_plan(Sessions $therapist_session)
    {
        $clientSessions = Sessions::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id,['start_time','>=',$therapist_session->start_time]])->get();
        $last_Session = Sessions::latest()->where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->first();

        $therapistData = Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail();

        //Rating average of therapist
            $avg_rating = \DB::table('reviews')->where('therapist_id', $therapistData->id)->avg('rating');

        return view('therapists.create-plan', [
            'data' => $therapistData,
            'therapist_session' => $therapist_session,
            'clientSessions'=>$clientSessions,
            'last_Session'=>$last_Session,
             'avg_rating' => $avg_rating
        ]);
    }

    //store client file
    // [client_name_pdf - age_pdf - gender_pdf - problem_pdf - therap_evaluation_pdf - diagnostic_pdf - therapeutic_intervention_pdf - problem_description_pdf - homework_pdf - table_pdf - long_term_pdf - short_term_pdf - transfer_pdf - current_status_pdf - last_visit_pdf - therapist_name_pdf]


    public function store_plan(UpdatePlanRequest $request , Sessions $therapist_session)
    {
        $planData = TreatmentPlan::create(array_merge($request->only('session_id',
            'age','gender','problem','problem_description'
            ,'therap_evaluation','long_term','short_term','transfer','current_status','last_visit','homework', 'client_name_pdf' , 'age_pdf' , 'gender_pdf' , 'problem_pdf' , 'therap_evaluation_pdf' , 'diagnostic_pdf' , 'therapeutic_intervention_pdf' , 'problem_description_pdf' , 'homework_pdf' , 'table_pdf' , 'long_term_pdf' , 'short_term_pdf' , 'transfer_pdf' , 'current_status_pdf' , 'last_visit_pdf' , 'therapist_name_pdf'),
            ['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id]));
        if($request->diagnostic){
            foreach ($request->diagnostic as $diag){
                TreatmentPlansDiagnosis::create(['treatment_plan_id'=>$planData->id,'diagnosis_id'=>$diag]);
            }
        }
        if($request->therapeutic_intervention) {
            foreach ($request->therapeutic_intervention as $treat) {
                TreatmentPlansTreatments::create(['treatment_plan_id' => $planData->id, 'treatments_id' => $treat]);
            }
        }

        $therapistData = Therapist::find($therapist_session->therapist_id);

        $visitor = Visitor::findOrFail($therapist_session->visitor_id);

        $doctor = User::find($therapistData->user_id);
        //Send Notify
        $tokens = \DB::table('firebase_tokens')->where('user_id', $visitor->user_id)->pluck('platform_token');
            
        $userLang = User::find($visitor->user_id);
        if($userLang->lang == 'ar')
        {
            $body = 'المعالج   '.$doctor->name.' قام بإنشاء خطه علاجيه لك  ';
            $this->sendWebNotification(' رسالة جديده ... ', $body, $therapist_session->id, $tokens, 'create_plan');
        }
        else
        {
            $body = 'Doctor '.$therapistData->name_e.' create a new medical plan for you';
            $this->sendWebNotification('New Message...', $body, $therapist_session->id, $tokens, 'create_plan');
        }

        //saveNotifyIntoDatabase
        $saveBody = '<h3>Doctor <span>'.$doctor->name.'</span> create a new medical plan for you</h3>';
        $saveBody_ar = '<h3>المعالج  <span>'.$doctor->name.'</span> قام بإنشاء خطه علاجيه لك</h3>';
        $this->saveNotifyIntoDatabase($saveBody,$therapistData->id, $visitor->id, $saveBody_ar, $doctor->name, $therapist_session->id, 'create_plan');



        Session::flash('status',trans('home.save_plan'));
        return redirect()->route('clients-files')->with(['planData'=>$planData]);
    }

    //edit file
    public function edit_plan (Sessions $therapist_session)
    {

        $clientSessions = Sessions::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id,['start_time','>=',$therapist_session->start_time]])->get();
        $editTreatmentPlan = TreatmentPlan::where('session_id',$therapist_session->id)->firstOrFail();
        $last_Session = Sessions::latest()->where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->first();

        $data = Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail();
        $avg_rating = \DB::table('reviews')->where('therapist_id', $data->id)->avg('rating');

        return view('therapists.update-plan')->with([
            'data' => Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail(),
            'therapist_session'=>$therapist_session,
            'editTreatmentPlan'=>$editTreatmentPlan,
            'clientSessions'=>$clientSessions,
            'last_Session'=>$last_Session,
            'avg_rating' => $avg_rating
        ]);
    }
    //update plan
    public function update_plan(UpdatePlanRequest $request , TreatmentPlan $editTreatmentPlan)
    {
        $updatedPlan = TreatmentPlan::findOrFail($editTreatmentPlan->id);
        $array=array_merge($request->only(/*'serial_number',*/'age','gender','problem','problem_description',
            'therap_evaluation','long_term','short_term','transfer','current_status','last_visit','homework'
        ),
            ['therapist_id'=>$editTreatmentPlan->therapist_id,'visitor_id'=>$editTreatmentPlan->visitor_id,'agreement_client'=>"0"
                ,
                'client_name_pdf'=>($request->client_name_pdf?1:0) ,
                'age_pdf'=>($request->age_pdf?1:0) ,
                'gender_pdf'=>($request->gender_pdf?1:0) ,
                'problem_pdf'=>($request->problem_pdf?1:0) ,
                'therap_evaluation_pdf'=>($request->therap_evaluation_pdf?1:0) ,
                'diagnostic_pdf'=>($request->diagnostic_pdf?1:0) ,
                'therapeutic_intervention_pdf'=>($request->therapeutic_intervention_pdf?1:0) ,
                'problem_description_pdf'=>($request->problem_description_pdf?1:0) ,
                'homework_pdf'=>($request->homework_pdf?1:0) ,
                'table_pdf'=>($request->table_pdf?1:0) ,
                'long_term_pdf'=>($request->long_term_pdf?1:0) ,
                'short_term_pdf'=>($request->short_term_pdf?1:0) ,
                'transfer_pdf'=>($request->transfer_pdf?1:0) ,
                'current_status_pdf'=>($request->current_status_pdf?1:0) ,
                'last_visit_pdf'=>($request->last_visit_pdf?1:0) ,
                'therapist_name_pdf'=>($request->therapist_name_pdf?1:0)
            ]);
        foreach ($array as $key=>$value){
            $updatedPlan->$key=$value;
        }
        $updatedPlan->save();
        //$updatedPlan->update($array);
        //dd($updatedPlan);
        $diagIds=[];

        if($request->diagnostic){
        foreach ($request->diagnostic as $diag){
            $treatmentPlanDiagnosis=TreatmentPlansDiagnosis::where('treatment_plan_id')->where('diagnosis_id',$diag)->first();
            if(!$treatmentPlanDiagnosis){
                $treatmentPlanDiagnosis=new TreatmentPlansDiagnosis();
                $treatmentPlanDiagnosis->treatment_plan_id=$updatedPlan->id;
                $treatmentPlanDiagnosis->diagnosis_id=$diag;
                $treatmentPlanDiagnosis->save();
            }
            $diagIds[]=$treatmentPlanDiagnosis->id;
        }
        TreatmentPlansDiagnosis::whereNotIn('id',$diagIds)->where('treatment_plan_id',$updatedPlan->id)->delete();
        }



        $treatIds=[];
        if($request->therapeutic_intervention)
        {
            
        
        foreach ($request->therapeutic_intervention as $treat){
            $treatmentPlanTreat=TreatmentPlansTreatments::where('treatment_plan_id')->where('treatments_id',$treat)->first();
            if(!$treatmentPlanTreat){
                $treatmentPlanTreat=new TreatmentPlansTreatments();
                $treatmentPlanTreat->treatment_plan_id=$updatedPlan->id;
                $treatmentPlanTreat->treatments_id=$treat;
                $treatmentPlanTreat->save();
            }
            $treatIds[]=$treatmentPlanTreat->id;
        }
        TreatmentPlansTreatments::whereNotIn('id',$treatIds)->where('treatment_plan_id',$updatedPlan->id)->delete();

        }
        Session::flash('status',trans('home.update_plan'));
        return redirect()->route('clients-files')->with(['updatedPlan'=>$updatedPlan]);;
    }
    //view_plan
    public function view_plan (Sessions $therapist_session)
    {
        $planData = TreatmentPlan::where('session_id',$therapist_session->id)->first();
        $sessionsAttend = Sessions::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id,['start_time','>=',$therapist_session->start_time]])->get();
        if(is_null($planData))
        {
            Session::flash('status',trans('home.not-plan'));
            return redirect()->route('clients-files');
        }

        $therapist = Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail();

        $avg_rating = \DB::table('reviews')->where('therapist_id', $therapist->id)->avg('rating');
        return view('therapists.display-plan')->with([
            'data' => Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail(),
            'visitor'=>\App\Visitor::findOrFail($planData->visitor_id),
            'planData'=>$planData,
            'sessionsAttend'=>$sessionsAttend,
            'avg_rating' => $avg_rating
        ]);
    }
    //save_attend
    public function save_attend (Request $request)
    {
        $sessionInfo = Sessions::findOrFail($request->id);
        $sessionInfo->attend = $request->attend;
        $sessionInfo->save();
        return response()->json('attend save successfully');
    }

    //update_attend
    public function update_attend (Request $request)
    {
        $sessionInfo = Sessions::findOrFail($request->id);
        $sessionInfo->attend = $request->attend;
        $sessionInfo->save();
        return response()->json('attend save successfully');
    }

    //therapist_secret_notice
    public function therapist_secret_notice(Request $request)
    {
        $session=Sessions::findOrFail($request->id);
        $therapistInfo = Therapist::findOrFail($session->therapist_id);
        $therapistInfo->agreement_therapist_secret_notice = $request->value;
        $therapistInfo->save();
        $type=(auth()->user()->type=='therapists')?'therapist':'visitor';
        if(!hasAgreement($session->visitor_id,$session->therapist_id,$type)){
            ConfidentialityNoticeAgrements::create([
                'session_id'=>$session->id,
                'visitor_id'=>$session->visitor_id,
                'therapist_id'=>$session->therapist_id,
                $type.'_agree_date'=>DB::raw('now()'),
            ]);
        }
        return response()->json('therapist agreement save successfully');
    }
    public function allowChat($id){
        $treatInfo = TreatmentPlan::where('session_id',$id)->first();
        if($treatInfo&&$treatInfo->allow_chat==0){
            $treatInfo->allow_chat_date=date('Y-m-d H:i:s');
            $treatInfo->allow_chat=1;
            $treatInfo->save();
            return redirect()->back();
        }
        return abort(404);
    }
    public function disAllowChat($id){
        $treatInfo = TreatmentPlan::where('session_id',$id)->first();
        if($treatInfo&&$treatInfo->allow_chat==1){
            $treatInfo->disallow_chat_date=date('Y-m-d H:i:s');
            $treatInfo->allow_chat=0;
            $treatInfo->save();
            return redirect()->back();
        }
        return abort(404);
    }
    //clientMessages
    public function clientMessages ($id)
    { 
        $treatInfo = TreatmentPlan::where('session_id',$id)->first();
         $client_session = Sessions::whereId($id)->first();
        $treatInfo->messages_count = 0;
        $treatInfo->save();
        $allMessages = Message::where('session_id',$id)->take(3)->latest()->get();
        $data=Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail();
        $avg_rating = \DB::table('reviews')->where('therapist_id', $data->id)->avg('rating');


        return view('therapists.inbox-messages',['allMessages'=>$allMessages,'data' =>$data,'treatInfo'=>$treatInfo ,'avg_rating' => $avg_rating, 'client_session' =>$client_session]);
    }
    public function addMessage($id,Request $request){
        $session=Sessions::find($id);
        if($session){
            if($request->type == 'therapist')
            {
                $therapist=Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail();
            }
            else
            {
                $therapist=Visitor::where('user_id', auth()->user()->id)->firstOrFail();
            }
            
            $treatInfo = TreatmentPlan::where('session_id',$id)->first();
            $message=Message::where('session_id',$id)->find($request->message_id);
            if($message){
                if($message->answer){
                    return response()->json(['success'=>false,'message'=>'<div class="alert alert-danger">تم اضافة الاجابة من قبل</div>']);
                }
                $message->answer=$request->answer;
                $message->save();
                


            if($request->type == 'therapist')
            {
                $visitor = Visitor::find($treatInfo->visitor_id);
                $therapist = Therapist::find($treatInfo->therapist_id);
                $doctor = User::find($therapist->user_id);
                $tokens = \DB::table('firebase_tokens')->where('user_id', $visitor->user_id)->pluck('platform_token');


                $userLang = User::find($visitor->user_id);
                if($userLang->lang == 'ar')
                {
                    $body = 'المعالج   '.$doctor->name.' رد علي رسالتك  ';
                    $this->sendWebNotification('رسالة جديده...', $body, $id, $tokens, 'message');
                }
                else
                {
                    $body = 'Doctor '.$therapist->name_e.' Has Answered For Your Message';
                    $this->sendWebNotification('New Message...', $body, $id, $tokens, 'message');
                }



                //saveNotifyIntoDatabase
                $saveBody = '<h3>Doctor <span>'.$doctor->name.'</span> Has Answered For Your Message</h3>';
                $saveBody_ar = '<h3>المعالج  <span>'.$doctor->name.'</span> رد علي رسالتك</h3>';
            $this->saveNotifyIntoDatabase($saveBody, $therapist->id, $visitor->id,$saveBody_ar, $doctor->name, $id, 'message');

                $user=User::find($session->visitor->user_id);
                $goType = 'patient';
                $html=view('email.send_inbox_answer',compact('session','message','user','therapist','goType'))->render();
                $send=sendGridEmailToUser($html,$user->email,$user->name,'Doctor '.$therapist->name_e.' Has Answer For Your Message');
                return response()->json(['success'=>true,'message'=>'<div class="alert alert-success">تم اضافة الاجابة بنجاح</div>','send'=>$send]);

            }
            else
            {
                $therapist = Therapist::find($treatInfo->therapist_id);
                $visitor = Visitor::find($treatInfo->visitor_id);
                $patient = User::find($visitor->user_id);
                $tokens = \DB::table('firebase_tokens')->where('user_id', $therapist->user_id)->pluck('platform_token');

                $userLang = User::find($therapist->user_id);
                if($userLang->lang == 'ar')
                {
                    $body = 'العميل   '.$patient->name.' رد علي رسالتك  ';
                    $this->sendWebNotification('رسالة جديده...', $body, $id,$tokens, 'message');
                }
                else
                {
                    $body = 'Patient '.$patient->name.' Has Answered For Your Message';
                    $this->sendWebNotification('New Message...', $body, $id,$tokens, 'message');
                }

                
                //saveNotifyIntoDatabase
                $saveBody = '<h3>Patient <span>'.$patient->name.'</span> Has Answered For Your Message</h3>';
                $saveBody_ar = '<h3>العميل   <span>'.$patient->name.'</span> رد علي رسالتك</h3>';
                $this->saveNotifyIntoDatabase($saveBody, $visitor->id,$therapist->id,$saveBody_ar, $patient->name, $id, 'message');

                $goType = 'therapist';
                $user=User::find($session->therapist->user_id);
                $patient = User::find($therapist->user_id);
                $html=view('email.send_inbox_answer',compact('session','message','user','therapist', 'goType'))->render();
                $send=sendGridEmailToUser($html,$user->email,$user->name,'Patient '.$patient->name.' Has Answer For Your Message');
                return response()->json(['success'=>true,'message'=>'<div class="alert alert-success">تم اضافة الاجابة بنجاح</div>','send'=>$send]);
            }
        }
        }

    }


    public function saveNotifyIntoDatabase($body,$sender_id,$reciever_id, $body_ar,$sender_name,$session_id,$type)
    {
        $data = [
            'body' =>$body,
            'body_ar' =>$body_ar,
            'sender_id' =>$sender_id,
            'reciever_id' =>$reciever_id,
            'sender_name' =>$sender_name,
            'session_id' =>$session_id,
            'type' =>$type,
            'created_at' =>date('Y-m-d H:i:s'),
            'updated_at' =>date('Y-m-d H:i:s'),
        ];
        \DB::table('notifications')->insert($data);
    }




    public function sendWebNotification($title,$msg_body, $session_id,$tokens=[], $type)
    {
        $data = '{"notification":{"title":"' . $title . '", "body": "' . $msg_body . '"' . ', "click_action": "FCM_PLUGIN_ACTIVITY"' . '}';
            $data .= ',"data":{"title":"' . $title . '", "body": "' . $msg_body . '","session_id":"' . $session_id . '", "type":"' . $type . '",}';
            $data .= ',"registration_ids":' . $tokens;
            $data .= '}';
            $curl = curl_init();

            $firebase_key = 'key=AAAAVE8vuIo:APA91bFhV7w4-wnqg-MKQttUTLT9Cy-aEZ8gJMPU-fCI1JaBSuvFXXK0yN-FzJuanb1PnHI-4lqpTi9iYVNrHTLdaPCCbG3oTudaJ0jIDBMO2L8FiPDlndbop0fJY2jItJmQYKTcs3it';

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://fcm.googleapis.com/fcm/send',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS =>$data,
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Authorization: ' . $firebase_key
                ),
            ));
            $response = curl_exec($curl);
            curl_close($curl);
    }












    //public sessions
    public function getSessionsPublic($id)
    {
        $allSessions = Sessions::getSessionsForClients($id);
        return response()->json($allSessions, 200);
    }


    public function sessionStart($session_id){

        $session=Sessions::where('session_status','reserved')->find($session_id);
        if($session){
             $user=auth()->user();
             if($user->type=='therapist'){
                $session->therapist_start=1;
                $session->therapist_start_date=date('Y-m-d H:i:s');
           }else{
                $session->visitor_start_date=date('Y-m-d H:i:s');
           }
           $session->save();
           return response()->json(['success'=>true]);
        }
        return response()->json(['success'=>false]);
    }


    public function sessionEnd($session_id){
        if(!auth()->check()){
            return abort(404);
        }
        $session=Sessions::where('session_status','reserved')->find($session_id);
        if($session){
            $user=auth()->user();
            if($user->type=='therapists'){
                $session->therapist_end_date=date('Y-m-d H:i:s');
            }else{
                $session->visitor_end_date=date('Y-m-d H:i:s');
           }
           $session->save();
           if($session->therapist_end_date || $session->visitor_end_date){
                $session->session_status='closed';
                $session->closed_date=date('Y-m-d H:i:s');
                $session->save();
            }
            return response()->json(['success'=>true]);
        }
        return response()->json(['success'=>false]);
    }



    public function sessionEndForMobile($type,$session_id){

        $session=Sessions::where('session_status','reserved')->find($session_id);
        if($session){
             if($type=='therapist'){
                $session->therapist_end_date=date('Y-m-d H:i:s');
           }else{
                $session->visitor_end_date=date('Y-m-d H:i:s');
           }
           $session->save();
           if($session->therapist_end_date || $session->visitor_end_date){
                $session->session_status='closed';
                $session->closed_date=date('Y-m-d H:i:s');
                $session->save();
            }
            return response()->json(['success'=>true]);
        }
        return response()->json(['success'=>false]);
    }


    

    public function sessionStartForMobile($type , $session_id){

        $session=Sessions::where('session_status','reserved')->find($session_id);
        if($session){
             if($type=='therapist'){
                $session->therapist_start=1;
                $session->therapist_start_date=date('Y-m-d H:i:s');
           }else{
                $session->visitor_start_date=date('Y-m-d H:i:s');
           }
           $session->save();
           return response()->json(['success'=>true]);
        }
        return response()->json(['success'=>false]);
    }








    public function sessionPageForMobile($session_id,$type)
    {
        $session = Sessions::whereNotNull('visitor_id')->find($session_id);

        if($session->session_status!='reserved'){
            return redirect()->to('/');
        }
        if($session->meeting_provider=='whereby'&&$session->visitor_start_date==NULL){
            $session->visitor_start_date=date('Y-m-d H:i:s');
            $session->save();
        }
        addInvoice($session);
        $visitor = '';
        //return view('auth.session',['data'=>$visitor,'session'=>$session,'type'=>'visitor']);
        return view('therapists.session',['data'=>$visitor,'session'=>$session,'type'=>'visitor']);

       // return view('auth.sessionVideo', compact('session','type'));
    }



}
