<?php

namespace App\Http\Controllers;

use App\Sliders;
use App\User;
use App\Visitor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Laravel\Socialite\Facades\Socialite;

class SocialLoginController extends Controller
{
    private $allowedSocial=['facebook','google'];
   public function login($social,Request $request){
       if(in_array($social,$this->allowedSocial)){
           return Socialite::driver($social)->redirect();
           dd($request->input());
       }
       return abort(404);
   }
   public function callback($social,Request $request){
       if(in_array($social,$this->allowedSocial)){
           try {
               $socialUser=Socialite::driver($social)->user();
               $user=User::where('email',$socialUser->getEmail())->first();
               if(!$user){
                   $user=new User();
                   $user->type='visitors';
                   $user->active=1;
                   $user->name=$socialUser->getName();
                   $user->email=$socialUser->getEmail();
                   $user->login_with=$social;
                   $user->password=Hash::make($social.'Password');
                   $user->save();
                   $newVisitor=new Visitor();
                   $newVisitor->user_id=$user->id;
                   $newVisitor->gender='male';
                   $newVisitor->save();
               }
               if($user->type=='visitors'&&$user->active==0){
                   $user->active=1;
                   $user->save();
                   Visitor::where('user_id',$user->id)->update(['active'=>1]);
               }
               Auth::login($user);
              return redirect()->to('/');
           }catch (\Exception $exception){
               //dd($exception);
               return redirect()->to('login/'.$social);
           }
       }
       return abort(404);
   }
}
