<?php

namespace App\Http\Controllers;

use App\Countries;
use App\MainFocus;
use App\Reviews;
use App\SessionsQuestionAnswer;
use App\TherapistsInvoices;
use App\TherapistsMainFocus;
use App\TherapistsQuestions;
use App\TreatmentPlan;
use App\Visitor;
use App\Coupons;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Therapist;
use App\Specialties;
use App\Languages;
use App\Sessions;

use App\Mail\VerifyEmail as MailVerifyEmail;
use App\Therapists_languages;
use App\TherapistsPictures;
use App\TherapistsSpecialties;
use App\User;
use App\TherapistsRequests;
use Illuminate\Auth\Notifications\VerifyEmail;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Jenssegers\Date\Date;
use App\Http\Requests\StoreTherapistReg;
use Yajra\DataTables\Facades\DataTables;
use ZipArchive;
use Stevebauman\Location\Facades\Location;
use Intervention\Image\Facades\Image;

class TherapistController extends Controller
{

    function  __construct(Request $request)
    {

         $ipaddress = '';
            if (isset($_SERVER['HTTP_CLIENT_IP'])) {
                $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
            } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED'];
            } else if (isset($_SERVER['REMOTE_ADDR'])) {
                $ipaddress = $_SERVER['REMOTE_ADDR'];
            } else {
                $ipaddress = 'UNKNOWN';
            }

        $location = Location::get($ipaddress);
        View::share('location', $location);
    }

    // all therapist .. index method
    public function index()
    {
        $data = Therapist::active();

        if (!empty(request('property_id'))) {
            $data->whereHas('specialties', function ($q) {

                if (request('property_id') == 25) {
                    $q->whereIn('speciality_id', [25, 31, 32, 33, 1, 34]);
                } else {
                    $q->where('speciality_id', request('property_id'));
                }
            });
        }
 
        $data = $data->orderBy('id', 'asc')->paginate(100);


        return view('therapists.therapists', [
            'specialties' => Specialties::where([['parent_id', 0], ['active', 1]])->orderBy('sort', 'ASC')->get(),
            'languages' => Languages::where([['active', 1]])->get(),
            'data' => $data,
        ]);
    }

    //therapistslistInOrder
    public function therapistslistInOrder()
    {
        $therapists = Therapist::where('active', '1')->inRandomOrder()->limit(4)->get();
        return view('therapists.randomTherapists', compact('therapists'));
    }


    public function therapistSessions(Request $request)
    {
        $userData = User::findOrFail(auth()->user()->id);
        if($userData->type=='visitors'){
            return abort(404);
        }
        $therapist = Therapist::where([['user_id', auth()->user()->id]])->first();
        $userData->therapist = $therapist;
//        if($therapist->agreement_privacy_charter==0){
//            return redirect()->to(route('therapist_privacy_charter'));
//        }
        if ($therapist && $therapist->active == 1) {
            $todayDate = Carbon::now()->format('Y-m-d');
            $todayDateTime = Carbon::now()->format('Y-m-d H:i:s');

            if ($request->ajax()) {
                if($request->getSessionsClientAnswer){
                    $session=Sessions::find($request->session_id);
                    if($session){
                        $sessionQuestions=SessionsQuestionAnswer::where('session_id',$session->id)->get();

                        if(count($sessionQuestions)){
                            $html=view('therapists.include.session_question_answer',compact('session','sessionQuestions'))->render();
                        }else{
                            $visitor=$session->visitor;
                            $planData=TreatmentPlan::where('therapist_id',$session->therapist_id)->where('visitor_id',$visitor->id)->orderBy('id')->first();
                            $sessionsAttend = Sessions::where(['therapist_id'=>$session->therapist_id,'visitor_id'=>$session->visitor_id,['start_time','>=',$session->start_time]])->get();
                            $isAjax=true;
                            $html=view('therapists.include.client_plan_profile',compact('visitor','planData','sessionsAttend','isAjax'))->render();
                        }

                        return response()->json(['success'=>true,'html'=>$html]);
                    }
                    return response()->json(['success'=>false,]);
                }
                if($request->getSessions){

                    //OR DATE_FORMAT(start_time,'Y-m-d')=DATE_FORMAT(NOW(),'Y-m-d')
                    $nextSessions = Sessions::where('therapist_id', $therapist->id)->whereRaw("(NOW()BETWEEN start_time AND DATE_ADD(start_time,INTERVAL `type` MINUTE) OR start_time>NOW())")
                        ->orderBy('start_time')
                        ->where('therapist_id', $therapist->id)
                        ->whereNotNull('visitor_id');

                    if($request->status){
                        $nextSessions=$nextSessions->where('session_status',$request->status);
                    }else{
                        $nextSessions=$nextSessions->whereIn('session_status',['reserved','cancelled','visitor_cancelled']);
                    }
                    $sql=getEloquentSqlWithBindings($nextSessions);
                    $nextSessions=$nextSessions->paginate(20);
                    $html=view('therapists.include.session_filter_blocks',compact('nextSessions'))->render();
                    return response()->json(['success'=>true,'html'=>$html,'paginate'=>$nextSessions->links()->render(),'currentTime'=>$todayDateTime,'$sql'=>$sql]);
                }
                if($request->getAllSessions){
                    $allSessions = Sessions::select('sessions.*','users.name AS user_name')->leftJoin('visitors','visitors.id','=','sessions.visitor_id')->leftJoin('users','users.id','=','visitors.user_id')->where('therapist_id', $therapist->id)->where('session_status','!=','available');
                    if($request->status){
                        $allSessions=$allSessions->where('session_status',$request->status);
                    }
                    return DataTables::of($allSessions)
                        ->addIndexColumn()
                        ->editColumn('start_time',function ($session){
                            return $session->start_time->format('Y-m-d h:i a');
                        })
                        ->addColumn('checkbox', function($sessionInfo){
                            return($sessionInfo->visitor_id == null)?'<div class="checkbox-nice checkbox-inline"><input data-id="'.$sessionInfo->id.'" class="sessionCheckbox" value="'.$sessionInfo->id.'" type="checkbox" class="sub_chk"></div>':'';
                        })
                        ->addColumn('action', function ($sessions) {
                            $return='';
                            if($sessions->visitor_id == null){
                                $return.='<button class="btn btn-danger delete-session ml-1" data-id="'.$sessions->id.'" ><i class="fa fa-trash-o"></i></button>';
                            }
                            if(in_array($sessions->session_status,['available','reserved'])){
                                $return.='<button class="btn btn-danger cancelBtn ml-1" data-type="table" data-id="'.$sessions->id.'">'.trans('home.Cancel').'</button>';
                            }
                            return $return;

                        })
                        ->rawColumns(['checkbox','action'])
                        ->make(true);
                }
                if($request->getAvailableSessions){
                    $allSessions = Sessions::select('sessions.*','users.name AS user_name')->leftJoin('visitors','visitors.id','=','sessions.visitor_id')->leftJoin('users','users.id','=','visitors.user_id')->where('therapist_id', $therapist->id)->where('session_status','available');
                    if($request->status){
                        $allSessions=$allSessions->where('session_status',$request->status);
                    }
                    return DataTables::of($allSessions)
                        ->addIndexColumn()
                        ->editColumn('start_time',function ($session){
                            return $session->start_time->format('Y-m-d h:i a');
                        })
                        ->addColumn('checkbox', function($sessionInfo){
                            return($sessionInfo->visitor_id == null)?'<div class="checkbox-nice checkbox-inline"><input data-id="'.$sessionInfo->id.'" class="sessionCheckbox" value="'.$sessionInfo->id.'" type="checkbox" class="sub_chk"></div>':'';
                        })
                        ->addColumn('action', function ($sessions) {
                            $return='';
                            if($sessions->visitor_id == null){
                                $return.='<button class="btn btn-danger delete-session ml-1" data-id="'.$sessions->id.'" ><i class="fa fa-trash-o"></i></button>';
                            }
                            if(in_array($sessions->session_status,['available','reserved'])){
                                $return.='<button class="btn btn-danger cancelBtn ml-1" data-type="table" data-id="'.$sessions->id.'">'.trans('home.Cancel').'</button>';
                            }
                            return $return;

                        })
                        ->rawColumns(['checkbox','action'])
                        ->make(true);
                }
                if($request->getPrevSessions){
                    $previousSessions = Sessions::select('sessions.*','users.name AS user_name')->leftJoin('visitors','visitors.id','=','sessions.visitor_id')->leftJoin('users','users.id','=','visitors.user_id')->where('therapist_id', $therapist->id)->whereRaw("(start_time<NOW() OR status='cancelled')")->where('session_status','!=','available');//->whereNotNull('visitor_id')->with('visitor')->get();
                    if($request->status){
                        $previousSessions=$previousSessions->where('session_status',$request->status);
                    }
                    return DataTables::of($previousSessions)
                        ->addIndexColumn()
                        ->editColumn('start_time',function ($session){
                            return $session->start_time->format('Y-m-d h:i a');
                        })
                        ->addColumn('checkbox', function($sessionInfo){
                            return($sessionInfo->visitor_id == null)?'<div class="checkbox-nice checkbox-inline"><input data-id="'.$sessionInfo->id.'" class="sessionCheckbox" value="'.$sessionInfo->id.'" type="checkbox" class="sub_chk"></div>':'';
                        })
                        ->addColumn('action', function ($sessions) {
                            $return='';
                            if($sessions->visitor_id == null){
                                $return.='<button class="btn btn-danger delete-session ml-1" data-id="'.$sessions->id.'" ><i class="fa fa-trash-o"></i></button>';
                            }
                            if($sessions->session_status=='available'){
                                $return.='<button class="btn btn-danger cancelBtn ml-1" data-type="table" data-id="'.$sessions->id.'">'.trans('home.Cancel').'</button>';
                            }
                            return $return;

                        })
                        ->rawColumns(['checkbox','action'])
                        ->make(true);
                }
                $date = Carbon::now()->toDateString();
                $calenderSessions = Sessions::where([['therapist_id', $therapist->id]])->get();

                $sessionCalender = [];
                foreach ($calenderSessions as $sessionData) {
                    $sessionCalender[] = [
                        'start' => $sessionData->start_time,
                        'date' => date('Y-m-d', strtotime($sessionData->start_time)),
                        'color' => ($sessionData->visitor_id) ? '#3da8c0' : '#666669',
                        'class' => ($sessionData->visitor_id) ? 'session-reserved' : 'session-available',
                    ];
                }
                return response()->json($sessionCalender);
            }

            $avg_rating = \DB::table('reviews')->where('therapist_id', $therapist->id)->avg('rating');
            // dd($previousSessions);

            //  dd($previousSessions);
            //dd($nextSessions);
            //$nextSessions=$nextSessions->get();
            return view('therapists.home', ['data' => $therapist, 'avg_rating' =>$avg_rating]);
        }

        return view('therapists.data-revision', compact('userData'));
    }
    public function deleteSessions(Request $request){
        $userData = User::findOrFail(auth()->user()->id);
        $therapist = Therapist::where([['user_id', auth()->user()->id]])->first();
        $userData->therapist = $therapist;
        if ($therapist && $therapist->active == 1) {
           if($request->ids){
               Sessions::whereIn('id',$request->ids)->where('therapist_id',$therapist->id)->delete();
               return response()->json(['success'=>true]);
           }elseif($request->id){
               $session=Sessions::where('therapist_id',$therapist->id)->find($request->id);//->delete();
               if($session){
                   $session->delete();
                   return response()->json(['success'=>true]);
               }

           }
        }
        return response()->json(['success'=>false]);
    }
    public function cancelSessions(Request $request){
        $userData = User::findOrFail(auth()->user()->id);
        $therapist = Therapist::where([['user_id', auth()->user()->id]])->first();
        $userData->therapist = $therapist;
        if ($therapist && $therapist->active == 1) {
            if($request->ids){
                if(Sessions::whereIn('id',$request->ids)->where('therapist_id',$therapist->id)->where('session_status','reserved')->whereBetween('start_time',[date('Y-m-d H:i:s'),date('Y-m-d H:i:s',strtotime('- 8 hours'))])->count()){
                    return response()->json(['success'=>false,'message'=>trans('home.The session may not be canceled 8 hours before the scheduled time')]);
                }
                if(Sessions::whereIn('id',$request->ids)->where('start_time','<=',date('Y-m-d H:i:s'))->count()){
                    return response()->json(['success'=>false,'message'=>trans('home.The session date is gone')]);
                }
                Sessions::whereIn('id',$request->ids)->where('therapist_id',$therapist->id)->update([
                    'status'=>3,
                    'session_status'=>'cancelled',
                    'cancelled_reason'=>$request->cancel_reason,
                    'cancelled_date'=>date('Y-m-d H:i:s'),
                ]);
                TherapistsInvoices::whereIn('session_id',$request->ids)->where('therapist_id',$therapist->id)->delete();
                sendCanceledEmail(Sessions::whereIn('id',$request->ids)->where('therapist_id',$therapist->id)->get(),'visitor');
                return response()->json(['success'=>true]);
            }elseif($request->id){
                if(Sessions::where('id',$request->id)->where('therapist_id',$therapist->id)->where('session_status','reserved')->whereBetween('start_time',[date('Y-m-d H:i:s'),date('Y-m-d H:i:s',strtotime('- 8 hours'))])->count()){
                    return response()->json(['success'=>false,'message'=>trans('home.The session may not be canceled 8 hours before the scheduled time')]);
                }
                $session=Sessions::where('therapist_id',$therapist->id)->find($request->id);//->delete();
                if($session){
                    /*if($session->start_time<=date('Y-m-d H:i:s')){
                        return response()->json(['success'=>false,'message'=>trans('home.The session date is gone')]);
                    }*/
                    $session->status=3;
                    $session->session_status='cancelled';
                    $session->cancelled_date=date('Y-m-d H:i:s');
                    $session->cancelled_reason=$request->cancel_reason;
                    $session->save();
                    TherapistsInvoices::where('session_id',$request->id)->where('therapist_id',$therapist->id)->delete();
                    if($session->visitor){
                        if ($userData) {
                           sendCanceledEmail([$session], $userData->name,'visitor');
                        }
                        else
                        {
                            sendCanceledEmail([$session],'visitor');
                        }
                        
                    }
                    return response()->json(['success'=>true]);
                }

            }
        }
        return response()->json(['success'=>false]);
    }

    public function therapistClients()
    {
        $userData = User::findOrFail(auth()->user()->id);
        $therapistInfo = Therapist::where('user_id', auth()->user()->id)->first();
//        if($therapistInfo->agreement_privacy_charter==0){
//            return redirect()->to(route('therapist_privacy_charter'));
//        }
         $avg_rating = \DB::table('reviews')->where('therapist_id', $therapistInfo->id)->avg('rating');

        if ($therapistInfo->active == 1) {
            $sessionsData = Sessions::with('therapist')->where([['therapist_id', '=', $therapistInfo->id], ['visitor_id', '!=', null]])->get();
            $ClientInfo = Therapist::getClientData($sessionsData);
            return view('therapists.clients', [
                'data' => Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail(),
                'ClientInfo' => $ClientInfo,
                'therapistID' => $therapistInfo->id,
                'avg_rating' => $avg_rating,
            ]);
        }
        return view('therapists.data-revision', compact('userData'));
    }

    public function therapistInvoice(Request $request)
    {
        $userData = User::findOrFail(auth()->user()->id);
        $therapistInfo = Therapist::where('user_id', auth()->user()->id)->firstOrFail();
//        if($therapistInfo->agreement_privacy_charter==0){
//            return redirect()->to(route('therapist_privacy_charter'));
//        }
        if ($therapistInfo->active == 1) {
            $sessionsData = TherapistsInvoices::whereHas('sessionInvoice', function($q){
                    $q->where('therapist_start_date', '!=', null)->where('start_time', '<=',date('Y-m-d H:i:s'));
                })->where('therapist_id', '=', $therapistInfo->id);

            $totalSessionPound = TherapistsInvoices::whereHas('sessionInvoice', function($q){
                    $q->where('therapist_start_date', '!=', null)->where('start_time', '<=',date('Y-m-d H:i:s'));
                })->where('therapist_id', '=', $therapistInfo->id);

            $totalSessionDollar = TherapistsInvoices::whereHas('sessionInvoice', function($q){
                    $q->where('therapist_start_date', '!=', null)->where('start_time', '<=',date('Y-m-d H:i:s'));
                })->where('therapist_id', '=', $therapistInfo->id);

            if ($request->from_date && $request->to_date) {
                if($request->from_date==$request->to_date){
                    $sessionsData=$sessionsData->whereHas('sessionInvoice', function($q) use($request){
                        $q->where('start_time', $request->from_date);
                    });
                    $totalSessionPound=$totalSessionPound->whereHas('sessionInvoice', function($q) use($request){
                        $q->where('start_time', $request->from_date);
                    });
                    $totalSessionDollar=$totalSessionDollar->whereHas('sessionInvoice', function($q) use($request){
                        $q->where('start_time', $request->from_date);
                    });
                }else{
                    

                    $sessionsData=$sessionsData->whereHas('sessionInvoice', function($q) use($request){
                        $q->whereBetween('start_time', [$request->from_date, \Carbon\Carbon::parse($request->to_date)->addDays(1)]);
                    });
                   

                    $totalSessionPound=$totalSessionPound->whereHas('sessionInvoice', function($q) use($request){
                        $q->whereBetween('start_time', [$request->from_date, \Carbon\Carbon::parse($request->to_date)->addDays(1)]);
                    });
                   

                    $totalSessionDollar=$totalSessionDollar->whereHas('sessionInvoice', function($q) use($request){
                        $q->whereBetween('start_time', [$request->from_date, \Carbon\Carbon::parse($request->to_date)->addDays(1)]);
                    });
                }

            }
            if ($request->q) {
                $search = $request->q;
                $sessionsData = $sessionsData->where(function ($q) use ($search) {
                    $q->where('visitor_name', 'LIKE', "%$search%")
                        //                    ->orWhere('sessions.type','LIKE',"%$search%")
                        //                    ->orWhere('sessions.start_time','LIKE',"%$search%")
                    ;
                });
                $totalSessionPound = $totalSessionPound->where(function ($q) use ($search) {
                    $q->where('visitor_name', 'LIKE', "%$search%")
                        //                    ->orWhere('sessions.type','LIKE',"%$search%")
                        //                    ->orWhere('sessions.start_time','LIKE',"%$search%")
                    ;
                });
                $totalSessionDollar = $totalSessionDollar->where(function ($q) use ($search) {
                    $q->where('visitor_name', 'LIKE', "%$search%")
                        //                    ->orWhere('sessions.type','LIKE',"%$search%")
                        //                    ->orWhere('sessions.start_time','LIKE',"%$search%")
                    ;
                });
            }
            $totalSessionPound = $totalSessionPound->where('currency','EGP')->sum('therapist_amount');
            $totalSessionDollar = $totalSessionDollar->where('currency','USD')->sum('therapist_amount');

            if ($request->ajax()) {
                if ($request->returnSum) {

                    return response()->json(['pound' => $totalSessionPound, 'dollar' => $totalSessionDollar]);
                }
                if(isset($request->search['value'])){
                    $search=$request->search['value'];
                    $sessionsData = $sessionsData->where(function ($q) use ($search) {
                        $q->where('visitor_name', 'LIKE', "%$search%")
                            //                    ->orWhere('sessions.type','LIKE',"%$search%")
                            //                    ->orWhere('sessions.start_time','LIKE',"%$search%")
                        ;
                    });
                }
                return DataTables::of($sessionsData) 
                    ->addIndexColumn()
                    ->editColumn('session_date', function ($invoice) {
                        $session = Sessions::find($invoice->session_id);
                        return date('Y-m-d H:i:s', strtotime($session->start_time));
                    })
                    ->editColumn('total_after_discount', function ($invoice) {
                        return number_format(floor($invoice->total_after_discount*100)/100, 2) .' '.$invoice->currency;
                    })->editColumn('therapist_amount', function ($invoice) {
                        return number_format(floor($invoice->therapist_amount*100)/100, 2) .' '.$invoice->currency;
                    })->editColumn('discount_amount', function ($invoice) {
                        return $invoice->discount_amount?number_format(floor($invoice->discount_amount*100)/100, 2) .' '.$invoice->currency:'';
                    })->editColumn('discount_percentage', function ($invoice) {
                        return ($invoice->discount_percentage)?$invoice->discount_percentage.'%':'';
                    })
                    ->rawColumns([])
                    ->make(true);
            }
            $date = date('Y-m-d');
            $totalSessionThisMonth = TherapistsInvoices::whereHas('sessionInvoice', function($q){
                    $q->where('therapist_start_date', '!=', null)->where('start_time', '<=',date('Y-m-d H:i:s'));
                })
            // ->whereRaw("DATE_FORMAT(session_date,'%Y-%m-%d')='$date'")

                ->where('therapist_id', '=', $therapistInfo->id)
                // ->where('session_date', '<=',date('Y-m-d H:i:s'))
                ->where('currency','EGP')->sum('therapist_amount');
            $totalSessionThisMonthDollar = TherapistsInvoices::whereHas('sessionInvoice', function($q){
                    $q->where('therapist_start_date', '!=', null)->where('start_time', '<=',date('Y-m-d H:i:s'));
                })
            // ->whereRaw("DATE_FORMAT(session_date,'%Y-%m-%d')='$date'")
                ->where('therapist_id', '=', $therapistInfo->id)
                // ->where('session_date', '<=',date('Y-m-d H:i:s'))
                ->where('currency','USD')->sum('therapist_amount');


            //Rating average of therapist
            $avg_rating = \DB::table('reviews')->where('therapist_id', $therapistInfo->id)->avg('rating');

            return view('therapists.invoices', [
                'data' => Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail(),
                'sessionsData' => $sessionsData,
                'totalSessionThisMonth' => $totalSessionThisMonth,
                'totalSessionThisMonthDollar' => $totalSessionThisMonthDollar,
                'totalSessionPound' => $totalSessionPound,
                'totalSessionDollar' => $totalSessionDollar,
                'avg_rating' => $avg_rating
            ]);
        }
        return view('therapists.data-revision', compact('userData'));
    }

    // start session method
    public function startsession($id)
    {
        if(!\auth()->check()){
           return redirect()->to('login');
        }
        $therapist = Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail();
        $session = Sessions::where('therapist_id', $therapist->id)->findOrFail($id);
        if($session->session_status!='reserved'){
            return redirect()->back();
        }
        if($session->meeting_provider=='whereby'&&$session->therapist_start_date==NULL){
            $session->therapist_start_date=date('Y-m-d H:i:s');
            $session->save();
        }
        addInvoice($session);
        return view('therapists.session', ['data' => $therapist, 'session' => $session, 'type' => 'therapist']);
    }
    public function clickSessionLink($id)
    {
        $therapist = Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail();
        $session = Sessions::where('therapist_id', $therapist->id)->findOrFail($id);
        $session->therapist_start = 1;
        $session->therapist_start_date = date('Y-m-d H:i:s');
        $session->save();
        return response()->json(['success' => true]);
    }

    // start session method
    public function view_old(Therapist $therapist)
    {
        $timeTables = DB::select(DB::raw("SELECT *, DATE(start_time) AS 'myDate' FROM `sessions` WHERE therapist_id = $therapist->id AND start_time BETWEEN CURRENT_TIMESTAMP AND DATE_ADD(CURRENT_TIMESTAMP, INTERVAL 9 DAY)  ORDER BY start_time ASC"));
        $noTimes = 0;
        $theapistSessions = Sessions::where('therapist_id', $therapist->id)->get()->chunk(3);
        $languages = Languages::join('therapists_languages', 'therapists_languages.language_id', '=', 'languages.id')
            ->where([['therapists_languages.therapist_id', $therapist->id]])->get();
        return view(
            'therapists.preview',
            [
                'data' => $therapist
                    ->join('countries', 'therapists.country_id', '=', 'countries.id')
                    ->select('therapists.*')  // 'countries.title as country'
                    ->where([['therapists.active', '1'], ['therapists.id', $therapist->id]])->firstOrFail(),
                'languages' =>  $languages,
                'timeTables' => $timeTables,
                'noTimes' => $noTimes,
                'theapistSessions' => $theapistSessions
            ]
        );
    }
    public function view($id)
    {
        $therapist=Therapist::active()->find($id);
        if($therapist&&$therapist->id!=$therapist->url){
            return redirect()->to(route('therapists_preview',$therapist->url));
        }
        $therapist=Therapist::active()->where('url',$id)->firstOrFail();
        $query = "SELECT DATEDIFF(MAX(DATE(start_time)), CURRENT_DATE) AS 'myDate' FROM `sessions` WHERE therapist_id = $therapist->id";
        $numberOfDays = DB::select($query);
        if (count($numberOfDays)) {
            $numberOfDays = ($numberOfDays[0]->myDate > 0) ? $numberOfDays[0]->myDate : 8;
        } else {
            $numberOfDays = 8;
        }
        // $arrayOfDays = [];
        // for ($x = 0; $x <= $numberOfDays; $x++) {
        //     $date = date('Y-m-d', strtotime('+' . $x . ' Day'));
        //     $arrayOfDays[] = Sessions::where('therapist_id', $therapist->id)->whereRaw("DATE(start_time)='$date'")->whereIn('session_status',['available','reserved'])->orderBY('start_time')->get();
        // }
        // $arrayOfDays = array_chunk($arrayOfDays, 3);
        $date = Carbon::now()->format('Y-m-d H:i:m');
        $arrayOfDays = Sessions::where('therapist_id', $therapist->id)->whereIn('session_status',['available','reserved'])->where('start_time', '>=', $date)->orderBY('start_time')->paginate(100);


        $languages = Languages::join('therapists_languages', 'therapists_languages.language_id', '=', 'languages.id')
            ->where([['therapists_languages.therapist_id', $therapist->id]])->where('therapists_languages.language_id', $therapist->language_id)->orderBy('language_id', 'desc')->get();
        //  dd($languages);

        //Rating average of therapist
        $avg_rating = \DB::table('reviews')->where('therapist_id', $therapist->id)->avg('rating');


        return view(
            'therapists.preview',
            [
                'arrayOfDays' => $arrayOfDays,
                'data' => $therapist
                    ->join('countries', 'therapists.country_id', '=', 'countries.id')
                    // ->join('reviews', 'reviews.therapist_id', '=', 'therapists.id')
                    ->select('therapists.*')  // 'countries.title as country'
                    ->where([['therapists.active', '1'], ['therapists.id', $therapist->id]])->firstOrFail(),
                'languages' =>  $languages,
                'avg_rating' =>$avg_rating,
            ]
        );
    }

    //side bar therapist sessions
    public function show_old(Therapist $therapist)
    {
        $timeTables = DB::select(DB::raw("SELECT *, DATE(start_time) AS 'myDate' FROM `sessions` WHERE therapist_id = $therapist->id AND start_time BETWEEN CURRENT_TIMESTAMP AND DATE_ADD(CURRENT_TIMESTAMP, INTERVAL 8 DAY)  ORDER BY start_time ASC"));
        $noTimes = 0;
        $theapistSessions = Sessions::where('therapist_id', $therapist->id)->get()->chunk(3);
        $languages = Languages::join('therapists_languages', 'therapists_languages.language_id', '=', 'languages.id')
            ->where([['therapists_languages.therapist_id', $therapist->id]])->get();

        return view(
            'therapists.therapist',
            [
                'data' => $therapist
                    ->join('countries', 'therapists.country_id', '=', 'countries.id')
                    ->select('therapists.*') //'countries.title as country'
                    ->where([['therapists.active', '1'], ['therapists.id', $therapist->id]])->firstOrFail(),
                'languages' =>  $languages,
                'timeTables' => $timeTables,
                'noTimes' => $noTimes,
                'theapistSessions' => $theapistSessions
            ]
        );
    }
    public function show(Therapist $therapist)
    {
        $query = "SELECT DATEDIFF(MAX(DATE(start_time)), CURRENT_DATE) AS 'myDate' FROM `sessions` WHERE therapist_id = $therapist->id";
        $numberOfDays = DB::select($query);
        if (count($numberOfDays)) {
            $numberOfDays = ($numberOfDays[0]->myDate > 0) ? $numberOfDays[0]->myDate : 8;
        } else {
            $numberOfDays = 8;
        }
        // $arrayOfDays = [];
        // for ($x = 0; $x <= $numberOfDays; $x++) {
        //     $date = date('Y-m-d', strtotime('+' . $x . ' Day'));
        //     $arrayOfDays[] = Sessions::where('therapist_id', $therapist->id)->whereRaw("DATE(start_time)='$date'")->whereIn('session_status',['available','reserved'])->get();
        // }
        // $arrayOfDays = array_chunk($arrayOfDays, 2);
        $date = Carbon::now()->format('Y-m-d H:i:m');
        $arrayOfDays = Sessions::where('therapist_id', $therapist->id)->whereIn('session_status',['available','reserved'])->where('start_time', '>=', $date)->orderBY('start_time')->paginate(100);

        
        $languages = Languages::join('therapists_languages', 'therapists_languages.language_id', '=', 'languages.id')
            ->where([['therapists_languages.therapist_id', $therapist->id]])->get();

        return view(
            'therapists.therapist',
            [
                'arrayOfDays' => $arrayOfDays,
                'data' => $therapist
                    ->join('countries', 'therapists.country_id', '=', 'countries.id')
                    ->select('therapists.*') //'countries.title as country'
                    ->where([['therapists.active', '1'], ['therapists.id', $therapist->id]])->firstOrFail(),
                'languages' =>  $languages,
            ]
        );
    }


    // search (title, summery, description).. method
    public function ajax($type)
    {
        $ipaddress = '';
            if (isset($_SERVER['HTTP_CLIENT_IP'])) {
                $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
            } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED'];
            } else if (isset($_SERVER['REMOTE_ADDR'])) {
                $ipaddress = $_SERVER['REMOTE_ADDR'];
            } else {
                $ipaddress = 'UNKNOWN';
            }

        $location = Location::get($ipaddress);
        $dataquery = Therapist::active();
        if (!empty(request('sort'))) {

            if($location && $location->countryName == 'Egypt')
            {
                if (request('sort') == 'p_low') {
                    $sortfield = 'price30';
                    $sortoption = 'asc';
                } else if (request('sort') == 'p_hight') {
                    $sortfield = 'price30';
                    $sortoption = 'desc';
                } else if (request('sort') == 'r') {
                    $sortfield = 'rating';
                    $sortoption = 'desc';
                } else {
                    $sortfield = 'title';
                    $sortoption = 'asc';
                }
            }
            else
            {
                if (request('sort') == 'p_low') {
                    $sortfield = 'thirty_price_dollar';
                    $sortoption = 'asc';
                } else if (request('sort') == 'p_hight') {
                    $sortfield = 'thirty_price_dollar';
                    $sortoption = 'desc';
                } else if (request('sort') == 'r') {
                    $sortfield = 'rating';
                    $sortoption = 'desc';
                } else {
                    $sortfield = 'title';
                    $sortoption = 'asc';
                }
            }




        } else {
            $sortfield = 'id';
            $sortoption = 'asc';
        }

        if (!empty(request('word'))) {
            $dataquery->where(function ($query) {
                $query->where('title', 'LIKE', "%" . request('word') . "%")
                    ->orWhere('name_a', 'LIKE', "%" . request('word') . "%")
                    ->orWhere('name_e', 'LIKE', "%" . request('word') . "%");
            });
        }
        if (!empty(request('dept'))) {
            $dataquery->whereHas('specialties', function ($q) {

                if (request('dept') == 25) {
                    $q->whereIn('speciality_id', [25, 31, 32, 33, 1, 34]);
                } else {
                    $q->where('speciality_id', request('dept'));
                }
            });
        }
        if (!empty(request('lang'))) {
            $dataquery->whereHas('languages', function ($q) {
                $q->where('language_id', request('lang'));
            });
        }
        if (!empty(request('from_dateee')) && !empty(request('to_dateee'))) {
            $from = \Carbon\Carbon::parse(request('from_dateee'))->format('Y-m-d');
            $to = \Carbon\Carbon::parse(request('to_dateee'))->format('Y-m-d');
            $dataquery->whereHas('sessions', function ($q) use ($from, $to) {
                $q->whereBetween('session_date', [$from, $to])->whereNull('visitor_id');
            });
        }
        if (!empty(request('duration')) && !empty(request('types'))) {
            if (in_array('week', request('duration'))) {
                $from = date("Y-m-d", time());
                $to = date("Y-m-d", time() + (7 * 24 * 60 * 60));
                $dataquery->whereHas('sessions', function ($q) use ($from, $to) {
                    $q->whereBetween(DB::raw("DATE(start_time)"), [$from, $to])->whereNull('visitor_id')->whereIn('type', request('types'));
                });
            } else if (in_array('today', request('duration'))) {
                $from = date("Y-m-d", time());
                $to = date("Y-m-d", time() + (24 * 60 * 60));
                $dataquery->whereHas('sessions', function ($q) use ($from, $to) {
                    $endtodayDate = Carbon::now()->endOfDay()->format('Y-m-d H:i:m');
                    $q->whereRaw("(NOW()BETWEEN start_time AND DATE_ADD(start_time,INTERVAL `type` MINUTE) OR (start_time<'$endtodayDate' AND start_time>=NOW()) )")->whereNull('visitor_id')->whereIn('type', request('types'));
                });
            }
        } elseif (!empty(request('duration'))) {
            if (in_array('week', request('duration'))) {
                $from = date("Y-m-d", time());
                $to = date("Y-m-d", time() + (7 * 24 * 60 * 60));
                $dataquery->whereHas('sessions', function ($q) use ($from, $to) {
                    $q->whereBetween(DB::raw("DATE(start_time)"), [$from, $to])->whereNull('visitor_id');
                });
            } else if (in_array('today', request('duration'))) {
                $from = date("Y-m-d", time());
                $to = date("Y-m-d", time() + (24 * 60 * 60));
                 
                $dataquery->whereHas('sessions', function ($q) use ($from, $to) {
                    $endtodayDate = Carbon::now()->endOfDay()->format('Y-m-d H:i:m');
                    $q->whereRaw("(NOW()BETWEEN start_time AND DATE_ADD(start_time,INTERVAL `type` MINUTE) OR (start_time<'$endtodayDate' AND start_time>=NOW()) )")->whereNull('visitor_id');
                });
            }
        } elseif (!empty(request('types'))) {
            
            if(in_array('30', request('types')))
            {
                $dataquery->whereHas('sessions', function ($q) {
                    $q->whereIn('type', [10,3,30])->whereRaw("(NOW()BETWEEN start_time AND DATE_ADD(start_time,INTERVAL `type` MINUTE) OR start_time>=NOW() )")->whereNull('visitor_id');
                });
            }
            elseif(in_array('60', request('types')))
            {
                $dataquery->whereHas('sessions', function ($q) {
                    $q->whereIn('type', [15,6,60])->whereRaw("(NOW()BETWEEN start_time AND DATE_ADD(start_time,INTERVAL `type` MINUTE) OR start_time>=NOW() )")->whereNull('visitor_id');
                });
            }
            elseif(in_array('30', request('types')) && in_array('60', request('types')))
            {
                $dataquery->whereHas('sessions', function ($q) {
                    $q->whereIn('type', [10,3,30,15,6,60])->whereRaw("(NOW()BETWEEN start_time AND DATE_ADD(start_time,INTERVAL `type` MINUTE) OR start_time>=NOW() )")->whereNull('visitor_id');
                });
            }
            else
            {
                $dataquery->whereHas('sessions', function ($q) {
                    $q->whereIn('type', [10,3,30,15,6,60]);
                });
            }

        }
        if (!empty(request('gender'))) {
            $dataquery->whereIn('gender', request('gender'));
        }
        if (!empty(request('rating'))) {
            $dataquery->where('rating', '>', request('rating') - 1);
        }
        if (!empty(request('rang'))) {

            

            if($location && $location->countryName == 'Egypt')
            {
                if (intval(request('rang'))) {
                    $between = [
                        '150' => array(0, 149),
                        '200' => array(150, 200),
                        '300' => array(200, 300),
                        '500' => array(300, 500),
                    ];
                    $dataquery->whereBetween('price30', $between[request('rang')]);
                } else {
                    $dataquery->where('price30', '>', 500);
                }   
            }
            else
            {
                if (intval(request('rang'))) {
                    $between = [
                        '150' => array(0, 149),
                        '200' => array(150, 200),
                        '300' => array(200, 300),
                        '500' => array(300, 500),
                    ];
                    $dataquery->whereBetween('thirty_price_dollar', $between[request('rang')]);
                } else {
                    $dataquery->where('thirty_price_dollar', '>', 500);
                }
            }


            
        }
        //dd($dataquery->toSql(),$dataquery->getBindings());
        $data = $dataquery->orderBy($sortfield, $sortoption)->paginate(100);
        if ($type == 'html') {
            return view('therapists.ajax', ['data' => $data]);
        } else {

            return response()->json($data);
        }
    }

    // login therapist
    public function login(Request $request)
    {
        if (User::where(['email' => $request->email, 'type' => 'visitors'])->count() > 0)
        {
            return back()->with('dis-allow', trans('home.You are not allowed as a visitor to enter from here'));
        }

        $attributes = request()->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        $remember_me = $request->has('remember') ? true : false; 

        if (Auth::attempt($attributes, $remember_me)) {
            // Authentication passed...
            if(config('app.locale') == "en")
            {
                return redirect()->intended('/en/therapists/sessions');
            }
            else
            { 
                return redirect()->intended('/therapists/sessions');
            }
            
        } else {
            return redirect()->back()->withErrors(['error' => trans('home.Wrong email or password')]);;
        }
    }
















    // regstration page
    public function signup()
    {
        return view('therapists.register');
    }
    public function signup_form()
    {
        return view('therapists.register_form');
    }


    // reg .. mail send

    public function ThreraReg(Request $request)
    {
        $country=DB::table('country')->find($request->country_id);
        $trans = array(
            "۰" => "0",
            "۱" => "1",
            "۲" => "2",
            "۳" => "3",
            "٤" => "4",
            "٥" => "5",
            "٦" => "6",
            "٧" => "7",
            "۸" => "8",
            "۹" => "9",
        );

        $phone= strtr($request->phone, $trans);
        if (substr($phone,0,1)=="0"){$phone=substr($phone,1);}
        if($country){
            $phone=$country->code.$phone;
        }
        $request->merge(['phone'=>$phone]);
        $request->validate(
            [
                'name' => 'required|string|max:255',
                'email' => 'required|string|email|max:255|unique:users',
                'phone' => 'required|regex:/^[0-9]+$/|string|max:255|unique:therapists,mobile',
                'password' => 'required|string|min:8|max:32|confirmed',
                'agreement' => 'required|in:1',

            ],
            [
                'name.required'    => trans('home.Please put your name'),
                'name.max'    => trans('home.maxChar'),
                'email.required'   => trans('home.Please enter your email address'),
                'email.unique'     => trans('home.Unfortunately the e-mail already exists'),
                'phone.regex'     => trans('home.regexPhone'),
                'password.required' => trans('home.Please enter a password'),
                'password.confirmed' => trans('home.The password and the confirmation password do not match'),
                'password.min'     => trans('home.Passwords must be at least 8 letters or numbers'),
                'password.max'     => trans('home.Passwords must be more than 32 letters or numbers'),
                'agreement.required' => trans('home.Please agree to the terms and conditions'),
                'agreement.in' => trans('home.You must agree to the terms and conditions')
            ]
        );
        if ($request->hasFile('cv')) {
            $file = $request->file('cv');
            $destinationPath = public_path('resumes/');
            $fileName = time() . uniqid() . $file->getClientOriginalName();
            $file->move($destinationPath, $fileName);
            $cv = $fileName;
        } else {
            $cv = '';
        }

        if ($request->hasFile('qualification')) {
            $file = $request->file('qualification');
            $destinationPath = public_path('qualification/');
            $fileName = time() . uniqid() . $file->getClientOriginalName();
            $file->move($destinationPath, $fileName);
            File::copy($destinationPath.$fileName,public_path('qualification/'.$fileName));
            $qualification = $fileName;
        } else {
            $qualification = '';
        }
        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'type' => 'therapists',
            // 'phone' => $request->phone,
            'verifyToken' => Str::random(40),
            'agreement' => $request->agreement,
            'cv' => $cv,
            'qualification' => $qualification,

        ]);

        $data['user_id'] = $user->id;
        $data['title'] = $user->name;
        $data['name_a'] = $user->name;
        $data['name_e'] = $user->name;
        $data['country_id'] = $request->country_id;

        $data['mobile'] = $request->phone;
        $data['resume'] = $cv;
        $data['zip_certificates'] = $qualification;

        $therapist=Therapist::create($data);

        $user = User::findOrFail($user->id);
       // $this->sendEmail($user);
        // $html = view('email.register_step2_hr_email', compact('therapist','user'))->render();
        // sendGridEmailToUser($html, 'hr@newhayah.com', 'New Hayah', 'Notification New Doctor Data');
        // sendGridEmailToUser($html, 'omar.bakry@almoasher.net', 'Omar Bakry', 'Notification New Doctor Data');
        // sendGridEmailToUser($html, 'mostafa.elnemer@almoasher.net', 'Mostafa Elnemer', 'Notification New Doctor Data');
        // sendGridEmailToUser($html, 'ahmedibrahim199028@gmail.com', 'Ahmed Tester', 'Notification New Doctor Data');

        $html = view('email.sendView', compact('user'))->render();
        sendGridEmailToUser($html, $user->email, $user->name, 'Verified Email');

        return view('email.verifyEmailFirst', compact('user'));
    }



    // send email

    public function sendEmail($user)
    {
        $html = view('email.sendView', compact('user'))->render();
        sendGridEmailToUser($html, $user->email, $user->name, 'Verified Email');
        //Mail::to($thisUser['email'])->send(new MailVerifyEmail($thisUser));
    }



    // Send Email done !!
    public function sendEmailTherapist($email, $verifyToken)
    {
        $user = User::where(['email' => $email, 'verifyToken' => $verifyToken])->first();

        if ($user) {

            $countries = Countries::orderBy('title_ar')->get();
            $prfixs = Specialties::select('id', 'title_ar AS title')->where('active', 1)->orderBy('sort', 'ASC')->get();
            $langs = Languages::all();
            $genders = ['male' => Lang::get('home.male'), 'female' => Lang::get('home.female')];
            $therapist = Therapist::where('user_id', $user->id)->first();
            return view('therapists.show_login',compact(
                'user',
                'countries',
                'prfixs',
                'langs',
                'genders',
                'therapist','email','verifyToken'
            ));
            return view('therapists.step2register', compact(
                'user',
                'countries',
                'prfixs',
                'langs',
                'genders',
                'therapist'
            ));
        }
        return abort(404);
    }
    public function sendEmailTherapistPost($email,$verifyToken,Request $request){
        $user = User::where(['email' => $email, 'verifyToken' => $verifyToken])->first();
        if ($user) {
            $countries = Countries::orderBy('title_ar')->get();
            $prfixs = Specialties::select('id', 'title_ar AS title')->where('active', 1)->orderBy('sort', 'ASC')->get();
            $langs = Languages::all();
            $genders = ['male' => Lang::get('home.male'), 'female' => Lang::get('home.female')];
            $therapist = Therapist::where('user_id', $user->id)->first();

            if($request->password){
                if(Hash::check($request->password,$user->password)){
                    Auth::login($user);
                    return redirect()->to(route('therapists_profile_basic'));
                }
                return redirect()->back()->withErrors(['password'=>[trans('home.Wrong Password')]]);
            }

            return redirect()->back()->withErrors(['password'=>[trans('home.required_field')]]);
        }
        return abort(404);
    }


    // step 2
    public function StepRegstrion(StoreTherapistReg $request)
    {


        if ($request->hasFile('resume')) {
            //dd($request->file('resume')->getClientMimeType());
            //https://svn.apache.org/repos/asf/httpd/httpd/trunk/docs/conf/mime.types
            if (!in_array($request->file('resume')->getClientMimeType(), ['application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'application/pdf'])) {
                return back()->withInput()->withErrors(['resume' => trans('home.resume-type')]);
            }
        }

        $userData = User::findOrFail($request->user_id);

        if ((Therapist::where('user_id', $request->user_id)->count()) > 0)
            //  return back()->withErrors(trans('home.exist'));


            $therapists = Therapist::where('user_id', $request->user_id)->update(array_merge($request->only('user_id', 'name_e', 'name_a', 'license_no', 'years', 'license_org', 'birth', 'gender', 'country_id', 'price30', 'price60'), ['title' => $request->name_e]));


        $therapist = Therapist::where('user_id', $request->user_id)->first();

        if ($request->hasFile('picture')) {

            $imagename = array();
            foreach ($request->file('picture') as $image) {

                $images = $image->hashName();
                $file = $request->file('picture');
                $destinationPath = public_path('avatars/therapists');
                $fileName = time() . uniqid() . $image->getClientOriginalName();
                $image->move($destinationPath, $images);
                array_push($imagename, $images);



                $therapist->picture = $imagename[0];
            } {
            }

            if ($request->hasFile('resume')) {
                $file = $request->file('resume');
                $destinationPath = public_path('resumes/');
                $fileName = time() . uniqid() . $file->getClientOriginalName();
                $file->move($destinationPath, $fileName);
                $therapist->resume = $fileName;
            }

            if ($request->hasFile('licence')) {
                $file = $request->file('licence');
                $destinationPath = public_path('licences/');
                $fileName = time() . uniqid() . $file->getClientOriginalName();
                $file->move($destinationPath, $fileName);
                $therapist->licence = $fileName;
            }

            if ($request->hasFile('zip_certificates')) {
                $file = $request->file('zip_certificates');
                $destinationPath = public_path('qualification/');
                $certificateName = time() . uniqid() . $file->getClientOriginalName();
                $file->move($destinationPath, $certificateName);
                $therapist->zip_certificates = $certificateName;
            }


            $therapist_lang = Therapists_languages::create([
                'therapist_id' => $therapist->id,
                'language_id' => $request->language_id,
            ]);

            if (!empty($request->speciality_id)) {
                foreach ($request->speciality_id as $key => $value) {
                    $therapist_spec = TherapistsSpecialties::create([
                        'therapist_id' => $therapist->id,
                        'speciality_id' => $value,
                    ]);
                }
            }
            $therapist->save();



            /////////////upload multi picture in TherapistsPictures
            /*  if($request->hasFile('picture'))
        {
            $imagename = array();
            foreach ($request->file('picture') as $image) {

                $images = $image->hashName();
                $file=$request->file('picture');
                $destinationPath = public_path('avatars/therapists');
                $fileName = time().uniqid().$image->getClientOriginalName();
                $image->move($destinationPath, $images);
                array_push($imagename, $images);




            }*/
            for ($j = 0; $j < count($imagename); $j++) {
                $data['pictures'] =  $imagename[$j];
                $data['therapists_id'] = $therapist->id;
                TherapistsPictures::create($data);
            }
        }
        //////////////////////////////////////////////////








        $html = view('email.register_step2', compact('therapist'))->render();
        //sendGridEmailToUser($html,$therapist->user->email,$therapist->user->name,'Notification Review Your Email');

        //        $html=view('email.register_step2_hr_email',compact('therapist'))->render();
        //        sendGridEmailToUser($html,'most22491@gmail.com','Mostafa Elnemer','Notification New Doctor Data');

        $user=$userData;
        $html = view('email.register_step2_hr_email', compact('therapist','user'))->render();
        sendGridEmailToUser($html, 'hr@newhayah.com', 'New Hayah', 'Notification New Doctor Data');
        sendGridEmailToUser($html, 'omar.bakry@almoasher.net', 'Omar Bakry', 'Notification New Doctor Data');
        sendGridEmailToUser($html, 'mostafa.elnemer@almoasher.net', 'Mostafa Elnemer', 'Notification New Doctor Data');
        sendGridEmailToUser($html, 'ahmedibrahim199028@gmail.com', 'Ahmed Tester', 'Notification New Doctor Data');

        //return view('email.endsteps',compact('userData'));
        return redirect()->to(route('therapistQuestions', ['email' => $userData->email, 'verifyToken' => $userData->verifyToken]));
    }
    public function therapistQuestions($email, $verifyToken)
    {
        $user = User::where(['email' => $email, 'verifyToken' => $verifyToken])->first();
        if ($user) {
            $therapistQuestion = TherapistsQuestions::where('user_id', $user->id)->first();
            $therapist = Therapist::where('user_id', $user->id)->first();
            $prfixs = Specialties::select('id', 'title_ar AS title')->where('active', 1)->orderBy('sort', 'ASC')->get();
            return view('therapists.therapist_questions', compact('therapist', 'user', 'prfixs', 'therapistQuestion'));
        }
        return abort(404);
    }

    public function therapistQuestionsAnswers(Request $request, $email, $verifyToken)
    {
        $user = User::where(['email' => $email, 'verifyToken' => $verifyToken])->first();
        if ($user) {
            $therapistQuestion = TherapistsQuestions::where('user_id', $user->id)->first();
            if (!$therapistQuestion) {
                $therapist = Therapist::where('user_id', $user->id)->first();
                $validator = Validator::make(
                    $request->all(),
                    array(
                        'works_hours' => 'required',
                        'offered_psychological_internet' => 'required',
                        'speciality_id' => 'required',
                    )
                );
                if ($validator->fails()) {
                    return redirect()->back()->withErrors($validator->errors())->withInput();
                } else {
                    $request->merge([
                        'speciality_id' => (is_array($request->speciality_id)) ? json_encode($request->speciality_id) : json_encode([]),
                        'experience' => ($request->offered_psychological_internet == 1) ? $request->experience : 0,
                    ]);

                    TherapistsQuestions::create(array_merge($request->only('works_hours', 'offered_psychological_internet', 'experience', 'speciality_id', 'defects', 'contribute', 'most_effective'), ['user_id' => $user->id, 'therapist_id' => ($therapist) ? $therapist->id : 0]));
                    $html = view('email.therapist_privacy_binder')->render();
                    $attaches = (object)['file_dir' => '/img/', 'file' => 'ميثاق-الخصوصية-للمعالجين.pdf'];
                    // $send=sendGridEmailToUser($html,$user->email,$user->name,trans('home.Therapist Privacy Binder'),[$attaches],'elnigm1990@yahoo.com');
                    $send = sendGridEmailToUser($html, $user->email, $user->name, trans('home.Therapist Privacy Binder'), [$attaches], 'hr@newhayah.com');
                    return redirect()->to(route('thanks_therapist'));
                }
            } else {
                return redirect()->to(route('thanks_therapist'));
            }
        }
        return abort(404);
    }
    public function thanksTherapist()
    {
        return view('email.thanks_therapist');
    }





    // list all therapist
    public function list()
    {
        return view('dashboard.therapists', ['data' => Therapist::latest()->paginate(30)]);
    }


    // search (price) ..methode dashboard
    public function search()
    {
        if (!empty(request('search'))) {
            $data = Therapist::where(function ($query) {
                $query->where('id', '=', request('search'))
                    ->orwhere('name_a', 'LIKE', "%" . request('search') . "%")
                    ->orwhere('description', 'LIKE', "%" . request('search') . "%")
                    ->orwhere('price', '=', request('search'));
            })->latest()->paginate(30);
        } else {
            abort(403, 'Unauthorized action.');
        }
        return view('dashboard.therapists', ['data' => $data]);
    }


    //store .. therapists
    public function store()
    {
        $attributes = request()->validate([
            'title' => 'required|max:255',
            'picture' => 'required|mimes:jpeg,bmp,png|dimensions:min_width=150,min_height=150',
            'description' => 'required|max:1000',
            'price' => 'required|integer',
        ]);
        $attributes['active'] = (request('active') == '1') ? '1' : '0';
        $attributes['picture'] = str_replace("avatars/therapists/", "", request('picture')->store('avatars/therapists'));
        Therapist::create($attributes);
        return back()->with('status', 'Therapist added successfully ');
    }


    // edit .. method
    public function edit(Therapist $therapist)
    {
        return view('dashboard.therapists-edit', ['data' => $therapist]);
    }


    // update .. method
    public function update(Therapist $therapist)
    {
        $attributes = request()->validate([
            'title' => 'required|max:255',
            'picture' => 'mimes:jpeg,bmp,png|dimensions:min_width=150,min_height=150',
            'description' => 'required|max:1000',
            'price' => 'required|integer',
        ]);
        $attributes['active'] = (request('active') == '1') ? '1' : '0';
        if (request('picture')) {
            $attributes['picture'] = str_replace("avatars/therapists/", "", request('picture')->store('avatars/therapists'));
        }
        $therapist->update($attributes);
        return redirect()->route('therapists')->with('status', 'Therapist updated successfully ');
    }


    // profile .. method

    public function profile_view()
    {
        return view('therapists.profile', ['data' => Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail()]);
        //return view('dashboard.therapists-edit',['data'=>$therapist]);
    }
    public function profile()
    {
        $attributes = request()->validate([
            'title' => 'required|max:255',
            'picture' => 'mimes:jpeg,bmp,png|dimensions:min_width=150,min_height=150',
            'description' => 'required|max:1000',
            'price' => 'required|integer',
        ]);
        $attributes['active'] = (request('active') == '1') ? '1' : '0';
        if (request('picture')) {
            $attributes['picture'] = str_replace("avatars/therapists/", "", request('picture')->store('avatars/therapists'));
        }
        $therapist->update($attributes);
        return redirect()->route('therapists')->with('status', 'Therapist updated successfully ');
    }


    // delete .. method
    public function destroy(Therapist $therapist)
    {
        $therapist->delete();
        return back()->with('status', 'Therapist deleted successfully ');
    }

    public function basic_info()
    {


        $userData = User::findOrFail(auth()->user()->id);

        $userData->therapist = Therapist::where([['user_id', auth()->user()->id]])->first();
        if($userData->type=='therapists'&&!$userData->therapist){
            $userData->therapist=Therapist::create(['user_id'=>auth()->user()->id,'name_a'=>$userData->name,'name_e'=>$userData->name,'title'=>$userData->name]);
        }
        //  dd($userData->therapist);
        $specialties = Specialties::where('active',1)->orderBy('sort', 'ASC')->pluck('title_ar', 'id');
        $therapist_specialties = TherapistsSpecialties::where('therapist_id', $userData->therapist->id)->pluck('speciality_id', 'id')->ToArray();
        $therapistss = Therapist::where('user_id', '=', Auth::guard()->user()->id)->first();
        $therapistsrequests = TherapistsRequests::where('therapists_id', $therapistss->id)->get();

        //Rating average of therapist
            $avg_rating = \DB::table('reviews')->where('therapist_id', $therapistss->id)->avg('rating');
        //if($userData->therapist && $userData->therapist->active==1){
        return view(
            'therapists.basic_info',
            [
                'data' => $userData->therapist,
                'specialties' => $specialties,
                'therapist_specialties' => $therapist_specialties,
                'therapistsrequests' => $therapistsrequests,
                'avg_rating' => $avg_rating
            ]
        );
        //  }
        // return view('therapists.data-revision',compact('userData','therapistsrequests'));
    }

    public function save_basic_info(Request $request)
    {
        //   dd($request);
        $attributes = $request->input();

        $therapist =  Therapist::where([['user_id', auth()->user()->id]])->firstOrFail();
        $user =  User::where('id', auth()->user()->id)->firstOrFail();
        request()->validate(
            [
                'title_ar' => 'required|max:255',
                'title_en' => 'required|max:255',
                'summery_en' => 'required|max:1000',
                'summery_ar' => 'required|max:1000',
                'email' => 'required|unique:users,email,' . auth()->user()->id . ',id',
                'resume' => ['mimes:pdf,doc,docx'],
                'zip_certificates' => ['mimes:zip,pdf,doc,docx', 'max:2048'],
                'thirty_price_dollar' => ['integer', 'numeric', 'not_in:0', 'min:1'],
                'sixty_price_dollar' => ['integer', 'numeric', 'not_in:0', 'min:1', 'gt:thirty_price_dollar'],
            ],
            [
                'title_ar.required' => trans('home.Name is required (Arabic)'),
                'title_en.required' => trans('home.Name is required (English)'),
                'summery_ar.required' => trans('home.Required summary (Arabic)'),
                'summery_en.required' => trans('home.Required summary (English)'),
                'email.unique' => trans('home.This email is already in use'),
                'resume.mimes' => trans('home.The file type should be pdf or word'),
                'zip_certificates.mimes' => trans('home.It should be in zip file format'),
                'zip_certificates.max' => trans('home.The file size does not exceed 2 MB'),
                'thirty_price_dollar.min' => trans('home.min'),
                'sixty_price_dollar.min' => trans('home.min'),
                'sixty_price_dollar.gt' => trans('home.sixty_price_dollar_gt'),
            ]
        );

        if ($request->ajax() && $request->hasFile('resume')) {
            if (file_exists(public_path() . '/resumes/' . $therapist->resume))
                @unlink(public_path() . '/resumes/' . $therapist->resume);

            $file = $request->file('resume');
            $destinationPath = public_path('resumes/');
            $fileName = $file->getClientOriginalName();
            $file->move($destinationPath, $fileName);
            $resumeInfo = $fileName;
        } else {
            $resumeInfo = $therapist->resume;
        }

        if ($request->ajax() && $request->hasFile('picture')) {
            if (file_exists(public_path() . '/avatars/therapists/' . $therapist->picture))
                @unlink(public_path() . '/avatars/therapists/' . $therapist->picture);

            $image_name = time() . '.' . $request->file('picture')->getClientOriginalExtension();
            $destinationPath = public_path('avatars/therapists');
            $request->file('picture')->move($destinationPath, $image_name);
            $therapist->picture = $image_name;
        }

        if ($request->ajax() && $request->hasFile('zip_certificates')) {
            if (file_exists(public_path() . '/qualification/' . $therapist->zip_certificates))
                @unlink(public_path() . '/qualification/' . $therapist->zip_certificates);

            $file = $request->file('zip_certificates');
            $destinationPath = public_path("/qualification/");
            $certificateName = $file->getClientOriginalName();
            $file->move($destinationPath, $certificateName);
            $therapist->zip_certificates = $certificateName;
        } else {
            $therapist->zip_certificates = $therapist->zip_certificates;
        }

        if ($request->hasFile('licence')) {
            if (file_exists(public_path() . '/licences/' . $therapist->licence))
                @unlink(public_path() . '/licences/' . $therapist->licence);

            $file = $request->file('licence');
            $destinationPath = public_path('licences/');
            $fileName = time() . uniqid() . $file->getClientOriginalName();
            $file->move($destinationPath, $fileName);
            $therapist->licence = $fileName;
        } else {
            $therapist->licence =  $therapist->licence;
        }

        $data = [
            'name_a' => $attributes['title_ar'],
            'name_e' => $attributes['title_en'],
            'description_en' => $attributes['description_en'],
            'summery_en' => $attributes['summery_en'],
            'description_ar' => $attributes['description_ar'],
            'summery_ar' => $attributes['summery_ar'],
            'country_id' => $attributes['country_id'],
            'resume' => $resumeInfo,
            'main_specialty_ar' => $attributes['main_specialty_ar'],
            'main_specialty_en' => $attributes['main_specialty_en'],
            'price30' => $attributes['price30'],
            'price60' => $attributes['price60'],
            'thirty_price_dollar' => $attributes['thirty_price_dollar'],
            'sixty_price_dollar' => $attributes['sixty_price_dollar'],
            'experience_ar' => $attributes['experience_ar'],
            'experience_en' => $attributes['experience_en'],
            'certifications_ar' => $attributes['certifacations_ar'],
            'certifications_en' => $attributes['certifacations_en'],
            'license_no' =>  $attributes['license_no'],
            'license_org' => $attributes['license_org'],
            'language_id' => $attributes['language_id'],
        ];

        $data_trans = [
            'summery' => ['ar' => $attributes['summery_ar'], 'en' => $attributes['summery_en']],
            'description' => ['ar' => $attributes['description_ar'], 'en' => $attributes['description_en']],
        ];

        if (!empty($request->specialties)) {
            foreach ($request->specialties as $key => $value) {
                $therapist_spec = TherapistsSpecialties::create([
                    'therapist_id' => $therapist->id,
                    'speciality_id' => $value,
                ]);
            }
        }

        

        $therapist->update($data);
        $therapist->save();
        if ($therapist) {
            $user->email = $attributes['email'];
            $user->save();
            save_front_trans($data_trans, $therapist->id, 'therapists');
            Session::flash('success', trans('home.The data has been successfully updated'));
            return back();
        } else {
            Session::flash('success', trans('home.Data update failed'));
            return back();
        }
    }


    public function basic_info_request(Request $request)
    {
        //dd($request);
        $attributes = $request->input();
        $therapist =  Therapist::where([['user_id', auth()->user()->id]])->firstOrFail();

        $user =  User::where('id', auth()->user()->id)->firstOrFail();
        request()->validate(
            [

                'title_ar' => 'required|max:255',
                'title_en' => 'required|max:255',
//                'main_focus_ar' => 'required|max:255',
//                'main_focus_en' => 'required|max:255',
                // 'main_focus' => 'required',
                // 'summery_en' => 'required',
                // 'summery_ar' => 'required',
                'email' => 'required|unique:users,email,' . auth()->user()->id . ',id',
                'resume' => ['mimes:pdf,doc,docx'],
                'zip_certificates' => ['mimes:zip,pdf,doc,docx', 'max:2048'],
                'thirty_price_dollar' => ['integer', 'numeric', 'not_in:0', 'min:1'],
                'sixty_price_dollar' => ['integer', 'numeric', 'not_in:0', 'min:1', 'gt:thirty_price_dollar'],

                'price30' => ['integer', 'numeric', 'not_in:0', 'min:1'],
                'price60' => ['integer', 'numeric', 'not_in:0', 'min:1', 'gt:price30'],
            ],
            [
                'title_ar.required' => trans('home.Name is required (Arabic)'),
                'title_en.required' => trans('home.Name is required (English)'),
                // 'main_focus_ar.required' => trans('home.required_field'),
                // 'main_focus_en.required' => trans('home.required_field'),
                'main_focus.required' => trans('home.required_field'),
                'summery_ar.required' => trans('home.Required summary (Arabic)'),
                'summery_en.required' => trans('home.Required summary (English)'),
                'email.required' => trans('home.input-required'),
                'email.unique' => trans('home.This email is already in use'),
                'resume.mimes' => trans('home.Cv file type should be pdf or word'),
                'zip_certificates.mimes' => trans('home.Certificate should be in zip file format'),
                'zip_certificates.max' => trans('home.Certificate file size does not exceed 2 MB'),
                'thirty_price_dollar.min' => trans('home.min'),
                'sixty_price_dollar.min' => trans('home.min'),
                'sixty_price_dollar.gt' => trans('home.sixty_price_dollar_gt'),

                'price30.min' => trans('home.min'),
                'price60.min' => trans('home.min'),
                'price60.gt' => trans('home.price60_gt'),


            ]
        );




        $therapist = Therapist::where('user_id', '=', Auth::guard()->user()->id)->first();
        if ($therapist->active == 1) {
            $therapist->summery_ar=trim(preg_replace('/\s\s+/', ' ', $therapist->summery_ar));
            $therapist->summery_ar=str_replace('> <','><',$therapist->summery_ar);
            $therapist->summery_en=trim(preg_replace('/\s\s+/', ' ', $therapist->summery_en));
            $therapist->summery_en=str_replace('> <','><',$therapist->summery_en);
            $therapist->description_ar=trim(preg_replace('/\s\s+/', ' ', $therapist->description_ar));
            $therapist->description_ar=str_replace('> <','><',$therapist->description_ar);
            $therapist->description_en=trim(preg_replace('/\s\s+/', ' ', $therapist->description_en));
            $therapist->description_en=str_replace('> <','><',$therapist->description_en);
            $therapist->certifications_ar=trim(preg_replace('/\s\s+/', ' ', $therapist->certifications_ar));
            $therapist->certifications_ar=str_replace('> <','><',$therapist->certifications_ar);
            $therapist->certifications_en=trim(preg_replace('/\s\s+/', ' ', $therapist->certifications_en));
            $therapist->certifications_en=str_replace('> <','><',$therapist->certifications_en);
            $therapist->experience_ar=trim(preg_replace('/\s\s+/', ' ', $therapist->experience_ar));
            $therapist->experience_ar=str_replace('> <','><',$therapist->experience_ar);
            $therapist->experience_en=trim(preg_replace('/\s\s+/', ' ', $therapist->experience_en));
            $therapist->experience_en=str_replace('> <','><',$therapist->experience_en);
            $user->email = $request->email;
            $therapist->gender = $request->gender;
            $therapist->name_a = $request->title_ar;
            $therapist->name_e = $request->title_en;
//            $therapist->summery_ar = $request->summery_ar;
//            $therapist->summery_en = $request->summery_en;
//            $therapist->description_ar = $request->description_ar;
//            $therapist->description_en = $request->description_en;
            $therapist->license_no = $request->license_no;
            $therapist->license_org = $request->license_org;
            $therapist->language_id = $request->language_id;
            $therapist->country_id  = $request->country_id;
            $therapist->price30 = $request->price30;
            $therapist->price60  = $request->price60;
            $therapist->thirty_price_dollar  = $request->thirty_price_dollar;
            $therapist->sixty_price_dollar = $request->sixty_price_dollar;
//            $therapist->certifications_ar      = $request->certifacations_ar;
//            $therapist->certifications_en      = $request->certifacations_en;
//            $therapist->experience_ar      = $request->experience_ar;
//            $therapist->experience_en      = $request->experience_en;
            $therapist->main_specialty_ar      = $request->main_specialty_ar;
            $therapist->main_specialty_en      = $request->main_specialty_en;
//            $therapist->main_focus_ar      = $request->main_focus_ar;
//            $therapist->main_focus_en      = $request->main_focus_en;
            // $main_focus_ar=implode(',',MainFocus::whereIn('id',$request->main_focus)->pluck('title_ar')->toArray());
            // $main_focus_en=implode(',',MainFocus::whereIn('id',$request->main_focus)->pluck('title_en')->toArray());
            // $therapist->main_focus_ar      = $main_focus_ar;
            // $therapist->main_focus_en      = $main_focus_en;

//            if($request->main_focus){
//                $ids=[];
//                foreach ($request->main_focus as $main_focus_id){
//                    $therapistsMainFocus=TherapistsMainFocus::where('therapist_id',$therapist->id)->where('main_focus_id',$main_focus_id)->first();
//                    if(!$therapistsMainFocus){
//                        $therapistsMainFocus=new TherapistsMainFocus();
//                        $therapistsMainFocus->therapist_id=$therapist->id;
//                        $therapistsMainFocus->main_focus_id=$main_focus_id;
//                        $therapistsMainFocus->save();
//                    }
//                    $ids[]=$therapistsMainFocus->id;
//                }
//                TherapistsMainFocus::where('therapist_id',$therapist->id)->whereNotIn('id',$ids)->delete();
//            }

            if($request->main_focus)
            {
                $therapist->main_focus = implode(',' , $request->main_focus);
            }
            

            $therapistsspecialties = TherapistsSpecialties::where('therapist_id', '=',   $therapist->id)->pluck('speciality_id')->toArray();
            $therapistsspecialties2 = TherapistsSpecialties::where('therapist_id', '=',   $therapist->id)->first();
            $therapist2 = Therapist::where('user_id', '=', Auth::guard()->user()->id)->first();
            $user2 =  User::where('id', auth()->user()->id)->firstOrFail();

            if ($request->hasFile('resume')) {
               // if (file_exists(public_path() . '/resumes/' . $therapist->resume))
                    //  @unlink(public_path().'/resumes/'.$therapist->resume);

                    $file = $request->file('resume');
                $destinationPath = public_path('resumes/');
                $fileName = $file->getClientOriginalName();
                $file->move($destinationPath, $fileName);
                $resumeInfo = $fileName;
                $therapist->resume = $fileName;
                if ($therapist->isDirty('resume')) {
                    $data=[];
                    $data['from'] = $therapist2->resume;
                    $data['to'] =  $fileName;
                    $data['therapists_id'] = $therapist->id;
                    $data['column_name'] = 'resume';
                    if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($data);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                    }
                }
            }

            if ($request->hasFile('picture')) {
               // if (file_exists(public_path() . '/avatars/therapists/' . $therapist->picture))
                    //@unlink(public_path().'/avatars/therapists/'.$therapist->picture);

                    $image_name = time() . '.' . $request->file('picture')->getClientOriginalExtension();
                $destinationPath = public_path('avatars/therapists');
                $request->file('picture')->move($destinationPath, $image_name);
                // $therapist->picture = $image_name;
                $therapist->picture = $image_name;
                if ($therapist->isDirty('picture')) {
                    $data=[];
                    $data['from'] = $therapist2->picture;
                    $data['to'] =  $image_name;
                    $data['therapists_id'] = $therapist->id;
                    $data['column_name'] = 'picture';
                    if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($data);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                    }
                }
            }
            if ($request->hasFile('zip_certificates')) {
                //if (file_exists(public_path() . '/qualification/' . $therapist->zip_certificates))
                    //@unlink(public_path().'/qualification/'.$therapist->zip_certificates);
                    //dd( $request->file('zip_certificates'));
                    $file = $request->file('zip_certificates');

                $destinationPath = public_path("/qualification/");
                $certificateName = $file->getClientOriginalName();
                $file->move($destinationPath, $certificateName);
                $therapist->zip_certificates = $certificateName;

                if ($therapist->isDirty('zip_certificates')) {
                    $data=[];
                    $data['from'] = $therapist2->zip_certificates;
                    $data['to'] =  $certificateName;
                    $data['therapists_id'] = $therapist->id;
                    $data['column_name'] = 'zip_certificates';
                    if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($data);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                    }
                }
            }


            if ($request->hasFile('licence')) {
                

                $file = $request->file('licence');
                $destinationPath = public_path('licences/');
                $fileName = $file->getClientOriginalName();
                $file->move($destinationPath, $fileName);
                $therapist->licence = $fileName;

                if ($therapist->isDirty('licence')) {
                    $data=[];
                    $data['from'] = $therapist2->licence;
                    $data['to'] =  $fileName;
                    $data['therapists_id'] = $therapist->id;
                    $data['column_name'] = 'licence';
                    if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($data);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                    }
                }
            }


            //for ($i = 0; $i < count($request['specialties']); $i++) {


            foreach ($request->specialties as $specialty){
                if(!in_array($specialty,$therapistsspecialties)||(in_array($specialty,$therapistsspecialties)&&count($request->specialties)!=count($therapistsspecialties))){
                    $data=[];
                    $data['from'] = (is_array($therapistsspecialties))?json_encode($therapistsspecialties):json_encode([$therapistsspecialties]);
                    $data['to'] = json_encode($request->specialties);
                    $data['therapists_id'] = $therapist->id;
                    $data['column_name'] = 'speciality_id';
                    if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                        $inserted = TherapistsRequests::create($data);
                    }else{
                        $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                    }
                    break;
                }
            }
            /*if($therapistsspecialties !=null){
                $therapistsspecialties->speciality_id = $request->specialties;

                if ($therapistsspecialties->isDirty('speciality_id')) {

                    $data['from'] = $therapistsspecialties2->speciality_id;
                    $data['to'] = json_encode($request->specialties);
                    $data['therapists_id'] = $therapist->id;
                    $data['column_name'] = 'speciality_id';
                    $inserted =   TherapistsRequests::create($data);
                }
            }else{
                $data['from'] = null;
                $data['to'] = json_encode($request->specialties);
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'speciality_id';
                $inserted =   TherapistsRequests::create($data);
            }*/


            // }
            $therapist2 = Therapist::where('user_id', '=', Auth::guard()->user()->id)->first();
            if ($therapist->isDirty('name_a')) {
                $data=[];
                $data['from'] = $therapist2->name_a;
                $data['to'] = $request->title_ar;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'name_a';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }

            if ($therapist->isDirty('main_focus')) {
                $data=[];
                $data['from'] = $therapist2->main_focus;
                $data['to'] = implode(',' , $request->main_focus);
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'main_focus';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }


            if ($therapist->isDirty('name_e')) {
                $data=[];
                $data['from'] = $therapist2->name_e;
                $data['to'] = $request->title_en;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'name_e';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->update($data);
                }
            }
            // if ($therapist->isDirty('main_focus_ar')) {
            //     $data=[];
            //     $data['from'] = $therapist2->main_focus_ar;
            //     $data['to'] = $main_focus_ar;
            //     $data['therapists_id'] = $therapist->id;
            //     $data['column_name'] = 'main_focus_ar';
            //     $data['ids'] = json_encode($request->main_focus);
            //     if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
            //         $inserted = TherapistsRequests::create($data);
            //     }else{
            //         $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
            //     }
            // }

            // if ($therapist->isDirty('main_focus_en')) {
            //     $data=[];
            //     $data['from'] = $therapist2->main_focus_en;
            //     $data['to'] = $main_focus_en;
            //     $data['therapists_id'] = $therapist->id;
            //     $data['column_name'] = 'main_focus_en';
            //     $data['ids'] = json_encode($request->main_focus);
            //     if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
            //         $inserted = TherapistsRequests::create($data);
            //     }else{
            //         $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->update($data);
            //     }
            // }

            if ($therapist->summery_ar!=$request->summery_ar) {
                $data=[];
                $data['from'] = $therapist2->summery_ar;
                $data['to'] = $request->summery_ar;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'summery_ar';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }
            if ($therapist->summery_en!=$request->summery_en) {
                $data=[];
                $data['from'] = $therapist2->summery_en;
                $data['to'] = $request->summery_en;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'summery_en';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }
            if ($therapist->description_ar!=$request->description_ar) {
                $data=[];
                $data['from'] = $therapist2->description_ar;
                $data['to'] = $request->description_ar;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'description_ar';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }
            if ($therapist->description_en!=$request->description_en) {
                $data=[];
                $data['from'] = $therapist2->description_en;
                $data['to'] = $request->description_en;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'description_en';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }

            if ($therapist->isDirty('gender')) {
                $data=[];
                $data['from'] = $therapist2->gender;
                $data['to'] = $request->gender;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'gender';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }
            if ($therapist->isDirty('license_no')) {
                $data=[];
                $data['from'] = $therapist2->license_no;
                $data['to'] = $request->license_no;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'license_no';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }

            if ($therapist->isDirty('license_org')) {
                $data=[];
                $data['from'] = $therapist2->license_org;
                $data['to'] = $request->license_org;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'license_org';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }

            if ($therapist->isDirty('language_id')) {
                $data=[];
                $data['from'] = $therapist2->language_id;
                $data['to'] = $request->language_id;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'language_id';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }
            if ($therapist->isDirty('country_id')) {
                $data=[];
                $data['from'] = $therapist2->country_id;
                $data['to'] = $request->country_id;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'country_id';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }


            if ($therapist->isDirty('price30')) {
                $data=[];
                $data['from'] = $therapist2->price30;
                $data['to'] = $request->price30;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'price30';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }

            if ($therapist->isDirty('price60')) {
                $data=[];
                $data['from'] = $therapist2->price60;
                $data['to'] = $request->price60;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'price60';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }

            if ($therapist->isDirty('thirty_price_dollar')) {
                $data=[];
                $data['from'] = $therapist2->thirty_price_dollar;
                $data['to'] = $request->thirty_price_dollar;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'thirty_price_dollar';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }

            if ($therapist->isDirty('sixty_price_dollar')) {
                $data=[];
                $data['from'] = $therapist2->sixty_price_dollar;
                $data['to'] = $request->sixty_price_dollar;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'sixty_price_dollar';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }
            if ($therapist->certifications_ar!=$request->certifacations_ar) {
                $data=[];
                $data['from'] = $therapist2->certifications_ar;
                $data['to'] = $request->certifacations_ar;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'certifications_ar';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }
            if ($therapist->certifications_en!=$request->certifacations_en) {
                $data=[];
                $data['from'] = $therapist2->certifications_en;
                $data['to'] = $request->certifacations_en;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'certifications_en';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }
            //dd($therapist->experience_ar,$request->experience_ar,$therapist->experience_ar!=$request->experience_ar);
            if ($therapist->experience_ar!=$request->experience_ar) {
                $data=[];
                $data['from'] = $therapist2->experience_ar;
                $data['to'] = $request->experience_ar;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'experience_ar';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }
            if ($therapist->experience_en!=$request->experience_en) {
                $data=[];
                $data['from'] = $therapist2->experience_en;
                $data['to'] = $request->experience_en;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'experience_en';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }
            if ($therapist->isDirty('main_specialty_ar')) {
                $data=[];
                $data['from'] = $therapist2->main_specialty_ar;
                $data['to'] = $request->main_specialty_ar;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'main_specialty_ar';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }
            if ($therapist->isDirty('main_specialty_en')) {
                $data=[];
                $data['from'] = $therapist2->main_specialty_en;
                $data['to'] = $request->main_specialty_en;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'main_specialty_en';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }
            /*  if($therapist->isDirty('main_specialty_ar')){

        $data['from']= $therapist2->main_specialty_ar;
        $data['to']= $request->main_specialty_ar;
        $data['therapists_id']=$therapist->id;
        $data['column_name']='main_specialty_ar';
        $inserted=TherapistsRequests::create($data);

    }*/
            if ($user->isDirty('email')) {
                $data=[];
                $data['from'] = $user2->email;
                $data['to'] = $request->email;
                $data['therapists_id'] = $therapist->id;
                $data['column_name'] = 'email';
                if(!TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->count()){
                    $inserted = TherapistsRequests::create($data);
                }else{
                    $inserted =TherapistsRequests::where('column_name',$data['column_name'])->where('therapists_id',$therapist->id)->where('status','pending')->update($data);
                }
            }

            $this->sendEmailresult($request);
            return response()->json(['success'=>true,'message'=>(isset($inserted))?trans('home.Data is reviewed and approved as soon as possible'):trans('home.You haven\'t change any thing')]);
        } else {
            // dd($request);
            $therapistnotactive = Therapist::where('user_id', '=', Auth::guard()->user()->id)->first();
            if ($request->specialties) {
                /*for ($i = 0; $i < count($request['specialties']); $i++) {

                    $updatethspeciality['speciality_id'] = $request->specialties[$i];
                    $updatethspeciality['therapist_id'] = $therapistnotactive->id;
                    TherapistsSpecialties::where('therapist_id', $therapistnotactive->id)->delete();
                    TherapistsSpecialties::create($updatethspeciality);
                    //  Therapist TherapistsSpecialties


                }*/
                $ids=[];
                foreach ($request->specialties as $specialty){
                    $therapistSpeciality=TherapistsSpecialties::where('therapist_id',$therapistnotactive->id)->where('speciality_id',$specialty)->first();
                    if(!$therapistSpeciality){
                        $therapistSpeciality=new TherapistsSpecialties();
                        $therapistSpeciality->speciality_id=$specialty;
                        $therapistSpeciality->therapist_id=$therapistnotactive->id;
                        $therapistSpeciality->save();
                    }
                    $ids[]=$therapistSpeciality->id;
                }
                TherapistsSpecialties::where('therapist_id', $therapistnotactive->id)->whereNotIn('id',$ids)->delete();
            }
            // if($request->main_focus){
            //     $ids=[];
            //     foreach ($request->main_focus as $main_focus_id){
            //         $therapistsMainFocus=TherapistsMainFocus::where('therapist_id',$therapist->id)->where('main_focus_id',$main_focus_id)->first();
            //         if(!$therapistsMainFocus){
            //             $therapistsMainFocus=new TherapistsMainFocus();
            //             $therapistsMainFocus->therapist_id=$therapist->id;
            //             $therapistsMainFocus->main_focus_id=$main_focus_id;
            //             $therapistsMainFocus->save();
            //         }
            //         $ids[]=$therapistsMainFocus->id;
            //     }
            //     TherapistsMainFocus::where('therapist_id',$therapist->id)->whereNotIn('id',$ids)->delete();
            // }

            $email['email'] = $request->email;
            User::where('id', auth()->user()->id)->update($email);

            $updateth['gender'] = $request->gender;
            $updateth['name_a'] = $request->title_ar;
            // $updateth['main_focus_en'] = $request->main_focus_en;
            $updateth['name_e'] = $request->title_en;
            $updateth['summery_ar'] = $request->summery_ar;
            $updateth['summery_en'] = $request->summery_en;
            $updateth['description_ar'] = $request->description_ar;
            $updateth['description_en'] = $request->description_en;
            $updateth['license_no'] = $request->license_no;
            $updateth['license_org'] = $request->license_org;
            $updateth['language_id'] = $request->language_id;
            $updateth['country_id'] = $request->country_id;
            $updateth['price30'] = $request->price30;
            $updateth['price60'] = $request->price60;
            $updateth['thirty_price_dollar'] = $request->thirty_price_dollar;
            $updateth['sixty_price_dollar'] = $request->sixty_price_dollar;
            $updateth['certifications_ar'] = $request->certifacations_ar;
            $updateth['certifications_en'] = $request->certifacations_en;
            $updateth['experience_ar'] = $request->experience_ar;
            $updateth['experience_en'] = $request->experience_en;
            $updateth['main_specialty_ar'] = $request->main_specialty_ar;
            $updateth['main_specialty_en'] = $request->main_specialty_en;
            $lang = Therapists_languages::where('therapist_id', $therapistnotactive->id)->get();
            if (count($lang) > 0) {
                $language_id['language_id'] = $request->language_id;
                Therapists_languages::where('therapist_id', $therapistnotactive->id)->update($language_id);
            } else {
                Therapists_languages::create([
                    'therapist_id' => $therapistnotactive->id,
                    'language_id' => $request->language_id,
                ]);
            }
            if ($request->hasFile('resume')) {
                if (file_exists(public_path() . '/resumes/' . $therapist->resume))
                    @unlink(public_path() . '/resumes/' . $therapist->resume);

                $file = $request->file('resume');
                $destinationPath = public_path('resumes/');
                $fileName = $file->getClientOriginalName();
                $file->move($destinationPath, $fileName);
                $resumeInfo = $fileName;
                $updateth['resume'] = $fileName;
            }

            if ($request->hasFile('picture')) {
                if (file_exists(public_path() . '/avatars/therapists/' . $therapist->picture))
                    @unlink(public_path() . '/avatars/therapists/' . $therapist->picture);

                $image_name = time() . '.' . $request->file('picture')->getClientOriginalExtension();
                $destinationPath = public_path('avatars/therapists');
                $request->file('picture')->move($destinationPath, $image_name);
                // $therapist->picture = $image_name;
                $updateth['picture'] = $image_name;
            }

            if ($request->hasFile('zip_certificates')) {
                if (file_exists(public_path() . '/qualification/' . $therapist->zip_certificates))
                    @unlink(public_path() . '/qualification/' . $therapist->zip_certificates);

                $file = $request->file('zip_certificates');
                $destinationPath = public_path("/qualification/");
                $certificateName = $file->getClientOriginalName();
                $file->move($destinationPath, $certificateName);
                $updateth['zip_certificates'] = $certificateName;
            }


            if ($request->hasFile('licence')) {
                if (file_exists(public_path() . '/licences/' . $therapist->licence))
                    @unlink(public_path() . '/licences/' . $therapist->licence);

                $file = $request->file('licence');
                $destinationPath = public_path('licences/');
                $fileName = time() . uniqid() . $file->getClientOriginalName();
                $file->move($destinationPath, $fileName);
                $updateth['licence'] = $fileName;
            }

            if($request->main_focus)
            {
                $updateth['main_focus'] = implode(',' , $request->main_focus);
            }

            Therapist::where('id', $therapistnotactive->id)->update($updateth);
            return response()->json(['success'=>true,'message'=>trans('home.Edited successfully')]);
        }
    }

    //sendEmailresult
    public function sendEmailresult(Request $request)
    {
        $request->validate([
            'email' => 'required|email|exists:users',
        ]);
        $token = Str::random(60);

        $email = "hr@newhayah.com";
        $name = $request->name;
        $result = 'Customer Want To Make Updates On His Basic Information';
        $html = view('therapistsrequestsnotfications', compact('token', 'email', 'result'))->render();
        sendGridEmailToUser($html, $email, $name, 'Notification Therapists Request');
        Session::flash('status', 'تم الارسال بنجاح');
        return back();
    }


    public function experience()
    {
        return view('therapists.experience', ['data' => Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail()]);
    }

    public function save_experience(Request $request)
    {
        $attributes = $request->input();
        $therapist =  Therapist::where([['active', '1'], ['user_id', auth()->user()->id]])->firstOrFail();
        $user =  User::where('id', auth()->user()->id)->firstOrFail();
        request()->validate(
            [
                'title_ar' => 'required|max:255',
                'title_en' => 'required|max:255',
                'summery_en' => 'required|max:1000',
                'summery_ar' => 'required|max:1000',
                'email' => 'required|unique:users,email,' . auth()->user()->id . ',id',
            ],
            [
                'title_ar.required' => trans('home.Name is required (Arabic)'),
                'title_en.required' => trans('home.Name is required (English)'),
                'summery_ar.required' => trans('home.Required summary (Arabic)'),
                'summery_en.required' => trans('home.Required summary (English)'),
                'email.unique'     => trans('home.Unfortunately the e-mail already exists'),
            ]
        );

        if (request('picture')) {
            $attributes['picture'] = str_replace("avatars/therapists/", "", request('picture')->store('avatars/therapists'));
        }
        $data = [
            'title' => $attributes['title_en'],
            'description' => $attributes['description_en'],
            'summery' => $attributes['summery_en'],
            'country_id' => $attributes['country_id'],
        ];
        $data_trans = [
            'title' => ['ar' => $attributes['title_ar'], 'en' => $attributes['title_en']],
            'summery' => ['ar' => $attributes['summery_ar'], 'en' => $attributes['summery_en']],
            'description' => ['ar' => $attributes['description_ar'], 'en' => $attributes['description_en']],
        ];
        $therapist->update($data);
        $therapist->save();
        if ($therapist) {
            $user->email = $attributes['email'];
            $user->save();
            save_front_trans($data_trans, $therapist->id, 'therapists');
            return response(200);
        } else
            return response(500);
    }

    public function therapistResume($id)
    {
        $therapistData = Therapist::findOrFail($id);
        if($therapistData->resume){
            $file = public_path() . "/resumes/" . $therapistData->resume;
            if(file_exists($file)){
                return response()->download($file);
            }
        }
        Session::flash('error', trans('home.There is no CV .. please attach it'));
        return back();

    }

    public function therapistLicence($id)
    {
        $therapistData = Therapist::findOrFail($id);
        if($therapistData->licence){
            $file = public_path() . "/licences/" . $therapistData->licence;
            if(file_exists($file)){
                return response()->download($file);
            }
        }
        Session::flash('error', trans('home.There is no license .. please attach it'));
        return back();
    }

    //download Zip
    public function therapistCertificates($id)
    {


        $therapistData = Therapist::findOrFail($id);
        if($therapistData->zip_certificates){
            $file = public_path() . "/qualification/" . $therapistData->zip_certificates;
            if(file_exists($file)){
                return response()->download($file);
            }
        }
        Session::flash('error', trans('home.There are no certificates .. please attach'));
        return back();
    }

    //clientMessages
    public function clientMessages(Session $therapist_session)
    {
        dd($therapist_session->id);
    }
    public function resendVerify()
    {
        $thisUser = Auth::user();
        $this->sendEmail($thisUser);
    }

    //deleteCheckedSessions
    public function deleteCheckedSessions(Request $request)
    {
        \DB::table("sessions")->whereIn('id', explode(",", $request->ids))->delete();
        return response()->json(['message' => trans('home.Sessions-Deleted-successfully')]);
    }


    public function gettherapistsrequests()
    {
        $therapistss = Therapist::where('user_id', '=', Auth::guard()->user()->id)->first();
        $therapistsrequests = TherapistsRequests::with('therapist')->with('therapistto')->with('languagefrom')->with('languageto')
            ->with('countaryfrom')->with('countaryto')
            ->where('therapists_id', $therapistss->id)->get();
        $userData = User::findOrFail(auth()->user()->id);
        $userData->therapist = Therapist::where([['user_id', auth()->user()->id]])->first();
        $data = $userData->therapist;
        return view('therapists.therapists_requests', compact('userData', 'therapistss', 'therapistsrequests', 'data'));
    }

    public function canceltherapists($id)
    {
        $request = TherapistsRequests::where('id', $id)->first();
        if ($request->status == "pending") {

            $data['status'] = "customer_canceled";
            TherapistsRequests::where('id', $id)->update($data);

            return redirect()->back()->withErrors(['error' => trans('home.requestcancel')]);
        } else {
            return redirect()->back()->withErrors(['error' => trans('home.notavaliable')]);
        }
    }
    public function getSessionsByDate(Request $request)
    {
        if ($request->date) {
            if (Auth::user()->type == 'therapists') {
                $therapist=Auth::user()->therapist;
                $sessionsTimes = Sessions::whereRaw("DATE_FORMAT(start_time,'%Y-%m-%d')='$request->date'" )->where('therapist_id',$therapist->id)->orderBy('start_time')->get();
                $html = view('therapists.include.all_time_slots', compact('sessionsTimes'))->render();
                return response()->json(['success' => true, 'html' => $html]);
            }
        }
        return response()->json(['success' => false]);
    }
    public function getSessionsInDate(Request $request)
    {
        if ($request->date) {
            if (Auth::user()->type == 'therapists') {
                $date = $request->date;
                $therapist = Therapist::where([['user_id', auth()->user()->id]])->first();
                $sessionsTimes = Sessions::whereRaw("DATE_FORMAT(start_time,'%Y-%m-%d')='$request->date'" )->where('therapist_id', $therapist->id)->orderBy('start_time','ASC')->get();
                $html = view('therapists.include.session_calendar_blocks', compact('sessionsTimes', 'date'))->render();
                return response()->json(['success' => true, 'html' => $html]);
            }
        }
        return response()->json(['success' => false]);
    }
    public function privacyCharter(){
        if(!auth()->check()){
            return abort(404);
        }
        $user=auth()->user();
        if($user->type!='therapists'){
            return abort(404);
        }
        return view('therapists.privacy_charter');
    }
    public function privacyCharterSave(){
        if(!auth()->check()){
            return response()->json(['success'=>false]);
        }
        $user=auth()->user();
        if($user->type!='therapists'){
            return response()->json(['success'=>false]);
        }
        $therapist=$user->therapist;
        $therapist->agreement_privacy_charter=1;
        $therapist->agreement_privacy_charter_date=date('Y-m-d H:i:s');
        $therapist->save();
        return response()->json(['success'=>true]);
    }



    //therapists_have_coupon
    public function therapists_have_coupon()
    {
        $coupon = Coupons::where('code', 'NewHayah 2022')->first();
        $specialties = Specialties::where('active', 1)->orderBy('sort', 'ASC')->get();
        if($coupon)
        {
            return view('therapists.therapistsCoupon', compact('coupon','specialties'));
        }
        else
        {
            return redirect("/");
        }
        

    }



    //filterBySpecialists
    public function filterBySpecialists(Request $request)
    {
        $coupon = Coupons::where('code', 'NewHayah 2022')->first();

        $dataquery = [];
        foreach(explode(',', $coupon->therapists) as $therapist_id)
        {
            $dataquery[] = Therapist::whereHas('specialties', function ($q) {
                if (request('val') == 25) {
                    $q->whereIn('speciality_id', [25, 31, 32, 33, 1, 34]);
                } else {
                    $q->where('speciality_id', request('val'));
                }
            })->whereId($therapist_id)->get();
        
        }

        $htmlContent = '';

        foreach($dataquery as $item => $value)
        {
            $htmlContent .= $item['id'];
        }


        return response()->json(['data' => $htmlContent]);
    }



    //update_my_profile_message
    public function update_my_profile_message()
    {
        if(app()->getLocale() == 'ar')
        {
            $message = '  تم حفظ البيانات وسيتم مراجعتها فى اقرب وقت ';
        }
        else
        {
             $message = '  The data has been saved and will be reviewed as soon as possible ';
        }
        
        return view('therapists.update_my_profile_message', compact('message'));
    }




}
