<?php

namespace App\Http\Controllers;

use App\Complain;
use App\Message;
use App\Payments;
use App\ReviewQuestionAnswer;
use App\Reviews;
use App\ReviewsQuestionAnswer;
use App\SessionsQuestionAnswer;
use App\SessionsSchedules;
use App\Therapist;
use App\TherapistsInvoices;
use App\TreatmentPlan;
use App\Visitor;
use App\User;
use App\Sessions;
use App\WebsiteRating;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use App\Http\Requests\UpdateVisitorProfile;
use  App\Http\Requests\createEvalutionRequest;
use App\Rules\FilterStringRule;

class VisitorController extends Controller
{

    public function index()
    {
        $userData = User::findOrFail(auth()->user()->id);
        if(User::where( [['active','1'],['id',auth()->user()->id]] )->first())
            return view('auth.profile',['data'=>User::where([['active','1'],['id',auth()->user()->id]])->firstOrFail(),'userData'=>$userData]);

        return view('auth.data-revision-visitor',compact('userData'));

    }


    public function mysessions_old()
    {
        $userData = User::findOrFail(auth()->user()->id);
        if(User::where( [['active',1],['id',auth()->user()->id]] )->first())
            return view('auth.mysessions',['data'=>Visitor::where([['user_id',auth()->user()->id]])->firstOrFail()]);

        return view('auth.data-revision-visitor',compact('userData'));
    }
    public function schedulingSession(Request $request){
        if($request->session_id&&$request->scheduling_session_id){
            $currentSession=Sessions::where('session_status','reserved')->find($request->session_id);
            if($currentSession&&$currentSession->start_time>date('Y-m-d H:i:s')){
                $visitor=Visitor::where( [['user_id',auth()->user()->id]] )->first();
                $selectedSession=Sessions::where('session_status','available')->where('therapist_id',$currentSession->therapist_id)->find($request->scheduling_session_id);
                if($selectedSession){
                    SessionsSchedules::create([
                        'session_id'=>$currentSession->id,
                        'session_schedule_id'=>$selectedSession->id,
                        'user_id'=>auth()->user()->id,
                        'visitor_id'=>$visitor->id,
                    ]);
                    $selectedSession->visitor_id=$visitor->id;
                    $selectedSession->status=2;
                    $selectedSession->session_status='reserved';
                    $selectedSession->reserved_date=date('Y-m-d H:i:s');
                    $selectedSession->payment_method=$currentSession->payment_method;
                    $selectedSession->payment_id=$currentSession->payment_id;
                    $selectedSession->save();
                    Payments::where('id',$currentSession->payment_id)->update(['session_id'=>$selectedSession->id]);
                    TherapistsInvoices::where('id',$currentSession->invoice_id)->update(['session_id'=>$selectedSession->id,'session_date'=>$selectedSession->start_time]);
                    $currentSession->session_status='available';
                    $currentSession->visitor_id=NULL;
                    $currentSession->status=1;
                    $currentSession->reserved_date=NULL;
                    $currentSession->payment_method=NULL;
                    $currentSession->payment_id=0;
                    $currentSession->save();
                    $therapistUser=$currentSession->therapist->user;
                    $html=view('email.session_scheduling_therapist',compact('selectedSession','currentSession','therapistUser'));
                    sendGridEmailToUser($html,$therapistUser->email,$therapistUser->name,'Scheduling Session');
                    return response()->json(['success'=>true,'message'=>trans('home.Scheduling Done')]);
                }
                return response()->json(['success'=>false,'message'=>trans('home.This session is not available')]);
            }
            return response()->json(['success'=>false,'message'=>trans('home.Your session you try to scheduling must be with date grete than now')]);
        }
    }
    public function mysessions(Request $request)
    {
        $userData = User::findOrFail(auth()->user()->id);
        if($userData->type!='visitors'){
            return abort(404);
        }
        if($userData->active){
            $visitor=Visitor::where( [['user_id',auth()->user()->id]] )->first();
            if(!$visitor){
                $visitor=new Visitor();
                $visitor->user_id=auth()->user()->id;
                $visitor->save();
            }
            if($request->getSchedulingSessions){
                if($request->session_id){
                    $session=Sessions::find($request->session_id);
                    $sessions=Sessions::where('type',$session->type)->where('id','!=',$session->id)->where(function($q)use($request,$session){
                        $q/*->where('start_time','>',$session->start_time)*/->where('start_time','>',date('Y-m-d H:i:s'))->where('id','!=',$session->id);
                    })->where('session_status','available')->where('therapist_id',$session->therapist_id)->take(20)->get();
                    $html=view('auth.include.scheduling_blocks',compact('sessions'))->render();
                    return response()->json(['success'=>true,'html'=>$html,'hasSessions'=>(count($sessions)?true:false), 'session_id' =>$session->id]);
                }
                return response()->json(['success'=>false]);
            }
            $todayDate=Carbon::now()->format('Y-m-d');

            $todaySessions=Sessions::where('visitor_id',$visitor->id)->whereNotIn('session_status',['cancelled','visitor_cancelled'])
            //->whereBetween('start_time', [Carbon::now()->format('Y-m-d H:i:m'), Carbon::now()->endOfDay()->format('Y-m-d H:i:m')])
            ->where('session_date', Carbon::now()->format('Y-m-d'))
            ->orderBy('start_time', 'asc')->get();


            $nextSessions=Sessions::where('visitor_id',$visitor->id)->whereNotIn('session_status',['cancelled','visitor_cancelled'])->whereRaw("DATE(session_date)>'$todayDate'")->get();

            $previousSessions=Sessions::where('visitor_id',$visitor->id)->whereNotIn('session_status',['cancelled','visitor_cancelled'])
          //  ->where("start_time", '<', Carbon::now()->format('Y-m-d H:i:m'))
            ->where("session_date", '<', Carbon::now()->format('Y-m-d'))
            ->orderBy('start_time', 'desc')->get();
            return view('auth.mysessions',['data'=>$visitor,'todaySessions'=>$todaySessions,'nextSessions'=>$nextSessions,'previousSessions'=>$previousSessions, 'userData'=>$userData]);

        }

        return view('auth.data-revision-visitor',compact('userData'));
    }
    public function cancelSession(Request $request){
        $userData = User::findOrFail(auth()->user()->id);
        $visitor = Visitor::where([['user_id', auth()->user()->id]])->first();
        $userData->visitor = $visitor;
        if ($visitor) {
            if($request->ids){
                if(Sessions::whereIn('id',$request->ids)->where('visitor_id',$visitor->id)->where('session_status','reserved')->whereBetween('start_time',[date('Y-m-d H:i:s'),date('Y-m-d H:i:s',strtotime('- 8 hours'))])->count()){
                    return response()->json(['success'=>false,'message'=>trans('home.The session may not be canceled 8 hours before the scheduled time')]);
                }
                TherapistsInvoices::whereIn('session_id',$request->ids)->where('visitor_id',$visitor->id)->delete();
                Sessions::whereIn('id',$request->ids)->where('visitor_id',$visitor->id)->update([
                    'visitor_id'=>NULL,
                    'status'=>1,
                    'session_status'=>'available',
                    'patient_cancel'=>'yes',
                    'cancelled_date'=>date('Y-m-d H:i:s'),
                ]);
                sendCanceledEmail(Sessions::whereIn('id',$request->ids)->where('visitor_id',$visitor->id)->get(),'therapist');
                return response()->json(['success'=>true]);
            }elseif($request->id){
                $date=date('Y-m-d H:i:s');
                $date8hours=date('Y-m-d H:i:s',strtotime('- 8 hours'));
                if(Sessions::where('id',$request->id)->where('visitor_id',$visitor->id)->where('session_status','reserved')->whereBetween('start_time',[$date,$date8hours])->count()){
                    return response()->json(['success'=>false,'message'=>trans('home.The session may not be canceled 8 hours before the scheduled time')]);
                }
                $session=Sessions::where('visitor_id',$visitor->id)->find($request->id);//->delete();
                //dd($session->start_time,$date);
                if($session){
                    if($session->start_time<=$date){
                        return response()->json(['success'=>false,'message'=>trans('home.The session date is gone')]);
                    }
                    $session->visitor_id=NULL;
                    $session->status=1;
                    $session->session_status='available';
                    $session->patient_cancel='yes';
                    $session->cancelled_date=date('Y-m-d H:i:s');
                    $session->save();
                    TherapistsInvoices::where('session_id',$request->id)->where('visitor_id',$visitor->id)->delete();

                        if ($userData) {
                           sendCanceledEmail([$session], $userData->name,'therapist');
                        }
                        else
                        {
                            sendCanceledEmail([$session],'therapist');
                        }
                    return response()->json(['success'=>true]);
                }

            }
        }
        return response()->json(['success'=>false]);
    }
    public function startsession ($id) {
        $visitor=Visitor::where([['user_id',auth()->user()->id]])->firstOrFail();
        $session=Sessions::where('visitor_id',$visitor->id)->findOrFail($id);
        if($session->session_status!='reserved'){
            return redirect()->back();
        }
        if($session->meeting_provider=='whereby'&&$session->visitor_start_date==NULL){
            $session->visitor_start_date=date('Y-m-d H:i:s');
            $session->save();
        }
        addInvoice($session);
        //return view('auth.session',['data'=>$visitor,'session'=>$session,'type'=>'visitor']);
        return view('therapists.session',['data'=>$visitor,'session'=>$session,'type'=>'visitor']);
    }

    public function book($id)
    {
        $session = Sessions::where([['id',$id]])->firstOrFail();
        $userData = User::findOrFail(auth()->user()->id);
        if(User::where( [['active','0'],['id',auth()->user()->id]] )->first())
            return view('auth.data-revision-visitor',compact('userData'));

        return view('payment',compact('id'));

    }

    public function sendEmailVisitor($email,$verifyToken)
    {
        $userData = User::where(['email'=>$email,'verifyToken'=>$verifyToken])->first();
        if($userData){
            $visitor = Visitor::where('user_id',$userData->id)->first();
            $userData->update(['active'=>1]);
            return view('email.endsteps',compact('userData'));
        }
       return abort(404);
    }

    public function rateSession($id)
    {
        return view('auth.rate-session',['userData'=>User::findOrFail(auth()->user()->id),'id'=>$id]);
    }

    //session evaluation
    public function insertRate(createEvalutionRequest $request,$id)
    {
        $sessionData = Sessions::findOrFail($id);
        $reviewData = Reviews::create(array_merge($request->only('comment','rating','answer1','answer2','answer3','answer4'),['therapist_id'=>$sessionData->therapist_id,'visitor_id'=>$sessionData->visitor_id,'session_id'=>$id]));
        foreach ($request->question as $key=>$value)
        {
            ReviewsQuestionAnswer::create([
                'question'=>$value,
                'answer'=>$request->answer[$key],
                'review_id'=>$reviewData->id
            ]);
        }
        Session::flash('success', trans('home.Your rating was added successfully'));
        return redirect()->route('mysessions');
    }

    public function rateWebsite()
    {
        $userData = User::findOrFail(auth()->user()->id);
        if(User::where( [['active','0'],['id',auth()->user()->id]] )->first())
            return view('auth.data-revision-visitor',compact('userData'));

        return view ('auth.rate-website',compact('userData'));
    }

    public function insertRateWebsite(createEvalutionRequest $request)
    {
        WebsiteRating::create(array_merge($request->only('comment','rating'),['user_id'=>auth()->user()->id]));
        Session::flash('success', trans('home.Your review has been submitted successfully'));
        return redirect()->route('mysessions');
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function reserveSessionWithPayment(Request $request,$id)
    {
            $session=Sessions::find($id);
            if($session->visitor_id){
                return redirect()->back()->withErrors(['message'=>trans('home.This session has been reserved')]);
            }





//            if($session->start_time<date('Y-m-d H:i:s')){
//                return redirect()->back()->withErrors(['message'=>trans('home.The session cannot be booked after the start date')]);
//            }
            request()->validate(['type' =>'required',], ['type.required'=> trans('home.Payment method required')]);
            $visitor = Visitor::where([['user_id',auth()->user()->id]])->firstOrFail();
            $attributes = [
                'visitor_id' => $visitor->id,
                'status' => '2',
                'payment_method'=>$request->type
            ];
            Sessions::where('id',$id)->update($attributes);
            Session::flash('message', trans('home.The session was booked successfully'));
            return redirect()->to(route('pay-session-rating',['id'=>$id]));
            return redirect()->to(route('mysessions'));
            return view('auth.mysessions',['data'=>Visitor::where([['user_id',auth()->user()->id]])->firstOrFail()]);
    }
    public function addPayRatingSession($id){
        $visitor=Visitor::where('user_id',Auth::user()->id)->first();
        if($visitor){
            $session=Sessions::where('visitor_id',$visitor->id)->find($id);
            if($session){
                $sessionQuestion=SessionsQuestionAnswer::where('session_id',$session->id)->first();
                return view('auth.add_pay_rating_session',compact('session','sessionQuestion'));
            }
        }

        return abort(404);
    }
    public function addPayRatingSessionPost($id,Request $request){
        $visitor=Visitor::where('user_id',Auth::user()->id)->first();
        if($visitor){
            $session=Sessions::where('visitor_id',$visitor->id)->find($id);
            if($session){
               foreach ($request->question as $key=>$question){
                   $answer=($request->answer[$key])?$request->answer[$key]:'';
                   if(is_array($answer)){
                       $answer=implode(',',$answer);
                   }
                   SessionsQuestionAnswer::create([
                       'session_id'=>$session->id,
                       'question'=>$question,
                       'answer'=>$answer,
                       'note'=>(isset($request->answer_note[$key]))?$request->answer_note[$key]:''
                   ]);
               }
                Session::flash('message', trans('home.Your Rating Added Success'));
                return redirect()->to(route('mysessions'));
            }
        }

        return abort(404);
    }



    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Visitor  $visitor
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateVisitorProfile $request, User $userData)
    {
        $visitor = Visitor::where('user_id',$userData->id)->first();
        if(!($request->birthyear<date('Y')&&$request->birthyear>=date('Y',strtotime('-70 years')))){
            return redirect()->back()->withErrors(['birthyear'=>trans('home.visitor-before',['age'=>70])]);
        }
        if($request->password){
            $array=array_merge($request->only('email'),['password'=>Hash::make($request->password)]);
        }else{
            $array=$request->only('email');
        }
        $userData->update($array);
        if($request->hasFile('picture'))
        {
            $file=$request->file('picture');
            $destinationPath = public_path('avatars/visitors');
            $fileName = $file->getClientOriginalName();
            $file->move($destinationPath, $fileName);
            $visitor->image = $fileName;
        }
        $visitor->update(['name' => $request->name,'birthyear'=>$request->birthyear,'mobile'=>$request->mobile]);
        Session::flash('message', trans('home.Successfully updated'));
        return back();
    }

    public function getComplaint (Request $request)
    {
        $userData = User::findOrFail(auth()->user()->id);
        if(User::where( [['active','0'],['id',auth()->user()->id]] )->first())
            return view('auth.data-revision-visitor',compact('userData'));

        return view('auth.complaint',compact('userData'));
    }

    public function insertComplaint (Request $request)
    {
        $request->validate(['title' => ['required',new FilterStringRule],'subject' => ['required',new FilterStringRule]]);
        $userData = User::findOrFail(auth()->user()->id);
        $complaintData = Complain::create(array_merge($request->only('title','subject'),['user_id'=>auth()->user()->id] ));
        if(is_null($complaintData))
        {
            return back();
        }
        else{
            Session::flash('success',trans('home.The complaint has been sent successfully'));
            return redirect()->route('mysessions');
        }
    }


    public function getPlans(Request $request)
    {
        $clientData = Visitor::where('user_id', auth()->user()->id)->firstOrFail();
        $clientSessions =Sessions::where('visitor_id',$clientData->id)->orderBy('start_time','asc')->get()->unique('therapist_id');



        return view('auth.medical-plans',[
            'userData'=>User::with('visitor')->where('id',auth()->user()->id)->first(),
            'clientSessions'=>$clientSessions
        ]);
    }

    public function clientViewPlan (Sessions $client_session)
    {
        $planData = TreatmentPlan::where('session_id',$client_session->id)->first();
//        dd($planData);
        if(is_null($planData))
            return back();
        $sessionsAttend = Sessions::where(['therapist_id'=>$client_session->therapist_id,'visitor_id'=>$client_session->visitor_id,['start_time','>=',$client_session->start_time]])->get();
        return view('auth.display-plan-client')->with([
            'planData'=>$planData,
            'sessionsAttend'=>$sessionsAttend,
            'data'=>Visitor::where('user_id', auth()->user()->id)->firstOrFail(),
        ]);
    }

    public function agreementPlan (Request $request)
    {
        $treatmentPlan = TreatmentPlan::where('session_id',$request->id)->first();
        $treatmentPlan->agreement_client = $request->agreement_client;
        $treatmentPlan->save();
        return response()->json(trans('home.agreement-client-save-successfully'));
    }

    //get client page
    public function getClientMessagePage (Sessions $client_session)
    {
        $treatmentPlan=TreatmentPlan::where('session_id',$client_session->id)->first();
        $allMessages=Message::where('session_id',$client_session->id)->take(3)->latest()->get();
        $lastMessage=Message::where('session_id',$client_session->id)->orderBy('id','DESC')->first();
        return view('auth.client-send-message',[ 
            'userData'=>User::with('visitor')->where('id',auth()->user()->id)->first(),
            'client_session'=>$client_session,
            'lastMessage'=>$lastMessage,
            'allMessages'=>$allMessages,
            'treatmentPlan'=>$treatmentPlan,
        ]);
    }
    //client send message
    public function sendMessage (Request $request,Sessions $client_session)
    {
        $treatmentPlan = TreatmentPlan::where('session_id',$client_session->id)->first();
        Message::create(['therapist_id'=>$treatmentPlan->therapist_id,'visitor_id'=>$treatmentPlan->visitor_id,'treatment_id'=>$treatmentPlan->id,'session_id'=>$client_session->id,'message'=>$request->message,'type'=>$request->type]);
        $treatmentPlan->messages_count += 1;


        if($request->type == 'patient')
        {
            $therapist = Therapist::find($treatmentPlan->therapist_id);
            $visitor = Visitor::find($treatmentPlan->visitor_id);
            $patient = User::find($visitor->user_id);
            $tokens = \DB::table('firebase_tokens')->where('user_id', $therapist->user_id)->pluck('platform_token');

            $userLang = User::find($therapist->user_id);
            if($userLang->lang == 'ar')
            {
                $body = 'العميل   '.$patient->name.'  أرسل لك رسالة  ';
                $this->sendWebNotification('رسالة جديده ...', $body, $client_session->id,$tokens, 'message');
            }
            else
            {
                $body = 'Patient '.$patient->name.' sent you a message';
                $this->sendWebNotification('New Message...', $body, $client_session->id,$tokens, 'message');
            }


            //saveNotifyIntoDatabase [sender => patient , reciever => therapist]
            $saveBody = '<h3>Patient <span>'.$patient->name.'</span> sent you a message</h3>';
            $saveBody_ar = '<h3>العميل  <span>'.$patient->name.'</span> أرسل لك رسالة</h3>';
            $this->saveNotifyIntoDatabase($saveBody, $visitor->id, $therapist->id, $saveBody_ar, $patient->name, $client_session->id, 'message');
        }
        else
        {
            $visitor = Visitor::find($treatmentPlan->visitor_id);
            $therapist = Therapist::find($treatmentPlan->therapist_id);
            $doctor = User::find($therapist->user_id);
            $tokens = \DB::table('firebase_tokens')->where('user_id', $visitor->user_id)->pluck('platform_token');


            $userLang = User::find($visitor->user_id);
            if($userLang->lang == 'ar')
            {
                $body = 'المعالج   '.$doctor->name.'  أرسل لك رسالة ';
                $this->sendWebNotification('رسالة جديده...', $body, $client_session->id, $tokens, 'message');
            }
            else
            {
                $body = 'Doctor '.$therapist->name_e.' sent you a message';
                $this->sendWebNotification('New Message...', $body, $client_session->id, $tokens, 'message');
            }

            
            //saveNotifyIntoDatabase
            $saveBody = '<h3>Doctor <span>'.$doctor->name.'</span> sent you a message</h3>';
            $saveBody_ar = '<h3>المعالج  <span>'.$doctor->name.'</span> أرسل لك رسالة</h3>';
            $this->saveNotifyIntoDatabase($saveBody,$therapist->id, $visitor->id, $saveBody_ar, $doctor->name, $client_session->id, 'message');
        }


        $treatmentPlan->save();
        Session::flash('success',trans('home.The message has been sent successfully'));
        return redirect()->back();
    }



    public function saveNotifyIntoDatabase($body,$sender_id,$reciever_id, $body_ar,$sender_name,$session_id,$type)
    {
        $data = [
            'body' =>$body,
            'body_ar' =>$body_ar,
            'sender_id' =>$sender_id,
            'reciever_id' =>$reciever_id,
            'sender_name' =>$sender_name,
            'session_id' =>$session_id,
            'type' =>$type,
            'created_at' =>date('Y-m-d H:i:s'),
            'updated_at' =>date('Y-m-d H:i:s'),
        ];
        \DB::table('notifications')->insert($data);
    }





    public function sendWebNotification($title,$msg_body, $session_id,$tokens=[], $type)
    {
        $data = '{"notification":{"title":"' . $title . '", "body": "' . $msg_body . '"' . ', "click_action": "FCM_PLUGIN_ACTIVITY"' . '}';
            $data .= ',"data":{"title":"' . $title . '", "body": "' . $msg_body . '","session_id":"' . $session_id . '", "type":"' . $type . '",}';
            $data .= ',"registration_ids":' . $tokens;
            $data .= '}';
            $curl = curl_init();

            $firebase_key = 'key=AAAAVE8vuIo:APA91bFhV7w4-wnqg-MKQttUTLT9Cy-aEZ8gJMPU-fCI1JaBSuvFXXK0yN-FzJuanb1PnHI-4lqpTi9iYVNrHTLdaPCCbG3oTudaJ0jIDBMO2L8FiPDlndbop0fJY2jItJmQYKTcs3it';

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://fcm.googleapis.com/fcm/send',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS =>$data,
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Authorization: ' . $firebase_key
                ),
            ));
            $response = curl_exec($curl);
            curl_close($curl);
    }






    public function clientViewPlanForMobile($user_id,Sessions $client_session)
    {
        $planData = TreatmentPlan::where('session_id',$client_session->id)->first();
        if(is_null($planData))
        {
            return back();
        }


        //setTimeZone(request()->timezone);
        $sessionsAttends = Sessions::where(['therapist_id'=>$client_session->therapist_id,'visitor_id'=>$client_session->visitor_id,['start_time','>=',$client_session->start_time]])->get()->toArray();

        foreach ($sessionsAttends as $x=>$sessionsAttend){
            $sessionsAttends[$x]['start_time']=date('Y-m-d H:i:s',strtotime($sessionsAttend['start_time']));
            $sessionsAttends[$x]['session_date']=date('Y-m-d',strtotime($sessionsAttend['session_date']));
        }

        
        return view('auth.display-plan-client-for-mobile')->with([
            'planData'=>$planData,
            'sessionsAttend'=>$sessionsAttends,
            'data'=>Visitor::where('user_id', $user_id)->firstOrFail(),
        ]);
    }



}
