<?php

namespace App\Http\Controllers;

use App\Sessions;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WherebyController extends Controller
{
    //
    private $_CREATE_MEETING_URL='https://api.whereby.dev/v1/meetings';
    private $_GET_MEETING_URL='https://api.whereby.dev/v1/meetings/';
    private $_API_KEY='';
   public function __construct()
   {
       $this->_API_KEY=config('app.WHEREBY_DEMO_API_KEY');
   }
   public function createMeeting(){
       $timezone='UTC' ;
       setTimeZone($timezone);
       $session=Sessions::find(5810);
       $requestParams=[
           'isLocked'=>true,
           'roomNamePrefix'=>'Meeting-'.$session->id,
           'startDate'=>date($session->start_time,strtotime('-5 minutes')),
           'endDate'=>date($session->start_time,strtotime('+ '.$session->type.' minutes')),
           'fields'=>[
               'hostRoomUrl'
           ]
       ];
       $headerParams=['authorization:Bearer '.$this->_API_KEY];
       $response=self::curlRequest($this->_CREATE_MEETING_URL,'POST',$requestParams,$headerParams,true);
       $session->whereby_startDate=date('Y-m-d H:i:s',strtotime($response->startDate));
       $session->whereby_endDate=date('Y-m-d H:i:s',strtotime($response->endDate));;
       $session->whereby_roomUrl=$response->roomUrl;
       $session->whereby_meetingId=$response->meetingId;
       $session->whereby_hostRoomUrl=$response->hostRoomUrl;
       $session->meeting_provider='whereby';
       $session->save();
       return $session;
   }
   public function getMeeting(){
       $session=Sessions::find(5810);
       $meeting_id=33962666;
       $requestParams=[
           'fields'=>[
               'hostRoomUrl'
           ]
       ];
       $headerParams=['authorization:Bearer '.$this->_API_KEY];
       $response=self::curlRequest($this->_GET_MEETING_URL.$meeting_id,'GET',$requestParams,$headerParams,false);
       dd($response);
   }
    public static function curlRequest($url,$method='GET',$requestParams=[],$headerParams=[],$creatMeeting=false){
        if($creatMeeting){
            $curl = curl_init();
            $headerParams[]= "accept: */*";
            $headerParams[]= "accept-language: en-US,en;q=0.8";
            $headerParams[]= "content-type: application/json";
            $arr=array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30000,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $method,
                CURLOPT_HTTPHEADER => $headerParams,
            );
            if($method=='POST'){
                $arr[CURLOPT_POSTFIELDS]=json_encode($requestParams);
            }
            curl_setopt_array($curl, $arr);
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);

            if ($err) {
                echo "cURL Error #:" . $err;
            } else {
                return json_decode($response);
            }
        }else{
            $content = '';
            if($method=='POST') {
                foreach ($requestParams as $key => $val) {
                    if ($content) {
                        $content .= '&' . $key . '=' . $val;
                    } else {
                        $content .= $key . '=' . $val;
                    }
                }
            }
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $method,
                CURLOPT_POSTFIELDS => $content,
                CURLOPT_HTTPHEADER => $headerParams,
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) {
                echo "cURL Error #:" . $err;
            } else {
                return json_decode($response);
            }
        }

    }
}
