<?php

namespace App\Http\Controllers;

use App\Sessions;
use App\Therapist;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
//code 124
//
class ZoomController extends Controller
{
    private $accessTokenURL='https://zoom.us/oauth/token';
    private $redirectURI='https://demo.newhayah.com/zoom/callback';
//    private $clientID='CulcJplcQ9mSKB0BcZZc3g';
//    private $clientSecret='7yxxFrjk9s6yXfNU1esrJttczFoukB5j';
//    private static $accessToken="eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJhdWQiOm51bGwsImlzcyI6Ill5S3FIVmtFUTBxSk1PSE1DMjNlVWciLCJleHAiOjE2Mzk5OTM5MjAsImlhdCI6MTYwODQ1NTY0MH0.SMSpEWVRVScdma3gvgy5sBgRrWqr8yb8bTkaRwsD2rI";
    private $authURL;
    public function __construct()
    {
        $this->authURL='https://zoom.us/oauth/authorize?client_id='.config('app.ZOOM_CLIENT_ID').'&response_type=code&redirect_uri='.urlencode($this->redirectURI);
    }

    public function callback(Request $request){
        if(!Auth::check()){
            return redirect()->to('/login');
        }

        $code=$request->code;
        if($code){
            $authorizationHeader='Basic '.base64_encode(config('app.ZOOM_CLIENT_ID').':'.config('app.ZOOM_CLIENT_SECRET'));
            $requestParams=[
                'grant_type'=>'authorization_code',
                'code'=>$code,
                'redirect_uri'=>$this->redirectURI,
            ];
            $headerParams=['authorization: '.$authorizationHeader];
            $response=$this->curlRequest($this->accessTokenURL,'POST',$requestParams,$headerParams);
            if(isset($response->error)){
                return redirect()->to($this->authURL);
            }
            $user=Auth::user();
            $user->zoom_token=$response->access_token;
            $user->zoom_refresh_token=$response->refresh_token;
            $user->zoom_expires_in=$response->expires_in;
            $user->zoom_token_date=date('Y-m-d H:i:s');
            $user->save();
            $sessionMeetingID=Session::get('sessionMeetingID');
            if($sessionMeetingID){
                $therapist=Therapist::where('user_id',$user->id)->first();
                if($therapist){
                    $session=Sessions::where('therapist_id',$therapist->id)->find($sessionMeetingID);
                    //dd($session,$sessionMeetingID,$user);
                    if ($session){
                        $session=self::createMeeting($session,$response->access_token);
                        Session::forget('sessionMeetingID');
                        return redirect()->to($session->start_url);
                    }
                }

            }
            return redirect()->back();
            //dd($authorizationHeader,$requestParams,$headerParams,$response);
        }
        return abort(404);
    }
    public function login(){
        return redirect()->to($this->authURL);
    }
    public static function createMeeting_old($session){
        $user=Auth::user();
        $requestParams = [
            'topic' => Auth::user()->name.' Meeting #'.$session->id,
            'start_time' => str_replace(' ',' T ',$session->start_time),
            'duration' => $session->type,
        ];
        $responseUserID=self::curlRequest('https://api.zoom.us/v2/users?access_token='.$user->zoom_token);
        $responseUserID=$responseUserID->users[0]->id;
        $headerParams=['authorization:Bearer '.$user->zoom_token];

        $response=self::curlRequest("https://api.zoom.us/v2/users/$responseUserID/meetings",'POST',$requestParams,$headerParams);
        $session->uuid=$response->uuid;
        $session->meeting_number=$response->id;
        $session->host_id=$response->host_id;
        $session->host_email=$response->host_email;
        $session->topic=$response->topic;
        $session->zoom_start_time=$response->start_time;
        $session->join_url=$response->join_url;
        $session->start_url=$response->start_url;
        $session->password=$response->password;
        $session->h323_password=$response->h323_password;
        $session->encrypted_password=$response->encrypted_password;
        $session->encrypted_password=$response->encrypted_password;
        $session->save();
    }
    public static function createMeeting($session,$token=null){
        //switc(config('app.CREATE_MEETING_PROVIDER')=='')
        switch (config('app.CREATE_MEETING_PROVIDER')){
            case 'whereby':
                self::createWherebyMeeting($session);
                break;
            case 'zoom':
                self::createZoomMeeting($session,$token);
                break;
        }
    }

    public static function createZoomMeeting($session,$token=null){
        $token=($token)?$token:config('app.ZOOM_ACCESS_TOKEN');
        $timezone=(Auth::user()->timezone)?Auth::user()->timezone:'Africa/Cairo' ;
        $requestParams = [
            'type'=> 2,
            'topic' => Auth::user()->name.' Meeting #'.$session->id,
            'start_time' => str_replace(' ',' T ',date($session->start_time,strtotime('-5 minutes'))),
            'duration' => ($session->type+5),
            'timezone' =>$timezone,
        ];
        $responseUserID=self::curlRequest('https://api.zoom.us/v2/users?access_token='.$token);
        try {
            $responseUserID=$responseUserID->users[0]->id;
        }catch (\Exception $e){
            dd($responseUserID,$e);
        }
        $headerParams=['authorization:Bearer '.$token];
        $response=self::curlRequest("https://api.zoom.us/v2/users/$responseUserID/meetings",'POST',$requestParams,$headerParams,true);
        //dd("https://api.zoom.us/v2/users/$responseUserID/meetings",$requestParams,$headerParams,$response);
        $session->uuid=$response->uuid;
        $session->meeting_number=$response->id;
        $session->host_id=$response->host_id;
        $session->host_email=$response->host_email;
        $session->topic=$response->topic;
        $session->zoom_start_time=$response->start_time;
        $session->join_url=$response->join_url;
        $session->start_url=$response->start_url;
        $session->password=$response->password;
        $session->h323_password=$response->h323_password;
        $session->encrypted_password=$response->encrypted_password;
        $session->encrypted_password=$response->encrypted_password;
        $session->meeting_provider='zoom';
        $session->save();
        return $session;
    }
    public static function createWherebyMeeting($session){
        $timezone='UTC' ;
        setTimeZone($timezone);
        $session=Sessions::find($session->id);
        $requestParams=[
            'isLocked'=>false,
            'roomNamePrefix'=>'Meeting-'.$session->id,
            'startDate'=>date($session->start_time,strtotime('-5 minutes')),
            'endDate'=>date($session->start_time,strtotime('+ '.$session->type.' minutes')),
            'fields'=>[
                'hostRoomUrl'
            ]
        ];
        $headerParams=['authorization:Bearer '.config('app.WHEREBY_API_KEY')];
        $response=self::curlRequest('https://api.whereby.dev/v1/meetings','POST',$requestParams,$headerParams,true);
        if(!isset($response->error)){
            $session->whereby_startDate=date('Y-m-d H:i:s',strtotime($response->startDate));
            $session->whereby_endDate=date('Y-m-d H:i:s',strtotime($response->endDate));;
            $session->whereby_roomUrl=$response->roomUrl;
            $session->whereby_meetingId=$response->meetingId;
            $session->whereby_hostRoomUrl=$response->hostRoomUrl;
            $session->meeting_provider='whereby';
            $session->save();

        }
        return $session;
    }





    public static function curlRequest($url,$method='GET',$requestParams=[],$headerParams=[],$creatMeeting=false){
        if($creatMeeting){
            $curl = curl_init();
            $headerParams[]= "accept: */*";
            $headerParams[]= "accept-language: en-US,en;q=0.8";
            $headerParams[]= "content-type: application/json";
            $arr=array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30000,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $method,
                CURLOPT_HTTPHEADER => $headerParams,
            );
            if($method=='POST'){
                $arr[CURLOPT_POSTFIELDS]=json_encode($requestParams);
            }
            curl_setopt_array($curl, $arr);
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);

            if ($err) {
                echo "cURL Error #:" . $err;
            } else {
                return json_decode($response);
            }
        }else{
            $content = '';
            if($method=='POST') {
                foreach ($requestParams as $key => $val) {
                    if ($content) {
                        $content .= '&' . $key . '=' . $val;
                    } else {
                        $content .= $key . '=' . $val;
                    }
                }
            }
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $method,
                CURLOPT_POSTFIELDS => $content,
                CURLOPT_HTTPHEADER => $headerParams,
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) {
                echo "cURL Error #:" . $err;
            } else {
                return json_decode($response);
            }
        }

    }
    public function loginCreateMeeting($session_id){
        Session::put('sessionMeetingID',$session_id);
        return redirect()->to($this->authURL);
    }
}
