<?php

namespace App\Http\Middleware;

use App\Profiles;
use Closure;
use App\User;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Route;
use Stevebauman\Location\Facades\Location;
use Illuminate\Support\Facades\Lang;

class FrontPagesApi
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        // if (!$request->secure()) {
        //     return redirect()->secure($request->getRequestUri());
        // }

        // if(request()->header('lang') == 'ar')
        // {
        //     $lang = 'ar';
        //     Lang::setLocale($lang);
        // }
        // else
        // {
        //     $lang = 'en';
        //     Lang::setLocale($lang);
        // }

        $ipaddress = '';
            if (isset($_SERVER['HTTP_CLIENT_IP'])) {
                $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
            } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
            } else if (isset($_SERVER['HTTP_FORWARDED'])) {
                $ipaddress = $_SERVER['HTTP_FORWARDED'];
            } else if (isset($_SERVER['REMOTE_ADDR'])) {
                $ipaddress = $_SERVER['REMOTE_ADDR'];
            } else {
                $ipaddress = 'UNKNOWN';
            }
        


        if(auth('api')->check()){ 
            if(auth('api')->user()->type=='therapists'){
                // $timezone='Asia/Dubai' ; //static
                $timezone=(auth('api')->user()->timezone)?auth('api')->user()->timezone:'Africa/Cairo' ;
                setTimeZone($timezone);
            }else{
                $location=json_decode(file_get_contents('http://ip-api.com/json/' . $ipaddress));
                $timezone=(isset($location->timezone))?$location->timezone:'Africa/Cairo';
                setTimeZone($timezone);
            }
        }else{
            $location=json_decode(file_get_contents('http://ip-api.com/json/' . $ipaddress));
            $timezone=(isset($location->timezone))?$location->timezone:'Africa/Cairo';
            setTimeZone($timezone);
        }
        return $next($request);
    }
}
