<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

use App\Rules\FilterStringRule;

class InsertRecommendation extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'email'=>['required','email'],
            'service_type'=> [new FilterStringRule],
            'ans2'=> ['required',new FilterStringRule],
            'ans3'=> ['required',new FilterStringRule],
        ];
    }


    public function messages()
    {
        return [
            'email.email'=>trans('home.must-email'),
            'email.unique'=>trans('home.unique-email'),
            'ans1.required' => trans('home.ans-required'),
            'ans2.required' =>  trans('home.ans-required'),
            'ans3.required' => trans('home.ans-required'),
            'ans4.required' =>  trans('home.ans-required'),
            'ans5.required' =>  trans('home.ans-required'),
            'ans6.required' =>  trans('home.ans-required'),
            'ans7.required' =>  trans('home.ans-required'),
            'ans8.required' =>  trans('home.ans-required'),
            'ans9.required' =>  trans('home.ans-required'),
            'ans10.required' =>  trans('home.ans-required'),

        ];
    }
}
