<?php

namespace App\Http\Requests;

use App\Rules\SessionStartTime;
use Illuminate\Foundation\Http\FormRequest;

class InsertSessionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'type' => ['required'],
            'start_time' => ['required','date','after:today', new SessionStartTime],
            //'color' => ['required','string'],
            //'text_color' => ['required','string'],
        ];
    }
    public function messages()
    {
        return [
            'type.required' => 'من فضلك اختر نوع الجلسة',
            'start_time.required' => 'من فضلك ادخل الوقت والتاريخ',
            'start_time.date' => 'يجب ادخال تاريخ',
            'start_time.after'=> 'يجب ان تكون الجلسة بعد اليوم',
            'color.required'=> 'يجب ادخال لون الخلفية',
            'text_color.required' => 'يجب ادخال لون النص',
        ];
    }

}
