<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

use App\Rules\FilterStringRule;

class StoreTherapistReg extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(\Illuminate\Http\Request $request)
    {
        //dd($request->file('resume')->getClientMimeType());
        return [
            'name_e'=> ['string','max:150',new FilterStringRule],
            'name_a'=> ['string','max:150',new FilterStringRule],
            //'license_no'=> ['integer','numeric','min:1'],
            //'license_org'=> ['string','max:150',new FilterStringRule],
//            'birth'=>['before:30 years ago'],
            'years'=> ['numeric','min:1'],
            'price30'=> ['integer','numeric','not_in:0','min:1'],
            'price60'=> ['integer','numeric','not_in:0','min:1','gt:price30'],
            'thirty_price_dollar'=> ['integer','numeric','not_in:0','min:1'],
            'sixty_price_dollar'=> ['integer','numeric','not_in:0','min:1','gt:thirty_price_dollar'],
            'speciality_id.0'=> ['integer','not_in:0'],
            'country_id'=> ['integer','not_in:0'],
            'gender'=> ['string',new FilterStringRule],
            'language_id'=> ['integer','not_in:0'],
            'resume' => ['max:2048'],
            'licence' => ['image','mimes:png,jpg,jpeg','max:2048'],
            'certificates' => ['file','mimes:zip','max:2048'],
        ];
    }

    public function messages()
    {
        return [
            'license_no.min' => trans('home.min'),
            'years.min' => trans('home.min'),
            'price30.min' => trans('home.min'),
            'price60.min' => trans('home.min'),
            'price60.gt'=>trans('home.gt'),
//            'birth.before' => trans('home.before'),
            'resume.mimes' => trans('home.resume-type'),
            'resume.max'=>trans('home.upload-max'),
            'resume.image'=>trans('home.licence-image'),
            'licence.image'=>trans('home.licence-image'),
            'licence.mimes'=>trans('home.licence-mimes'),
            'licence.max'=>trans('home.upload-max'),
            'certificates.mimes'=>trans('home.zip-mimes'),
            'certificates.max'=>trans('home.upload-max'),
        ];
    }
}
