<?php

namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use App\Rules\FilterStringRule;


class UpdateVisitorProfile extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
           // 'name'=> ['string','max:50',new FilterStringRule,'unique:users,name,'.auth()->user()->id],
            'email'=> ['email','max:50',new FilterStringRule,'unique:users,email,'.auth()->user()->id.',id,deleted_at,NULL'],
            'mobile'=> ['nullable','min:11','numeric','not_in:0','unique:visitors,mobile,'.auth()->user()->visitor->id],
            'birthyear'=> ['required','nullable','integer','not_in:0'],
            'password'=> ['nullable','min:8',
//                'regex:/[a-z]/',      // must contain at least one lowercase letter
//                'regex:/[A-Z]/',      // must contain at least one uppercase letter
//                'regex:/[0-9]/',      // must contain at least one digit
//                'regex:/[@$!%*#?&]/', // must contain a special character
            ],
            'confirm-password'=>'same:password',
            'picture'=>['image','mimes:png,jpg,jpeg','max:2048'],
        ];
    }

    public function messages()
    {
        return [
            'email.email'=>trans('home.visitor-email'),
            'email.unique'=>trans('home.email-unique'),
            'name.unique'=>trans('home.name-unique'),
            'mobile.required'=>trans('home.ans-required'),
            'mobile.unique'=>trans('home.mobile-unique'),
            'mobile.min'=>trans('home.mobile-min'),
            'password.min'=>trans('home.min-password'),
            'password.regex'=>trans('home.password-regex'),
            'confirm-password.same'=>trans('home.same-password'), 
            'picture.mimes' => trans('home.picture-type'),
            'picture.max' => trans('home.picture-max'),
            'picture.image' => trans('home.image'),
            'birthyear.required' => trans('home.birthyear-required'),
            'birthyear.before' => trans('home.visitor-before',['age'=>70]),
            'birthyear.integer'=>trans('home.birth-Integer'),
            'birthyear.not_in'=>trans('home.birth-not-zero'),
        ];
    }
}
