<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class MessageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'message'=>$this->message,
            'answer'=>$this->answer,
            'created_at'=>$this->created_at,
            'type'=>$this->type,
            'visitors'=>[
                'id'=>$this->visitors->id,
                'user'=>[
                    'id'=>$this->visitors->user->id,
                    'name'=>$this->visitors->user->name,
                ],
            ],
            'therapists'=>[
                'id'=>$this->therapists->id,
                'title'=>$this->therapists->title,
                'name_e'=>$this->therapists->name_e,
                'name_a'=>$this->therapists->name_a,
                'picture'=>asset('/avatars/therapists/'.$this->therapists->picture),
            ]
        ];
    }
}
