<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Languages extends Model
{
    //use SoftDeletes;

    protected $table = 'languages';

    protected $fillable = [
        'title_ar',
        'title_en',
        'active',
    ];

    public function scopeActive($query)
    {
        return $query->where('active', 1);
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
