<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class MainFocus extends Model
{
    protected $table='main_focus';
   protected $guarded=[];

    public function scopeActive($query)
    {
        return $query->where('active', 1);
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
