<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Message extends Model
{
    protected $table = "messages";

    protected $fillable = [
        'therapist_id',
        'visitor_id',
        'treatment_id',
        'session_id',
        'message',
        'type'
    ];

    protected $append = ['therapist_image'];

    public function visitors()
    {
        return $this->belongsTo(Visitor::class , 'visitor_id')->with('user');
    }

    public function therapists()
    {
        return $this->belongsTo(Therapist::class , 'therapist_id');
    }




    public function getTherapistImageAttribute()
    {
         return asset('avatars/therapists/'.$this->therapists->picture);
    }


    protected static function boot()
    {
        parent::boot();
        // static::updated(function ($model) {
        //     log_admin_action('update',$model);
        // });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
