<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Payments extends Model
{
    protected $table = 'payments';

    protected $guarded = [];

    public function therapist()
    {
        return $this->belongsTo(Therapist::class,'therapist_id','id');

    }//end fo Therapist

    public function user()
    {
        return $this->belongsTo(User::class,'user_id','id')->with('visitor');

    }//end fo user

    public function sessions()
    {
        return $this->belongsTo(Sessions::class,'session_id','id')->withTrashed();

    }//end fo user

}

