<?php

namespace App\Providers;

use App\Service;
use Illuminate\Support\ServiceProvider;
use App\Reviews;
use App\WebsiteRating;
use Illuminate\Support\Facades\Schema;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);
        $services = Service::get();
        view()->share('services', $services);
        $testimonial = /*array();/*/WebsiteRating::inRandomOrder()->limit(8)->get();
        view()->share('testimonial', $testimonial);
    }
}
