<?php

namespace App;
use Illuminate\Database\Eloquent\Model;

class QuestionChoicePoint extends Model
{
    protected $table="scales_questions_choices_points";

    protected $fillable=['scale_id','scales_question_id','scales_choice_id','point','add_by','add_date','lastedit_by','lastedit_date','email'];

    //relationships
    public function scale ()
    {
        return $this->belongsTo(Scale::class,'scale_id');
    }

    public function scalesQuestions ()
    {
        return $this->belongsTo(ScaleQuestion::class,'scales_question_id');
    }

    public function scalesChoices ()
    {
        return $this->belongsTo(ScaleChoice::class,'scales_choice_id');
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
