<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\RecommendationType;

class Recommendation extends Model
{
    protected $table="recommendation";
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'question',
        'answer',
        'service_type_id'
    ];

    //relationships
    public function RecommendationTypes()
    {
        return $this->belongsTo(RecommendationType::class,'service_type_id');
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
