<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class RecommendationType extends Model
{
    protected  $table="recommendation_types";

    protected  $fillable=['service_type','email', 'speciality_id', 'gender'];

    //relationships
    public function recommendations()
    {
        return $this->hasMany(Recommendation::class,'service_type_id');
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
