<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use TheSeer\Tokenizer\Exception;

class Reviews extends Model
{
    protected $fillable = [
        'therapist_id',
        'visitor_id',
        'session_id',
        'comment',
        'rating',
        'answer1',
        'answer2',
        'answer3',
        'answer4',
    ];


    public function therapist()
    {
        return $this->belongsTo(Therapist::class,'therapist_id')->with('user');
    }

    public function visitor()
    {
        return $this->belongsTo(Visitor::class,'visitor_id')->with('user');
    }

    public function session()
    {
        return $this->belongsTo(Sessions::class,'session_id');
    }

    public function ReQuestionAnswers ()
    {
        return $this->hasMany(ReviewsQuestionAnswer::class,'review_id','id');
    }

//    public static function getReviewsData($allReviews)
//    {
//        foreach ($allReviews as  $review)
//        {
//            $allResult [] =array_merge(DB::select( DB::raw("SELECT DISTINCT users.name, users.email FROM users INNER JOIN therapists ON users.id = therapists.user_id INNER JOIN
//                       sessions ON therapists.id = sessions.therapist_id
//                       where sessions.therapist_id  = $review->therapist_id")),
//                ['comment'=>$review->comment,'rating'=>$review->rating,'id'=>$review->id,'answer1'=>$review->answer1,'answer2'=>$review->answer2,'answer3'=>$review->answer3,'answer4'=>$review->answer4] );
//        }
//        return $allResult;
//    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
