<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ReviewsQuestionAnswer extends Model
{
    protected $table = "reviews_question_answer";

    protected $fillable = ['review_id','question','answer'];

    public function reviews ()
    {
        return $this->belongsTo(Reviews::class , 'review_id');
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
