<?php

namespace App\Rules;

use Carbon\Carbon;
use Illuminate\Contracts\Validation\Rule;

class SessionStartTime implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        // return Carbon::now()<Carbon::create($value)->add('-15 minutes');
        return Carbon::parse($value)->toDateTimeString() > Carbon::now()->addHours(24)->toDateTimeString();
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'يجب ان يكون المعاد بعد 24 ساعة من الان';
    }
}
