<?php

namespace App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Session;

class Scale extends Model
{
    static $always = 4;
    static $sometimes = 3;
    static $rarely = 3;
    static $never = 1;

    protected $table="scales";

    protected $fillable=['name_en','description_en','nominations_en','duration_en','instructions_en','note_en', 'name_ar', 'description_ar', 'type', 'nominations_ar',
        'duration_ar', 'is_free', 'instructions_ar','note_ar','active', 'active_by', 'active_date', 'unactive_by', 'unactive_date', 'add_by', 'add_date', 'lastedit_by',
        'lastedit_date'
        ];

    //relations
    public function scalesQuestions ()
    {
        return $this->hasMany(ScaleQuestion::class,'scales_id');
    }

    public function scaleChoices()
    {
        return $this->hasMany(ScaleChoice::class,'scales_id');
    }

    //static methods
    public static function InsertQuestionAnswerPoints ($request)
    {
        $messageInfo='';
        $scaleEmail = ScaleEmail::create($request->only('email','scale_id','scale_name'));
        foreach ($request->question as $key=>$value)
        {
            ScaleQuestionAnswers::create([
                'scale_id'=>$request->scale_id,
                'scales_question_id'=>$request->question[$key],
                'scales_choice_id'=>$request->answer[$key],
                'point'=>Scale::getPointValue($request->answer[$key]),
                'point_l'=>Scale::getPointValue($request->answer[$key],'L'),
                'point_e'=>Scale::getPointValue($request->answer[$key],'E'),
                'point_n'=>Scale::getPointValue($request->answer[$key],'N'),
                'point_p'=>Scale::getPointValue($request->answer[$key],'P'),
                'test_id'=> $scaleEmail->id
            ]);
        }
        $scaleEmail->sum_points=$scaleEmail->ScaleQuestionAnswers->sum('point');
        $scaleEmail->sum_points_l=$scaleEmail->ScaleQuestionAnswers->sum('point_l');
        $scaleEmail->sum_points_e=$scaleEmail->ScaleQuestionAnswers->sum('point_e');
        $scaleEmail->sum_points_n=$scaleEmail->ScaleQuestionAnswers->sum('point_n');
        $scaleEmail->sum_points_p=$scaleEmail->ScaleQuestionAnswers->sum('point_p');
        $messageInfo = Scale::getStatusMessage($scaleEmail->sum_points,$request);
        $scaleEmail->message=$messageInfo;
        $scaleEmail->save();
        return $scaleEmail;
    }

    public static function  getPointValue ($pointValue,$type='normal')
    {
        $dataPointObj = QuestionChoicePoint::where('scales_choice_id',$pointValue)->where('type',$type)->first();
        if(is_null($dataPointObj))
            return 0;
        $point = $dataPointObj->point;
        return $point;
    }

    public static function getStatusMessage ($pointValue,$request)
    {
        $pointData = ScaleMessage::where('from_point','<=',$pointValue)->where('to_point','>=',$pointValue)->where('scales_id',$request->scale_id)->first();
        if(is_null($pointData))
            return null;
        return $pointData->message_ar;
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
