<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ScaleChoice extends Model
{
    protected $table="scales_choices";

    protected $fillable=['scales_id','name','add_by','add_date','lastedit_by','lastedit_date'];

    //relations
    public function scales()
    {
        return $this->belongsTo(Scale::class,'scales_id');
    }

    public function QuestionChoicePoints ()
    {
        return $this->hasMany(QuestionChoicePoint::class,'scales_choice_id','id');
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
