<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ScaleEmail extends Model
{
    protected $table="scale_emails";

    protected $fillable = ['scale_name','scale_id','email','sum_points'];

    //relationships
    public function ScaleQuestionAnswers ()
    {
        return $this->hasMany(ScaleQuestionAnswers::class , 'test_id','id');
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
