<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ScaleMessage extends Model
{
    protected $table="scales_messages";

    protected $fillable=['scale_id','message_ar','message_en','	from_point','to_point'];

    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
