<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ScaleQuestionAnswers extends Model
{
    protected $table="scale_question_answers";

    protected $fillable=['scale_id','scales_question_id','scales_choice_id','scales_question_name','scales_choice_name','point','point_l','point_e','point_n','point_p','test_id'];
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
