<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SessionsQuestionAnswer extends Model
{
    protected $table = "sessions_question_answer";
    protected $fillable=['session_id','question','answer','note'];
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
