<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class StaticPage extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */

    protected $table="static_pages";

    protected $fillable = [
        'title',
        'body',
        'url',
        'active'
    ];
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
