<?php

namespace App;

use App\Reviews;
use App\Sessions;
use Illuminate\Container\RewindableGenerator;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Collection;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class Therapist extends Model
{
//UPDATE `therapists` SET url=CASE WHEN name_e IS NOT NULL THEN REPLACE(name_e,' ','-') ELSE REPLACE(name_a,' ','-') END -- WHERE user_id=182
    protected $fillable = [
        'user_id',
        'title',
        'name_e',
        'name_a',
        'years',
        'licence',
        'license_no',
        'license_org',
        'gender',
        'birth',
        'picture',
        'resume',
        'zip_certificates',
        'summery_ar',
        'description_ar',
        'summery_en',
        'description_en',
        'price30',
        'price60',
        'country_id',
        'rating',
        'numrating',
        'active',
        'main_specialty_ar',
        'main_specialty_en',
        'experience_ar',
        'experience_en' ,
        'certifications_ar' ,
        'certifications_en',
        'thirty_price_dollar',
        'sixty_price_dollar',
        'language_id',
        'main_focus',
        'mobile',
        'zip_certificates_file_name',
        'resume_file_name',
        'picture_file_name',
        'licence_file_name',
    ];

    protected $appends = ['session_count','main_focus_en'];

    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
            updateTherapistUrl($model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
            updateTherapistUrl($model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
            updateTherapistUrl($model);
        });
    }


    public function reservations()
    {
        return $this->hasMany(Reservation::class);
    }

    public function sessions()
    {
        return $this->hasMany(Sessions::class,'therapist_id');
    }

    public function reviews()
    {
        return $this->hasMany(Reviews::class,'therapist_id');
    }

    public function specialties()
    {
        return $this->hasMany(Therapists_specialties::class,'therapist_id')->join('specialties','specialties.id','=','therapists_specialties.speciality_id');
    }

    public function certificates()
    {
        return $this->hasMany(Certificates::class,'therapist_id');
    }

    public function experiences()
    {
        return $this->hasMany(TherapistsExperiences::class,'therapist_id');
    }

    public function languages()
    {
        return $this->hasMany(Therapists_languages::class,'therapist_id')->join('languages','languages.id','=','therapists_languages.language_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }

    public function country()
    {
        return $this->belongsTo(Countries::class,'country_id');
    }
    public function language()
    {
        return $this->belongsTo(Languages::class,'language_id');
    }
    public function treatment_plans()
    {
        return $this->hasMany(TreatmentPlan::class,'therapist_id');
    }

    //static functions
    public static function getClientData ($sessionsData)
    {
        $uniqueClients = array();
        $visitorIDS = array();
        foreach($sessionsData as $sessionsInfo)
        {
            $visitorId = $sessionsInfo->visitor_id;
            $visitorIDS[] = $visitorId;
        }
        $uniqueClients = array_unique($visitorIDS);
        return $uniqueClients;
    }

    public function scopeActive($query)
    {
        return $query->where(function($q){$q->where('active', 1)->where('archive',0);});
    }





    public function therapistsPictures()
    {
        return $this->hasMany(TherapistsPictures::class,'therapists_id','id');

    }//end of TherapistsPictures

    public function therapistsRequests()
    {
        return $this->hasMany(TherapistsRequests::class,'therapists_id','id')->with('user');

    }//end of TherapistsRequests



    public function getSessionCountAttribute()
    {
        return $this->sessions->whereIn('session_status',['reserved','closed'])->count() + 25;
    }


    public function getMainFocusEnAttribute()
    {
        // if($this->main_focus != null)
        // {
        //     $string='';

        //    foreach(explode(',', $this->main_focus) as $info)
        //    {
        //         $main = \App\MainFocus::where('title_ar', 'LIKE', '%'.$info.'%')->first();
        //         if($main)
        //         {
        //             $string .= $main->title_en.',';
        //         }
        //    }
        //    return $string;
        // }

    }


}
