<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Sessions;

class TherapistsInvoices extends Model
{

    protected $appends = ['therapist_start'];
    //
    use SoftDeletes;
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }


    public function sessionInvoice()
    {
        return $this->belongsTo(Sessions::class, 'session_id');
    }



    public function getTherapistStartAttribute()
    {
        $therapist_start_session = false;
        $session = Sessions::whereId($this->session_id)->first();
        if($session->therapist_start_date != null || $session->therapist_start_date != '')
        {
            $therapist_start_session = true;
        }
        else
        {
            $therapist_start_session = false;
        }
        return $therapist_start_session;
    }


}
