<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class TherapistsMainFocus extends Model
{
    protected $table='therapists_main_focus';
   protected $guarded=[];

    public function therapist()
    {
        return $this->belongsTo(Therapist::class,'therapist_id')->with('therapistsRequests');
    }

    public function mainFocus()
    {
        return $this->belongsTo(MainFocus::class,'main_focus_id');
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
