<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class TherapistsQuestions extends Model
{
    //
    protected $fillable=[
      'user_id',
      'therapist_id',
      'works_hours',
      'offered_psychological_internet',
      'experience',
      'speciality_id',
      'defects',
      'contribute',
      'most_effective',
    ];
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
