<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TherapistsRequests extends Model
{
    use SoftDeletes;
    protected $guarded=[];



    public function therapist()
    {
        return $this->belongsTo(Therapist::class,'therapists_id','id')->with('specialties')->with('languages');

    }//end fo Therapist

    public function therapistto()
    {
        return $this->belongsTo(Specialties::class,'to','id');
    }//end fo therapistto


    public function languagefrom()
    {
        return $this->belongsTo(Languages::class,'from','id');
    }//end fo languagefrom

    public function languageto()
    {
        return $this->belongsTo(Languages::class,'to','id');
    }//end fo languageto

    public function countaryfrom()
    {
        return $this->belongsTo(Countries::class,'from','id');
    }//end fo languagefrom

    public function countaryto()
    {
        return $this->belongsTo(Countries::class,'to','id');
    }//end fo languageto

}
