<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class TherapistsSpecialties extends Model
{

   protected $table = 'therapists_specialties';

    protected $fillable = [

        'therapist_id',

        'speciality_id',

    ];
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
