<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Therapists_languages extends Model
{
    protected $table = 'therapists_languages';

    protected $fillable = [

        'therapist_id',

        'language_id',

    ];

    public function therapist()
    {
        return $this->belongsTo(Therapist::class,'therapist_id');
    }

    public function language()
    {
        return $this->belongsTo(Languages::class,'language_id');
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
