<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Therapists_specialties extends Model
{
    protected $fillable = [
        'therapist_id',
        'speciality_id'
    ];

    public function therapist()
    {
        return $this->belongsTo(Therapist::class,'therapist_id')->with('therapistsRequests');
    }

    public function speciality()
    {
        return $this->belongsTo(Specialties::class,'speciality_id');
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
