<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TreatmentPlan extends Model
{
    use SoftDeletes;

    protected $table = 'treatment_plans';

    protected $fillable = [
        'therapist_id',
        'visitor_id',
        'session_id',
        'serial_number',
        'age',
        'gender',
        'problem',
        'problem_description',
        'diagnostic',
        'therap_evaluation',
        'long_term',
        'short_term',
        'therapeutic_intervention',
        'transfer',
        'current_status',
        'last_visit',
        'homework',
        'agreement_client',

        'client_name_pdf' , 'age_pdf' , 'gender_pdf' , 'problem_pdf' , 'therap_evaluation_pdf' , 'diagnostic_pdf' , 'therapeutic_intervention_pdf' , 'problem_description_pdf' , 'homework_pdf' , 'table_pdf' , 'long_term_pdf' , 'short_term_pdf' , 'transfer_pdf' , 'current_status_pdf' , 'last_visit_pdf' , 'therapist_name_pdf',

        ];
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }


    public function diagnosis()
    {
        return $this->hasMany("App\TreatmentPlansDiagnosis", 'treatment_plan_id')->join('diagnosis', 'diagnosis.id', '=', 'treatment_plans_diagnosis.diagnosis_id');
    }
    public function treatments()
    {
        return $this->hasMany("App\TreatmentPlansTreatments", 'treatment_plan_id')->join('treatments', 'treatments.id', '=', 'treatment_plans_treatments.treatments_id');
    }


}
