<?php

namespace App;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use App\Notifications\ResetPasswordNotification;
use Illuminate\Support\Facades\DB;
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use Notifiable,SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'type', 'name', 'email', 'password','verifyToken','active','agreement','qualification','cv'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function reviews()
    {
        return $this->hasMany(Reviews::class,'visitor_id');
    }

    public function therapist()
    {
        return $this->hasOne(Therapist::class,'user_id','id');
    }

    public function visitor()
    {
        return $this->hasOne(Visitor::class,'user_id','id')->with('sessions');
    }


    public function Payments()
    {
        return $this->hasOne(Payments::class,'user_id','id')->with('visitor');
    }


    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

    public static function visitorProfile($id)
    {
        return DB::table('users')
            ->leftJoin('visitors','visitors.user_id','=','users.id')
            ->select('users.*', 'visitors.*')
            ->where('users.id', $id)->get()->first();
    }
    public static function therapistProfile($id)
    {
        return DB::table('users')
            ->leftJoin('therapists','therapists.user_id','=','users.id')
            ->select('users.*', 'therapists.*')
            ->where('users.id', $id)->get()->first();
    }

    public function scopeActive($query)
    {
        return $query->where('active', 1);
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }

}
