<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Visitor extends Model
{
    protected $table="visitors";

    protected $fillable = [
        'user_id',
        'gender',
        'wallet',
        'birthyear',
        'mobile',
        'image',
        'active'
    ];

    public function user()
    {
        return $this->belongsTo(User::class,'user_id','id');
    }

    public function sessions()
    {
        return $this->hasMany(Sessions::class,'visitor_id','id');
    }

    public function reviews()
    {
        return $this->hasMany(Reviews::class,'visitor_id');
    }

    public function treatment_plans()
    {
        return $this->hasMany(TreatmentPlan::class,'visitor_id');
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
