<?php

namespace App;
use Illuminate\Database\Eloquent\Model;

class WebsiteRating extends Model
{
    protected $table="website_rating";

    protected $fillable = ['comment','rating','user_id'];

    public function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
