<?php

use App\Payments;
use App\WebsiteLanguages;
use App\Translations;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Stevebauman\Location\Facades\Location;

function diffBetweenTwoDates($fdate,$tdate,$format='%h'){
    $datetime1 = new DateTime($fdate);
    $datetime2 = new DateTime($tdate);
    $interval = $datetime1->diff($datetime2);
    return$interval->format($format);
}
function save_trans($table,$table_id,$language_id,$language_short_name,$key,$value){
    if(!empty($value)){
        $trans = new Translations();
        $t='table';
        $trans->$t = $table;
        $trans->table_id = $table_id;
        $trans->language_id = $language_id;
        $trans->short = $language_short_name;
        $trans->key = $key;
        $trans->value = $value;
        $trans->save();
    }
}
function getAge($bithdayDate){
    $date = new DateTime($bithdayDate);
    $now = new DateTime();
    $interval = $now->diff($date);
    return $interval->y;
}
function save_all_trans($data,$id,$table,$fields){
    $default_lang=WebsiteLanguages::where('default','=',1)->first();
    Translations::where('table_id','=',$id)->where('table','=',$table)->forceDelete();
    foreach ($fields as $k=>$v){
        save_trans($table,$id,$default_lang->id,$default_lang->short,$k,$data[$k]);
    }
    if(isset($data['languages'])) {
        foreach ($data['languages'] as $key => $val) {
            $l = WebsiteLanguages::find($val);
            if ($l) {
                foreach ($fields as $key1=>$val1){
                    save_trans($table, $id, $val, $l->short, $key1, $data[$val1][$key]);
                }
            }
        }
    }
}

function save_front_trans($data,$id,$table){
    Translations::where('table_id','=',$id)->where('table','=',$table)->forceDelete();
    $languages = WebsiteLanguages::pluck('short','id');
    foreach ($data as $key=>$val){
        foreach ($languages as $l_key=>$l_val){
            save_trans($table,$id,$l_key,$l_val,$key,$val[$l_val]);
        }
    }
}

function get_language_trans($id,$table){
    $languages=WebsiteLanguages::orderBy('default','desc')->get();
    foreach($languages as $language){
        $res = Translations::where('table_id','=',$id)->where('table','=',$table)->where('language_id','=',$language->id)->get();
        if(count($res)){
            $trans=new Translations();
            foreach($res as $t){
                $key=$t->key;
                $trans->$key=$t->value;
            }
            $language->res = $trans;
        }
    }
    return $languages;
}

function __trans($id,$key,$type='',$local=''){
    $l_code = Lang::locale();
    if(!empty($local)) $l_code = $local;
    if($l_code == 'en'){
        if($type != 'name' && $type != 'description'){
            $value = DB::table($type)->where('id',$id)->value($key);
            if(!empty($value)) return $value;
        }
    } else{
        $con = ['table_id'=>$id, 'table'=>$type, 'key'=>$key, 'short'=>$l_code];
        $value = Translations::where($con)->value('value');
        if(!empty($value)) return $value;
        else return __trans($id,$key,$type,'en');
    }
    return '';
}

function convertToDateTimeLocal($date){
    return (!empty($date)&&$date!='0000-00-00 00:00:00')?date("Y-m-d",strtotime($date)).'T'.date("H:i:s",strtotime($date)):'';
}
function PerUser($val){
    $UserPermissionsData=\Illuminate\Support\Facades\Request::get('UserPermissionsData');
    return(isset($UserPermissionsData->$val)&&$UserPermissionsData->$val)?true:false;
}
function timeAgo ($time)
{
    $time=strtotime($time);
    $time = time() - $time; // to get the time since that moment
    $time = ($time<1)? 1 : $time;
    $tokens = array (
        31536000 => 'year',
        2592000 => 'month',
        604800 => 'week',
        86400 => 'day',
        3600 => 'hour',
        60 => 'minute',
        1 => 'second'
    );
    foreach ($tokens as $unit => $text) {
        if ($time < $unit) continue;
        $numberOfUnits = floor($time / $unit);
        return $numberOfUnits.' '.$text.(($numberOfUnits>1)?'s':'');
    }
}
function makeDefaultImage($post,$name){
    if(!(!empty($post->img_dir)&&!empty($post->img)&&file_exists(public_path($post->img_dir.$post->img)))){
        $post->img_dir='/img/'.$name.'/';
        $post->img='default_image.png';
    }
    return$post;
}
function userSystem(){
    $system=\App\SystemSettings::where('user_id',Auth::user()->id)->first();
    if(empty($system)){
        $system=new \App\SystemSettings();
        $system->user_id=Auth::user()->id;
        $system->backend_lang='en';
        $system->save();
    }
    return$system;
}
function getUserSystem($pars){
    $userSystemData=\Illuminate\Support\Facades\Request::get('UserSystem');
    return (isset($userSystemData->$pars))?$userSystemData->$pars:'';
}
function byUser($user_id,$string=null){
    $user=DB::table('users')->where('id',$user_id)->first();

    if(!empty($user)){
        if($user->img_dir==''||$user->img==''){
            $user->img_dir='img/Users/';
            $user->img='default_user.png';
        }
        return'<div class="zoom_img"><img class="img-polaroid " src="'.asset($user->img_dir.$user->img).'" data-toggle="tooltip" data-placement="top" title="" data-original-title="'.$string.$user->name.'"></div>';
    }
    return Lang::get('main.no_image');
}
function byAppUser($user_id,$string=null){
    $user=\App\AppUsers::find($user_id);
    if(!empty($user)){
        if($user->img_dir==''&&$user->img==''){
            $user->img_dir='img/Users/';
            $user->img='default_user.png';
        }
        return'<div class="zoom_img"><img class="img-polaroid " src="'.asset($user->img_dir.$user->img).'" data-toggle="tooltip" data-placement="top" title="" data-original-title="'.$string.' { '.Lang::get('main.'.$user->type).' } '.$user->name.'"></div>';
    }
    return Lang::get('main.no_image');
}
function FileImage($file,$folder_name,$input_name='image'){
    $path = '/'.$folder_name.'/';
    if (!file_exists(public_path() . $path)) {
        File::makeDirectory(public_path() . $path, $mode = 0777, true, true);
    }
//    if (!file_exists(public_path() . $path.'thumbnail')) {
//        File::makeDirectory(public_path() . $path.'thumbnail', $mode = 0777, true, true);
//    }
    //file new name
    $namefile = $folder_name.'_' . rand(0000, 9999) . '_' . time();
    //file extension
    $ext = $file->getClientOriginalExtension();
    //file old name
//    $old_name = $file->getClientOriginalName();
    //convert the size of the file
    //$size = ImageUploader::GetSize($file->getSize());
    //get the mime type of the file
//    $mimtype = $file->getMimeType();
    //making the new name with extension
    $mastername = $namefile . '.' . $ext;
//    list($width, $height, $type, $attr) = getimagesize($_FILES[$input_name]['tmp_name']);
//    $width_per=round(($width*10)/100);
//    $height_per=round(($height*10)/100);
    $file->move(public_path() . $path, $mastername);
//    Image::make(public_path() . $path  . $mastername, array(
//        'width' => $width_per,
//        'height' => $height_per,
//    ))->save(public_path() . $path . 'thumbnail/thumbnail_' . $mastername);
    return array('img'=>$mastername,'img_dir'=>$path);
}
function FileImages($file,$folder_name,$x,$input_name='images'){
    $path = '/img/'.$folder_name.'/' . date('Y/m/d').'/';
    if (!file_exists(public_path() . $path)) {
        File::makeDirectory(public_path() . $path, $mode = 0777, true, true);
    }
    if (!file_exists(public_path() . $path.'thumbnail')) {
        File::makeDirectory(public_path() . $path.'thumbnail', $mode = 0777, true, true);
    }
    //file new name
    $namefile = $folder_name.'_' . rand(0000, 9999) . '_' . time();
    //file extension
    $ext = $file->getClientOriginalExtension();
    //file old name
    $old_name = $file->getClientOriginalName();
    //convert the size of the file
    //$size = ImageUploader::GetSize($file->getSize());
    //get the mime type of the file
    $mimtype = $file->getMimeType();
    //making the new name with extension
    $mastername = $namefile . '.' . $ext;
    list($width, $height, $type, $attr) = getimagesize($_FILES[$input_name]['tmp_name'][$x]);
    $width_per=round(($width*10)/100);
    $height_per=round(($height*10)/100);
    $file->move(public_path() . $path, $mastername);
    switch($folder_name){
        case'hotels':
            $imagesResize=[
                0=>['width'=>60,'height'=>60],
                1=>['width'=>260,'height'=>180],
                2=>['width'=>400,'height'=>200],
            ];
            break;
        case'flights':
            $imagesResize=[
                0=>['width'=>60,'height'=>60],
                1=>['width'=>260,'height'=>180],
                2=>['width'=>400,'height'=>200],
            ];
            break;
        default:
            $imagesResize=[];
            break;
    }
    foreach($imagesResize as $imageSize){
        $widthS=$imageSize['width'];
        $heightS=$imageSize['height'];
        Image::make(public_path() . $path  . $mastername, array(
            'width' => $widthS,
            'height' => $heightS,
        ))->save(public_path() . $path . 'thumbnail/'.$widthS.'_'.$heightS.'_' . $mastername);
    }
    Image::make(public_path() . $path  . $mastername, array(
        'width' => $width_per,
        'height' => $height_per,
    ))->save(public_path() . $path . 'thumbnail/thumbnail_' . $mastername);
    return array('img'=>$mastername,'img_dir'=>$path);
}
function tableCount($table){
    if(Schema::hasTable($table)){
        $section=DB::table($table)->count();
        return $section;
    }
   return 0;
}
function getDaysName(){
    $timestamp = strtotime('next Sunday');
    $days = array();
    for ($i = 0; $i < 7; $i++) {
        $days[] = strtolower(strftime('%A', $timestamp));
        $timestamp = strtotime('+1 day', $timestamp);
    }
    return$days;
}
function sendGridEmailToUser($html,$email,$name,$subject,$attachments=[],$replayTo='info@newhayah.com'){
    try{
        $sendEmail = new \SendGrid\Mail\Mail();
        $sendEmail->setFrom('info@newhayah.com', 'New Hayah');
        $sendEmail->setReplyTo($replayTo,'New Hayah');
        $sendEmail->setSubject($subject);
        $sendEmail->addTo($email, $name);
        $sendEmail->addContent("text/html", $html);
        foreach ($attachments as $attachment){
            $file_encoded=base64_encode(file_get_contents(public_path($attachment->file_dir.$attachment->file)));
            $type=mime_content_type(public_path($attachment->file_dir.$attachment->file));
            $sendEmail->addAttachment(
                $file_encoded,
                $type,
                $attachment->file,
                "attachment"
            );
        }
        //$sendgrid = new \SendGrid('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');
        $sendgrid = new \SendGrid('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');
        $sent=$sendgrid->send($sendEmail);
    }catch (\SendGrid\Mail\TypeException $e){
        return ['message'=>$e->getMessage(),'success'=>false];
    }
    return ['message'=>'success','success'=>true,'$sent'=>$sent];
}
function startSessionButton($session,$type='therapist'){
    if($type=='therapist'){
        return \Carbon\Carbon::now()->between($session->start_time->add('-15 minutes'),$session->start_time->add(((in_array($session->type,[30,3]))?$session->type+10:$session->type+15).' minutes'));
    }else{
        //dd(\Carbon\Carbon::now()->between($session->start_time,$session->start_time->add($session->type.' minutes'))&&$session->therapist_start);
       // return (\Carbon\Carbon::now()->between($session->start_time->add('-15 minutes'),$session->start_time->add($session->type.' minutes'))&&$session->therapist_start);
        return (\Carbon\Carbon::now()->between($session->start_time->add('-15 minutes'),$session->start_time->add(((in_array($session->type,[30,3]))?$session->type+10:$session->type+15).' minutes')));
    }
}

function generateToken()
{
    return md5(rand(1, 10) . microtime());
}
function log_admin_action($action,$model){

    //dd($model->getChanges());
    if(\Illuminate\Support\Facades\Auth::guard('admin')->check()){
        if(in_array($action,['create','delete'])){
            $adminLog=new \App\AdminLogs();
            $adminLog->user_id=Auth::guard('admin')->user()->id;
            $adminLog->action=$action;
            $adminLog->table=$model->getTable();
            $adminLog->table_id=$model->id;
            $adminLog->data=$model->toJson();
            $adminLog->save();
        }else{
            foreach ($model->getChanges() as $key=>$value){
                $adminLog=new \App\AdminLogs();
                $adminLog->user_id=Auth::guard('admin')->user()->id;
                $adminLog->action=$action;
                $adminLog->table=$model->getTable();
                $adminLog->table_id=$model->id;
                $adminLog->column=$key;
                $adminLog->from=$model->getOriginal($key);
                $adminLog->to=$value;
                $adminLog->save();
            }
        }
    }else{
        log_users_action($action,$model);
    }


}
function log_users_action($action,$model){
    //dd($model->getChanges());
    $request=Request();
    if(\Illuminate\Support\Facades\Auth::check()){
        if(in_array($action,['create','delete'])){
            $adminLog=new \App\UsersLogs();
            $adminLog->user_id=Auth::user()->id;
            $adminLog->action=$action;
            $adminLog->table=$model->getTable();
            $adminLog->table_id=$model->id;
            $adminLog->data=$model->toJson();
            $adminLog->path=$request->path();
            $adminLog->save();
        }else{
            foreach ($model->getChanges() as $key=>$value){
                $adminLog=new \App\UsersLogs();
                $adminLog->user_id=Auth::user()->id;
                $adminLog->action=$action;
                $adminLog->table=$model->getTable();
                $adminLog->table_id=$model->id;
                $adminLog->column=$key;
                $adminLog->from=$model->getOriginal($key);
                $adminLog->to=$value;
                $adminLog->path=$request->path();
                $adminLog->save();
            }
        }
    }


}
function setTimeZone($timezone){
    config(['app.timezone' => $timezone]);
    date_default_timezone_set($timezone);
    $now = new \DateTime();
    $mins = $now->getOffset() / 60;
    $sgn = ($mins < 0 ? -1 : 1);
    $mins = abs($mins);
    $hrs = floor($mins / 60);
    $mins -= $hrs * 60;
    $offset = sprintf('%+d:%02d', $hrs*$sgn, $mins);
    //dd($offset);//+2:00
    DB::update('SET time_zone = ?', [$offset]);
}
function convertDateTimezone($date,$timezone='Africa/Cairo',$format='Y-m-d H:i:s'){
    if(!$timezone){
        $timezone='Africa/Cairo';
    }
    try{
        $tz = new DateTimeZone($timezone);

        $date = new DateTime($date);
        $date->setTimezone($tz);
        return $date->format($format)."\n";
    }catch (Exception $e){
        dd($timezone,$e->getMessage());
    }

}
function therapistCheckUrl($url,$id,$x=1){
    if(\App\Therapist::where('url',$url)->where('id','!=',$id)->count()){
        $url=therapistCheckUrl($url.'-'.$x,$id,$x+1);
    }
    return $url;
}
function updateTherapistUrl($model){
    $url=$model->name_e?$model->name_e:$model->name_a;
    $url=therapistCheckUrl($url,$model->id);
    \App\Therapist::where('id',$model->id)->update(['url'=>\Illuminate\Support\Str::slug($url)]);
}
function getConvertToMySqlDate($date){
    $userTimezone = new \DateTimeZone('America/Los_Angeles');
    $gmtTimezone = new \DateTimeZone('GMT');
    $myDateTime = new \DateTime($date, $gmtTimezone);
    $offset = $userTimezone->getOffset($myDateTime);
    $myInterval=\DateInterval::createFromDateString((string)$offset . 'seconds');
    $myDateTime->add($myInterval);
    return$myDateTime->format('Y-m-d H:i:s');
}
function getTimeZoneOffset(){
    $now = new \DateTime();
    $mins = $now->getOffset() / 60;
    $sgn = ($mins < 0 ? -1 : 1);
    $mins = abs($mins);
    $hrs = floor($mins / 60);
    $mins -= $hrs * 60;
    $offset = sprintf('%+d', $hrs*$sgn, $mins);
    return $offset;
}
function generateVapulusHash($hashSecret,$postData) {
    ksort($postData);
    $message="";
    $appendAmp=0;
    foreach($postData as $key => $value) {
        if (strlen($value) > 0) {
            if ($appendAmp == 0) {
                $message .= $key . '=' . $value;
                $appendAmp = 1;
            } else {
                $message .= '&' . $key . "=" . $value;
            }
        }
    }

    $secret = pack('H*', $hashSecret);
    return hash_hmac('sha256', $message, $secret);
}
function getEloquentSqlWithBindings($query)
{
    return vsprintf(str_replace('?', '%s', $query->toSql()), collect($query->getBindings())->map(function ($binding) {
        return is_numeric($binding) ? $binding : "'{$binding}'";
    })->toArray());
}
function getAppSetting($key){
    $appSettings=\App\AppSettings::where('key',$key)->first();
    if($appSettings){
        return $appSettings->value;
    }
    return null;
}
function sendCanceledEmail($sessions,$pateint_name='',$type){
    foreach ($sessions as $session){
        $user=($type=='visitor')?$session->visitor->user:$session->therapist->user;

     //   $userBy=($type=='visitor')?$session->therapist->user:$session->visitor->user;


        $html=view('email.canceled_session',compact('user','session', 'pateint_name'))->render();
        sendGridEmailToUser($html,$user->email,$user->name,'Session Canceled By '.($type=='visitor'?'Therapist':'Visitor'));
    }
}
function getCurrentUrl($lang){
    $segments = \Illuminate\Support\Facades\Request::segments();
    if($lang=='en'){
        return implode('/',$segments);
    }else{
        $first = array_shift($segments);
        return implode('/', $segments);

    }
}
function getStaticPageValue($id,$key='title'){
    $key=$key.'_'.app()->getLocale();
    $staticPage=\App\StaticPage::find($id);
    if($staticPage){
        return $staticPage->$key;
    }
    return null;
}
function calculateTherapistAmount($total_amount,$website_percentage,$minimum_price){
    $price=($total_amount*$website_percentage)/100;
    return ($price>=$minimum_price)?$total_amount-$price:$total_amount-$minimum_price;
}
function hasAgreement($visitor_id,$therapist_id,$type='therapist'){
    if(in_array($type,['therapist','visitor'])){
        return \App\ConfidentialityNoticeAgrements::where('therapist_id',$therapist_id)->where('visitor_id',$visitor_id)->whereNotNull($type.'_agree_date')->count();
    }
   return false;
}
function addInvoice($session){
    if($session->visitor_start_date&&$session->therapist_start_date){
        $request=Request();
        $location = Location::get($request->ip());
        $payment=Payments::where('session_id',$session->id)->first();
        $invoice=\App\TherapistsInvoices::where('session_id',$session->id)->count();
        if(!$invoice){
            $invoice=new \App\TherapistsInvoices();
            $invoice->therapist_id=$session->therapist_id;
            $invoice->visitor_id=$session->visitor_id;
            $invoice->session_id=$session->id;
            $invoice->visitor_name=(isset($session->visitor->user->name))?$session->visitor->user->name:NULL;
            $invoice->session_date=$session->start_time;
            $invoice->therapist_price=(in_array($session->type,['30','3','10']))?$session->therapist->price30:$session->therapist->price60;
            $invoice->therapist_price_dolar=(in_array($session->type,['30','3','10']))?$session->therapist->thirty_price_dollar:$session->therapist->sixty_price_dollar;
            $invoice->session_type=$session->type;
            $invoice->total_amount=$payment->amount;
            $invoice->currency=$payment->currancy;
            $invoice->discount_amount=$payment->discount_amount;
            $invoice->discount_percentage=$payment->coupon_discount;
            $invoice->coupon_id=$payment->coupon_id;
            $invoice->coupon_code=$payment->coupon_code;
            $invoice->total_after_discount=$invoice->total_amount- $invoice->discount_amount;
            $invoice->dolar_rating=$payment->dolar_rating;

            $invoice->website_percentage=getAppSetting('website_percentage');
            $invoice->minimum_price_30=getAppSetting('minimum_price_30');
            $invoice->minimum_price_60=getAppSetting('minimum_price_60');
            $invoice->minimum_price_30_dolar=getAppSetting('minimum_price_30_dolar');
            $invoice->minimum_price_60_dolar=getAppSetting('minimum_price_60_dolar');
            $minimum_price=0;
            if(in_array($session->type,[30,3,10])){
                if($invoice->currency=='EGP'){
                    $minimum_price=$invoice->minimum_price_30;
                }else{
                    $minimum_price=$invoice->minimum_price_30_dolar;
                }
            }
            if(in_array($session->type,[60,6,15])){
                if($invoice->currency=='EGP'){
                    $minimum_price=$invoice->minimum_price_60;
                }else{
                    $minimum_price=$invoice->minimum_price_60_dolar;
                }
            }
            $invoice->therapist_amount=calculateTherapistAmount($invoice->total_after_discount,$invoice->website_percentage,$minimum_price);
            $invoice->save();
            \App\CouponsUsed::where('session_id',$session->id)->where('payment_id',$payment->id)->update([
                'invoice_id'=>$invoice->id,
            ]);
            $session->invoice_id=$invoice->id;
            $session->save();
        }
    }


}
