<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTherapistsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('therapists', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->id();
            $table->foreignId('user_id')->unique();
            $table->string('title')->index()->default(0);

            $table->string('name_e')->index()->default(0);
            $table->string('name_a')->index()->default(0);
            $table->integer('years')->index()->default(0);
            $table->string('license_no')->index()->default(0);
            $table->string('license_org')->default(0);
            $table->string('picture')->default(0);
            $table->string('resume')->default(0);
            $table->text('summery')->nullable();
            $table->text('description')->nullable();
            $table->foreignId('country_id')->index()->nullable();
            $table->enum('gender',['male','female'])->nullable();
            $table->date('birth')->nullable();

            $table->integer('price30')->index()->default(0);
            $table->integer('price60')->index()->default(0);
            $table->integer('rating')->index()->default(0);
            $table->integer('numrating')->index()->default(0);
            $table->boolean('active')->default(false);
            $table->timestamps();

            /*$table->foreign('user_id')
                ->references('id')
                ->on('users')
                ->onDelete('cascade');*/
        });


        Schema::create('therapists_languages', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->id();
            $table->foreignId('therapist_id')->index();
            $table->foreignId('language_id')->index()->nullable();
            $table->timestamps();

            $table->foreign('therapist_id')
                ->references('id')
                ->on('therapists')
                ->onDelete('cascade');

            /*$table->foreign('language_id')
                ->references('id')
                ->on('languages')
                ->onDelete('cascade');*/
        });

        Schema::create('therapists_specialties', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->id();
            $table->foreignId('therapist_id')->index();
            $table->foreignId('speciality_id')->index()->nullable();
            $table->timestamps();

            $table->foreign('therapist_id')
                ->references('id')
                ->on('therapists')
                ->onDelete('cascade');

            /*$table->foreign('speciality_id')
                ->references('id')
                ->on('specialties')
                ->onDelete('cascade');*/
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('therapists');
        Schema::dropIfExists('therapists_languages');
        Schema::dropIfExists('therapists_specialties');
    }
}
